# Supported Tools

CACE supports a variety of EDA tools. See the entries below for a list of supported tools and their implemented functionality.

## `ngspice`

Perform spice simulation using ngspice.

Arguments:

- `template`: `<string>` The template schematic under the `templates/` folder for simulation.
- `jobs` (optional): `<int|'max'>` The number of jobs (threads) that CACE allocates for a single simulation run. Make sure to set `num_threads` to `CACE{jobs}` in the template testbench. If not specified, the default is 1.
- `collate` (optional): `<string>` Used to collate results for Monte Carlo simulations.
- `format` (optional): `<'ascii'>` The file format of the ngspice result. Currently only `ascii` is supported.
- `suffix` (optional): `<string>` File extension of the result file. For example: `.data`.
- `variables`: `<List[string|null]>` A list of results inside the result file. Use `null` to ignore a column.
- `script` (optional): `<string>` Name of a Python script in the script folder. It will be executed on the results of each simulation.
- `script_variables` (optional): `<List[string|null]>` A list of results generated by the specified Python script. These results are available in addition to the ones specified under `variables`.
- `spiceinit_path` (optional): `<string>` Path to a spiceinit file that is copied to the simulation directory and renamed to `.spiceinit`. If not specified, the PDK spiceinit is used.

Results: The results depend on the `variables` and optionally the `script_variables` arguments.

## `magic_drc`

Perform DRC (Design Rule Check) with magic.

Arguments:

- `args` (optional): `<list[string]>` Additional args that are passed to magic.
- `gds_flatten` (optional): `<true/false>` Flatten the GDSII layout prior to running DRC. If not specified, the default is false.

Results:

- `drc_errors`: `<int>` Number of DRC errors.

## `magic_area`

Perform area measurements with magic.

Arguments:

- `args` (optional): `<list[string]>` Additional args that are passed to magic.

Results:

- `area`: `<float>` Area of the design in µm²
- `width`: `<float>` Width of the design in µm.
- `height`: `<float>` Height of the design in µm.

## `magic_antenna_check`

Perform the magic antenna check to find antenna violations in the layout.

Arguments:

- `args` (optional): `<list[string]>` Additional args that are passed to magic.

Results:

- `antenna_violations`: `<int>` The number of antenna violations.

## `klayout_drc`

Perform DRC (Design Rule Check) with KLayout.

Arguments:

- `jobs` (optional): `<int|'max'>` The number of jobs (threads) that CACE allocates for running DRC. If not specified, the default is 1.
- `args` (optional): `<list[string]>` Additional args that are passed to KLayout. For example `['-rd', 'feol=true']`.
- `drc_script_path` (optional): `<string>` Path to a KLayout DRC deck that is used to run DRC. If not specified, the PDK DRC deck is used.

Results:

- `drc_errors`: `<int>` Number of DRC errors.

## `netgen_lvs`

```{note}
The `netgen_lvs` tool always compares the `schematic` netlist with the `layout` extracted netlist, independent of the selected netlist source.
```

Perform LVS (Layout VS Schematic) with netgen.

Arguments:

- `args` (optional): `<list[string]>` Additional args that are passed to netgen.
- `script` (optional): `<string>` A custom LVS script under `scripts/`.

Results:

- `lvs_errors`: `<int>` Number of LVS errors.

## Missing a tool?

If you are missing a tool or functionality, please open an issue [here](https://github.com/efabless/cace/issues).
