import logging
from together import Together
from virtueai.models import VirtueAIModel, SafetyModel
import asyncio

class TogetherSafetyModel(SafetyModel):
    def __init__(self, api_key: str, safety_model: VirtueAIModel):
        self.together_client = Together(api_key=api_key)
        self.safety_model = safety_model.value

    async def __call__(self, query: str) -> bool:
        return await self.safety_check(query)

    async def safety_check(self, query: str) -> bool:
        try:
            
            response = await self.together_client.chat.completions.create(
                model=self.safety_model,
                messages=[{"role": "user", "content": query}],
            )
            logging.debug(response)
            verdict = response.choices[0].message.content.strip().lower()
            return verdict.startswith("safe")
        except Exception as exc:  # Fallback: if safety model fails, err on safe side
            # Optionally you could log this, but for now we allow the flow to continue.
            return True
