---
hide: toc
---

# Documentation for pynxtools-xrd

`pynxtools-xrd` is a free and open-source data software for harmonizing X-ray diffraction data and metadata for research data management using [NeXus](https://www.nexusformat.org/), implemented with the goal to make scientific research data FAIR (findable, accessible, interoperable, and reusable).

`pynxtools-xrd`, which is a plugin for [pynxtools](https://github.com/FAIRmat-NFDI/pynxtools), provides a tool for reading data from `.xrdml` files that were obtained with PANalytical X'Pert PRO version 1.5 (instruments).
The tool standardizes these data such that it is compliant with the NeXus application definitions [`NXxrd_pan`](https://fairmat-nfdi.github.io/nexus_definitions/classes/contributed_definitions/NXxrd_pan.html).
`pynxtools-xrd` is developed both as a standalone reader and as a tool within [NOMAD](https://nomad-lab.eu/), which is the open-source data management platform for materials science we are developing with [FAIRmat](https://www.fairmat-nfdi.eu/fairmat/).

`pynxtools-xrd` is useful for scientists from the X-ray powder diffraction community that wish to explore standardization of their data using NOMAD.

<div markdown="block" class="home-grid">
<div markdown="block"> 

### Tutorial

- [Installation guide](tutorial/installation.md)
- [Standalone usage](tutorial/standalone.md)
- [Development install](tutorial/dev_installation.md)

</div>
<div markdown="block">

### How-to guides

<!-- Coming soon!-->
<!-- How-to guides provide step-by-step instructions for a wide range of tasks, with the overarching topics: -->

</div>

<div markdown="block">

### Learn

<!-- Coming soon!-->
<!-- The explanation section provides background knowledge on the implementation design, how the data is structured, how data processing can be incorporated, how the integration works in NOMAD, and more.-->

</div>
<div markdown="block">

### Reference


</div>
</div>

<h2> Contact </h2>

For questions or suggestions:

- Open an issue on the [`pynxtools-xrd` GitHub](https://github.com/FAIRmat-NFDI/pynxtools-xrd/issues)
- Join our [Discord channel ](https://discord.gg/Gyzx3ukUw8)
- Get in contact with our [lead developers](contact.md).

<h2>Project and community</h2>

The work is funded by the Deutsche Forschungsgemeinschaft (DFG, German Research Foundation) - [460197019 (FAIRmat)](https://gepris.dfg.de/gepris/projekt/460197019?language=en).
