# !/usr/bin/python3
# -*- coding:utf-8 -*-
"""
@Author: xiaodong.li
@Time: 2024/11/08 14:20
@Description: Description
@File: ecoa_auth_service.py
"""
from api_requester.core.admin.api.ecoa_auth_api import AdminEcoaAuthApi
from api_requester.core.admin.dto.ecoa_onboard_request_dto import EcoaOnboardRequestDto
from api_requester.core.admin.dto.jwt_authentication_request import JwtAuthenticationRequest
from api_requester.core.admin.dto.reset_password_email_request_dto import ResetPasswordEmailRequestDto
from api_requester.core.admin.dto.sso_token_retrieve_dto import SsoTokenRetrieveDto


class AdminEcoaAuthService(AdminEcoaAuthApi):
    """
    The AdminEcoaAuthService was generated by Generator from the EcoaAuthController.java file.
    """

    def __init__(self):
        AdminEcoaAuthApi.__init__(self)

    def auth_ecoa_login(self, authentication_request: JwtAuthenticationRequest = None):
        return self.auth_ecoa_login_api(json=authentication_request)

    def create_authentication_token_from_sso(self, token_retrieve: SsoTokenRetrieveDto = None):
        return self.create_authentication_token_from_sso_api(json=token_retrieve)

    def auth_ecoa_logout(self):
        return self.auth_ecoa_logout_api()

    def auth_ecoa_me(self):
        return self.auth_ecoa_me_api()

    def reset_password_email(self, reset_password_email_request_dto: ResetPasswordEmailRequestDto = None):
        return self.reset_password_email_api(json=reset_password_email_request_dto)

    def ecoa_study_list(self):
        return self.ecoa_study_list_api()

    def onboard(self, ecoa_onboard_dto: EcoaOnboardRequestDto = None):
        return self.onboard_api(json=ecoa_onboard_dto)
