/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lbridge/BigIntegerDecimalSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/math/BigInteger;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "Shared"})
public final class BigIntegerDecimalSerializer
implements KSerializer<BigInteger> {
    @NotNull
    private final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("BigIntSerializer", PrimitiveKind.STRING.INSTANCE);

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public BigInteger deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        try {
            return new BigInteger(decoder.decodeString(), 10);
        }
        catch (NumberFormatException e) {
            String string;
            try {
                string = decoder.decodeString();
            }
            catch (Exception e2) {
                string = e2.getMessage();
            }
            String problematicJson = string;
            String msg = "Expecting a decimal integer, got: " + problematicJson;
            throw new Exception(msg, e);
        }
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull BigInteger value2) {
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value2, "value");
        String string = value2.toString(10);
        Intrinsics.checkNotNullExpressionValue(string, "value.toString(10)");
        encoder2.encodeString(string);
    }
}

