/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.ConstExp;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/certora/evmverifier/cvl/NumberExp;", "Lcom/certora/evmverifier/cvl/ConstExp;", "_n", "", "range", "Lspec/cvlast/CVLRange;", "(Ljava/lang/String;Lspec/cvlast/CVLRange;)V", "base", "", "(Ljava/lang/String;ILspec/cvlast/CVLRange;)V", "n", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;Lspec/cvlast/CVLRange;)V", "getN", "()Ljava/math/BigInteger;", "asCVLConstant", "Lspec/cvlast/CVLExp$Constant;", "scope", "Lspec/cvlast/CVLScope;", "toString", "Shared"})
public final class NumberExp
extends ConstExp {
    @NotNull
    private final BigInteger n;

    public NumberExp(@NotNull BigInteger n, @NotNull CVLRange range) {
        Intrinsics.checkNotNullParameter(n, "n");
        Intrinsics.checkNotNullParameter(range, "range");
        super(range, null);
        this.n = n;
    }

    @NotNull
    public final BigInteger getN() {
        return this.n;
    }

    public NumberExp(@NotNull String _n, @NotNull CVLRange range) {
        Intrinsics.checkNotNullParameter(_n, "_n");
        Intrinsics.checkNotNullParameter(range, "range");
        this(new BigInteger(_n), range);
    }

    public NumberExp(@NotNull String _n, int base, @NotNull CVLRange range) {
        Intrinsics.checkNotNullParameter(_n, "_n");
        Intrinsics.checkNotNullParameter(range, "range");
        this(new BigInteger(_n, base), range);
    }

    @NotNull
    public String toString() {
        return this.n + ".";
    }

    @Override
    @NotNull
    public CVLExp.Constant asCVLConstant(@NotNull CVLScope scope) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        return new CVLExp.Constant.NumberLit(this.n, new CVLExpTag(scope, this.getRange()));
    }
}

