/*
 * Decompiled with CFR 0.152.
 */
package report.calltrace;

import config.Config;
import datastructures.stdcollections.MapsKt;
import evm.EVMConstsKt;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.VMConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lreport/calltrace/BuiltinConstantTranslator;", "", "()V", "nameOf", "", "Ljava/math/BigInteger;", "", "get", "num", "Shared"})
public final class BuiltinConstantTranslator {
    @NotNull
    public static final BuiltinConstantTranslator INSTANCE = new BuiltinConstantTranslator();
    @NotNull
    private static final Map<BigInteger, String> nameOf = MapsKt.mutableMapOf();

    private BuiltinConstantTranslator() {
    }

    @Nullable
    public final String get(@NotNull BigInteger num) {
        Intrinsics.checkNotNullParameter(num, "num");
        return nameOf.get(num);
    }

    static {
        VMConfig vmConfig = Config.INSTANCE.getVMConfig();
        IntProgression bitSizes = IntProgression.Companion.fromClosedRange(8, 256, 8);
        int k = bitSizes.getFirst();
        int n = bitSizes.getLast();
        int n2 = bitSizes.getStep();
        if (n2 > 0 && k <= n || n2 < 0 && n <= k) {
            while (true) {
                nameOf.put(EVMConstsKt.MASK_SIZE(k), "max_uint" + k);
                if (k == n) break;
                k += n2;
            }
        }
        nameOf.put(vmConfig.getMaxAddress(), "max_address");
    }
}

