/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLScope;
import spec.cvlast.EVMBuiltinTypes;
import spec.cvlast.transformer.CVLCmdTransformer;
import spec.cvlast.transformer.CVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.MethodVariableNotInRule;
import utils.CollectingResult;
import utils.ErrorCollector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u0005j\b\u0012\u0004\u0012\u00020\u0002`\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lspec/cvlast/CVLCmdAddtionalChecks;", "Lspec/cvlast/transformer/CVLCmdTransformer;", "Lspec/cvlast/typechecker/CVLError;", "()V", "decl", "Lutils/CollectingResult;", "Lspec/cvlast/CVLCmd;", "cmd", "Lspec/cvlast/CVLCmd$Simple$Declaration;", "def", "Lspec/cvlast/CVLCmd$Simple$Definition;", "verifyMethodVariableDeclaration", "", "Lutils/VoidResult;", "Shared"})
final class CVLCmdAddtionalChecks
extends CVLCmdTransformer<CVLError> {
    public CVLCmdAddtionalChecks() {
        super(CVLExpTransformer.Companion.copyTransformer());
    }

    private final CollectingResult<Unit, CVLError> verifyMethodVariableDeclaration(CVLCmd.Simple.Declaration cmd2) {
        if (!Intrinsics.areEqual(cmd2.getCvlType(), EVMBuiltinTypes.INSTANCE.getMethod())) {
            return CollectingResult.Companion.getOk();
        }
        CVLScope.Item.RuleScopeItem ruleScopeItem = cmd2.getScope().enclosingRule();
        if (ruleScopeItem == null) {
            return CollectingResult.Companion.asError(new MethodVariableNotInRule(cmd2.getCvlRange()));
        }
        CVLScope.Item.RuleScopeItem enclosingRuleScopeItem = ruleScopeItem;
        if (enclosingRuleScopeItem.isDerivedFromInvariant()) {
            return CollectingResult.Companion.getOk();
        }
        if (!Intrinsics.areEqual(enclosingRuleScopeItem, CollectionsKt.last(cmd2.getScope().getScopeStack()))) {
            return CollectingResult.Companion.asError(new MethodVariableNotInRule(cmd2.getCvlRange()));
        }
        return CollectingResult.Companion.getOk();
    }

    @Override
    @NotNull
    public CollectingResult<CVLCmd, CVLError> decl(@NotNull CVLCmd.Simple.Declaration cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, CVLCmd>(this, cmd2){
            final /* synthetic */ CVLCmdAddtionalChecks this$0;
            final /* synthetic */ CVLCmd.Simple.Declaration $cmd;
            {
                this.this$0 = $receiver;
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CVLCmd invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                $this$collectingErrors.collect(CVLCmdAddtionalChecks.access$verifyMethodVariableDeclaration(this.this$0, this.$cmd));
                return (CVLCmd)$this$collectingErrors.bind(CVLCmdAddtionalChecks.access$decl$s688801304(this.this$0, this.$cmd));
            }
        });
    }

    @Override
    @NotNull
    public CollectingResult<CVLCmd, CVLError> def(@NotNull CVLCmd.Simple.Definition cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        if (!(!Intrinsics.areEqual(cmd2.getType(), EVMBuiltinTypes.INSTANCE.getMethod()))) {
            boolean bl = false;
            String string = "The typechecker should have prevented method-typed definitions";
            throw new IllegalStateException(string.toString());
        }
        return super.def(cmd2);
    }

    public static final /* synthetic */ CollectingResult access$verifyMethodVariableDeclaration(CVLCmdAddtionalChecks $this, CVLCmd.Simple.Declaration cmd2) {
        return $this.verifyMethodVariableDeclaration(cmd2);
    }

    public static final /* synthetic */ CollectingResult access$decl$s688801304(CVLCmdAddtionalChecks $this, CVLCmd.Simple.Declaration cmd2) {
        return super.decl(cmd2);
    }
}

