/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import config.SharedConfig;
import datastructures.stdcollections.IterablesKt;
import datastructures.stdcollections.SetsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLRuleChoiceKt;
import spec.cvlast.DistanceToName;
import spec.cvlast.IRule;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001af\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u001a$\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0017\u001a\u00020\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"logger", "Llog/Logger;", "getClosestStrings", "", "", "illegalWord", "legalWords", "distanceFunc", "Lkotlin/Function2;", "", "maxDist", "maxDistRatio", "", "maxSuggestions", "maxDelta", "inputStringDistance", "_input_str", "_dict_str", "validateRuleChoices", "Lutils/CollectingResult;", "", "Lspec/cvlast/typechecker/CVLError;", "Lutils/VoidResult;", "cvlAst", "Lspec/cvlast/CVLAst;", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVLRuleChoice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLRuleChoice.kt\nspec/cvlast/CVLRuleChoiceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1549#2:176\n1620#2,3:177\n1360#2:180\n1446#2,5:181\n*S KotlinDebug\n*F\n+ 1 CVLRuleChoice.kt\nspec/cvlast/CVLRuleChoiceKt\n*L\n27#1:176\n27#1:177,3\n42#1:180\n42#1:181,5\n*E\n"})
public final class CVLRuleChoiceKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.SPEC);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CollectingResult<Unit, CVLError> validateRuleChoices(@NotNull CVLAst cvlAst2) {
        void $this$flatMapTo$iv$iv;
        CVLInvariant it;
        Set set2;
        Object item$iv$iv2;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(cvlAst2, "cvlAst");
        Iterable $this$map$iv = cvlAst2.getRules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection<Object> destination$iv$iv = (Set)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            IRule iRule = (IRule)item$iv$iv2;
            set2 = destination$iv$iv;
            boolean bl = false;
            set2.add(((IRule)((Object)it)).getDeclarationId());
        }
        $this$map$iv = cvlAst2.getInvs();
        set2 = IterablesKt.toSet((List)destination$iv$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            it = (CVLInvariant)item$iv$iv2;
            Collection<Object> collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set<String> allRules = SetsKt.plus(set2, IterablesKt.toSet((List)destination$iv$iv));
        HashSet<String> hashSet = SharedConfig.INSTANCE.getRuleChoices();
        if (hashSet == null) {
            return CollectingResult.Companion.getOk();
        }
        HashSet<String> chosenRules = hashSet;
        Set<String> unknownRules = SetsKt.minus((Set)chosenRules, (Iterable)allRules);
        if (unknownRules.isEmpty()) {
            return CollectingResult.Companion.getOk();
        }
        logger.info((Function0<? extends Object>)new Function0<Object>(unknownRules, allRules){
            final /* synthetic */ Set<String> $unknownRules;
            final /* synthetic */ Set<String> $allRules;
            {
                this.$unknownRules = $unknownRules;
                this.$allRules = $allRules;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Could not find rules: " + this.$unknownRules + ". Starting to offer replacement rules names. All rule names are " + this.$allRules;
            }
        });
        String errStr = "The rules: " + unknownRules + " were not found in any of the specification files.";
        Iterable $this$flatMap$iv = unknownRules;
        boolean $i$f$flatMap = false;
        item$iv$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CVLRuleChoiceKt.getClosestStrings$default(it2, allRules, null, 0, 0.0, 0, 0, 124, null);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List allSuggestions = (List)destination$iv$iv2;
        if (allSuggestions.size() == 1) {
            errStr = errStr + " Did you mean rule " + allSuggestions.get(0) + "?";
        } else if (allSuggestions.size() >= 2) {
            errStr = errStr + " Did you mean rule " + allSuggestions.get(0) + " or " + allSuggestions.get(1) + "?";
        }
        return CollectingResult.Companion.asError(new CVLError.General(new CVLRange.Empty(null, 1, null), errStr));
    }

    @NotNull
    public static final Set<String> getClosestStrings(@NotNull String illegalWord, @NotNull Set<String> legalWords, @NotNull Function2<? super String, ? super String, Integer> distanceFunc, int maxDist, double maxDistRatio, int maxSuggestions, int maxDelta) {
        DistanceToName currentTuple;
        int currDist;
        Intrinsics.checkNotNullParameter(illegalWord, "illegalWord");
        Intrinsics.checkNotNullParameter(legalWords, "legalWords");
        Intrinsics.checkNotNullParameter(distanceFunc, "distanceFunc");
        Comparator compareByDistance = CVLRuleChoiceKt::getClosestStrings$lambda$3;
        PriorityQueue<DistanceToName> distanceQueue = new PriorityQueue<DistanceToName>(compareByDistance);
        for (String legalWord : legalWords) {
            int distance = ((Number)distanceFunc.invoke(illegalWord, legalWord)).intValue();
            distanceQueue.add(new DistanceToName(distance, legalWord));
        }
        Set<String> allSuggestions = SetsKt.mutableSetOf();
        int lastDist = Integer.MAX_VALUE;
        while (!distanceQueue.isEmpty() && allSuggestions.size() <= maxSuggestions && (currDist = (currentTuple = (DistanceToName)distanceQueue.poll()).getDistance()) <= maxDist && !((double)currDist / ((double)illegalWord.length() * 10.0) > maxDistRatio)) {
            if (lastDist != Integer.MAX_VALUE && Math.abs(currDist - lastDist) > maxDelta) continue;
            allSuggestions.add(currentTuple.getName());
            lastDist = currDist;
        }
        return allSuggestions;
    }

    public static /* synthetic */ Set getClosestStrings$default(String string, Set set2, Function2 function2, int n, double d2, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            function2 = getClosestStrings.1.INSTANCE;
        }
        if ((n4 & 8) != 0) {
            n = 40;
        }
        if ((n4 & 0x10) != 0) {
            d2 = 0.5;
        }
        if ((n4 & 0x20) != 0) {
            n2 = 2;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 2;
        }
        return CVLRuleChoiceKt.getClosestStrings(string, set2, function2, n, d2, n2, n3);
    }

    public static final int inputStringDistance(@NotNull String _input_str, @NotNull String _dict_str) {
        int row;
        Intrinsics.checkNotNullParameter(_input_str, "_input_str");
        Intrinsics.checkNotNullParameter(_dict_str, "_dict_str");
        String string = _input_str;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(locale)");
        String inputStr = string2;
        String string3 = _dict_str;
        Locale locale2 = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale2, "ENGLISH");
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase(locale)");
        String dictStr = string4;
        if (Intrinsics.areEqual(inputStr, dictStr)) {
            return 0;
        }
        if (StringsKt.startsWith$default(inputStr, dictStr, false, 2, null) || StringsKt.startsWith$default(dictStr, inputStr, false, 2, null)) {
            return Math.abs(dictStr.length() - inputStr.length());
        }
        int numRows = inputStr.length() + 1;
        int numCols = dictStr.length() + 1;
        int n = 0;
        int[][] nArrayArray = new int[numRows][];
        while (n < numRows) {
            int n2 = n++;
            nArrayArray[n2] = new int[numCols];
        }
        int[][] distanceMatrix = nArrayArray;
        for (row = 1; row < numRows; ++row) {
            distanceMatrix[row][0] = row;
        }
        for (int col = 1; col < numCols; ++col) {
            distanceMatrix[0][col] = col;
        }
        for (row = 1; row < numRows; ++row) {
            for (int col = 1; col < numCols; ++col) {
                char dictChar;
                char inputChar = inputStr.charAt(row - 1);
                int cost = inputChar == (dictChar = dictStr.charAt(col - 1)) ? 0 : (inputChar == '_' || dictChar == '_' ? 1 : 10);
                distanceMatrix[row][col] = cost + Math.min(distanceMatrix[row - 1][col], Math.min(distanceMatrix[row][col - 1], distanceMatrix[row - 1][col - 1]));
            }
        }
        return distanceMatrix[numRows - 1][numCols - 1];
    }

    private static final int getClosestStrings$lambda$3(DistanceToName t12, DistanceToName t22) {
        Intrinsics.checkNotNullParameter(t12, "t1");
        Intrinsics.checkNotNullParameter(t22, "t2");
        return t12.getDistance() - t22.getDistance();
    }
}

