/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLRange;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.DisallowedTypeUsedInQuantifier$;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="\n        CVL quantifier bodies may only contain CVL definitions or ghost function calls.\"\n        ")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        methods {\n            function returnsTwiceUint(uint x) external returns uint envfree;\n        }\n\n        rule checkQuantifier() {\n            require (exists uint x . #returnsTwiceUint(x)# > 4);\n            assert true;\n        }\n        ", exampleMessage="Contract function calls such as returnsTwiceUint(x) are disallowed inside quantified formulas."), @CVLErrorExample(exampleCVLWithRange="\n        function foo(uint x) returns uint {\n            return require_uint256(2 * x);\n        }\n\n        rule checkQuantifier() {\n            require (exists uint x . #foo(x)# > 4);\n            assert true;\n        }\n        ", exampleMessage="CVL function calls such as foo(x) are disallowed inside quantified formulas.")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001b\u001c\u001dB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB-\b\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u00c7\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u000b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lspec/cvlast/typechecker/DisallowedTypeUsedInQuantifier;", "Lspec/cvlast/typechecker/CVLError;", "location", "Lspec/cvlast/CVLRange;", "exp", "", "disallowedType", "Lspec/cvlast/typechecker/DisallowedTypeUsedInQuantifier$DisallowedType;", "(Lspec/cvlast/CVLRange;Ljava/lang/String;Lspec/cvlast/typechecker/DisallowedTypeUsedInQuantifier$DisallowedType;)V", "seen1", "", "message", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILspec/cvlast/CVLRange;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lspec/cvlast/CVLRange;Ljava/lang/String;)V", "getLocation", "()Lspec/cvlast/CVLRange;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "DisallowedType", "Shared"})
public final class DisallowedTypeUsedInQuantifier
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CVLRange location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public DisallowedTypeUsedInQuantifier(@NotNull CVLRange location, @NotNull String message2) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(message2, "message");
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public CVLRange getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public DisallowedTypeUsedInQuantifier(@NotNull CVLRange location, @NotNull String exp, @NotNull DisallowedType disallowedType) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(exp, "exp");
        Intrinsics.checkNotNullParameter((Object)disallowedType, "disallowedType");
        this(location, disallowedType.getDescription() + " such as " + exp + " are disallowed inside quantified formulas.");
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(DisallowedTypeUsedInQuantifier self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ DisallowedTypeUsedInQuantifier(int seen1, CVLRange location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{CVLRange.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/DisallowedTypeUsedInQuantifier$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/DisallowedTypeUsedInQuantifier;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<DisallowedTypeUsedInQuantifier> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lspec/cvlast/typechecker/DisallowedTypeUsedInQuantifier$DisallowedType;", "", "description", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "CVL_FUNCTION_CALL", "SOLIDITY_FUNCTION_CALL", "Shared"})
    public static final class DisallowedType
    extends Enum<DisallowedType> {
        @NotNull
        private final String description;
        public static final /* enum */ DisallowedType CVL_FUNCTION_CALL = new DisallowedType("CVL function calls");
        public static final /* enum */ DisallowedType SOLIDITY_FUNCTION_CALL = new DisallowedType("Contract function calls");
        private static final /* synthetic */ DisallowedType[] $VALUES;

        private DisallowedType(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static DisallowedType[] values() {
            return (DisallowedType[])$VALUES.clone();
        }

        public static DisallowedType valueOf(String value2) {
            return Enum.valueOf(DisallowedType.class, value2);
        }

        static {
            $VALUES = disallowedTypeArray = new DisallowedType[]{DisallowedType.CVL_FUNCTION_CALL, DisallowedType.SOLIDITY_FUNCTION_CALL};
        }
    }
}

