/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLPreserved;
import spec.cvlast.CVLRange;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.DuplicatePreserved$;

@Serializable
@CVLErrorType(category=CVLErrorCategory.SYNTAX, description="\n        You may have at most one {ref}`preserved` for each method, at most one generic `preserved` block, and at\n        most one `fallback` preserved block.\n        ")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        invariant i() true {\n            #preserved { }#\n            preserved  { }\n        }\n        ", exampleMessage="Invariant `i` has multiple generic preserved blocks (additional block on line 4)."), @CVLErrorExample(exampleCVLWithRange="invariant i() true { #preserved externalFunction() {}# preserved externalFunction() {} }", exampleMessage="Invariant `i` has multiple preserved blocks for `PrimaryContract.externalFunction()` (additional block at position 1:54).")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000  2\u00020\u0001:\u0006\u001f !\"#$B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012B\u0017\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u00c7\u0001R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lspec/cvlast/typechecker/DuplicatePreserved;", "Lspec/cvlast/typechecker/CVLError;", "invariant", "Lspec/cvlast/CVLInvariant;", "blocks", "", "Lspec/cvlast/CVLPreserved;", "type", "Lspec/cvlast/typechecker/DuplicatePreserved$Target;", "(Lspec/cvlast/CVLInvariant;Ljava/util/List;Lspec/cvlast/typechecker/DuplicatePreserved$Target;)V", "seen1", "", "location", "Lspec/cvlast/CVLRange;", "message", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILspec/cvlast/CVLRange;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lspec/cvlast/CVLRange;Ljava/lang/String;)V", "getLocation", "()Lspec/cvlast/CVLRange;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "Fallback", "Generic", "Specific", "Target", "Shared"})
public final class DuplicatePreserved
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CVLRange location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private DuplicatePreserved(CVLRange location, String message2) {
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public CVLRange getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public DuplicatePreserved(@NotNull CVLInvariant invariant, @NotNull List<? extends CVLPreserved> blocks, @NotNull Target type) {
        Intrinsics.checkNotNullParameter(invariant, "invariant");
        Intrinsics.checkNotNullParameter(blocks, "blocks");
        Intrinsics.checkNotNullParameter(type, "type");
        this(CollectionsKt.first(blocks).getCvlRange(), "Invariant `" + invariant.getId() + "` has multiple " + type.getDescription() + " (additional block " + blocks.get(1).getCvlRange().relativeDescription(CollectionsKt.first(blocks).getCvlRange()) + ").");
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(DuplicatePreserved self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ DuplicatePreserved(int seen1, CVLRange location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{CVLRange.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/DuplicatePreserved$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/DuplicatePreserved;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<DuplicatePreserved> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lspec/cvlast/typechecker/DuplicatePreserved$Fallback;", "Lspec/cvlast/typechecker/DuplicatePreserved$Target;", "()V", "Shared"})
    public static final class Fallback
    extends Target {
        public Fallback() {
            super("fallback preserved blocks", null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lspec/cvlast/typechecker/DuplicatePreserved$Generic;", "Lspec/cvlast/typechecker/DuplicatePreserved$Target;", "()V", "Shared"})
    public static final class Generic
    extends Target {
        public Generic() {
            super("generic preserved blocks", null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lspec/cvlast/typechecker/DuplicatePreserved$Specific;", "Lspec/cvlast/typechecker/DuplicatePreserved$Target;", "method", "Lspec/cvlast/CVLPreserved$ExplicitMethod;", "(Lspec/cvlast/CVLPreserved$ExplicitMethod;)V", "Shared"})
    public static final class Specific
    extends Target {
        public Specific(@NotNull CVLPreserved.ExplicitMethod method) {
            Intrinsics.checkNotNullParameter(method, "method");
            super("preserved blocks for `" + method.getMethodSignature() + "`", null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lspec/cvlast/typechecker/DuplicatePreserved$Target;", "", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "Lspec/cvlast/typechecker/DuplicatePreserved$Fallback;", "Lspec/cvlast/typechecker/DuplicatePreserved$Generic;", "Lspec/cvlast/typechecker/DuplicatePreserved$Specific;", "Shared"})
    public static abstract class Target {
        @NotNull
        private final String description;

        private Target(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public /* synthetic */ Target(String description, DefaultConstructorMarker $constructor_marker) {
            this(description);
        }
    }
}

