/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLRange;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.InconsistentVariableDefinition$;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="\n        You are allowed to declare a variable and then define it inside the branches of an `if` block.  If you define it\n        in one branch, however, you must also define it in the other branch.\n        ")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        function f(bool flag) {\n            mathint x;\n            #if (flag) {\n                x = 5;\n            } else {\n                assert true;\n            }#\n        }\n        ", exampleMessage="`x` is defined in the `if` branch (on line 5) but not in the `else` branch."), @CVLErrorExample(exampleCVLWithRange="function f() { mathint x; #if(_) {} else { x = 5; }# }", exampleMessage="`x` is defined in the `else` branch (at position 1:43) but not in the `if` branch."), @CVLErrorExample(exampleCVLWithRange="function f() { mathint x; #if(_) { x = 3; } else { mathint z = x; }# }"), @CVLErrorExample(exampleCVLWithRange="function f() { mathint x; #if(_) { x = 4; }# }"), @CVLErrorExample(exampleCVLWithRange="function f() { uint x; #if (_) { if (_) { x = 0; } else { x = 1; } }# }"), @CVLErrorExample(exampleCVLWithRange="function f() { uint x; #if (_) { } else { if (_) { x = 0; } else { x = 1; } }# }")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u00c7\u0001R\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lspec/cvlast/typechecker/InconsistentVariableDefinition;", "Lspec/cvlast/typechecker/CVLError;", "id", "", "ifLocation", "Lspec/cvlast/CVLRange;", "definitionLocation", "definedInThenBlock", "", "(Ljava/lang/String;Lspec/cvlast/CVLRange;Lspec/cvlast/CVLRange;Z)V", "seen1", "", "location", "message", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILspec/cvlast/CVLRange;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lspec/cvlast/CVLRange;Ljava/lang/String;)V", "getLocation", "()Lspec/cvlast/CVLRange;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "Shared"})
public final class InconsistentVariableDefinition
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CVLRange location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private InconsistentVariableDefinition(CVLRange location, String message2) {
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public CVLRange getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public InconsistentVariableDefinition(@NotNull String id, @NotNull CVLRange ifLocation, @NotNull CVLRange definitionLocation, boolean definedInThenBlock) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(ifLocation, "ifLocation");
        Intrinsics.checkNotNullParameter(definitionLocation, "definitionLocation");
        this(ifLocation, "`" + id + "` is defined in the `" + (definedInThenBlock ? "if" : "else") + "` branch (" + definitionLocation.relativeDescription(ifLocation) + ") but not in the `" + (definedInThenBlock ? "else" : "if") + "` branch.");
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(InconsistentVariableDefinition self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ InconsistentVariableDefinition(int seen1, CVLRange location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{CVLRange.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/InconsistentVariableDefinition$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/InconsistentVariableDefinition;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<InconsistentVariableDefinition> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

