/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.CertoraErrorType;
import utils.TimeCheckException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0016\u0018\u0000 \u000e2\u00060\u0001j\u0002`\u0002:\u0001\u000eB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lutils/CertoraException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "type", "Lutils/CertoraErrorType;", "msg", "", "t", "", "(Lutils/CertoraErrorType;Ljava/lang/String;Ljava/lang/Throwable;)V", "getMsg", "()Ljava/lang/String;", "getType", "()Lutils/CertoraErrorType;", "Companion", "Shared"})
public class CertoraException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CertoraErrorType type;
    @NotNull
    private final String msg;

    public CertoraException(@NotNull CertoraErrorType type, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(msg, "msg");
        super(msg, t);
        this.type = type;
        this.msg = msg;
    }

    public /* synthetic */ CertoraException(CertoraErrorType certoraErrorType, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(certoraErrorType, string, throwable);
    }

    @NotNull
    public final CertoraErrorType getType() {
        return this.type;
    }

    @NotNull
    public final String getMsg() {
        return this.msg;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\fH\u0002\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lutils/CertoraException$Companion;", "", "()V", "computeExceptionErrorCode", "Lkotlin/UInt;", "e", "Lutils/CertoraException$Companion$ExceptionDetailsForErrorCode;", "computeExceptionErrorCode-OGnWXxg", "(Lutils/CertoraException$Companion$ExceptionDetailsForErrorCode;)I", "fromException", "Lutils/CertoraException;", "t", "", "customMsg", "", "fromExceptionWithRuleName", "ruleName", "getErrorCodeForException", "getErrorCodeForException-OGnWXxg", "(Ljava/lang/Throwable;)I", "isTimeout", "", "ExceptionDetailsForErrorCode", "Shared"})
    @SourceDebugExtension(value={"SMAP\nCertoraException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertoraException.kt\nutils/CertoraException$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final int computeExceptionErrorCode-OGnWXxg(ExceptionDetailsForErrorCode e) {
            return UInt.constructor-impl(e.hashCode());
        }

        public final int getErrorCodeForException-OGnWXxg(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter(t, "t");
            return this.computeExceptionErrorCode-OGnWXxg(ExceptionDetailsForErrorCode.Companion.invoke(t));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isTimeout(Throwable $this$isTimeout) {
            if ($this$isTimeout instanceof InterruptedException) return true;
            if ($this$isTimeout instanceof RejectedExecutionException) return true;
            if ($this$isTimeout instanceof TimeCheckException) return true;
            if (!($this$isTimeout instanceof ExecutionException)) return false;
            Throwable throwable = $this$isTimeout.getCause();
            if (throwable == null) return false;
            if (!this.isTimeout(throwable)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CertoraException fromException(@NotNull Throwable t, @Nullable String customMsg) {
            CertoraException certoraException;
            Intrinsics.checkNotNullParameter(t, "t");
            if (t instanceof CertoraException) {
                certoraException = (CertoraException)t;
            } else if (this.isTimeout(t)) {
                String string = customMsg;
                if (string == null) {
                    string = "Timeout";
                }
                certoraException = new CertoraException(CertoraErrorType.TASK_TIMEOUT, string, null, 4, null);
            } else {
                String string;
                Object object;
                Logger.Companion.alwaysError("Unknown error " + t, t);
                ExceptionDetailsForErrorCode exceptionDetails = ExceptionDetailsForErrorCode.Companion.invoke(t);
                int code = this.computeExceptionErrorCode-OGnWXxg(exceptionDetails);
                Logger.Companion.regression((Function0<? extends Object>)new Function0<Object>(t, exceptionDetails, code){
                    final /* synthetic */ Throwable $t;
                    final /* synthetic */ ExceptionDetailsForErrorCode $exceptionDetails;
                    final /* synthetic */ int $code;
                    {
                        this.$t = $t;
                        this.$exceptionDetails = $exceptionDetails;
                        this.$code = $code;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Error code of " + this.$t + ": " + this.$exceptionDetails + ": " + UInt.toString-impl(this.$code);
                    }
                });
                CertoraErrorType certoraErrorType = CertoraErrorType.UNKNOWN;
                String string2 = UInt.toString-impl(code);
                String string3 = customMsg;
                if (string3 == null) {
                    string3 = t.getMessage();
                }
                if (string3 != null) {
                    void it;
                    String string4 = string3;
                    String string5 = string2;
                    CertoraErrorType certoraErrorType2 = certoraErrorType;
                    boolean bl = false;
                    String string6 = ". Error message: " + (String)it;
                    certoraErrorType = certoraErrorType2;
                    string2 = string5;
                    object = string6;
                } else {
                    object = string = null;
                }
                if (object == null) {
                    string = "";
                }
                Throwable throwable = t;
                String string7 = "Encountered an unexpected error in Prover, please report in certora.com. Error code " + string2 + string;
                CertoraErrorType certoraErrorType3 = certoraErrorType;
                certoraException = new CertoraException(certoraErrorType3, string7, throwable);
            }
            return certoraException;
        }

        public static /* synthetic */ CertoraException fromException$default(Companion companion, Throwable throwable, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.fromException(throwable, string);
        }

        @NotNull
        public final CertoraException fromExceptionWithRuleName(@NotNull Throwable t, @NotNull String ruleName) {
            Intrinsics.checkNotNullParameter(t, "t");
            Intrinsics.checkNotNullParameter(ruleName, "ruleName");
            return this.isTimeout(t) ? this.fromException(t, "Rule " + ruleName + " timed-out") : this.fromException(t, "Rule " + ruleName + " had an error");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lutils/CertoraException$Companion$ExceptionDetailsForErrorCode;", "", "exceptionName", "", "context", "(Ljava/lang/String;Ljava/lang/String;)V", "getContext", "()Ljava/lang/String;", "getExceptionName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Shared"})
        public static final class ExceptionDetailsForErrorCode {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String exceptionName;
            @NotNull
            private final String context;

            public ExceptionDetailsForErrorCode(@NotNull String exceptionName, @NotNull String context) {
                Intrinsics.checkNotNullParameter(exceptionName, "exceptionName");
                Intrinsics.checkNotNullParameter(context, "context");
                this.exceptionName = exceptionName;
                this.context = context;
            }

            @NotNull
            public final String getExceptionName() {
                return this.exceptionName;
            }

            @NotNull
            public final String getContext() {
                return this.context;
            }

            @NotNull
            public final String component1() {
                return this.exceptionName;
            }

            @NotNull
            public final String component2() {
                return this.context;
            }

            @NotNull
            public final ExceptionDetailsForErrorCode copy(@NotNull String exceptionName, @NotNull String context) {
                Intrinsics.checkNotNullParameter(exceptionName, "exceptionName");
                Intrinsics.checkNotNullParameter(context, "context");
                return new ExceptionDetailsForErrorCode(exceptionName, context);
            }

            public static /* synthetic */ ExceptionDetailsForErrorCode copy$default(ExceptionDetailsForErrorCode exceptionDetailsForErrorCode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = exceptionDetailsForErrorCode.exceptionName;
                }
                if ((n & 2) != 0) {
                    string2 = exceptionDetailsForErrorCode.context;
                }
                return exceptionDetailsForErrorCode.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "ExceptionDetailsForErrorCode(exceptionName=" + this.exceptionName + ", context=" + this.context + ")";
            }

            public int hashCode() {
                int result2 = this.exceptionName.hashCode();
                result2 = result2 * 31 + this.context.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExceptionDetailsForErrorCode)) {
                    return false;
                }
                ExceptionDetailsForErrorCode exceptionDetailsForErrorCode = (ExceptionDetailsForErrorCode)other;
                if (!Intrinsics.areEqual(this.exceptionName, exceptionDetailsForErrorCode.exceptionName)) {
                    return false;
                }
                return Intrinsics.areEqual(this.context, exceptionDetailsForErrorCode.context);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lutils/CertoraException$Companion$ExceptionDetailsForErrorCode$Companion;", "", "()V", "invoke", "Lutils/CertoraException$Companion$ExceptionDetailsForErrorCode;", "t", "", "Shared"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final ExceptionDetailsForErrorCode invoke(@NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter(t, "t");
                    String string = t.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue(string, "t.javaClass.name");
                    StackTraceElement[] stackTraceElementArray = t.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "t.stackTrace");
                    StackTraceElement stackTraceElement = (StackTraceElement)ArraysKt.firstOrNull((Object[])stackTraceElementArray);
                    String string2 = stackTraceElement != null ? stackTraceElement.toString() : null;
                    if (string2 == null) {
                        string2 = "";
                    }
                    return new ExceptionDetailsForErrorCode(string, string2);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

