/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.Config;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.DegenerateTimeChecker;
import utils.TimeCheckException;
import utils.TimeChecker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u00020\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lutils/TimePing;", "Ljava/lang/Thread;", "frequencySeconds", "", "doPing", "", "checker", "Lutils/TimeChecker;", "startTime", "Ljava/time/Instant;", "(JZLutils/TimeChecker;Ljava/time/Instant;)V", "getChecker", "()Lutils/TimeChecker;", "getDoPing", "()Z", "elapsedMinutes", "getElapsedMinutes", "()J", "getFrequencySeconds", "getStartTime", "()Ljava/time/Instant;", "bye", "", "run", "threadDump", "", "toStringFull", "Ljava/lang/management/ThreadInfo;", "Companion", "Shared"})
@SourceDebugExtension(value={"SMAP\nOutPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutPrinter.kt\nutils/TimePing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1549#2:240\n1620#2,3:241\n*S KotlinDebug\n*F\n+ 1 OutPrinter.kt\nutils/TimePing\n*L\n118#1:240\n118#1:241,3\n*E\n"})
public final class TimePing
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long frequencySeconds;
    private final boolean doPing;
    @NotNull
    private final TimeChecker checker;
    @NotNull
    private final Instant startTime;
    @NotNull
    private static final List<Function0<String>> progressReports = new ArrayList();

    public TimePing(long frequencySeconds, boolean doPing, @NotNull TimeChecker checker, @NotNull Instant startTime2) {
        Intrinsics.checkNotNullParameter(checker, "checker");
        Intrinsics.checkNotNullParameter(startTime2, "startTime");
        this.frequencySeconds = frequencySeconds;
        this.doPing = doPing;
        this.checker = checker;
        this.startTime = startTime2;
    }

    public /* synthetic */ TimePing(long l, boolean bl, TimeChecker timeChecker, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            timeChecker = new DegenerateTimeChecker();
        }
        if ((n & 8) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue(instant2, "now()");
            instant = instant2;
        }
        this(l, bl, timeChecker, instant);
    }

    public final long getFrequencySeconds() {
        return this.frequencySeconds;
    }

    public final boolean getDoPing() {
        return this.doPing;
    }

    @NotNull
    public final TimeChecker getChecker() {
        return this.checker;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    public final long getElapsedMinutes() {
        return Duration.between(this.startTime, Instant.now()).toMinutes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Logger.Companion.always("Start " + Calendar.getInstance().getTime(), false);
        try {
            while (true) {
                Thread.sleep(this.frequencySeconds * (long)1000);
                if (this.doPing) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = progressReports;
                    long l = this.getElapsedMinutes();
                    boolean $i$f$map = false;
                    void var4_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Function0 function0 = (Function0)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((String)it.invoke());
                    }
                    collection = (List)destination$iv$iv;
                    String msg = "Ping " + l + "m - " + CollectionsKt.joinToString$default(collection, ";", null, null, 0, null, null, 62, null);
                    Logger.Companion.always(msg, false);
                    if (((Boolean)Config.INSTANCE.getShowPingInStderr().get()).booleanValue()) {
                        System.err.println(msg);
                    }
                }
                this.checker.check();
            }
        }
        catch (InterruptedException msg) {
            Logger.Companion.always("Done " + this.getElapsedMinutes() + "m", false);
        }
        catch (TimeCheckException e) {
            try {
                Logger.Companion.always("Global timeout reached, hard stopping everything", false);
                Logger.Companion.always(this.threadDump(), false);
                throw e;
            }
            catch (Throwable throwable) {
                Logger.Companion.always("Done " + this.getElapsedMinutes() + "m", false);
                throw throwable;
            }
        }
    }

    private final String threadDump() {
        StringBuilder threadDump = new StringBuilder(System.lineSeparator());
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue(threadMXBean, "getThreadMXBean()");
        ThreadMXBean threadMXBean2 = threadMXBean;
        ThreadInfo[] threadInfoArray = threadMXBean2.dumpAllThreads(true, true);
        Intrinsics.checkNotNullExpressionValue(threadInfoArray, "threadMXBean.dumpAllThreads(true, true)");
        for (ThreadInfo threadInfo : threadInfoArray) {
            Intrinsics.checkNotNullExpressionValue(threadInfo, "threadInfo");
            threadDump.append(this.toStringFull(threadInfo));
        }
        String string = threadDump.toString();
        Intrinsics.checkNotNullExpressionValue(string, "threadDump.toString()");
        return string;
    }

    @Nullable
    public final String toStringFull(@NotNull ThreadInfo $this$toStringFull) {
        int i;
        Intrinsics.checkNotNullParameter($this$toStringFull, "<this>");
        StringBuilder sb = new StringBuilder("\"" + $this$toStringFull.getThreadName() + "\"" + ($this$toStringFull.isDaemon() ? " daemon" : "") + " prio=" + $this$toStringFull.getPriority() + " Id=" + $this$toStringFull.getThreadId() + " " + $this$toStringFull.getThreadState());
        if ($this$toStringFull.getLockName() != null) {
            sb.append(" on " + $this$toStringFull.getLockName());
        }
        if ($this$toStringFull.getLockOwnerName() != null) {
            sb.append(" owned by \"" + $this$toStringFull.getLockOwnerName() + "\" Id=" + $this$toStringFull.getLockOwnerId());
        }
        if ($this$toStringFull.isSuspended()) {
            sb.append(" (suspended)");
        }
        if ($this$toStringFull.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < $this$toStringFull.getStackTrace().length; ++i) {
            MonitorInfo[] monitorInfoArray;
            StackTraceElement ste;
            Intrinsics.checkNotNullExpressionValue($this$toStringFull.getStackTrace()[i], "stackTrace.get(i)");
            sb.append("\tat " + ste);
            sb.append('\n');
            if (i == 0 && $this$toStringFull.getLockInfo() != null) {
                Thread.State ts;
                Intrinsics.checkNotNullExpressionValue((Object)$this$toStringFull.getThreadState(), "getThreadState()");
                switch (WhenMappings.$EnumSwitchMapping$0[ts.ordinal()]) {
                    case 1: {
                        sb.append("\t-  blocked on " + $this$toStringFull.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case 2: {
                        sb.append("\t-  waiting on " + $this$toStringFull.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case 3: {
                        sb.append("\t-  waiting on " + $this$toStringFull.getLockInfo());
                        sb.append('\n');
                    }
                }
            }
            Intrinsics.checkNotNullExpressionValue($this$toStringFull.getLockedMonitors(), "lockedMonitors");
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo mi;
                Intrinsics.checkNotNullExpressionValue(monitorInfoArray[j], "lockedMonitors");
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + mi);
                sb.append('\n');
            }
        }
        if (i < $this$toStringFull.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        LockInfo[] lockInfoArray = $this$toStringFull.getLockedSynchronizers();
        Intrinsics.checkNotNullExpressionValue(lockInfoArray, "getLockedSynchronizers()");
        LockInfo[] locks = lockInfoArray;
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- " + li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public final void bye() {
        try {
            this.interrupt();
        }
        catch (Exception e) {
            try {
                Logger.Companion.alwaysError("Got error " + e + " when interrupting");
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lutils/TimePing$Companion;", "", "()V", "progressReports", "", "Lkotlin/Function0;", "", "getProgressReports", "()Ljava/util/List;", "registerReport", "", "f", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Function0<String>> getProgressReports() {
            return progressReports;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void registerReport(@NotNull Function0<String> f) {
            Intrinsics.checkNotNullParameter(f, "f");
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                boolean bl2 = Companion.getProgressReports().add(f);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            try {
                nArray[Thread.State.BLOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.WAITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.TIMED_WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

