# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.20.118
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import velo_payments
from velo_payments.models.payment_response_v4 import PaymentResponseV4  # noqa: E501
from velo_payments.rest import ApiException

class TestPaymentResponseV4(unittest.TestCase):
    """PaymentResponseV4 unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test PaymentResponseV4
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = velo_payments.models.payment_response_v4.PaymentResponseV4()  # noqa: E501
        if include_optional :
            return PaymentResponseV4(
                payment_id = '0', 
                payee_id = '0', 
                payor_id = '0', 
                payor_name = '0', 
                quote_id = '0', 
                source_account_id = '0', 
                source_account_name = 'My Account', 
                remote_id = 'aasdf123', 
                source_amount = 12345, 
                source_currency = 'USD', 
                payment_amount = 56, 
                payment_currency = 'USD', 
                rate = 1.337, 
                inverted_rate = 1.337, 
                submitted_date_time = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), 
                status = 'ACCEPTED', 
                funding_status = 'FUNDED', 
                routing_number = '123123123123', 
                account_number = '123123232323', 
                iban = 'DE89 3704 0044 0532 0130 00', 
                payment_memo = 'Payment memo', 
                filename_reference = 'file ref', 
                individual_identification_number = '1231231adf', 
                trace_number = 'abodu123', 
                payor_payment_id = '123123asdf', 
                payment_channel_id = '123asdf', 
                payment_channel_name = 'My Payment Channel', 
                account_name = 'My Account Name', 
                rails_id = 'RAILS ID UNAVAILABLE', 
                country_code = 'US', 
                events = [
                    {"principal":"principal","eventId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","eventDateTime":"2000-01-23T04:56:07.000+00:00","routingNumber":"routingNumber","accountName":"accountName","iban":"iban","sourceAmount":1299,"eventType":"PAYOUT_SUBMITTED","accountNumber":"accountNumber","paymentAmount":1299}
                    ], 
                return_cost = 1232, 
                return_reason = 'Some Reason Value', 
                rails_payment_id = '0', 
                rails_batch_id = '0', 
                rejection_reason = '0', 
                payout = {"payoutId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","payoutFrom":{"principal":"principal","principalId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","payorId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","dbaName":"dbaName","payorName":"payorName"},"payoutTo":{"principal":"principal","principalId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","payorId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","dbaName":"dbaName","payorName":"payorName"}}
            )
        else :
            return PaymentResponseV4(
                payment_id = '0',
                payee_id = '0',
                payor_id = '0',
                quote_id = '0',
                source_account_id = '0',
                payment_amount = 56,
                submitted_date_time = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                status = 'ACCEPTED',
                funding_status = 'FUNDED',
                rails_id = 'RAILS ID UNAVAILABLE',
                events = [
                    {"principal":"principal","eventId":"046b6c7f-0b8a-43b9-b35d-6489e6daee91","eventDateTime":"2000-01-23T04:56:07.000+00:00","routingNumber":"routingNumber","accountName":"accountName","iban":"iban","sourceAmount":1299,"eventType":"PAYOUT_SUBMITTED","accountNumber":"accountNumber","paymentAmount":1299}
                    ],
        )

    def testPaymentResponseV4(self):
        """Test PaymentResponseV4"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
