# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.20.118
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from velo_payments.configuration import Configuration


class PayeeResponse2(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'payee_id': 'str',
        'payor_refs': 'list[PayeePayorRefV3]',
        'email': 'str',
        'address': 'PayeeAddress',
        'country': 'str',
        'display_name': 'str',
        'payment_channel': 'PayeePaymentChannel',
        'challenge': 'Challenge',
        'language': 'Language',
        'accept_terms_and_conditions_timestamp': 'datetime',
        'cellphone_number': 'str',
        'payee_type': 'PayeeType',
        'company': 'CompanyResponse',
        'individual': 'IndividualResponse',
        'created': 'datetime',
        'grace_period_end_date': 'date',
        'watchlist_status_updated_timestamp': 'str',
        'marketing_opt_ins': 'list[MarketingOptIn]',
        'watchlist_status': 'WatchlistStatus',
        'onboarded_status': 'OnboardedStatus'
    }

    attribute_map = {
        'payee_id': 'payeeId',
        'payor_refs': 'payorRefs',
        'email': 'email',
        'address': 'address',
        'country': 'country',
        'display_name': 'displayName',
        'payment_channel': 'paymentChannel',
        'challenge': 'challenge',
        'language': 'language',
        'accept_terms_and_conditions_timestamp': 'acceptTermsAndConditionsTimestamp',
        'cellphone_number': 'cellphoneNumber',
        'payee_type': 'payeeType',
        'company': 'company',
        'individual': 'individual',
        'created': 'created',
        'grace_period_end_date': 'gracePeriodEndDate',
        'watchlist_status_updated_timestamp': 'watchlistStatusUpdatedTimestamp',
        'marketing_opt_ins': 'marketingOptIns',
        'watchlist_status': 'watchlistStatus',
        'onboarded_status': 'onboardedStatus'
    }

    def __init__(self, payee_id=None, payor_refs=None, email=None, address=None, country=None, display_name=None, payment_channel=None, challenge=None, language=None, accept_terms_and_conditions_timestamp=None, cellphone_number=None, payee_type=None, company=None, individual=None, created=None, grace_period_end_date=None, watchlist_status_updated_timestamp=None, marketing_opt_ins=None, watchlist_status=None, onboarded_status=None, local_vars_configuration=None):  # noqa: E501
        """PayeeResponse2 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._payee_id = None
        self._payor_refs = None
        self._email = None
        self._address = None
        self._country = None
        self._display_name = None
        self._payment_channel = None
        self._challenge = None
        self._language = None
        self._accept_terms_and_conditions_timestamp = None
        self._cellphone_number = None
        self._payee_type = None
        self._company = None
        self._individual = None
        self._created = None
        self._grace_period_end_date = None
        self._watchlist_status_updated_timestamp = None
        self._marketing_opt_ins = None
        self._watchlist_status = None
        self._onboarded_status = None
        self.discriminator = None

        if payee_id is not None:
            self.payee_id = payee_id
        self.payor_refs = payor_refs
        self.email = email
        if address is not None:
            self.address = address
        if country is not None:
            self.country = country
        if display_name is not None:
            self.display_name = display_name
        if payment_channel is not None:
            self.payment_channel = payment_channel
        if challenge is not None:
            self.challenge = challenge
        if language is not None:
            self.language = language
        self.accept_terms_and_conditions_timestamp = accept_terms_and_conditions_timestamp
        if cellphone_number is not None:
            self.cellphone_number = cellphone_number
        if payee_type is not None:
            self.payee_type = payee_type
        self.company = company
        if individual is not None:
            self.individual = individual
        if created is not None:
            self.created = created
        self.grace_period_end_date = grace_period_end_date
        self.watchlist_status_updated_timestamp = watchlist_status_updated_timestamp
        if marketing_opt_ins is not None:
            self.marketing_opt_ins = marketing_opt_ins
        if watchlist_status is not None:
            self.watchlist_status = watchlist_status
        if onboarded_status is not None:
            self.onboarded_status = onboarded_status

    @property
    def payee_id(self):
        """Gets the payee_id of this PayeeResponse2.  # noqa: E501


        :return: The payee_id of this PayeeResponse2.  # noqa: E501
        :rtype: str
        """
        return self._payee_id

    @payee_id.setter
    def payee_id(self, payee_id):
        """Sets the payee_id of this PayeeResponse2.


        :param payee_id: The payee_id of this PayeeResponse2.  # noqa: E501
        :type: str
        """

        self._payee_id = payee_id

    @property
    def payor_refs(self):
        """Gets the payor_refs of this PayeeResponse2.  # noqa: E501


        :return: The payor_refs of this PayeeResponse2.  # noqa: E501
        :rtype: list[PayeePayorRefV3]
        """
        return self._payor_refs

    @payor_refs.setter
    def payor_refs(self, payor_refs):
        """Sets the payor_refs of this PayeeResponse2.


        :param payor_refs: The payor_refs of this PayeeResponse2.  # noqa: E501
        :type: list[PayeePayorRefV3]
        """

        self._payor_refs = payor_refs

    @property
    def email(self):
        """Gets the email of this PayeeResponse2.  # noqa: E501


        :return: The email of this PayeeResponse2.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this PayeeResponse2.


        :param email: The email of this PayeeResponse2.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def address(self):
        """Gets the address of this PayeeResponse2.  # noqa: E501


        :return: The address of this PayeeResponse2.  # noqa: E501
        :rtype: PayeeAddress
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this PayeeResponse2.


        :param address: The address of this PayeeResponse2.  # noqa: E501
        :type: PayeeAddress
        """

        self._address = address

    @property
    def country(self):
        """Gets the country of this PayeeResponse2.  # noqa: E501


        :return: The country of this PayeeResponse2.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this PayeeResponse2.


        :param country: The country of this PayeeResponse2.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def display_name(self):
        """Gets the display_name of this PayeeResponse2.  # noqa: E501


        :return: The display_name of this PayeeResponse2.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this PayeeResponse2.


        :param display_name: The display_name of this PayeeResponse2.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def payment_channel(self):
        """Gets the payment_channel of this PayeeResponse2.  # noqa: E501


        :return: The payment_channel of this PayeeResponse2.  # noqa: E501
        :rtype: PayeePaymentChannel
        """
        return self._payment_channel

    @payment_channel.setter
    def payment_channel(self, payment_channel):
        """Sets the payment_channel of this PayeeResponse2.


        :param payment_channel: The payment_channel of this PayeeResponse2.  # noqa: E501
        :type: PayeePaymentChannel
        """

        self._payment_channel = payment_channel

    @property
    def challenge(self):
        """Gets the challenge of this PayeeResponse2.  # noqa: E501


        :return: The challenge of this PayeeResponse2.  # noqa: E501
        :rtype: Challenge
        """
        return self._challenge

    @challenge.setter
    def challenge(self, challenge):
        """Sets the challenge of this PayeeResponse2.


        :param challenge: The challenge of this PayeeResponse2.  # noqa: E501
        :type: Challenge
        """

        self._challenge = challenge

    @property
    def language(self):
        """Gets the language of this PayeeResponse2.  # noqa: E501


        :return: The language of this PayeeResponse2.  # noqa: E501
        :rtype: Language
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this PayeeResponse2.


        :param language: The language of this PayeeResponse2.  # noqa: E501
        :type: Language
        """

        self._language = language

    @property
    def accept_terms_and_conditions_timestamp(self):
        """Gets the accept_terms_and_conditions_timestamp of this PayeeResponse2.  # noqa: E501

        The timestamp when the payee last accepted T&Cs  # noqa: E501

        :return: The accept_terms_and_conditions_timestamp of this PayeeResponse2.  # noqa: E501
        :rtype: datetime
        """
        return self._accept_terms_and_conditions_timestamp

    @accept_terms_and_conditions_timestamp.setter
    def accept_terms_and_conditions_timestamp(self, accept_terms_and_conditions_timestamp):
        """Sets the accept_terms_and_conditions_timestamp of this PayeeResponse2.

        The timestamp when the payee last accepted T&Cs  # noqa: E501

        :param accept_terms_and_conditions_timestamp: The accept_terms_and_conditions_timestamp of this PayeeResponse2.  # noqa: E501
        :type: datetime
        """

        self._accept_terms_and_conditions_timestamp = accept_terms_and_conditions_timestamp

    @property
    def cellphone_number(self):
        """Gets the cellphone_number of this PayeeResponse2.  # noqa: E501


        :return: The cellphone_number of this PayeeResponse2.  # noqa: E501
        :rtype: str
        """
        return self._cellphone_number

    @cellphone_number.setter
    def cellphone_number(self, cellphone_number):
        """Sets the cellphone_number of this PayeeResponse2.


        :param cellphone_number: The cellphone_number of this PayeeResponse2.  # noqa: E501
        :type: str
        """

        self._cellphone_number = cellphone_number

    @property
    def payee_type(self):
        """Gets the payee_type of this PayeeResponse2.  # noqa: E501


        :return: The payee_type of this PayeeResponse2.  # noqa: E501
        :rtype: PayeeType
        """
        return self._payee_type

    @payee_type.setter
    def payee_type(self, payee_type):
        """Sets the payee_type of this PayeeResponse2.


        :param payee_type: The payee_type of this PayeeResponse2.  # noqa: E501
        :type: PayeeType
        """

        self._payee_type = payee_type

    @property
    def company(self):
        """Gets the company of this PayeeResponse2.  # noqa: E501


        :return: The company of this PayeeResponse2.  # noqa: E501
        :rtype: CompanyResponse
        """
        return self._company

    @company.setter
    def company(self, company):
        """Sets the company of this PayeeResponse2.


        :param company: The company of this PayeeResponse2.  # noqa: E501
        :type: CompanyResponse
        """

        self._company = company

    @property
    def individual(self):
        """Gets the individual of this PayeeResponse2.  # noqa: E501


        :return: The individual of this PayeeResponse2.  # noqa: E501
        :rtype: IndividualResponse
        """
        return self._individual

    @individual.setter
    def individual(self, individual):
        """Sets the individual of this PayeeResponse2.


        :param individual: The individual of this PayeeResponse2.  # noqa: E501
        :type: IndividualResponse
        """

        self._individual = individual

    @property
    def created(self):
        """Gets the created of this PayeeResponse2.  # noqa: E501


        :return: The created of this PayeeResponse2.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this PayeeResponse2.


        :param created: The created of this PayeeResponse2.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def grace_period_end_date(self):
        """Gets the grace_period_end_date of this PayeeResponse2.  # noqa: E501


        :return: The grace_period_end_date of this PayeeResponse2.  # noqa: E501
        :rtype: date
        """
        return self._grace_period_end_date

    @grace_period_end_date.setter
    def grace_period_end_date(self, grace_period_end_date):
        """Sets the grace_period_end_date of this PayeeResponse2.


        :param grace_period_end_date: The grace_period_end_date of this PayeeResponse2.  # noqa: E501
        :type: date
        """

        self._grace_period_end_date = grace_period_end_date

    @property
    def watchlist_status_updated_timestamp(self):
        """Gets the watchlist_status_updated_timestamp of this PayeeResponse2.  # noqa: E501


        :return: The watchlist_status_updated_timestamp of this PayeeResponse2.  # noqa: E501
        :rtype: str
        """
        return self._watchlist_status_updated_timestamp

    @watchlist_status_updated_timestamp.setter
    def watchlist_status_updated_timestamp(self, watchlist_status_updated_timestamp):
        """Sets the watchlist_status_updated_timestamp of this PayeeResponse2.


        :param watchlist_status_updated_timestamp: The watchlist_status_updated_timestamp of this PayeeResponse2.  # noqa: E501
        :type: str
        """

        self._watchlist_status_updated_timestamp = watchlist_status_updated_timestamp

    @property
    def marketing_opt_ins(self):
        """Gets the marketing_opt_ins of this PayeeResponse2.  # noqa: E501


        :return: The marketing_opt_ins of this PayeeResponse2.  # noqa: E501
        :rtype: list[MarketingOptIn]
        """
        return self._marketing_opt_ins

    @marketing_opt_ins.setter
    def marketing_opt_ins(self, marketing_opt_ins):
        """Sets the marketing_opt_ins of this PayeeResponse2.


        :param marketing_opt_ins: The marketing_opt_ins of this PayeeResponse2.  # noqa: E501
        :type: list[MarketingOptIn]
        """

        self._marketing_opt_ins = marketing_opt_ins

    @property
    def watchlist_status(self):
        """Gets the watchlist_status of this PayeeResponse2.  # noqa: E501


        :return: The watchlist_status of this PayeeResponse2.  # noqa: E501
        :rtype: WatchlistStatus
        """
        return self._watchlist_status

    @watchlist_status.setter
    def watchlist_status(self, watchlist_status):
        """Sets the watchlist_status of this PayeeResponse2.


        :param watchlist_status: The watchlist_status of this PayeeResponse2.  # noqa: E501
        :type: WatchlistStatus
        """

        self._watchlist_status = watchlist_status

    @property
    def onboarded_status(self):
        """Gets the onboarded_status of this PayeeResponse2.  # noqa: E501


        :return: The onboarded_status of this PayeeResponse2.  # noqa: E501
        :rtype: OnboardedStatus
        """
        return self._onboarded_status

    @onboarded_status.setter
    def onboarded_status(self, onboarded_status):
        """Sets the onboarded_status of this PayeeResponse2.


        :param onboarded_status: The onboarded_status of this PayeeResponse2.  # noqa: E501
        :type: OnboardedStatus
        """

        self._onboarded_status = onboarded_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PayeeResponse2):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PayeeResponse2):
            return True

        return self.to_dict() != other.to_dict()
