# coding: utf-8

"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.20.118
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from velo_payments.configuration import Configuration


class PaymentChannelRule(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'element': 'str',
        'required': 'bool',
        'display_name': 'str',
        'min_length': 'int',
        'max_length': 'int',
        'validation': 'str',
        'display_order': 'int'
    }

    attribute_map = {
        'element': 'element',
        'required': 'required',
        'display_name': 'displayName',
        'min_length': 'minLength',
        'max_length': 'maxLength',
        'validation': 'validation',
        'display_order': 'displayOrder'
    }

    def __init__(self, element=None, required=None, display_name=None, min_length=None, max_length=None, validation=None, display_order=None, local_vars_configuration=None):  # noqa: E501
        """PaymentChannelRule - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._element = None
        self._required = None
        self._display_name = None
        self._min_length = None
        self._max_length = None
        self._validation = None
        self._display_order = None
        self.discriminator = None

        self.element = element
        self.required = required
        self.display_name = display_name
        if min_length is not None:
            self.min_length = min_length
        if max_length is not None:
            self.max_length = max_length
        self.validation = validation
        if display_order is not None:
            self.display_order = display_order

    @property
    def element(self):
        """Gets the element of this PaymentChannelRule.  # noqa: E501

        <p>the rule element</p> <p>will match a given element name for a payment channel configuration   # noqa: E501

        :return: The element of this PaymentChannelRule.  # noqa: E501
        :rtype: str
        """
        return self._element

    @element.setter
    def element(self, element):
        """Sets the element of this PaymentChannelRule.

        <p>the rule element</p> <p>will match a given element name for a payment channel configuration   # noqa: E501

        :param element: The element of this PaymentChannelRule.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and element is None:  # noqa: E501
            raise ValueError("Invalid value for `element`, must not be `None`")  # noqa: E501

        self._element = element

    @property
    def required(self):
        """Gets the required of this PaymentChannelRule.  # noqa: E501

        is this element required  # noqa: E501

        :return: The required of this PaymentChannelRule.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this PaymentChannelRule.

        is this element required  # noqa: E501

        :param required: The required of this PaymentChannelRule.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and required is None:  # noqa: E501
            raise ValueError("Invalid value for `required`, must not be `None`")  # noqa: E501

        self._required = required

    @property
    def display_name(self):
        """Gets the display_name of this PaymentChannelRule.  # noqa: E501

        User friendly name  # noqa: E501

        :return: The display_name of this PaymentChannelRule.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this PaymentChannelRule.

        User friendly name  # noqa: E501

        :param display_name: The display_name of this PaymentChannelRule.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and display_name is None:  # noqa: E501
            raise ValueError("Invalid value for `display_name`, must not be `None`")  # noqa: E501

        self._display_name = display_name

    @property
    def min_length(self):
        """Gets the min_length of this PaymentChannelRule.  # noqa: E501

        mininum length of the element data  # noqa: E501

        :return: The min_length of this PaymentChannelRule.  # noqa: E501
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """Sets the min_length of this PaymentChannelRule.

        mininum length of the element data  # noqa: E501

        :param min_length: The min_length of this PaymentChannelRule.  # noqa: E501
        :type: int
        """

        self._min_length = min_length

    @property
    def max_length(self):
        """Gets the max_length of this PaymentChannelRule.  # noqa: E501

        maximum length of the element data  # noqa: E501

        :return: The max_length of this PaymentChannelRule.  # noqa: E501
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """Sets the max_length of this PaymentChannelRule.

        maximum length of the element data  # noqa: E501

        :param max_length: The max_length of this PaymentChannelRule.  # noqa: E501
        :type: int
        """

        self._max_length = max_length

    @property
    def validation(self):
        """Gets the validation of this PaymentChannelRule.  # noqa: E501

        a regex to validate the element data  # noqa: E501

        :return: The validation of this PaymentChannelRule.  # noqa: E501
        :rtype: str
        """
        return self._validation

    @validation.setter
    def validation(self, validation):
        """Sets the validation of this PaymentChannelRule.

        a regex to validate the element data  # noqa: E501

        :param validation: The validation of this PaymentChannelRule.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and validation is None:  # noqa: E501
            raise ValueError("Invalid value for `validation`, must not be `None`")  # noqa: E501

        self._validation = validation

    @property
    def display_order(self):
        """Gets the display_order of this PaymentChannelRule.  # noqa: E501


        :return: The display_order of this PaymentChannelRule.  # noqa: E501
        :rtype: int
        """
        return self._display_order

    @display_order.setter
    def display_order(self, display_order):
        """Sets the display_order of this PaymentChannelRule.


        :param display_order: The display_order of this PaymentChannelRule.  # noqa: E501
        :type: int
        """

        self._display_order = display_order

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentChannelRule):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PaymentChannelRule):
            return True

        return self.to_dict() != other.to_dict()
