// Ruby bindings for Helix using magnus
// Generated automatically - review before use
#![cfg(feature = "ruby")]
use magnus::{prelude::*, Error as MagnusError, Ruby, exception::runtime_error, Value as MagnusValue};
use crate::dna::hel::dna_hlx::Hlx;
use crate::dna::atp::parser::Parser;
use crate::dna::compiler::Compiler;
use crate::dna::hel::dispatch::HelixDispatcher;
use crate::dna::atp::interpreter::HelixInterpreter;
use crate::dna::atp::ast::HelixAst;
use crate::dna::atp::types::{HelixConfig, ProjectConfig, AgentConfig, WorkflowConfig, MemoryConfig, ContextConfig, CrewConfig, PipelineConfig};
use crate::dna::atp::value::Value;
use crate::dna::vlt::Vault;
use crate::dna::ops::engine::OperatorEngine;
use crate::dna::mds::a_example::{Document, Embedding, Metadata};
use crate::dna::map::core::{TrainingSample, TrainingDataset};
use crate::dna::hel::binary::{HelixBinary, SymbolTableStats};
use crate::dna::ops::validation::{ValidationRule, ValidationResult};
use crate::dna::atp::output::CompressionAlgorithm;
use crate::dna::compiler::CompilerBuilder;
use crate::dna::mds::optimizer::OptimizationLevel;
use crate::dna::hel::hlx::CacheStats;
use crate::dna::mds::codegen::HelixIR;
use crate::dna::mds::search::SearchResult;
use crate::dna::hel::dna_hlx::TypedGetter;
use crate::dna::atp::lexer::TokenWithLocation;
use crate::dna::cmd::workflow::WorkflowAction;
use arrow::array::ArrayRef;
use std::os::raw::c_char;
use tokio::runtime::Runtime;
use std::sync::OnceLock;
use std::sync::Arc;
use std::collections::HashMap;
use std::path::{Path, PathBuf};
use crate::dna::hel::binary::CompressionMethod;
use crate::dna::hel::error::HlxResult;
use crate::dna::hel::dna_hlx::DatasetConfig;
use crate::dna::ops::fundamental::ExecutionContext;
use crate::dna::mds::filter::FilterConfig;
use crate::dna::mds::config::GlobalConfig;
use clap_complete::Shell;

// Type aliases for Ruby bindings
type RubyObject = MagnusValue;
type RubyHelixBinary = HelixBinary;
type RubyHelixIR = HelixIR;
type RecordBatch = crate::dna::hel::dna_hlx::RecordBatch;
type RubyExpression = MagnusValue;
type RubyUnknown = RubyObject;
type LintIssue = MagnusValue;
type Env = MagnusValue;
type HlxHeader = MagnusValue;
type ExportData = MagnusValue;
type ExportFormat = MagnusValue;
type TuiResult = MagnusValue;
type RubyTrainingDataset = TrainingDataset;
type RubyHelixVM = MagnusValue;
type Config = HelixConfig;
type Schema = serde_json::Value;
type JsonValue = serde_json::Value;

// Global runtime for Ruby extension
static RUNTIME: OnceLock<Runtime> = OnceLock::new();

fn get_runtime() -> Result<&'static Runtime, MagnusError> {
    RUNTIME.get_or_try_init(|| {
        Runtime::new().map_err(|e| MagnusError::new(
            runtime_error(),
            format!("Failed to create runtime: {}", e)
        ))
    })
}

// Ruby class for Helix
#[magnus::wrap(class = "Helix")]
pub struct Helix {
    // Instance state if needed
}

#[magnus::init]
fn init(ruby: &Ruby) -> Result<(), MagnusError> {
    let class = ruby.define_class("Helix", ruby.class_object())?;
    
    Ok(())
}

impl Helix {
    
    // add
    pub fn add(&self, _value: RubyObject) -> Result<u32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add(_value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_agent
    pub fn add_agent(&self, _agent: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_agent(_agent, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_batch
    pub fn add_batch(&self, batch: RecordBatch) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_batch(batch).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_context
    pub fn add_context(&self, _context: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_context(_context, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_crew
    pub fn add_crew(&self, _crew: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_crew(_crew, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_database
    pub fn add_database(&self, _database: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_database(_database, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_declaration
    pub fn add_declaration(&self, _decl: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::add_declaration(_decl, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_dependencies
    pub fn add_dependencies(&self, dependencies: Vec<String>, version: Option<String>, dev: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_dependencies(dependencies, version.as_deref(), dev, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_dependency
    pub fn add_dependency(&self, from: &str, to: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_dependency(from, to, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_entry
    pub fn add_entry(&self, entry: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_entry(entry, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_file
    pub fn add_file(&self, path: &str, binary: RubyHelixBinary, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_file(path, binary, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_filter
    pub fn add_filter(&self, name: &str, pattern: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_filter(name, pattern, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_load
    pub fn add_load(&self, _load: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_load(_load, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_memory
    pub fn add_memory(&self, _memory: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_memory(_memory, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_migration
    pub fn add_migration(&self, from_version: &str, to_version: &str, migration_fn: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_migration(from_version, to_version, migration_fn, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_pipeline
    pub fn add_pipeline(&self, _pipeline: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_pipeline(_pipeline, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_plugin
    pub fn add_plugin(&self, _plugin: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_plugin(_plugin, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_project
    pub fn add_project(&self, name: &str, properties: HashMap<String, Value>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_project(name, properties).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_row
    pub fn add_row(&self, row: HashMap<String, Value>, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_row(row, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_search_path
    pub fn add_search_path(&self, path: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::add_search_path(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_section
    pub fn add_section(&self, _section: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_section(_section, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // add_workflow
    pub fn add_workflow(&self, _workflow: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::add_workflow(_workflow, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // analyze
    pub fn analyze(&self, ast: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::analyze(ast, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // analyze_python_files_with_options
    pub fn analyze_python_files_with_options(&self, target_dir: &str, top_level: bool, with_versions: bool, verbose: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::analyze_python_files_with_options(target_dir, top_level, with_versions, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // apply_filters
    pub fn apply_filters(&self, input: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::apply_filters(input).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // array
    pub fn array(&self) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::array().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // as_boolean
    pub fn as_boolean(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::as_boolean().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // as_f64
    pub fn as_f64(&self) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::as_f64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // as_integer
    pub fn as_integer(&self) -> Result<Option<i64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::as_integer().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // ast_to_config
    pub fn ast_to_config(&self, ast: HelixAst) -> Result<HelixConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::ast_to_config(ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // base64_error
    pub fn base64_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::base64_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // benchmark_and_select
    pub fn benchmark_and_select(&self, data: &str) -> Result<CompressionAlgorithm, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::benchmark_and_select(data).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // binary
    pub fn binary(&self, left: &str, op: &str, right: &str) -> Result<RubyExpression, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::binary(left, op, right).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // binary_to_config
    pub fn binary_to_config(&self, binary: HelixBinary) -> Result<HelixConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::binary_to_config(binary).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // bool
    pub fn bool(&self) -> Result<Option<bool>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::bool().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // bool_or
    pub fn bool_or(&self, default: bool) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::bool_or(default).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // bool_or_false
    pub fn bool_or_false(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::bool_or_false().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // bool_or_true
    pub fn bool_or_true(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::bool_or_true().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // boolean
    pub fn boolean(&self) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::boolean().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // build
    pub fn build(&self) -> Result<Compiler, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::build().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // build_bundle
    pub fn build_bundle(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::build_bundle(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // builder
    pub fn builder(&self) -> Result<CompilerBuilder, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Compiler::builder().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // bundle_command
    pub fn bundle_command(&self, directory: PathBuf, output: PathBuf, include: Vec<String>, exclude: Vec<String>, tree_shake: bool, optimize: u8, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::bundle_command(directory, output, include, exclude, tree_shake, optimize, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // bundle_files
    pub fn bundle_files(&self, files: &str, optimization_level: OptimizationLevel) -> Result<HelixBinary, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::bundle_files(files, optimization_level).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cache
    pub fn cache(&self, enable: bool) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cache(enable).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cache_stats
    pub fn cache_stats(&self) -> Result<std::io::Result<CacheStats>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cache_stats().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // calculate_checksum
    pub fn calculate_checksum(&self) -> Result<u64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::calculate_checksum().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // can_migrate
    pub fn can_migrate(&self, from_version: &str, to_version: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::can_migrate(from_version, to_version).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // caption_file_exists_and_not_empty
    pub fn caption_file_exists_and_not_empty(&self, path: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::caption_file_exists_and_not_empty(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_circular
    pub fn check_circular(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_circular(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_dependencies
    pub fn check_dependencies(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_dependencies(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_environment
    pub fn check_environment(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_environment(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_file_issues
    pub fn check_file_issues(&self, content: &str, _file: &str) -> Result<Vec<LintIssue>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_file_issues(content, _file).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_line_issues
    pub fn check_line_issues(&self, line: &str, line_num: usize) -> Result<Vec<LintIssue>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_line_issues(line, line_num).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_type
    pub fn check_type(&self, field: &str, expr: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_type(field, expr).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // check_types
    pub fn check_types(&self, ast: &str) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::check_types(ast).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // clean_cache
    pub fn clean_cache(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::clean_cache(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // clean_project
    pub fn clean_project(&self, all: bool, cache: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::clean_project(all, cache, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // clear
    pub fn clear(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::clear(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // clear_cache
    pub fn clear_cache(&self) -> Result<std::io::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::clear_cache().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // clear_changes
    pub fn clear_changes(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::clear_changes(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // clear_filters
    pub fn clear_filters(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::clear_filters(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // close_active_tab
    pub fn close_active_tab(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::close_active_tab(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_add
    pub fn cmd_add(&self, dependency: &str, version: Option<String>, dev: bool, verbose: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_add(dependency, version.as_deref(), dev, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_bench
    pub fn cmd_bench(&self, pattern: Option<String>, iterations: Option<u32>) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_bench(pattern.as_deref(), iterations.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_bundle
    pub fn cmd_bundle(&self, input: Option<String>, output: Option<String>, include: Vec<String>, exclude: Vec<String>, tree_shake: bool, optimize: u8) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_bundle(input.as_deref(), output.as_deref(), include, exclude, tree_shake, optimize).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_clean
    pub fn cmd_clean(&self, _all: bool, _cache: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_clean(_all, _cache).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_compile
    pub fn cmd_compile(&self, input: Option<String>, output: Option<String>, compress: bool, optimize: u8, cache: bool, verbose: bool, quiet: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_compile(input.as_deref(), output.as_deref(), compress, optimize, cache, verbose, quiet).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_completions
    pub fn cmd_completions(&self, _shell: &str, _verbose: bool, _quiet: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_completions(_shell, _verbose, _quiet).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_dataset
    pub fn cmd_dataset(&self, files: Vec<String>, output: Option<String>, format: Option<String>) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_dataset(files, output.as_deref(), format.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_diff
    pub fn cmd_diff(&self, file1: *const c_char, file2: *const c_char, detailed: bool) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_diff(file1, file2, detailed).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_doctor
    pub fn cmd_doctor(&self, action: *const c_char) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_doctor(action).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_export
    pub fn cmd_export(&self, format: Option<String>, output: Option<String>, include_deps: bool, verbose: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_export(format.as_deref(), output.as_deref(), include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_filter
    pub fn cmd_filter(&self, _files: Vec<String>) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_filter(_files).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_fmt
    pub fn cmd_fmt(&self, _files: Vec<String>, _check: bool, _verbose: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_fmt(_files, _check, _verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_generate
    pub fn cmd_generate(&self, template: &str, output: Option<String>, name: Option<String>, force: bool, verbose: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_generate(template, output.as_deref(), name.as_deref(), force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_import
    pub fn cmd_import(&self, input: *const c_char, registry: *const c_char, token: *const c_char, dry_run: bool) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_import(input, registry, token, dry_run).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_info
    pub fn cmd_info(&self, input: Option<String>, file: Option<String>, output: Option<String>, format: Option<String>, symbols: bool, sections: bool, verbose: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_info(input.as_deref(), file.as_deref(), output.as_deref(), format.as_deref(), symbols, sections, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_init
    pub fn cmd_init(&self, name: Option<String>, dir: Option<String>, template: Option<String>, force: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_init(name.as_deref(), dir.as_deref(), template.as_deref(), force).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_lint
    pub fn cmd_lint(&self, _files: Vec<String>, _verbose: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_lint(_files, _verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_optimize
    pub fn cmd_optimize(&self, input: Option<String>, output: Option<String>, level: u8) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_optimize(input.as_deref(), output.as_deref(), level).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_publish
    pub fn cmd_publish(&self, action: *const c_char, registry: *const c_char, token: *const c_char, dry_run: bool, verbose: bool, quiet: bool, input: *const c_char, key: *const c_char, output: *const c_char, verify: bool, format: *const c_char, include_deps: bool) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_publish(action, registry, token, dry_run, verbose, quiet, input, key, output, verify, format, include_deps).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_remove
    pub fn cmd_remove(&self, _files: Vec<String>) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_remove(_files).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_reset
    pub fn cmd_reset(&self, _force: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_reset(_force).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_schema
    pub fn cmd_schema(&self, target: *const c_char, lang: *const c_char, output: *const c_char, verbose: bool) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_schema(target, lang, output, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_search
    pub fn cmd_search(&self, query: &str, search_type: Option<String>, limit: Option<u32>, threshold: Option<f64>, embeddings: Option<String>, auto_find: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_search(query, search_type.as_deref(), limit.as_deref(), threshold.as_deref(), embeddings.as_deref(), auto_find).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_serve
    pub fn cmd_serve(&self, port: Option<u16>, host: Option<String>, directory: Option<String>) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_serve(port.as_deref(), host.as_deref(), directory.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_sign
    pub fn cmd_sign(&self, input: &str, key: Option<String>, output: Option<String>, verify: bool, verbose: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_sign(input, key.as_deref(), output.as_deref(), verify, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_test
    pub fn cmd_test(&self, pattern: Option<String>, integration: bool) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_test(pattern.as_deref(), integration).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_tui
    pub fn cmd_tui(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_tui().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_validate
    pub fn cmd_validate(&self, target: Option<String>) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_validate(target.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_vlt
    pub fn cmd_vlt(&self, subcommand: *const c_char, name: *const c_char, path: *const c_char, editor: *const c_char, long: bool, description: *const c_char, limit: *const u32, version: *const c_char, force: bool, from: *const c_char, to: *const c_char, show: bool, compress: *const bool, retention_days: *const u32, max_versions: *const u32, dry_run: bool) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_vlt(subcommand, name, path, editor, long, description, limit, version, force, from, to, show, compress, retention_days, max_versions, dry_run).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cmd_watch
    pub fn cmd_watch(&self, input: Option<String>, output: Option<String>, optimize: u8, debounce: Option<u32>, filter: Option<String>) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cmd_watch(input.as_deref(), output.as_deref(), optimize, debounce.as_deref(), filter.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // collect_dependencies
    pub fn collect_dependencies(&self, _project_dir: &str) -> Result<std::collections::HashMap<String, String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::collect_dependencies(_project_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // collect_helix_files
    pub fn collect_helix_files(&self, dir: &str, files: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::collect_helix_files(dir, files).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // collect_source_files
    pub fn collect_source_files(&self, project_dir: &str) -> Result<std::collections::HashMap<String, String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::collect_source_files(project_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compilation_error
    pub fn compilation_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compilation_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compilation_order
    pub fn compilation_order(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compilation_order().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compile
    pub fn compile(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compile().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compile_command
    pub fn compile_command(&self, input: PathBuf, output: Option<PathBuf>, compress: bool, optimize: u8, cache: bool, verbose: bool, _quiet: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Compiler::compile_command(input, output.as_deref(), compress, optimize, cache, verbose, _quiet).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compile_source
    pub fn compile_source(&self, source: &str, source_path: Option<&Path>) -> Result<HelixBinary, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Compiler::compile_source(source, source_path.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compile_to_binary
    pub fn compile_to_binary(&self, content: &str) -> Result<HlxResult<crate::dna::hel::binary::HelixBinary>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Compiler::compile_to_binary(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // completions_command
    pub fn completions_command(&self, shell: Shell, verbose: bool, quiet: bool) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::completions_command(shell, verbose, quiet).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compress
    pub fn compress(&self, method: CompressionMethod) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compress(method).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compression
    pub fn compression(&self, enable: bool) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compression(enable).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compression_error
    pub fn compression_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compression_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compression_ratio
    pub fn compression_ratio(&self, original_size: usize) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compression_ratio(original_size).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // compute_statistics
    pub fn compute_statistics(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::compute_statistics(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // concat_files
    pub fn concat_files(&self, directory: &str, config: &str, dry_run: bool) -> Result<usize, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::concat_files(directory, config, dry_run).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // config_conversion
    pub fn config_conversion(&self, field: impl Into<String>, details: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::config_conversion(field, details).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // context
    pub fn context(&self) -> Result<&Arc<ExecutionContext>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::context().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // continue_execution
    pub fn continue_execution(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::continue_execution(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // convert_from_ruby_value
    pub fn convert_from_ruby_value(&self, value: RubyUnknown) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::convert_from_ruby_value(value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // convert_legacy_dataset
    pub fn convert_legacy_dataset(&self, legacy_config: HashMap<String, String>) -> Result<HlxResult<DatasetConfig>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::convert_legacy_dataset(legacy_config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // copy_directory
    pub fn copy_directory(&self, src: &str, dst: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::copy_directory(src, dst).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cosine_similarity
    pub fn cosine_similarity(&self, a: &str, b: &str) -> Result<f32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::cosine_similarity(a, b).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_default_config
    pub fn create_default_config(&self) -> Result<GlobalConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::create_default_config().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_default_filter
    pub fn create_default_filter(&self) -> Result<FilterConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_default_filter().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_error_response
    pub fn create_error_response(&self, status: &str, message: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_error_response(status, message).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_health_response
    pub fn create_health_response(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_health_response().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_html_response
    pub fn create_html_response(&self, html: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_html_response(html).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_new_tab
    pub fn create_new_tab(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_new_tab(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_package_archive
    pub fn create_package_archive(&self, project_dir: &str, manifest: &str, project_name: &str, version: &str, verbose: bool) -> Result<PathBuf, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_package_archive(project_dir, manifest, project_name, version, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_project
    pub fn create_project(&self, name: &str, path: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_project(name, path, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_ruby_array
    pub fn create_ruby_array(&self, env: Env, size: usize) -> Result<RubyUnknown, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_ruby_array(env, size).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_ruby_boolean
    pub fn create_ruby_boolean(&self, env: Env, b: bool) -> Result<RubyUnknown, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_ruby_boolean(env, b).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_ruby_error
    pub fn create_ruby_error(&self, message: &str) -> Result<RubyError, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_ruby_error(message).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_ruby_number
    pub fn create_ruby_number(&self, env: Env, n: f64) -> Result<RubyUnknown, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_ruby_number(env, n).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_ruby_object
    pub fn create_ruby_object(&self, env: Env) -> Result<RubyUnknown, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_ruby_object(env).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_ruby_string
    pub fn create_ruby_string(&self, env: Env, s: &str) -> Result<RubyUnknown, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_ruby_string(env, s).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // create_template
    pub fn create_template(&self, _user: &str, _reasoning: &str, _assistant: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::create_template(_user, _reasoning, _assistant).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cycle_operator_category_next
    pub fn cycle_operator_category_next(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::cycle_operator_category_next(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // cycle_operator_category_prev
    pub fn cycle_operator_category_prev(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::cycle_operator_category_prev(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // dataset_command
    pub fn dataset_command(&self, action: DatasetAction, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::dataset_command(action, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // dataset_not_found
    pub fn dataset_not_found(&self, path: PathBuf) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::dataset_not_found(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // dataset_processing
    pub fn dataset_processing(&self, message: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::dataset_processing(message).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decode_json_strings
    pub fn decode_json_strings(&self, value: Value) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decode_json_strings(value).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decompile
    pub fn decompile(&self, binary: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decompile(binary).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decompile_binary
    pub fn decompile_binary(&self, binary: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decompile_binary(binary).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decompile_command
    pub fn decompile_command(&self, input: PathBuf, output: Option<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decompile_command(input, output.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decompile_ir
    pub fn decompile_ir(&self, ir: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decompile_ir(ir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decompress
    pub fn decompress(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decompress().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // decompression_error
    pub fn decompression_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::decompression_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // delete
    pub fn delete(&self, key: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::delete(key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // dependency_graph
    pub fn dependency_graph(&self) -> Result<RubyDependencyGraph, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::dependency_graph().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // description
    pub fn description(&self, description: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::description(description).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // deserialization_error
    pub fn deserialization_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::deserialization_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // deserialize
    pub fn deserialize(&self, data: Vec<u8>) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::deserialize(data).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // deserialize_to_ir
    pub fn deserialize_to_ir(&self, binary: &str) -> Result<HelixIR, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::deserialize_to_ir(binary).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // detect_training_format
    pub fn detect_training_format(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::detect_training_format(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // diff_command
    pub fn diff_command(&self, file1: PathBuf, file2: PathBuf, detailed: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::diff_command(file1, file2, detailed).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // edit_config
    pub fn edit_config(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::edit_config(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // edit_config_file
    pub fn edit_config_file(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::edit_config_file(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // email
    pub fn email(&self) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::email().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // ensure_calc_dir
    pub fn ensure_calc_dir(&self) -> Result<std::io::Result<PathBuf>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::ensure_calc_dir().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // enum_values
    pub fn enum_values(&self, values: Vec<String>) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::enum_values(values).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // error_csharp
    pub fn error_csharp(&self, message: impl Into<String>) -> Result<CsError, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::error_csharp(message).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // eval_date_expression
    pub fn eval_date_expression(&self, fmt: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::eval_date_expression(fmt).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // eval_expr
    pub fn eval_expr(&self, expr: &str, env: &str) -> Result<i64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::eval_expr(expr, env).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // eval_math_expression
    pub fn eval_math_expression(&self, expr: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::eval_math_expression(expr).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // evaluate
    pub fn evaluate(&self, source: &str) -> Result<anyhow::Result<CalcResult>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::evaluate(source).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // evaluate_expression
    pub fn evaluate_expression(&self, expr: &str) -> Result<crate::dna::atp::value::Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::evaluate_expression(expr).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // exclude
    pub fn exclude(&self, _pattern: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::exclude(_pattern).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execute
    pub fn execute(&self, code: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::execute(code).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execute_ast
    pub fn execute_ast(&self, ast: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::execute_ast(ast).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execute_binary
    pub fn execute_binary(&self, binary: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::execute_binary(binary, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execute_date
    pub fn execute_date(&self, fmt: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::execute_date(fmt).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execute_helix
    pub fn execute_helix(&self, source: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::execute_helix(source).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execute_operator
    pub fn execute_operator(&self, operator: &str, params: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::execute_operator(operator, params).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // execution_error
    pub fn execution_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::execution_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_project
    pub fn export_project(&self, format: &str, output: Option<PathBuf>, include_deps: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_project(format, output.as_deref(), include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_to_docker
    pub fn export_to_docker(&self, output: &str, include_deps: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_to_docker(output, include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_to_json
    pub fn export_to_json(&self, output: &str, include_deps: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_to_json(output, include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_to_k8s
    pub fn export_to_k8s(&self, output: &str, include_deps: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_to_k8s(output, include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_to_kubernetes
    pub fn export_to_kubernetes(&self, project_dir: &str, output: Option<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_to_kubernetes(project_dir, output.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_to_toml
    pub fn export_to_toml(&self, output: &str, include_deps: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_to_toml(output, include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // export_to_yaml
    pub fn export_to_yaml(&self, output: &str, include_deps: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::export_to_yaml(output, include_deps, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // extract_keywords
    pub fn extract_keywords(&self, text: &str) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::extract_keywords(text).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // extract_project_name
    pub fn extract_project_name(&self, content: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::extract_project_name(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // extract_project_version
    pub fn extract_project_version(&self, content: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::extract_project_version(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // extract_training_metadata
    pub fn extract_training_metadata(&self, raw_metadata: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::extract_training_metadata(raw_metadata).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // f32
    pub fn f32(&self) -> Result<Option<f32>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::f32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // f64
    pub fn f64(&self) -> Result<Option<f64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::f64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // f64_or
    pub fn f64_or(&self, default: f64) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::f64_or(default).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // feature_error
    pub fn feature_error(&self, feature: impl Into<String>, message: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::feature_error(feature, message).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // field
    pub fn field(&self, name: impl Into<String>, rules: Vec<ValidationRule>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::field(name, rules).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // finalize
    pub fn finalize(&self, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::finalize(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // finalize_all
    pub fn finalize_all(&self, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::finalize_all(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // finalize_enhanced_with_source_map
    pub fn finalize_enhanced_with_source_map(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::finalize_enhanced_with_source_map(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // find_embedding_directories
    pub fn find_embedding_directories(&self) -> Result<Vec<PathBuf>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::find_embedding_directories().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // find_helix_files
    pub fn find_helix_files(&self, dir: &str, files: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::find_helix_files(dir, files).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // find_helix_files_recursive
    pub fn find_helix_files_recursive(&self, dir: &str, files: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::find_helix_files_recursive(dir, files).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // find_project_root
    pub fn find_project_root(&self) -> Result<PathBuf, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::find_project_root().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // find_schema_for_file
    pub fn find_schema_for_file(&self, json_path: &str, schema_dir: Option<&Path>) -> Result<Option<PathBuf>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::find_schema_for_file(json_path, schema_dir.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // flush_batch
    pub fn flush_batch(&self, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::flush_batch(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // fnmanage_cache
    pub fn fnmanage_cache(&self, action: CacheAction, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::fnmanage_cache(action, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // fnmanage_config
    pub fn fnmanage_config(&self, action: ConfigAction, key: Option<String>, value: Option<String>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::fnmanage_config(action, key.as_deref(), value.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // fnrun_diagnostics
    pub fn fnrun_diagnostics(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::fnrun_diagnostics(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // focus
    pub fn focus(&self, area: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::focus(area, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // format_conversion
    pub fn format_conversion(&self, from: impl Into<String>, to: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::format_conversion(from, to).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // format_files
    pub fn format_files(&self, files: Vec<PathBuf>, check: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::format_files(files, check, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // format_json_file
    pub fn format_json_file(&self, file: PathBuf) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::format_json_file(file).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // format_text_content
    pub fn format_text_content(&self, content: &str) -> Result<anyhow::Result<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::format_text_content(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // format_value
    pub fn format_value(&self, value: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::format_value(value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // format_with_source
    pub fn format_with_source(&self, source: &str, tokens: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::format_with_source(source, tokens).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_binary
    pub fn from_binary(&self, binary: &str) -> Result<RubyHelixIR, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_binary(binary).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_file
    pub fn from_file(&self, path: &str) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_file(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_json
    pub fn from_json(&self, _json_value: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_json(_json_value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_json_bytes
    pub fn from_json_bytes(&self, _bytes: Vec<u8>, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_json_bytes(_bytes, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_preset
    pub fn from_preset(&self, _preset: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_preset(_preset, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_str
    pub fn from_str(&self, s: &str) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_str(s).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_string
    pub fn from_string(&self, content: &str) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_string(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // from_u8
    pub fn from_u8(&self, _level: u8, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::from_u8(_level, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // garbage_collect
    pub fn garbage_collect(&self) -> Result<VaultResult<usize>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::garbage_collect().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // gather_json_paths
    pub fn gather_json_paths(&self, files: &str, data_dirs: &str) -> Result<Vec<PathBuf>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::gather_json_paths(files, data_dirs).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate
    pub fn generate(&self, ast: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate(ast, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_code
    pub fn generate_code(&self, template: &str, output: Option<PathBuf>, name: Option<String>, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_code(template, output.as_deref(), name.as_deref(), force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_csharp_schema
    pub fn generate_csharp_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_csharp_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_for_ast
    pub fn generate_for_ast(&self, ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::generate_for_ast(ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_for_ir
    pub fn generate_for_ir(&self, ir: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_for_ir(ir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_go_schema
    pub fn generate_go_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_go_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_java_schema
    pub fn generate_java_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_java_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_javascript_schema
    pub fn generate_javascript_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_javascript_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_large_config
    pub fn generate_large_config(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::generate_large_config().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_medium_config
    pub fn generate_medium_config(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::generate_medium_config().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_php_schema
    pub fn generate_php_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_php_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_python_schema
    pub fn generate_python_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_python_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_ruby_schema
    pub fn generate_ruby_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_ruby_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_rust_schema
    pub fn generate_rust_schema(&self, _ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_rust_schema(_ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_schema_code
    pub fn generate_schema_code(&self, ast: &str, lang: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::generate_schema_code(ast, lang).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // generate_small_config
    pub fn generate_small_config(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::generate_small_config().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get
    pub fn get(&self, id: u32) -> Result<Option<&String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get(id).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_agents
    pub fn get_agents(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::get_agents(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_all_configs
    pub fn get_all_configs(&self) -> Result<HashMap<PathBuf, HelixConfig>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::get_all_configs().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_array
    pub fn get_array(&self, section: &str, key: &str) -> Result<Option<&[Value]>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_array(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_auto
    pub fn get_auto(&self, section: &str, key: &str) -> Result<Option<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_auto(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_bool
    pub fn get_bool(&self, section: &str, key: &str) -> Result<Option<bool>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_bool(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_boolean
    pub fn get_boolean(&self, _key: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_boolean(_key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_bundle_path
    pub fn get_bundle_path(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_bundle_path().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_cache_directory
    pub fn get_cache_directory(&self) -> Result<PathBuf, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_cache_directory().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_changed_files
    pub fn get_changed_files(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_changed_files().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_compilation_order
    pub fn get_compilation_order(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_compilation_order().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_config
    pub fn get_config(&self, env: Env, name: &str, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::get_config(env, name, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_config_value
    pub fn get_config_value(&self, config: &str, key: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::get_config_value(config, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_context
    pub fn get_context(&self, location: &str, context_lines: usize) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::get_context(location, context_lines).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_contexts
    pub fn get_contexts(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::get_contexts(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_default_editor
    pub fn get_default_editor(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_default_editor().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_dynamic
    pub fn get_dynamic(&self, section: &str, key: &str) -> Result<Option<DynamicValue>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_dynamic(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_editor
    pub fn get_editor(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_editor().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_embedded_templates
    pub fn get_embedded_templates(&self) -> Result<&'static [(&'static str, &'static str)], MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_embedded_templates().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_embedding_stats
    pub fn get_embedding_stats(&self, embeddings: &str) -> Result<HashMap<String, serde_json::Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_embedding_stats(embeddings).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_endpoint
    pub fn get_endpoint(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_endpoint().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_error_count
    pub fn get_error_count(&self) -> Result<usize, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_error_count().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_errors
    pub fn get_errors(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::get_errors().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_f32
    pub fn get_f32(&self, section: &str, key: &str) -> Result<Option<f32>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_f32(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_f64
    pub fn get_f64(&self, section: &str, key: &str) -> Result<Option<f64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_f64(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_features
    pub fn get_features(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_features(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_file_path
    pub fn get_file_path(&self) -> Result<Option<&Path>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_file_path().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_files
    pub fn get_files(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_files().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_filter_names
    pub fn get_filter_names(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_filter_names().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_global_config_path
    pub fn get_global_config_path(&self) -> Result<PathBuf, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::get_global_config_path().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_history
    pub fn get_history(&self, path: &str) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_history(path).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_i32
    pub fn get_i32(&self, section: &str, key: &str) -> Result<Option<i32>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_i32(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_i64
    pub fn get_i64(&self, section: &str, key: &str) -> Result<Option<i64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_i64(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_level
    pub fn get_level(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_level().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_line
    pub fn get_line(&self, line_num: usize) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_line(line_num).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_memory
    pub fn get_memory(&self, env: Env, start: usize, length: usize, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_memory(env, start, length, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_migration_path
    pub fn get_migration_path(&self, from_version: &str, to_version: &str) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_migration_path(from_version, to_version).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_mut
    pub fn get_mut(&self, env: Env, _key: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_mut(env, _key, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_num
    pub fn get_num(&self, section: &str, key: &str) -> Result<Option<f64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_num(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_number
    pub fn get_number(&self, _key: &str) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_number(_key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_object
    pub fn get_object(&self, env: Env, _key: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_object(env, _key, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_or_create_helix_dir
    pub fn get_or_create_helix_dir(&self) -> Result<std::io::Result<PathBuf>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_or_create_helix_dir().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_output_files
    pub fn get_output_files(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_output_files().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_preview
    pub fn get_preview(&self) -> Result<Option<Vec<serde_json::Value>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_preview().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_project_name
    pub fn get_project_name(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_project_name().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_project_path
    pub fn get_project_path(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_project_path().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_projects
    pub fn get_projects(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::get_projects(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_random_sample
    pub fn get_random_sample(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_random_sample(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_raw
    pub fn get_raw(&self, section: &str, key: &str) -> Result<Option<&Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_raw(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_ref
    pub fn get_ref(&self, env: Env, key: &str, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::get_ref(env, key, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_registers
    pub fn get_registers(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_registers(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_report
    pub fn get_report(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_report().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_ruby_null
    pub fn get_ruby_null(&self, env: Env) -> Result<RubyUnknown, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_ruby_null(env).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_schema
    pub fn get_schema(&self) -> Result<&HlxHeader, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_schema().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_schema_version
    pub fn get_schema_version(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_schema_version().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_similarity
    pub fn get_similarity(&self, text1: &str, text2: &str) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_similarity(text1, text2).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_str
    pub fn get_str(&self, section: &str, key: &str) -> Result<Option<&str>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_str(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_string
    pub fn get_string(&self, section: &str, key: &str) -> Result<Option<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_string(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_supported_formats
    pub fn get_supported_formats(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_supported_formats().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_supported_targets
    pub fn get_supported_targets(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_supported_targets().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_u32
    pub fn get_u32(&self, section: &str, key: &str) -> Result<Option<u32>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_u32(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_u64
    pub fn get_u64(&self, section: &str, key: &str) -> Result<Option<u64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_u64(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_value
    pub fn get_value(&self, env: Env, key: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::get_value(env, key, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_variable
    pub fn get_variable(&self, name: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::get_variable(name).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_vec_bool
    pub fn get_vec_bool(&self, section: &str, key: &str) -> Result<Option<Vec<bool>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_vec_bool(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_vec_f64
    pub fn get_vec_f64(&self, section: &str, key: &str) -> Result<Option<Vec<f64>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_vec_f64(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_vec_i32
    pub fn get_vec_i32(&self, section: &str, key: &str) -> Result<Option<Vec<i32>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_vec_i32(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_vec_string
    pub fn get_vec_string(&self, section: &str, key: &str) -> Result<Option<Vec<String>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_vec_string(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_workflow_status
    pub fn get_workflow_status(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::get_workflow_status(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // get_workflows
    pub fn get_workflows(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixAst::get_workflows(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // handle_get_request
    pub fn handle_get_request(&self, path: &str, target_dir: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::handle_get_request(path, target_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // handle_request
    pub fn handle_request(&self, request: &str, target_dir: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::handle_request(request, target_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // has
    pub fn has(&self, key: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::has(key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // has_errors
    pub fn has_errors(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::has_errors().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // has_variable
    pub fn has_variable(&self, name: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::has_variable(name).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // hash_error
    pub fn hash_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::hash_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // helix_version
    pub fn helix_version(&self) -> Result<&'static str, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::helix_version().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // i32
    pub fn i32(&self) -> Result<Option<i32>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::i32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // i32_or
    pub fn i32_or(&self, default: i32) -> Result<i32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::i32_or(default).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // i64
    pub fn i64(&self) -> Result<Option<i64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::i64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // i64_or
    pub fn i64_or(&self, default: i64) -> Result<i64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::i64_or(default).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // import_export_data
    pub fn import_export_data(&self, export_data: ExportData, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::import_export_data(export_data, force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // import_from_json
    pub fn import_from_json(&self, input: &str, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::import_from_json(input, force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // import_from_toml
    pub fn import_from_toml(&self, input: &str, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::import_from_toml(input, force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // import_from_yaml
    pub fn import_from_yaml(&self, input: &str, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::import_from_yaml(input, force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // import_project
    pub fn import_project(&self, import_path: PathBuf, format: ExportFormat, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::import_project(import_path, format, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // include
    pub fn include(&self, _pattern: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::include(_pattern).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // increase
    pub fn increase(&self, section: &str, key: &str, amount: f64) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::increase(section, key, amount).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // index
    pub fn index(&self, section: &str) -> Result<Option<&HashMap<String, Value>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::index(section).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // index_mut
    pub fn index_mut(&self, section: &str) -> Result<Option<&mut HashMap<String, Value>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::index_mut(section).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // infer_type
    pub fn infer_type(&self, expression: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::infer_type(expression).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // info
    pub fn info(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::info(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // info_command
    pub fn info_command(&self, file: PathBuf, format: &str, symbols: bool, sections: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::info_command(file, format, symbols, sections, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // init
    pub fn init(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::init(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // init_command
    pub fn init_command(&self, template: &str, dir: Option<PathBuf>, name: Option<String>, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::init_command(template, dir.as_deref(), name.as_deref(), force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // init_project
    pub fn init_project(&self, template: &str, dir: Option<PathBuf>, name: Option<String>, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::init_project(template, dir.as_deref(), name.as_deref(), force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // initialize
    pub fn initialize(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::initialize().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // initialize_ruby_bindings
    pub fn initialize_ruby_bindings(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::initialize_ruby_bindings().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // insert_selected_operator
    pub fn insert_selected_operator(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::insert_selected_operator(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // inspect_state_dict
    pub fn inspect_state_dict(&self, path: &str) -> Result<anyhow::Result<Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::inspect_state_dict(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // intern
    pub fn intern(&self, s: &str) -> Result<u32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::intern(s).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // interpreter
    pub fn interpreter(&self) -> Result<Option<&HelixInterpreter>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixDispatcher::interpreter().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // interpreter_mut
    pub fn interpreter_mut(&self) -> Result<Option<&mut HelixInterpreter>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixDispatcher::interpreter_mut().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // invalid_input
    pub fn invalid_input(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::invalid_input(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // invalid_parameters
    pub fn invalid_parameters(&self, operator: &str, params: &str) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::invalid_parameters(operator, params).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // io_error
    pub fn io_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::io_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_array
    pub fn is_array(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_array().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_boolean
    pub fn is_boolean(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_boolean().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_compatible
    pub fn is_compatible(&self, _ir: RubyObject) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_compatible(_ir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_compressed
    pub fn is_compressed(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_compressed().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_empty
    pub fn is_empty(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_empty().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_loaded
    pub fn is_loaded(&self, section_type: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_loaded(section_type).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_null
    pub fn is_null(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_null().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_number
    pub fn is_number(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_number().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_object
    pub fn is_object(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_object().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_paused
    pub fn is_paused(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_paused().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_ready
    pub fn is_ready(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixDispatcher::is_ready().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_recoverable
    pub fn is_recoverable(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_recoverable().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_running
    pub fn is_running(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_running().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // is_string
    pub fn is_string(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::is_string().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // items
    pub fn items(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::items(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // items_cloned
    pub fn items_cloned(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::items_cloned(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // json_error
    pub fn json_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::json_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // json_to_text
    pub fn json_to_text(&self, json: &str) -> Result<anyhow::Result<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::json_to_text(json).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // json_to_value
    pub fn json_to_value(&self, json_value: serde_json:: Value) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::json_to_value(json_value).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // json_value_to_value
    pub fn json_value_to_value(&self, json_value: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::json_value_to_value(json_value).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // keys
    pub fn keys(&self, section: &str) -> Result<Option<Vec<&String>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::keys(section).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // launch
    pub fn launch(&self) -> Result<TuiResult<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::launch().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // len
    pub fn len(&self) -> Result<usize, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::len().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // lint_files
    pub fn lint_files(&self, files: Vec<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::lint_files(files, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // lint_project
    pub fn lint_project(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::lint_project(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // lint_single_file
    pub fn lint_single_file(&self, file: &str, verbose: bool) -> Result<Vec<LintIssue>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::lint_single_file(file, verbose).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // lint_specific_files
    pub fn lint_specific_files(&self, files: Vec<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::lint_specific_files(files, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // list_binaries
    pub fn list_binaries(&self, target_dir: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::list_binaries(target_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // list_config
    pub fn list_config(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::list_config(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // list_config_values
    pub fn list_config_values(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::list_config_values(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // list_variables
    pub fn list_variables(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::list_variables().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // list_versions
    pub fn list_versions(&self, path: &str) -> Result<VaultResult<Vec<Version>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::list_versions(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // list_workflows
    pub fn list_workflows(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::list_workflows(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load
    pub fn load(&self, name: &str, split: &str, cache_dir: &str) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load(name, split, cache_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_binary
    pub fn load_binary(&self, binary: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_binary(binary, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_default_config
    pub fn load_default_config(&self) -> Result<HelixConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::load_default_config().await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_embeddings
    pub fn load_embeddings(&self, emb_path: &str) -> Result<Vec<LoadedEmbedding>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_embeddings(emb_path).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_file
    pub fn load_file(&self, _file_path: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_file(_file_path, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_from_file
    pub fn load_from_file(&self, path: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_from_file(path, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_from_hlx
    pub fn load_from_hlx(&self) -> Result<OperatorParser, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_from_hlx().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_from_string
    pub fn load_from_string(&self, content: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_from_string(content, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_global_config
    pub fn load_global_config(&self) -> Result<GlobalConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::load_global_config().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_hlx
    pub fn load_hlx(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::load_hlx().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_latest
    pub fn load_latest(&self, path: &str) -> Result<VaultResult<Vec<u8>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_latest(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_memory
    pub fn load_memory(&self, address: u32, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_memory(address, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_module
    pub fn load_module(&self, path: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_module(path, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_project
    pub fn load_project(&self, path: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_project(path, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_schema
    pub fn load_schema(&self, schema: &str, _ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_schema(schema, _ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_script
    pub fn load_script(&self, path: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_script(path, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_section
    pub fn load_section(&self, section_type: SectionType) -> Result<&DataSection, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_section(section_type).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // load_version
    pub fn load_version(&self, file_hash: &str, version_id: &str) -> Result<VaultResult<Vec<u8>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::load_version(file_hash, version_id).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // make
    pub fn make(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::make().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // manage_cache
    pub fn manage_cache(&self, action: CacheAction, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::manage_cache(action, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // manage_config
    pub fn manage_config(&self, action: ConfigAction, key: Option<String>, value: Option<String>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::manage_config(action, key.as_deref(), value.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // merge
    pub fn merge(&self, other: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::merge(other, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // merge_configs
    pub fn merge_configs(&self, env: Env, configs: Vec<RubyObject>, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::merge_configs(env, configs, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // merge_modules
    pub fn merge_modules(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::merge_modules(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // migrate
    pub fn migrate(&self, ir: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::migrate(ir, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // migrate_env
    pub fn migrate_env(&self, env_str: &str) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::migrate_env(env_str).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // migrate_json
    pub fn migrate_json(&self, json_str: &str) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::migrate_json(json_str).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // migrate_toml
    pub fn migrate_toml(&self, toml_str: &str) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::migrate_toml(toml_str).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // migrate_yaml
    pub fn migrate_yaml(&self, yaml_str: &str) -> Result<CsResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::migrate_yaml(yaml_str).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // modules
    pub fn modules(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::modules(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // new_enhanced
    pub fn new_enhanced(&self, tokens: Vec<RubyObject>) -> Result<RubyParser, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::new_enhanced(tokens).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // new_with_context
    pub fn new_with_context(&self, context: ExecutionContext) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::new_with_context(context).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // new_with_source_map
    pub fn new_with_source_map(&self, source_map: &str) -> Result<RubyParser, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::new_with_source_map(source_map).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // next_tab
    pub fn next_tab(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::next_tab(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // next_token
    pub fn next_token(&self) -> Result<Token, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::next_token().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // next_token_with_location
    pub fn next_token_with_location(&self) -> Result<TokenWithLocation, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::next_token_with_location().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // number
    pub fn number(&self) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::number().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // numeric_range
    pub fn numeric_range(&self, min: Option<f64>, max: Option<f64>) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::numeric_range(min.as_deref(), max.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // object
    pub fn object(&self) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::object().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // on_tick
    pub fn on_tick(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::on_tick(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // open_selected_file
    pub fn open_selected_file(&self) -> Result<TuiResult<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::open_selected_file().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // operator_engine
    pub fn operator_engine(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::operator_engine(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // operator_engine_mut
    pub fn operator_engine_mut(&self, env: Env, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::operator_engine_mut(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // operator_registry
    pub fn operator_registry(&self) -> Result<&OperatorRegistry, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::operator_registry().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // optimization_level
    pub fn optimization_level(&self, level: OptimizationLevel) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::optimization_level(level).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // optimize
    pub fn optimize(&self, _ir: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::optimize(_ir, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // optimize_command
    pub fn optimize_command(&self, input: PathBuf, output: Option<PathBuf>, level: u8, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::optimize_command(input, output.as_deref(), level, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // params_to_json
    pub fn params_to_json(&self, params: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::params_to_json(params).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse
    pub fn parse(&self, source: &str) -> Result<HelixAst, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse(source).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_and_execute
    pub fn parse_and_execute(&self, source: &str) -> Result<DispatchResult, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_and_execute(source).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_array
    pub fn parse_array(&self, txt: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_array(txt).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_content
    pub fn parse_content(&self, content: &str) -> Result<HlxConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_content(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_date
    pub fn parse_date(&self, v: &str, parser: &str) -> Result<Option<Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_date(v, parser).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_dsl
    pub fn parse_dsl(&self, source: &str) -> Result<DispatchResult, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixDispatcher::parse_dsl(source).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_env
    pub fn parse_env(&self, v: &str) -> Result<Option<Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_env(v).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_global_var
    pub fn parse_global_var(&self, v: &str) -> Result<Option<Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_global_var(v).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_helix
    pub fn parse_helix(&self, source: &str) -> Result<HelixAst, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_helix(source).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_helix_source
    pub fn parse_helix_source(&self, _source: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_helix_source(_source, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_hlx_content
    pub fn parse_hlx_content(&self, content: &str) -> Result<HashMap<String, Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_hlx_content(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_line
    pub fn parse_line(&self, raw: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_line(raw).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_object
    pub fn parse_object(&self, txt: &str) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_object(txt).await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_only
    pub fn parse_only(&self, source: &str) -> Result<anyhow::Result<Vec<Assign>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixDispatcher::parse_only(source).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_params
    pub fn parse_params(&self, params: &str) -> Result<HashMap<String, Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_params(params).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_primitive
    pub fn parse_primitive(&self, v: &str) -> Result<Option<Value>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_primitive(v).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_program
    pub fn parse_program(&self, source: &str) -> Result<anyhow::Result<Vec<Assign>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_program(source).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_quoted_string
    pub fn parse_quoted_string(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_quoted_string().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // parse_value
    pub fn parse_value(&self, value: &str) -> Result<crate::dna::atp::value::Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::parse_value(value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // pattern
    pub fn pattern(&self, pattern: impl Into<String>) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::pattern(pattern).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // pause
    pub fn pause(&self, id: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::pause(id, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // pause_workflow
    pub fn pause_workflow(&self, workflow_id: &str, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::pause_workflow(workflow_id, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // pop
    pub fn pop(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::pop(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // position
    pub fn position(&self) -> Result<usize, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::position().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // pretty_print
    pub fn pretty_print(&self, ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::pretty_print(ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // preview_command
    pub fn preview_command(&self, file: PathBuf, format: Option<String>, rows: Option<usize>, columns: Option<Vec<String>>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::preview_command(file, format.as_deref(), rows.as_deref(), columns.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // previous_tab
    pub fn previous_tab(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::previous_tab(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // print
    pub fn print(&self, ast: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::print(ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process
    pub fn process(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_caption_file
    pub fn process_caption_file(&self, path: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_caption_file(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_dataset
    pub fn process_dataset(&self, dataset_name: &str, config: &str) -> Result<TrainingDataset, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_dataset(dataset_name, config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_dataset_config
    pub fn process_dataset_config(&self, config_path: &str, dataset_name: &str) -> Result<HlxResult<DatasetConfig>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::process_dataset_config(config_path, dataset_name).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_e621_json_data
    pub fn process_e621_json_data(&self, data: &str, file_path: &str, config: Option<E621Config>) -> Result<anyhow::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_e621_json_data(data, file_path, config.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_e621_json_file
    pub fn process_e621_json_file(&self, file_path: &str, config: Option<caption::E621Config>) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_e621_json_file(file_path, config.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_e621_tags
    pub fn process_e621_tags(&self, tags_dict: &str, config: Option<&E621Config>) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_e621_tags(tags_dict, config.as_deref()).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_file
    pub fn process_file(&self, path: &str) -> Result<anyhow::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_file(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_image_file
    pub fn process_image_file(&self, image_path: &str, config: &str, dry_run: bool) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_image_file(image_path, config, dry_run).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_json_to_caption
    pub fn process_json_to_caption(&self, input_path: &str) -> Result<io::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_json_to_caption(input_path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_safetensors_file
    pub fn process_safetensors_file(&self, file: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_safetensors_file(file).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // process_with_hlx
    pub fn process_with_hlx(&self, hlx_config_path: &str, dataset_data: Vec<serde_json::Value>) -> Result<HlxResult<ProcessedDataset>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::process_with_hlx(hlx_config_path, dataset_data).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // publish_project
    pub fn publish_project(&self, registry: Option<String>, token: Option<String>, dry_run: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::publish_project(registry.as_deref(), token.as_deref(), dry_run, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // push
    pub fn push(&self, value: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::push(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // quality_assessment
    pub fn quality_assessment(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::quality_assessment(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // quality_validation
    pub fn quality_validation(&self, score: f64, issues: Vec<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::quality_validation(score, issues).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // range
    pub fn range(&self, min: f64, max: f64) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::range(min, max).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_batches
    pub fn read_batches(&self) -> Result<Vec<RecordBatch>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_batches().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_bool
    pub fn read_bool(&self) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_bool().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_bytes
    pub fn read_bytes(&self, length: usize) -> Result<Vec<u8>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_bytes(length).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_config
    pub fn read_config(&self) -> Result<HelixConfig, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::read_config().await.map(|item| item.to_ruby())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_f32
    pub fn read_f32(&self) -> Result<f32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_f32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_f64
    pub fn read_f64(&self) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_f64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_from_file
    pub fn read_from_file(&self, path: &str) -> Result<HelixBinary, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_from_file(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_header
    pub fn read_header(&self) -> Result<HlxcHeader, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_header().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_i32
    pub fn read_i32(&self) -> Result<i32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_i32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_i64
    pub fn read_i64(&self) -> Result<i64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_i64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_project_manifest
    pub fn read_project_manifest(&self, project_dir: &str) -> Result<crate::dna::mds::project::ProjectManifest, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_project_manifest(project_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_string
    pub fn read_string(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_string().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_u32
    pub fn read_u32(&self) -> Result<u32, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_u32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // read_u64
    pub fn read_u64(&self) -> Result<u64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::read_u64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // remaining
    pub fn remaining(&self) -> Result<usize, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::remaining().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // remove_breakpoint
    pub fn remove_breakpoint(&self, address: usize, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::remove_breakpoint(address, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // remove_dependencies
    pub fn remove_dependencies(&self, dependencies: Vec<String>, dev: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::remove_dependencies(dependencies, dev, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // remove_dependency
    pub fn remove_dependency(&self, dependency: &str, dev: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::remove_dependency(dependency, dev, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // remove_file
    pub fn remove_file(&self, path: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::remove_file(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // remove_filter
    pub fn remove_filter(&self, name: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::remove_filter(name).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // rename_file_without_image_extension
    pub fn rename_file_without_image_extension(&self, path: &str) -> Result<io::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::rename_file_without_image_extension(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // replace_special_chars
    pub fn replace_special_chars(&self, path: PathBuf) -> Result<anyhow::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::replace_special_chars(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // replace_string
    pub fn replace_string(&self, path: &str, search: &str, replace: &str) -> Result<anyhow::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::replace_string(path, search, replace).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // report
    pub fn report(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::report().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // required
    pub fn required(&self, field: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::required(field).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // reset
    pub fn reset(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::reset(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // reset_operator_category
    pub fn reset_operator_category(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::reset_operator_category(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // reset_project
    pub fn reset_project(&self, force: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::reset_project(force, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // resolve
    pub fn resolve(&self, module_name: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::resolve(module_name).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // resolve_dependencies
    pub fn resolve_dependencies(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::resolve_dependencies(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // resume
    pub fn resume(&self, id: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::resume(id, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // resume_workflow
    pub fn resume_workflow(&self, workflow_id: &str, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::resume_workflow(workflow_id, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // revert
    pub fn revert(&self, path: &str, version_id: &str) -> Result<VaultResult<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::revert(path, version_id).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // ruby_version
    pub fn ruby_version(&self) -> Result<&'static str, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::ruby_version().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run
    pub fn run(&self, args: LintArgs) -> Result<anyhow::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run(args).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_benchmarks
    pub fn run_benchmarks(&self, pattern: Option<String>, iterations: Option<usize>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_benchmarks(pattern.as_deref(), iterations.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_build
    pub fn run_build(&self, args: crate::dna::cmd::build:: BuildArgs) -> Result<anyhow::Result<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_build(args).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_diagnostics
    pub fn run_diagnostics(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_diagnostics(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_json_cmd
    pub fn run_json_cmd(&self, args: JsonArgs) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_json_cmd(args).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_multi_process_clean
    pub fn run_multi_process_clean(&self, src_files: Vec<PathBuf>, dst_root: &str, schema_dir: Option<&Path>, format_override: &str, _jobs: usize) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_multi_process_clean(src_files, dst_root, schema_dir.as_deref(), format_override, _jobs).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_program
    pub fn run_program(&self, assignments: &str) -> Result<anyhow::Result<Env>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_program(assignments).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_project
    pub fn run_project(&self, input: Option<PathBuf>, args: Vec<String>, optimize: u8, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_project(input.as_deref(), args, optimize, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // run_tests
    pub fn run_tests(&self, pattern: Option<String>, verbose: bool, integration: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::run_tests(pattern.as_deref(), verbose, integration).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // rust_result_bool_to_c
    pub fn rust_result_bool_to_c(&self, result: CsResult<bool>, error_out: *mut *mut c_char) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::rust_result_bool_to_c(result, error_out).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // rust_result_f64_to_c
    pub fn rust_result_f64_to_c(&self, result: CsResult<f64>, error_out: *mut *mut c_char) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::rust_result_f64_to_c(result, error_out).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // rust_result_string_to_c
    pub fn rust_result_string_to_c(&self, result: CsResult<String>) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::rust_result_string_to_c(result).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // rust_result_u64_to_c
    pub fn rust_result_u64_to_c(&self, result: CsResult<u64>, error_out: *mut *mut c_char) -> Result<u64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::rust_result_u64_to_c(result, error_out).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // rust_string_to_c
    pub fn rust_string_to_c(&self, s: &str) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::rust_string_to_c(s).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // save
    pub fn save(&self, path: &str, description: Option<String>) -> Result<VaultResult<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::save(path, description.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // save_active_tab
    pub fn save_active_tab(&self) -> Result<TuiResult<()>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::save_active_tab().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // save_global_config
    pub fn save_global_config(&self, config: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::save_global_config(config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // save_project
    pub fn save_project(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::save_project(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // schema_command
    pub fn schema_command(&self, target: PathBuf, lang: Language, output: Option<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::schema_command(target, lang, output.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // search_command
    pub fn search_command(&self, query: &str, search_type: &str, limit: usize, threshold: f32, embeddings_path: Option<PathBuf>, auto_find: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::search_command(query, search_type, limit, threshold, embeddings_path.as_deref(), auto_find, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // search_embeddings
    pub fn search_embeddings(&self, embeddings: &str, query: &str, search_type: &str, limit: usize, threshold: f32) -> Result<Vec<SearchResult>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::search_embeddings(embeddings, query, search_type, limit, threshold).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // search_hlx_files
    pub fn search_hlx_files(&self, query: &str, search_type: &str, limit: usize) -> Result<Vec<SearchResult>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::search_hlx_files(query, search_type, limit).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // sections
    pub fn sections(&self) -> Result<Vec<&String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::sections().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // seek
    pub fn seek(&self, position: usize, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::seek(position, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select
    pub fn select(&self, section: &str, key: &str) -> Result<TypedGetter, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::select(section, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_best
    pub fn select_best(&self, data: &str) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::select_best(data).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_next_command
    pub fn select_next_command(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::select_next_command(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_next_file
    pub fn select_next_file(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::select_next_file(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_next_operator
    pub fn select_next_operator(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::select_next_operator(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_prev_command
    pub fn select_prev_command(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::select_prev_command(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_prev_file
    pub fn select_prev_file(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::select_prev_file(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // select_prev_operator
    pub fn select_prev_operator(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::select_prev_operator(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // serialization_error
    pub fn serialization_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::serialization_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // serialize
    pub fn serialize(&self, data: RubyUnknown) -> Result<Vec<u8>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::serialize(data).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // serialize_config
    pub fn serialize_config(&self, config: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::serialize_config(config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // serve_binary_file
    pub fn serve_binary_file(&self, filename: &str, target_dir: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::serve_binary_file(filename, target_dir).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // serve_project
    pub fn serve_project(&self, port: Option<u16>, host: Option<String>, directory: Option<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::serve_project(port.as_deref(), host.as_deref(), directory.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // server
    pub fn server(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::server().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set
    pub fn set(&self, key: &str, value: RubyUnknown, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set(key, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_bool
    pub fn set_bool(&self, section: &str, key: &str, value: bool, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_bool(section, key, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_breakpoint
    pub fn set_breakpoint(&self, address: usize, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_breakpoint(address, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_config
    pub fn set_config(&self, key: Option<String>, value: Option<String>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::set_config(key.as_deref(), value.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_config_value
    pub fn set_config_value(&self, config: &str, key: &str, value: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::set_config_value(config, key, value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_context
    pub fn set_context(&self, context: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_context(context, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_format
    pub fn set_format(&self, format: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_format(format, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_level
    pub fn set_level(&self, level: RubyUnknown, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_level(level, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_num
    pub fn set_num(&self, section: &str, key: &str, value: f64, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_num(section, key, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_runtime_context
    pub fn set_runtime_context(&self, context: HashMap<String, Value>, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::set_runtime_context(context, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_str
    pub fn set_str(&self, section: &str, key: &str, value: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_str(section, key, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_target
    pub fn set_target(&self, target: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::set_target(target, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_value
    pub fn set_value(&self, key: &str, value: RubyUnknown, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::set_value(key, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // set_variable
    pub fn set_variable(&self, name: &str, value: Value) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixInterpreter::set_variable(name, value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // should_ignore_e621_tag
    pub fn should_ignore_e621_tag(&self, tag: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::should_ignore_e621_tag(tag).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // show_cache_info
    pub fn show_cache_info(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::show_cache_info(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // show_cache_size
    pub fn show_cache_size(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::show_cache_size(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // sign_binary
    pub fn sign_binary(&self, input: PathBuf, key: Option<String>, output: Option<PathBuf>, verify: bool, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::sign_binary(input, key.as_deref(), output.as_deref(), verify, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // size
    pub fn size(&self) -> Result<usize, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::size().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // split_content
    pub fn split_content(&self, content: &str) -> Result<(Vec<String>, Vec<String>), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::split_content(content).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // start
    pub fn start(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::start(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // start_default_server
    pub fn start_default_server(&self) -> Result<crate::dna::mds::server::HelixServer, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::start_default_server().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // start_hot_reload
    pub fn start_hot_reload(&self, directory: PathBuf, output: Option<PathBuf>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::start_hot_reload(directory, output.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // start_server
    pub fn start_server(&self, config: crate::dna::mds::server:: ServerConfig) -> Result<crate::dna::mds::server::HelixServer, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::start_server(config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // state
    pub fn state(&self, env: Env, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::state(env, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // stats
    pub fn stats(&self) -> Result<SymbolTableStats, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::stats().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // step
    pub fn step(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::step(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // stop
    pub fn stop(&self, id: &str) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::stop(id).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // stop_hot_reload
    pub fn stop_hot_reload(&self, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::stop_hot_reload(verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // stop_workflow
    pub fn stop_workflow(&self, workflow_id: &str, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::stop_workflow(workflow_id, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // store_memory
    pub fn store_memory(&self, address: u32, value: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::store_memory(address, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // str
    pub fn str(&self) -> Result<Option<&str>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::str().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // string
    pub fn string(&self) -> Result<Option<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::string().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // string_length
    pub fn string_length(&self, min: Option<usize>, max: Option<usize>) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::string_length(min.as_deref(), max.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // string_or
    pub fn string_or(&self, default: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::string_or(default).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // string_or_default
    pub fn string_or_default(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::string_or_default().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // suggest_for_syntax_error
    pub fn suggest_for_syntax_error(&self, found: &str, expected: &str) -> Result<Option<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::suggest_for_syntax_error(found, expected).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // suggest_for_undefined_reference
    pub fn suggest_for_undefined_reference(&self, name: &str) -> Result<Option<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::suggest_for_undefined_reference(name).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // suggestions
    pub fn suggestions(&self) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::suggestions().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // supported_features
    pub fn supported_features(&self) -> Result<Vec<&'static str>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::supported_features().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // sync_operator_selection
    pub fn sync_operator_selection(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::sync_operator_selection(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // test
    pub fn test(&self) -> Result<&'static str, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::test().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // test_conditional_operators
    pub fn test_conditional_operators(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::test_conditional_operators().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // test_fundamental_operators
    pub fn test_fundamental_operators(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::test_fundamental_operators().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_algorithm_format
    pub fn to_algorithm_format(&self, algorithm: &str) -> Result<Box<dyn std::any::Any>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_algorithm_format(algorithm).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_binary
    pub fn to_binary(&self) -> Result<RubyHelixBinary, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_binary().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_json
    pub fn to_json(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_json().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_json_bytes
    pub fn to_json_bytes(&self) -> Result<Vec<u8>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_json_bytes().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_json_value
    pub fn to_json_value(&self) -> Result<serde_json::Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::to_json_value().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_string
    pub fn to_string(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_string().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_training_dataset
    pub fn to_training_dataset(&self) -> Result<RubyTrainingDataset, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_training_dataset().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // to_yaml
    pub fn to_yaml(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::to_yaml().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // tokenize
    pub fn tokenize(&self, text: &str) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::tokenize(text).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // tokenize_with_locations
    pub fn tokenize_with_locations(&self, input: &str) -> Result<Vec<TokenWithLocation>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::tokenize_with_locations(input).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // total_size_gb
    pub fn total_size_gb(&self) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::total_size_gb().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // total_size_mb
    pub fn total_size_mb(&self) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::total_size_mb().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // trigger_command
    pub fn trigger_command(&self, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::trigger_command(ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // try_math
    pub fn try_math(&self, s: &str) -> Result<f64, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Parser::try_math(s).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // u32
    pub fn u32(&self) -> Result<Option<u32>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::u32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // u64
    pub fn u64(&self) -> Result<Option<u64>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::u64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // unknown_error
    pub fn unknown_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::unknown_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // unknown_operator
    pub fn unknown_operator(&self, operator: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            OperatorEngine::unknown_operator(operator).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // unset_config
    pub fn unset_config(&self, key: Option<String>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::unset_config(key.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // unset_config_value
    pub fn unset_config_value(&self, config: &str, key: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::unset_config_value(config, key).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // unsupported_algorithm
    pub fn unsupported_algorithm(&self, algorithm: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::unsupported_algorithm(algorithm).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // unwatch_file
    pub fn unwatch_file(&self, id: &str) -> Result<bool, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::unwatch_file(id).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // upload_to_registry
    pub fn upload_to_registry(&self, _archive_path: &str, _manifest: crate::dna::mds::project:: ProjectManifest, _registry: Option<String>, _token: Option<String>, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::upload_to_registry(_archive_path, _manifest, _registry.as_deref(), _token.as_deref(), verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // url
    pub fn url(&self) -> Result<ValidationRule, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::url().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validate
    pub fn validate(&self, ast: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::validate(ast).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validate_command
    pub fn validate_command(&self, file: PathBuf, detailed: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::validate_command(file, detailed).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validate_dataset
    pub fn validate_dataset(&self, dataset_config: &str, data_sample: serde_json:: Value) -> Result<HlxResult<ValidationResult>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::validate_dataset(dataset_config, data_sample).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validate_file
    pub fn validate_file(&self, path: &str) -> Result<Vec<String>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::validate_file(path).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validate_filter_config
    pub fn validate_filter_config(&self, config: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::validate_filter_config(config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validate_package
    pub fn validate_package(&self, project_dir: &str, manifest: &str, project_name: &str, version: &str, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::validate_package(project_dir, manifest, project_name, version, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // validation_error
    pub fn validation_error(&self, message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::validation_error(message, suggestion).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // value_to_arrow_array
    pub fn value_to_arrow_array(&self, field: &str, values: Vec<crate::dna::atp::value::Value>) -> Result<ArrayRef, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::value_to_arrow_array(field, values).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // value_to_csharp
    pub fn value_to_csharp(&self, env: Env, value: &str) -> Result<*mut c_char, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::value_to_csharp(env, value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // value_to_json
    pub fn value_to_json(&self, value: &str) -> Result<serde_json::Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::value_to_json(value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // value_to_json_value
    pub fn value_to_json_value(&self, value: &str) -> Result<JsonValue, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::value_to_json_value(value).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // value_to_ruby
    pub fn value_to_ruby(&self, env: Env, value: &str, ruby: &Ruby) -> Result<Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::value_to_ruby(env, value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // value_type
    pub fn value_type(&self) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Value::value_type().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // vec_bool
    pub fn vec_bool(&self) -> Result<Option<Vec<bool>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::vec_bool().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // vec_f64
    pub fn vec_f64(&self) -> Result<Option<Vec<f64>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::vec_f64().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // vec_i32
    pub fn vec_i32(&self) -> Result<Option<Vec<i32>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::vec_i32().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // vec_string
    pub fn vec_string(&self) -> Result<Option<Vec<String>>, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::vec_string().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // verbose
    pub fn verbose(&self, enable: bool) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::verbose(enable).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // version
    pub fn version(&self, version: impl Into<String>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::version(version).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // vm
    pub fn vm(&self) -> Result<RubyHelixVM, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::vm().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // watch
    pub fn watch(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::watch().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // watch_command
    pub fn watch_command(&self, directory: PathBuf, output: Option<PathBuf>, optimize: u8, verbose: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::watch_command(directory, output.as_deref(), optimize, verbose).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // watch_file
    pub fn watch_file(&self, path: &str) -> Result<String, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::watch_file(path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_artist_prefix
    pub fn with_artist_prefix(&self, prefix: Option<String>) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_artist_prefix(prefix.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_artist_suffix
    pub fn with_artist_suffix(&self, suffix: Option<String>) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_artist_suffix(suffix.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_compression
    pub fn with_compression(&self, _compressed: bool, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_compression(_compressed, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_compression_method
    pub fn with_compression_method(&self, _method: RubyObject) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_compression_method(_method).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_config
    pub fn with_config(&self, _config: Config) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            HelixConfig::with_config(_config).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_debug
    pub fn with_debug(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_debug().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_deduplication
    pub fn with_deduplication(&self, deduplicate: bool, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_deduplication(deduplicate, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_filter_tags
    pub fn with_filter_tags(&self, _filter_tags: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_filter_tags(_filter_tags).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_format
    pub fn with_format(&self, format: Option<String>) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_format(format.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_imports
    pub fn with_imports(&self, _follow: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_imports(_follow).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_iterations
    pub fn with_iterations(&self, iterations: usize, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_iterations(iterations, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_lazy
    pub fn with_lazy(&self, enable: bool) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_lazy(enable).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_metadata
    pub fn with_metadata(&self, metadata: HashMap<String, serde_json::Value>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_metadata(metadata).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_mmap
    pub fn with_mmap(&self, enable: bool) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_mmap(enable).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_preview
    pub fn with_preview(&self, _preview: Vec<RubyObject>, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_preview(_preview, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_rating_conversions
    pub fn with_rating_conversions(&self, conversions: Option<std::collections::HashMap<String, String>>) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_rating_conversions(conversions.as_deref()).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_replace_underscores
    pub fn with_replace_underscores(&self, _replace_underscores: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_replace_underscores(_replace_underscores).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_row_count
    pub fn with_row_count(&self, _count: u64, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_row_count(_count, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_schema
    pub fn with_schema(&self, schema: Schema) -> Result<Self, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_schema(schema).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_tree_shaking
    pub fn with_tree_shaking(&self, _enable: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_tree_shaking(_enable).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // with_warmup
    pub fn with_warmup(&self, warmup: usize, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::with_warmup(warmup, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // workflow_command
    pub fn workflow_command(&self, action: WorkflowAction, verbose: bool, _quiet: bool) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::workflow_command(action, verbose, _quiet).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_agents
    pub fn write_agents(&self, agents: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_agents(agents).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_batch
    pub fn write_batch(&self, batch: RubyObject, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Vault::write_batch(batch, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_bool
    pub fn write_bool(&self, value: bool, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_bool(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_bytes
    pub fn write_bytes(&self, bytes: Vec<u8>, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_bytes(bytes, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_contexts
    pub fn write_contexts(&self, contexts: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_contexts(contexts).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_crews
    pub fn write_crews(&self, crews: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_crews(crews).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_f32
    pub fn write_f32(&self, value: f32, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_f32(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_f64
    pub fn write_f64(&self, value: f64, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_f64(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_header
    pub fn write_header(&self) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_header().await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_i32
    pub fn write_i32(&self, value: i32, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_i32(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_i64
    pub fn write_i64(&self, value: i64, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_i64(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_metadata
    pub fn write_metadata(&self, metadata: &str, value: serde_json:: Value) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_metadata(metadata, value: serde_json:).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_string
    pub fn write_string(&self, value: &str, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_string(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_to_file
    pub fn write_to_file(&self, binary: &str, path: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_to_file(binary, path).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_u32
    pub fn write_u32(&self, value: u32, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_u32(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_u64
    pub fn write_u64(&self, value: u64, ruby: &Ruby) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_u64(value, ruby).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // write_workflows
    pub fn write_workflows(&self, workflows: &str) -> Result<(), MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::write_workflows(workflows).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
    // xlh
    pub fn xlh(&self, hlx: &str, operator: &str, params: &str) -> Result<crate::dna::atp::value::Value, MagnusError> {
        let runtime = get_runtime()?;
        runtime.block_on(async {
            Hlx::xlh(hlx, operator, params).await
                .map_err(|e| MagnusError::new(runtime_error(), format!("{}", e)))
        })
    }
    
}

// Standalone Ruby functions (module-level functions)
// add
#[magnus::wrap(class = "Helix")]
fn helix_add(_value: RubyObject) -> Result<u32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add(_value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_agent
#[magnus::wrap(class = "Helix")]
fn helix_add_agent(_agent: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_agent(_agent, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_batch
#[magnus::wrap(class = "Helix")]
fn helix_add_batch(batch: RecordBatch) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_batch(batch).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_context
#[magnus::wrap(class = "Helix")]
fn helix_add_context(_context: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_context(_context, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_crew
#[magnus::wrap(class = "Helix")]
fn helix_add_crew(_crew: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_crew(_crew, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_database
#[magnus::wrap(class = "Helix")]
fn helix_add_database(_database: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_database(_database, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_declaration
#[magnus::wrap(class = "Helix")]
fn helix_add_declaration(_decl: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::add_declaration(_decl, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_dependencies
#[magnus::wrap(class = "Helix")]
fn helix_add_dependencies(dependencies: Vec<String>, version: Option<String>, dev: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_dependencies(dependencies, version.as_deref(), dev, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_dependency
#[magnus::wrap(class = "Helix")]
fn helix_add_dependency(from: &str, to: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_dependency(from, to, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_entry
#[magnus::wrap(class = "Helix")]
fn helix_add_entry(entry: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_entry(entry, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_file
#[magnus::wrap(class = "Helix")]
fn helix_add_file(path: &str, binary: RubyHelixBinary, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_file(path, binary, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_filter
#[magnus::wrap(class = "Helix")]
fn helix_add_filter(name: &str, pattern: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_filter(name, pattern, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_load
#[magnus::wrap(class = "Helix")]
fn helix_add_load(_load: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_load(_load, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_memory
#[magnus::wrap(class = "Helix")]
fn helix_add_memory(_memory: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_memory(_memory, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_migration
#[magnus::wrap(class = "Helix")]
fn helix_add_migration(from_version: &str, to_version: &str, migration_fn: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_migration(from_version, to_version, migration_fn, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_pipeline
#[magnus::wrap(class = "Helix")]
fn helix_add_pipeline(_pipeline: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_pipeline(_pipeline, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_plugin
#[magnus::wrap(class = "Helix")]
fn helix_add_plugin(_plugin: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_plugin(_plugin, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_project
#[magnus::wrap(class = "Helix")]
fn helix_add_project(name: &str, properties: HashMap<String, Value>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_project(name, properties).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_row
#[magnus::wrap(class = "Helix")]
fn helix_add_row(row: HashMap<String, Value>, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_row(row, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_search_path
#[magnus::wrap(class = "Helix")]
fn helix_add_search_path(path: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::add_search_path(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_section
#[magnus::wrap(class = "Helix")]
fn helix_add_section(_section: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_section(_section, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// add_workflow
#[magnus::wrap(class = "Helix")]
fn helix_add_workflow(_workflow: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::add_workflow(_workflow, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// analyze
#[magnus::wrap(class = "Helix")]
fn helix_analyze(ast: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::analyze(ast, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// analyze_python_files_with_options
#[magnus::wrap(class = "Helix")]
fn helix_analyze_python_files_with_options(target_dir: &str, top_level: bool, with_versions: bool, verbose: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::analyze_python_files_with_options(target_dir, top_level, with_versions, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// apply_filters
#[magnus::wrap(class = "Helix")]
fn helix_apply_filters(input: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::apply_filters(input).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// array
#[magnus::wrap(class = "Helix")]
fn helix_array() -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::array().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// as_boolean
#[magnus::wrap(class = "Helix")]
fn helix_as_boolean() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::as_boolean().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// as_f64
#[magnus::wrap(class = "Helix")]
fn helix_as_f64() -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::as_f64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// as_integer
#[magnus::wrap(class = "Helix")]
fn helix_as_integer() -> Result<Option<i64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::as_integer().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// ast_to_config
#[magnus::wrap(class = "Helix")]
fn helix_ast_to_config(ast: HelixAst) -> Result<HelixConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::ast_to_config(ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// base64_error
#[magnus::function]
fn helix_base64_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Helix, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::base64_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// benchmark_and_select
#[magnus::wrap(class = "Helix")]
fn helix_benchmark_and_select(data: &str) -> Result<CompressionAlgorithm, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::benchmark_and_select(data).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// binary
#[magnus::wrap(class = "Helix")]
fn helix_binary(left: &str, op: &str, right: &str) -> Result<RubyExpression, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::binary(left, op, right).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// binary_to_config
#[magnus::wrap(class = "Helix")]
fn helix_binary_to_config(binary: HelixBinary) -> Result<HelixConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::binary_to_config(binary).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// bool
#[magnus::wrap(class = "Helix")]
fn helix_bool() -> Result<Option<bool>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::bool().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// bool_or
#[magnus::wrap(class = "Helix")]
fn helix_bool_or(default: bool) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::bool_or(default).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// bool_or_false
#[magnus::wrap(class = "Helix")]
fn helix_bool_or_false() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::bool_or_false().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// bool_or_true
#[magnus::wrap(class = "Helix")]
fn helix_bool_or_true() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::bool_or_true().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// boolean
#[magnus::wrap(class = "Helix")]
fn helix_boolean() -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::boolean().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// build
#[magnus::wrap(class = "Helix")]
fn helix_build() -> Result<Compiler, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::build().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// build_bundle
#[magnus::wrap(class = "Helix")]
fn helix_build_bundle(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::build_bundle(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// builder
#[magnus::wrap(class = "Helix")]
fn helix_builder() -> Result<CompilerBuilder, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Compiler::builder().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// bundle_command
#[magnus::wrap(class = "Helix")]
fn helix_bundle_command(directory: PathBuf, output: PathBuf, include: Vec<String>, exclude: Vec<String>, tree_shake: bool, optimize: u8, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::bundle_command(directory, output, include, exclude, tree_shake, optimize, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// bundle_files
#[magnus::wrap(class = "Helix")]
fn helix_bundle_files(files: &str, optimization_level: OptimizationLevel) -> Result<HelixBinary, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::bundle_files(files, optimization_level).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cache
#[magnus::wrap(class = "Helix")]
fn helix_cache(enable: bool) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cache(enable).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cache_stats
#[magnus::wrap(class = "Helix")]
fn helix_cache_stats() -> Result<std::io::Result<CacheStats>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cache_stats().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// calculate_checksum
#[magnus::wrap(class = "Helix")]
fn helix_calculate_checksum() -> Result<u64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::calculate_checksum().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// can_migrate
#[magnus::wrap(class = "Helix")]
fn helix_can_migrate(from_version: &str, to_version: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::can_migrate(from_version, to_version).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// caption_file_exists_and_not_empty
#[magnus::wrap(class = "Helix")]
fn helix_caption_file_exists_and_not_empty(path: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::caption_file_exists_and_not_empty(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_circular
#[magnus::wrap(class = "Helix")]
fn helix_check_circular(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_circular(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_dependencies
#[magnus::wrap(class = "Helix")]
fn helix_check_dependencies(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_dependencies(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_environment
#[magnus::wrap(class = "Helix")]
fn helix_check_environment(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_environment(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_file_issues
#[magnus::wrap(class = "Helix")]
fn helix_check_file_issues(content: &str, _file: &str) -> Result<Vec<LintIssue>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_file_issues(content, _file).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_line_issues
#[magnus::wrap(class = "Helix")]
fn helix_check_line_issues(line: &str, line_num: usize) -> Result<Vec<LintIssue>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_line_issues(line, line_num).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_type
#[magnus::wrap(class = "Helix")]
fn helix_check_type(field: &str, expr: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_type(field, expr).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// check_types
#[magnus::wrap(class = "Helix")]
fn helix_check_types(ast: &str) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::check_types(ast).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// clean_cache
#[magnus::wrap(class = "Helix")]
fn helix_clean_cache(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::clean_cache(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// clean_project
#[magnus::wrap(class = "Helix")]
fn helix_clean_project(all: bool, cache: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::clean_project(all, cache, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// clear
#[magnus::wrap(class = "Helix")]
fn helix_clear(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::clear(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// clear_cache
#[magnus::wrap(class = "Helix")]
fn helix_clear_cache() -> Result<std::io::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::clear_cache().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// clear_changes
#[magnus::wrap(class = "Helix")]
fn helix_clear_changes(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::clear_changes(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// clear_filters
#[magnus::wrap(class = "Helix")]
fn helix_clear_filters(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::clear_filters(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// close_active_tab
#[magnus::wrap(class = "Helix")]
fn helix_close_active_tab(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::close_active_tab(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_add
#[magnus::wrap(class = "Helix")]
fn helix_cmd_add(dependency: &str, version: Option<String>, dev: bool, verbose: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_add(dependency, version.as_deref(), dev, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_bench
#[magnus::wrap(class = "Helix")]
fn helix_cmd_bench(pattern: Option<String>, iterations: Option<u32>) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_bench(pattern.as_deref(), iterations.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_bundle
#[magnus::wrap(class = "Helix")]
fn helix_cmd_bundle(input: Option<String>, output: Option<String>, include: Vec<String>, exclude: Vec<String>, tree_shake: bool, optimize: u8) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_bundle(input.as_deref(), output.as_deref(), include, exclude, tree_shake, optimize).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_clean
#[magnus::wrap(class = "Helix")]
fn helix_cmd_clean(_all: bool, _cache: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_clean(_all, _cache).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_compile
#[magnus::wrap(class = "Helix")]
fn helix_cmd_compile(input: Option<String>, output: Option<String>, compress: bool, optimize: u8, cache: bool, verbose: bool, quiet: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_compile(input.as_deref(), output.as_deref(), compress, optimize, cache, verbose, quiet).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_completions
#[magnus::wrap(class = "Helix")]
fn helix_cmd_completions(_shell: &str, _verbose: bool, _quiet: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_completions(_shell, _verbose, _quiet).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_dataset
#[magnus::wrap(class = "Helix")]
fn helix_cmd_dataset(files: Vec<String>, output: Option<String>, format: Option<String>) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_dataset(files, output.as_deref(), format.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_diff
#[magnus::wrap(class = "Helix")]
fn helix_cmd_diff(file1: *const c_char, file2: *const c_char, detailed: bool) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_diff(file1, file2, detailed).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_doctor
#[magnus::wrap(class = "Helix")]
fn helix_cmd_doctor(action: *const c_char) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_doctor(action).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_export
#[magnus::wrap(class = "Helix")]
fn helix_cmd_export(format: Option<String>, output: Option<String>, include_deps: bool, verbose: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_export(format.as_deref(), output.as_deref(), include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_filter
#[magnus::wrap(class = "Helix")]
fn helix_cmd_filter(_files: Vec<String>) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_filter(_files).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_fmt
#[magnus::wrap(class = "Helix")]
fn helix_cmd_fmt(_files: Vec<String>, _check: bool, _verbose: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_fmt(_files, _check, _verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_generate
#[magnus::wrap(class = "Helix")]
fn helix_cmd_generate(template: &str, output: Option<String>, name: Option<String>, force: bool, verbose: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_generate(template, output.as_deref(), name.as_deref(), force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_import
#[magnus::wrap(class = "Helix")]
fn helix_cmd_import(input: *const c_char, registry: *const c_char, token: *const c_char, dry_run: bool) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_import(input, registry, token, dry_run).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_info
#[magnus::wrap(class = "Helix")]
fn helix_cmd_info(input: Option<String>, file: Option<String>, output: Option<String>, format: Option<String>, symbols: bool, sections: bool, verbose: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_info(input.as_deref(), file.as_deref(), output.as_deref(), format.as_deref(), symbols, sections, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_init
#[magnus::wrap(class = "Helix")]
fn helix_cmd_init(name: Option<String>, dir: Option<String>, template: Option<String>, force: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_init(name.as_deref(), dir.as_deref(), template.as_deref(), force).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_lint
#[magnus::wrap(class = "Helix")]
fn helix_cmd_lint(_files: Vec<String>, _verbose: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_lint(_files, _verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_optimize
#[magnus::wrap(class = "Helix")]
fn helix_cmd_optimize(input: Option<String>, output: Option<String>, level: u8) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_optimize(input.as_deref(), output.as_deref(), level).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_publish
#[magnus::wrap(class = "Helix")]
fn helix_cmd_publish(action: *const c_char, registry: *const c_char, token: *const c_char, dry_run: bool, verbose: bool, quiet: bool, input: *const c_char, key: *const c_char, output: *const c_char, verify: bool, format: *const c_char, include_deps: bool) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_publish(action, registry, token, dry_run, verbose, quiet, input, key, output, verify, format, include_deps).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_remove
#[magnus::wrap(class = "Helix")]
fn helix_cmd_remove(_files: Vec<String>) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_remove(_files).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_reset
#[magnus::wrap(class = "Helix")]
fn helix_cmd_reset(_force: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_reset(_force).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_schema
#[magnus::wrap(class = "Helix")]
fn helix_cmd_schema(target: *const c_char, lang: *const c_char, output: *const c_char, verbose: bool) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_schema(target, lang, output, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_search
#[magnus::wrap(class = "Helix")]
fn helix_cmd_search(query: &str, search_type: Option<String>, limit: Option<u32>, threshold: Option<f64>, embeddings: Option<String>, auto_find: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_search(query, search_type.as_deref(), limit.as_deref(), threshold.as_deref(), embeddings.as_deref(), auto_find).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_serve
#[magnus::wrap(class = "Helix")]
fn helix_cmd_serve(port: Option<u16>, host: Option<String>, directory: Option<String>) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_serve(port.as_deref(), host.as_deref(), directory.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_sign
#[magnus::wrap(class = "Helix")]
fn helix_cmd_sign(input: &str, key: Option<String>, output: Option<String>, verify: bool, verbose: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_sign(input, key.as_deref(), output.as_deref(), verify, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_test
#[magnus::wrap(class = "Helix")]
fn helix_cmd_test(pattern: Option<String>, integration: bool) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_test(pattern.as_deref(), integration).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_tui
#[magnus::wrap(class = "Helix")]
fn helix_cmd_tui() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_tui().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_validate
#[magnus::wrap(class = "Helix")]
fn helix_cmd_validate(target: Option<String>) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_validate(target.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_vlt
#[magnus::wrap(class = "Helix")]
fn helix_cmd_vlt(subcommand: *const c_char, name: *const c_char, path: *const c_char, editor: *const c_char, long: bool, description: *const c_char, limit: *const u32, version: *const c_char, force: bool, from: *const c_char, to: *const c_char, show: bool, compress: *const bool, retention_days: *const u32, max_versions: *const u32, dry_run: bool) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_vlt(subcommand, name, path, editor, long, description, limit, version, force, from, to, show, compress, retention_days, max_versions, dry_run).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cmd_watch
#[magnus::wrap(class = "Helix")]
fn helix_cmd_watch(input: Option<String>, output: Option<String>, optimize: u8, debounce: Option<u32>, filter: Option<String>) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cmd_watch(input.as_deref(), output.as_deref(), optimize, debounce.as_deref(), filter.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// collect_dependencies
#[magnus::wrap(class = "Helix")]
fn helix_collect_dependencies(_project_dir: &str) -> Result<std::collections::HashMap<String, String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::collect_dependencies(_project_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// collect_helix_files
#[magnus::wrap(class = "Helix")]
fn helix_collect_helix_files(dir: &str, files: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::collect_helix_files(dir, files).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// collect_source_files
#[magnus::wrap(class = "Helix")]
fn helix_collect_source_files(project_dir: &str) -> Result<std::collections::HashMap<String, String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::collect_source_files(project_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compilation_error
#[magnus::wrap(class = "Helix")]
fn helix_compilation_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compilation_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compilation_order
#[magnus::wrap(class = "Helix")]
fn helix_compilation_order() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compilation_order().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compile
#[magnus::wrap(class = "Helix")]
fn helix_compile() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compile().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compile_command
#[magnus::wrap(class = "Helix")]
fn helix_compile_command(input: PathBuf, output: Option<PathBuf>, compress: bool, optimize: u8, cache: bool, verbose: bool, _quiet: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Compiler::compile_command(input, output.as_deref(), compress, optimize, cache, verbose, _quiet).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compile_source
#[magnus::wrap(class = "Helix")]
fn helix_compile_source(source: &str, source_path: Option<&Path>) -> Result<HelixBinary, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Compiler::compile_source(source, source_path.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compile_to_binary
#[magnus::wrap(class = "Helix")]
fn helix_compile_to_binary(content: &str) -> Result<HlxResult<crate::dna::hel::binary::HelixBinary>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Compiler::compile_to_binary(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// completions_command
#[magnus::wrap(class = "Helix")]
fn helix_completions_command(shell: Shell, verbose: bool, quiet: bool) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::completions_command(shell, verbose, quiet).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compress
#[magnus::wrap(class = "Helix")]
fn helix_compress(method: CompressionMethod) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compress(method).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compression
#[magnus::wrap(class = "Helix")]
fn helix_compression(enable: bool) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compression(enable).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compression_error
#[magnus::wrap(class = "Helix")]
fn helix_compression_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compression_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compression_ratio
#[magnus::wrap(class = "Helix")]
fn helix_compression_ratio(original_size: usize) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compression_ratio(original_size).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// compute_statistics
#[magnus::wrap(class = "Helix")]
fn helix_compute_statistics(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::compute_statistics(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// concat_files
#[magnus::wrap(class = "Helix")]
fn helix_concat_files(directory: &str, config: &str, dry_run: bool) -> Result<usize, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::concat_files(directory, config, dry_run).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// config_conversion
#[magnus::wrap(class = "Helix")]
fn helix_config_conversion(field: impl Into<String>, details: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::config_conversion(field, details).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// context
#[magnus::wrap(class = "Helix")]
fn helix_context() -> Result<&Arc<ExecutionContext>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::context().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// continue_execution
#[magnus::wrap(class = "Helix")]
fn helix_continue_execution(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::continue_execution(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// convert_from_ruby_value
#[magnus::wrap(class = "Helix")]
fn helix_convert_from_ruby_value(value: RubyUnknown) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::convert_from_ruby_value(value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// convert_legacy_dataset
#[magnus::wrap(class = "Helix")]
fn helix_convert_legacy_dataset(legacy_config: HashMap<String, String>) -> Result<HlxResult<DatasetConfig>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::convert_legacy_dataset(legacy_config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// copy_directory
#[magnus::wrap(class = "Helix")]
fn helix_copy_directory(src: &str, dst: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::copy_directory(src, dst).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cosine_similarity
#[magnus::wrap(class = "Helix")]
fn helix_cosine_similarity(a: &str, b: &str) -> Result<f32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::cosine_similarity(a, b).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_default_config
#[magnus::wrap(class = "Helix")]
fn helix_create_default_config() -> Result<GlobalConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::create_default_config().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_default_filter
#[magnus::wrap(class = "Helix")]
fn helix_create_default_filter() -> Result<FilterConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_default_filter().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_error_response
#[magnus::wrap(class = "Helix")]
fn helix_create_error_response(status: &str, message: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_error_response(status, message).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_health_response
#[magnus::wrap(class = "Helix")]
fn helix_create_health_response() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_health_response().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_html_response
#[magnus::wrap(class = "Helix")]
fn helix_create_html_response(html: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_html_response(html).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_new_tab
#[magnus::wrap(class = "Helix")]
fn helix_create_new_tab(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_new_tab(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_package_archive
#[magnus::wrap(class = "Helix")]
fn helix_create_package_archive(project_dir: &str, manifest: &str, project_name: &str, version: &str, verbose: bool) -> Result<PathBuf, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_package_archive(project_dir, manifest, project_name, version, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_project
#[magnus::wrap(class = "Helix")]
fn helix_create_project(name: &str, path: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_project(name, path, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_ruby_array
#[magnus::wrap(class = "Helix")]
fn helix_create_ruby_array(env: Env, size: usize) -> Result<RubyUnknown, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_ruby_array(env, size).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_ruby_boolean
#[magnus::wrap(class = "Helix")]
fn helix_create_ruby_boolean(env: Env, b: bool) -> Result<RubyUnknown, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_ruby_boolean(env, b).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_ruby_error
#[magnus::wrap(class = "Helix")]
fn helix_create_ruby_error(message: &str) -> Result<RubyError, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_ruby_error(message).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_ruby_number
#[magnus::wrap(class = "Helix")]
fn helix_create_ruby_number(env: Env, n: f64) -> Result<RubyUnknown, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_ruby_number(env, n).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_ruby_object
#[magnus::wrap(class = "Helix")]
fn helix_create_ruby_object(env: Env) -> Result<RubyUnknown, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_ruby_object(env).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_ruby_string
#[magnus::wrap(class = "Helix")]
fn helix_create_ruby_string(env: Env, s: &str) -> Result<RubyUnknown, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_ruby_string(env, s).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// create_template
#[magnus::wrap(class = "Helix")]
fn helix_create_template(_user: &str, _reasoning: &str, _assistant: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::create_template(_user, _reasoning, _assistant).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cycle_operator_category_next
#[magnus::wrap(class = "Helix")]
fn helix_cycle_operator_category_next(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::cycle_operator_category_next(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// cycle_operator_category_prev
#[magnus::wrap(class = "Helix")]
fn helix_cycle_operator_category_prev(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::cycle_operator_category_prev(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// dataset_command
#[magnus::wrap(class = "Helix")]
fn helix_dataset_command(action: DatasetAction, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::dataset_command(action, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// dataset_not_found
#[magnus::wrap(class = "Helix")]
fn helix_dataset_not_found(path: PathBuf) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::dataset_not_found(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// dataset_processing
#[magnus::wrap(class = "Helix")]
fn helix_dataset_processing(message: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::dataset_processing(message).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decode_json_strings
#[magnus::wrap(class = "Helix")]
fn helix_decode_json_strings(value: Value) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decode_json_strings(value).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decompile
#[magnus::wrap(class = "Helix")]
fn helix_decompile(binary: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decompile(binary).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decompile_binary
#[magnus::wrap(class = "Helix")]
fn helix_decompile_binary(binary: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decompile_binary(binary).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decompile_command
#[magnus::wrap(class = "Helix")]
fn helix_decompile_command(input: PathBuf, output: Option<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decompile_command(input, output.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decompile_ir
#[magnus::wrap(class = "Helix")]
fn helix_decompile_ir(ir: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decompile_ir(ir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decompress
#[magnus::wrap(class = "Helix")]
fn helix_decompress() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decompress().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// decompression_error
#[magnus::wrap(class = "Helix")]
fn helix_decompression_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::decompression_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// delete
#[magnus::wrap(class = "Helix")]
fn helix_delete(key: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::delete(key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// dependency_graph
#[magnus::wrap(class = "Helix")]
fn helix_dependency_graph() -> Result<RubyDependencyGraph, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::dependency_graph().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// description
#[magnus::wrap(class = "Helix")]
fn helix_description(description: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::description(description).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// deserialization_error
#[magnus::wrap(class = "Helix")]
fn helix_deserialization_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::deserialization_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// deserialize
#[magnus::wrap(class = "Helix")]
fn helix_deserialize(data: Vec<u8>) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::deserialize(data).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// deserialize_to_ir
#[magnus::wrap(class = "Helix")]
fn helix_deserialize_to_ir(binary: &str) -> Result<HelixIR, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::deserialize_to_ir(binary).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// detect_training_format
#[magnus::wrap(class = "Helix")]
fn helix_detect_training_format(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::detect_training_format(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// diff_command
#[magnus::wrap(class = "Helix")]
fn helix_diff_command(file1: PathBuf, file2: PathBuf, detailed: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::diff_command(file1, file2, detailed).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// edit_config
#[magnus::wrap(class = "Helix")]
fn helix_edit_config(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::edit_config(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// edit_config_file
#[magnus::wrap(class = "Helix")]
fn helix_edit_config_file(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::edit_config_file(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// email
#[magnus::wrap(class = "Helix")]
fn helix_email() -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::email().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// ensure_calc_dir
#[magnus::wrap(class = "Helix")]
fn helix_ensure_calc_dir() -> Result<std::io::Result<PathBuf>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::ensure_calc_dir().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// enum_values
#[magnus::wrap(class = "Helix")]
fn helix_enum_values(values: Vec<String>) -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::enum_values(values).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// error_csharp
#[magnus::wrap(class = "Helix")]
fn helix_error_csharp(message: impl Into<String>) -> Result<CsError, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::error_csharp(message).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// eval_date_expression
#[magnus::wrap(class = "Helix")]
fn helix_eval_date_expression(fmt: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::eval_date_expression(fmt).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// eval_expr
#[magnus::wrap(class = "Helix")]
fn helix_eval_expr(expr: &str, env: &str) -> Result<i64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::eval_expr(expr, env).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// eval_math_expression
#[magnus::wrap(class = "Helix")]
fn helix_eval_math_expression(expr: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::eval_math_expression(expr).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// evaluate
#[magnus::wrap(class = "Helix")]
fn helix_evaluate(source: &str) -> Result<anyhow::Result<CalcResult>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::evaluate(source).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// evaluate_expression
#[magnus::wrap(class = "Helix")]
fn helix_evaluate_expression(expr: &str) -> Result<crate::dna::atp::value::Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::evaluate_expression(expr).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// exclude
#[magnus::wrap(class = "Helix")]
fn helix_exclude(_pattern: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::exclude(_pattern).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execute
#[magnus::wrap(class = "Helix")]
fn helix_execute(code: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::execute(code).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execute_ast
#[magnus::wrap(class = "Helix")]
fn helix_execute_ast(ast: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::execute_ast(ast).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execute_binary
#[magnus::wrap(class = "Helix")]
fn helix_execute_binary(binary: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::execute_binary(binary, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execute_date
#[magnus::wrap(class = "Helix")]
fn helix_execute_date(fmt: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::execute_date(fmt).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execute_helix
#[magnus::wrap(class = "Helix")]
fn helix_execute_helix(source: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::execute_helix(source).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execute_operator
#[magnus::wrap(class = "Helix")]
fn helix_execute_operator(operator: &str, params: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::execute_operator(operator, params).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// execution_error
#[magnus::wrap(class = "Helix")]
fn helix_execution_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::execution_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_project
#[magnus::wrap(class = "Helix")]
fn helix_export_project(format: &str, output: Option<PathBuf>, include_deps: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_project(format, output.as_deref(), include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_to_docker
#[magnus::wrap(class = "Helix")]
fn helix_export_to_docker(output: &str, include_deps: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_to_docker(output, include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_to_json
#[magnus::wrap(class = "Helix")]
fn helix_export_to_json(output: &str, include_deps: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_to_json(output, include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_to_k8s
#[magnus::wrap(class = "Helix")]
fn helix_export_to_k8s(output: &str, include_deps: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_to_k8s(output, include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_to_kubernetes
#[magnus::wrap(class = "Helix")]
fn helix_export_to_kubernetes(project_dir: &str, output: Option<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_to_kubernetes(project_dir, output.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_to_toml
#[magnus::wrap(class = "Helix")]
fn helix_export_to_toml(output: &str, include_deps: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_to_toml(output, include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// export_to_yaml
#[magnus::wrap(class = "Helix")]
fn helix_export_to_yaml(output: &str, include_deps: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::export_to_yaml(output, include_deps, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// extract_keywords
#[magnus::wrap(class = "Helix")]
fn helix_extract_keywords(text: &str) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::extract_keywords(text).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// extract_project_name
#[magnus::wrap(class = "Helix")]
fn helix_extract_project_name(content: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::extract_project_name(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// extract_project_version
#[magnus::wrap(class = "Helix")]
fn helix_extract_project_version(content: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::extract_project_version(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// extract_training_metadata
#[magnus::wrap(class = "Helix")]
fn helix_extract_training_metadata(raw_metadata: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::extract_training_metadata(raw_metadata).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// f32
#[magnus::wrap(class = "Helix")]
fn helix_f32() -> Result<Option<f32>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::f32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// f64
#[magnus::wrap(class = "Helix")]
fn helix_f64() -> Result<Option<f64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::f64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// f64_or
#[magnus::wrap(class = "Helix")]
fn helix_f64_or(default: f64) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::f64_or(default).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// feature_error
#[magnus::wrap(class = "Helix")]
fn helix_feature_error(feature: impl Into<String>, message: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::feature_error(feature, message).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// field
#[magnus::wrap(class = "Helix")]
fn helix_field(name: impl Into<String>, rules: Vec<ValidationRule>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::field(name, rules).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// finalize
#[magnus::wrap(class = "Helix")]
fn helix_finalize(ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::finalize(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// finalize_all
#[magnus::wrap(class = "Helix")]
fn helix_finalize_all(ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::finalize_all(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// finalize_enhanced_with_source_map
#[magnus::wrap(class = "Helix")]
fn helix_finalize_enhanced_with_source_map(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::finalize_enhanced_with_source_map(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// find_embedding_directories
#[magnus::wrap(class = "Helix")]
fn helix_find_embedding_directories() -> Result<Vec<PathBuf>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::find_embedding_directories().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// find_helix_files
#[magnus::wrap(class = "Helix")]
fn helix_find_helix_files(dir: &str, files: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::find_helix_files(dir, files).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// find_helix_files_recursive
#[magnus::wrap(class = "Helix")]
fn helix_find_helix_files_recursive(dir: &str, files: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::find_helix_files_recursive(dir, files).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// find_project_root
#[magnus::wrap(class = "Helix")]
fn helix_find_project_root() -> Result<PathBuf, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::find_project_root().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// find_schema_for_file
#[magnus::wrap(class = "Helix")]
fn helix_find_schema_for_file(json_path: &str, schema_dir: Option<&Path>) -> Result<Option<PathBuf>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::find_schema_for_file(json_path, schema_dir.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// flush_batch
#[magnus::wrap(class = "Helix")]
fn helix_flush_batch(ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::flush_batch(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// fnmanage_cache
#[magnus::wrap(class = "Helix")]
fn helix_fnmanage_cache(action: CacheAction, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::fnmanage_cache(action, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// fnmanage_config
#[magnus::wrap(class = "Helix")]
fn helix_fnmanage_config(action: ConfigAction, key: Option<String>, value: Option<String>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::fnmanage_config(action, key.as_deref(), value.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// fnrun_diagnostics
#[magnus::wrap(class = "Helix")]
fn helix_fnrun_diagnostics(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::fnrun_diagnostics(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// focus
#[magnus::wrap(class = "Helix")]
fn helix_focus(area: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::focus(area, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// format_conversion
#[magnus::wrap(class = "Helix")]
fn helix_format_conversion(from: impl Into<String>, to: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::format_conversion(from, to).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// format_files
#[magnus::wrap(class = "Helix")]
fn helix_format_files(files: Vec<PathBuf>, check: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::format_files(files, check, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// format_json_file
#[magnus::wrap(class = "Helix")]
fn helix_format_json_file(file: PathBuf) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::format_json_file(file).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// format_text_content
#[magnus::wrap(class = "Helix")]
fn helix_format_text_content(content: &str) -> Result<anyhow::Result<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::format_text_content(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// format_value
#[magnus::wrap(class = "Helix")]
fn helix_format_value(value: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::format_value(value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// format_with_source
#[magnus::wrap(class = "Helix")]
fn helix_format_with_source(source: &str, tokens: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::format_with_source(source, tokens).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_binary
#[magnus::wrap(class = "Helix")]
fn helix_from_binary(binary: &str) -> Result<RubyHelixIR, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_binary(binary).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_file
#[magnus::wrap(class = "Helix")]
fn helix_from_file(path: &str) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_file(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_json
#[magnus::wrap(class = "Helix")]
fn helix_from_json(_json_value: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_json(_json_value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_json_bytes
#[magnus::wrap(class = "Helix")]
fn helix_from_json_bytes(_bytes: Vec<u8>, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_json_bytes(_bytes, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_preset
#[magnus::wrap(class = "Helix")]
fn helix_from_preset(_preset: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_preset(_preset, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_str
#[magnus::wrap(class = "Helix")]
fn helix_from_str(s: &str) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_str(s).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_string
#[magnus::wrap(class = "Helix")]
fn helix_from_string(content: &str) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_string(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// from_u8
#[magnus::wrap(class = "Helix")]
fn helix_from_u8(_level: u8, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::from_u8(_level, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// garbage_collect
#[magnus::wrap(class = "Helix")]
fn helix_garbage_collect() -> Result<VaultResult<usize>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::garbage_collect().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// gather_json_paths
#[magnus::wrap(class = "Helix")]
fn helix_gather_json_paths(files: &str, data_dirs: &str) -> Result<Vec<PathBuf>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::gather_json_paths(files, data_dirs).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate
#[magnus::wrap(class = "Helix")]
fn helix_generate(ast: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate(ast, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_code
#[magnus::wrap(class = "Helix")]
fn helix_generate_code(template: &str, output: Option<PathBuf>, name: Option<String>, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_code(template, output.as_deref(), name.as_deref(), force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_csharp_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_csharp_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_csharp_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_for_ast
#[magnus::wrap(class = "Helix")]
fn helix_generate_for_ast(ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::generate_for_ast(ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_for_ir
#[magnus::wrap(class = "Helix")]
fn helix_generate_for_ir(ir: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_for_ir(ir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_go_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_go_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_go_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_java_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_java_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_java_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_javascript_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_javascript_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_javascript_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_large_config
#[magnus::wrap(class = "Helix")]
fn helix_generate_large_config() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::generate_large_config().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_medium_config
#[magnus::wrap(class = "Helix")]
fn helix_generate_medium_config() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::generate_medium_config().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_php_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_php_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_php_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_python_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_python_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_python_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_ruby_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_ruby_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_ruby_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_rust_schema
#[magnus::wrap(class = "Helix")]
fn helix_generate_rust_schema(_ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_rust_schema(_ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_schema_code
#[magnus::wrap(class = "Helix")]
fn helix_generate_schema_code(ast: &str, lang: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::generate_schema_code(ast, lang).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// generate_small_config
#[magnus::wrap(class = "Helix")]
fn helix_generate_small_config() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::generate_small_config().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get
#[magnus::wrap(class = "Helix")]
fn helix_get(id: u32) -> Result<Option<&String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get(id).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_agents
#[magnus::wrap(class = "Helix")]
fn helix_get_agents(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::get_agents(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_all_configs
#[magnus::wrap(class = "Helix")]
fn helix_get_all_configs() -> Result<HashMap<PathBuf, HelixConfig>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::get_all_configs().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_array
#[magnus::wrap(class = "Helix")]
fn helix_get_array(section: &str, key: &str) -> Result<Option<&[Value]>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_array(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_auto
#[magnus::wrap(class = "Helix")]
fn helix_get_auto(section: &str, key: &str) -> Result<Option<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_auto(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_bool
#[magnus::wrap(class = "Helix")]
fn helix_get_bool(section: &str, key: &str) -> Result<Option<bool>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_bool(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_boolean
#[magnus::wrap(class = "Helix")]
fn helix_get_boolean(_key: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_boolean(_key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_bundle_path
#[magnus::wrap(class = "Helix")]
fn helix_get_bundle_path() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_bundle_path().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_cache_directory
#[magnus::wrap(class = "Helix")]
fn helix_get_cache_directory() -> Result<PathBuf, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_cache_directory().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_changed_files
#[magnus::wrap(class = "Helix")]
fn helix_get_changed_files() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_changed_files().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_compilation_order
#[magnus::wrap(class = "Helix")]
fn helix_get_compilation_order() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_compilation_order().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_config
#[magnus::wrap(class = "Helix")]
fn helix_get_config(env: Env, name: &str, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::get_config(env, name, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_config_value
#[magnus::wrap(class = "Helix")]
fn helix_get_config_value(config: &str, key: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::get_config_value(config, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_context
#[magnus::wrap(class = "Helix")]
fn helix_get_context(location: &str, context_lines: usize) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::get_context(location, context_lines).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_contexts
#[magnus::wrap(class = "Helix")]
fn helix_get_contexts(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::get_contexts(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_default_editor
#[magnus::wrap(class = "Helix")]
fn helix_get_default_editor() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_default_editor().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_dynamic
#[magnus::wrap(class = "Helix")]
fn helix_get_dynamic(section: &str, key: &str) -> Result<Option<DynamicValue>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_dynamic(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_editor
#[magnus::wrap(class = "Helix")]
fn helix_get_editor() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_editor().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_embedded_templates
#[magnus::wrap(class = "Helix")]
fn helix_get_embedded_templates() -> Result<&'static [(&'static str, &'static str)], magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_embedded_templates().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_embedding_stats
#[magnus::wrap(class = "Helix")]
fn helix_get_embedding_stats(embeddings: &str) -> Result<HashMap<String, serde_json::Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_embedding_stats(embeddings).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_endpoint
#[magnus::wrap(class = "Helix")]
fn helix_get_endpoint() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_endpoint().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_error_count
#[magnus::wrap(class = "Helix")]
fn helix_get_error_count() -> Result<usize, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_error_count().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_errors
#[magnus::wrap(class = "Helix")]
fn helix_get_errors() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::get_errors().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_f32
#[magnus::wrap(class = "Helix")]
fn helix_get_f32(section: &str, key: &str) -> Result<Option<f32>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_f32(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_f64
#[magnus::wrap(class = "Helix")]
fn helix_get_f64(section: &str, key: &str) -> Result<Option<f64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_f64(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_features
#[magnus::wrap(class = "Helix")]
fn helix_get_features(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_features(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_file_path
#[magnus::wrap(class = "Helix")]
fn helix_get_file_path() -> Result<Option<&Path>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_file_path().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_files
#[magnus::wrap(class = "Helix")]
fn helix_get_files() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_files().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_filter_names
#[magnus::wrap(class = "Helix")]
fn helix_get_filter_names() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_filter_names().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_global_config_path
#[magnus::wrap(class = "Helix")]
fn helix_get_global_config_path() -> Result<PathBuf, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::get_global_config_path().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_history
#[magnus::wrap(class = "Helix")]
fn helix_get_history(path: &str) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_history(path).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_i32
#[magnus::wrap(class = "Helix")]
fn helix_get_i32(section: &str, key: &str) -> Result<Option<i32>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_i32(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_i64
#[magnus::wrap(class = "Helix")]
fn helix_get_i64(section: &str, key: &str) -> Result<Option<i64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_i64(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_level
#[magnus::wrap(class = "Helix")]
fn helix_get_level() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_level().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_line
#[magnus::wrap(class = "Helix")]
fn helix_get_line(line_num: usize) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_line(line_num).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_memory
#[magnus::wrap(class = "Helix")]
fn helix_get_memory(env: Env, start: usize, length: usize, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_memory(env, start, length, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_migration_path
#[magnus::wrap(class = "Helix")]
fn helix_get_migration_path(from_version: &str, to_version: &str) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_migration_path(from_version, to_version).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_mut
#[magnus::wrap(class = "Helix")]
fn helix_get_mut(env: Env, _key: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_mut(env, _key, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_num
#[magnus::wrap(class = "Helix")]
fn helix_get_num(section: &str, key: &str) -> Result<Option<f64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_num(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_number
#[magnus::wrap(class = "Helix")]
fn helix_get_number(_key: &str) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_number(_key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_object
#[magnus::wrap(class = "Helix")]
fn helix_get_object(env: Env, _key: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_object(env, _key, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_or_create_helix_dir
#[magnus::wrap(class = "Helix")]
fn helix_get_or_create_helix_dir() -> Result<std::io::Result<PathBuf>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_or_create_helix_dir().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_output_files
#[magnus::wrap(class = "Helix")]
fn helix_get_output_files() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_output_files().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_preview
#[magnus::wrap(class = "Helix")]
fn helix_get_preview() -> Result<Option<Vec<serde_json::Value>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_preview().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_project_name
#[magnus::wrap(class = "Helix")]
fn helix_get_project_name() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_project_name().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_project_path
#[magnus::wrap(class = "Helix")]
fn helix_get_project_path() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_project_path().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_projects
#[magnus::wrap(class = "Helix")]
fn helix_get_projects(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::get_projects(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_random_sample
#[magnus::wrap(class = "Helix")]
fn helix_get_random_sample(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_random_sample(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_raw
#[magnus::wrap(class = "Helix")]
fn helix_get_raw(section: &str, key: &str) -> Result<Option<&Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_raw(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_ref
#[magnus::wrap(class = "Helix")]
fn helix_get_ref(env: Env, key: &str, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::get_ref(env, key, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_registers
#[magnus::wrap(class = "Helix")]
fn helix_get_registers(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_registers(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_report
#[magnus::wrap(class = "Helix")]
fn helix_get_report() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_report().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_ruby_null
#[magnus::wrap(class = "Helix")]
fn helix_get_ruby_null(env: Env) -> Result<RubyUnknown, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_ruby_null(env).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_schema
#[magnus::wrap(class = "Helix")]
fn helix_get_schema() -> Result<&HlxHeader, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_schema().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_schema_version
#[magnus::wrap(class = "Helix")]
fn helix_get_schema_version() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_schema_version().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_similarity
#[magnus::wrap(class = "Helix")]
fn helix_get_similarity(text1: &str, text2: &str) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_similarity(text1, text2).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_str
#[magnus::wrap(class = "Helix")]
fn helix_get_str(section: &str, key: &str) -> Result<Option<&str>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_str(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_string
#[magnus::wrap(class = "Helix")]
fn helix_get_string(section: &str, key: &str) -> Result<Option<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_string(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_supported_formats
#[magnus::wrap(class = "Helix")]
fn helix_get_supported_formats() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_supported_formats().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_supported_targets
#[magnus::wrap(class = "Helix")]
fn helix_get_supported_targets() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_supported_targets().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_u32
#[magnus::wrap(class = "Helix")]
fn helix_get_u32(section: &str, key: &str) -> Result<Option<u32>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_u32(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_u64
#[magnus::wrap(class = "Helix")]
fn helix_get_u64(section: &str, key: &str) -> Result<Option<u64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_u64(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_value
#[magnus::wrap(class = "Helix")]
fn helix_get_value(env: Env, key: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::get_value(env, key, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_variable
#[magnus::wrap(class = "Helix")]
fn helix_get_variable(name: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::get_variable(name).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_vec_bool
#[magnus::wrap(class = "Helix")]
fn helix_get_vec_bool(section: &str, key: &str) -> Result<Option<Vec<bool>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_vec_bool(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_vec_f64
#[magnus::wrap(class = "Helix")]
fn helix_get_vec_f64(section: &str, key: &str) -> Result<Option<Vec<f64>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_vec_f64(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_vec_i32
#[magnus::wrap(class = "Helix")]
fn helix_get_vec_i32(section: &str, key: &str) -> Result<Option<Vec<i32>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_vec_i32(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_vec_string
#[magnus::wrap(class = "Helix")]
fn helix_get_vec_string(section: &str, key: &str) -> Result<Option<Vec<String>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_vec_string(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_workflow_status
#[magnus::wrap(class = "Helix")]
fn helix_get_workflow_status(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::get_workflow_status(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// get_workflows
#[magnus::wrap(class = "Helix")]
fn helix_get_workflows(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixAst::get_workflows(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// handle_get_request
#[magnus::wrap(class = "Helix")]
fn helix_handle_get_request(path: &str, target_dir: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::handle_get_request(path, target_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// handle_request
#[magnus::wrap(class = "Helix")]
fn helix_handle_request(request: &str, target_dir: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::handle_request(request, target_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// has
#[magnus::wrap(class = "Helix")]
fn helix_has(key: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::has(key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// has_errors
#[magnus::wrap(class = "Helix")]
fn helix_has_errors() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::has_errors().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// has_variable
#[magnus::wrap(class = "Helix")]
fn helix_has_variable(name: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::has_variable(name).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// hash_error
#[magnus::wrap(class = "Helix")]
fn helix_hash_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::hash_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// helix_version
#[magnus::wrap(class = "Helix")]
fn helix_helix_version() -> Result<&'static str, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::helix_version().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// i32
#[magnus::wrap(class = "Helix")]
fn helix_i32() -> Result<Option<i32>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::i32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// i32_or
#[magnus::wrap(class = "Helix")]
fn helix_i32_or(default: i32) -> Result<i32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::i32_or(default).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// i64
#[magnus::wrap(class = "Helix")]
fn helix_i64() -> Result<Option<i64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::i64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// i64_or
#[magnus::wrap(class = "Helix")]
fn helix_i64_or(default: i64) -> Result<i64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::i64_or(default).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// import_export_data
#[magnus::wrap(class = "Helix")]
fn helix_import_export_data(export_data: ExportData, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::import_export_data(export_data, force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// import_from_json
#[magnus::wrap(class = "Helix")]
fn helix_import_from_json(input: &str, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::import_from_json(input, force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// import_from_toml
#[magnus::wrap(class = "Helix")]
fn helix_import_from_toml(input: &str, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::import_from_toml(input, force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// import_from_yaml
#[magnus::wrap(class = "Helix")]
fn helix_import_from_yaml(input: &str, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::import_from_yaml(input, force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// import_project
#[magnus::wrap(class = "Helix")]
fn helix_import_project(import_path: PathBuf, format: ExportFormat, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::import_project(import_path, format, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// include
#[magnus::wrap(class = "Helix")]
fn helix_include(_pattern: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::include(_pattern).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// increase
#[magnus::wrap(class = "Helix")]
fn helix_increase(section: &str, key: &str, amount: f64) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::increase(section, key, amount).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// index
#[magnus::wrap(class = "Helix")]
fn helix_index(section: &str) -> Result<Option<&HashMap<String, Value>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::index(section).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// index_mut
#[magnus::wrap(class = "Helix")]
fn helix_index_mut(section: &str) -> Result<Option<&mut HashMap<String, Value>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::index_mut(section).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// infer_type
#[magnus::wrap(class = "Helix")]
fn helix_infer_type(expression: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::infer_type(expression).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// info
#[magnus::wrap(class = "Helix")]
fn helix_info(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::info(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// info_command
#[magnus::wrap(class = "Helix")]
fn helix_info_command(file: PathBuf, format: &str, symbols: bool, sections: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::info_command(file, format, symbols, sections, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// init
#[magnus::wrap(class = "Helix")]
fn helix_init(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::init(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// init_command
#[magnus::wrap(class = "Helix")]
fn helix_init_command(template: &str, dir: Option<PathBuf>, name: Option<String>, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::init_command(template, dir.as_deref(), name.as_deref(), force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// init_project
#[magnus::wrap(class = "Helix")]
fn helix_init_project(template: &str, dir: Option<PathBuf>, name: Option<String>, force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::init_project(template, dir.as_deref(), name.as_deref(), force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// initialize
#[magnus::wrap(class = "Helix")]
fn helix_initialize() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::initialize().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// initialize_ruby_bindings
#[magnus::wrap(class = "Helix")]
fn helix_initialize_ruby_bindings() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::initialize_ruby_bindings().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// insert_selected_operator
#[magnus::wrap(class = "Helix")]
fn helix_insert_selected_operator(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::insert_selected_operator(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// inspect_state_dict
#[magnus::wrap(class = "Helix")]
fn helix_inspect_state_dict(path: &str) -> Result<anyhow::Result<Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::inspect_state_dict(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// intern
#[magnus::wrap(class = "Helix")]
fn helix_intern(s: &str) -> Result<u32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::intern(s).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// interpreter
#[magnus::wrap(class = "Helix")]
fn helix_interpreter() -> Result<Option<&HelixInterpreter>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixDispatcher::interpreter().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// interpreter_mut
#[magnus::wrap(class = "Helix")]
fn helix_interpreter_mut() -> Result<Option<&mut HelixInterpreter>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixDispatcher::interpreter_mut().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// invalid_input
#[magnus::wrap(class = "Helix")]
fn helix_invalid_input(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::invalid_input(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// invalid_parameters
#[magnus::wrap(class = "Helix")]
fn helix_invalid_parameters(operator: &str, params: &str) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::invalid_parameters(operator, params).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// io_error
#[magnus::wrap(class = "Helix")]
fn helix_io_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::io_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_array
#[magnus::wrap(class = "Helix")]
fn helix_is_array() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_array().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_boolean
#[magnus::wrap(class = "Helix")]
fn helix_is_boolean() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_boolean().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_compatible
#[magnus::wrap(class = "Helix")]
fn helix_is_compatible(_ir: RubyObject) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_compatible(_ir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_compressed
#[magnus::wrap(class = "Helix")]
fn helix_is_compressed() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_compressed().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_empty
#[magnus::wrap(class = "Helix")]
fn helix_is_empty() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_empty().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_loaded
#[magnus::wrap(class = "Helix")]
fn helix_is_loaded(section_type: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_loaded(section_type).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_null
#[magnus::wrap(class = "Helix")]
fn helix_is_null() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_null().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_number
#[magnus::wrap(class = "Helix")]
fn helix_is_number() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_number().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_object
#[magnus::wrap(class = "Helix")]
fn helix_is_object() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_object().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_paused
#[magnus::wrap(class = "Helix")]
fn helix_is_paused() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_paused().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_ready
#[magnus::wrap(class = "Helix")]
fn helix_is_ready() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixDispatcher::is_ready().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_recoverable
#[magnus::wrap(class = "Helix")]
fn helix_is_recoverable() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_recoverable().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_running
#[magnus::wrap(class = "Helix")]
fn helix_is_running() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_running().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// is_string
#[magnus::wrap(class = "Helix")]
fn helix_is_string() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::is_string().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// items
#[magnus::wrap(class = "Helix")]
fn helix_items(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::items(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// items_cloned
#[magnus::wrap(class = "Helix")]
fn helix_items_cloned(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::items_cloned(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// json_error
#[magnus::wrap(class = "Helix")]
fn helix_json_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::json_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// json_to_text
#[magnus::wrap(class = "Helix")]
fn helix_json_to_text(json: &str) -> Result<anyhow::Result<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::json_to_text(json).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// json_to_value
#[magnus::wrap(class = "Helix")]
fn helix_json_to_value(json_value: serde_json:: Value) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::json_to_value(json_value).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// json_value_to_value
#[magnus::wrap(class = "Helix")]
fn helix_json_value_to_value(json_value: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::json_value_to_value(json_value).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// keys
#[magnus::wrap(class = "Helix")]
fn helix_keys(section: &str) -> Result<Option<Vec<&String>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::keys(section).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// launch
#[magnus::wrap(class = "Helix")]
fn helix_launch() -> Result<TuiResult<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::launch().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// len
#[magnus::wrap(class = "Helix")]
fn helix_len() -> Result<usize, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::len().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// lint_files
#[magnus::wrap(class = "Helix")]
fn helix_lint_files(files: Vec<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::lint_files(files, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// lint_project
#[magnus::wrap(class = "Helix")]
fn helix_lint_project(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::lint_project(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// lint_single_file
#[magnus::wrap(class = "Helix")]
fn helix_lint_single_file(file: &str, verbose: bool) -> Result<Vec<LintIssue>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::lint_single_file(file, verbose).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// lint_specific_files
#[magnus::wrap(class = "Helix")]
fn helix_lint_specific_files(files: Vec<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::lint_specific_files(files, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// list_binaries
#[magnus::wrap(class = "Helix")]
fn helix_list_binaries(target_dir: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::list_binaries(target_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// list_config
#[magnus::wrap(class = "Helix")]
fn helix_list_config(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::list_config(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// list_config_values
#[magnus::wrap(class = "Helix")]
fn helix_list_config_values(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::list_config_values(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// list_variables
#[magnus::wrap(class = "Helix")]
fn helix_list_variables() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::list_variables().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// list_versions
#[magnus::wrap(class = "Helix")]
fn helix_list_versions(path: &str) -> Result<VaultResult<Vec<Version>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::list_versions(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// list_workflows
#[magnus::wrap(class = "Helix")]
fn helix_list_workflows(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::list_workflows(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load
#[magnus::wrap(class = "Helix")]
fn helix_load(name: &str, split: &str, cache_dir: &str) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load(name, split, cache_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_binary
#[magnus::wrap(class = "Helix")]
fn helix_load_binary(binary: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_binary(binary, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_default_config
#[magnus::wrap(class = "Helix")]
fn helix_load_default_config() -> Result<HelixConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::load_default_config().await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_embeddings
#[magnus::wrap(class = "Helix")]
fn helix_load_embeddings(emb_path: &str) -> Result<Vec<LoadedEmbedding>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_embeddings(emb_path).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_file
#[magnus::wrap(class = "Helix")]
fn helix_load_file(_file_path: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_file(_file_path, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_from_file
#[magnus::wrap(class = "Helix")]
fn helix_load_from_file(path: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_from_file(path, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_from_hlx
#[magnus::wrap(class = "Helix")]
fn helix_load_from_hlx() -> Result<OperatorParser, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_from_hlx().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_from_string
#[magnus::wrap(class = "Helix")]
fn helix_load_from_string(content: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_from_string(content, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_global_config
#[magnus::wrap(class = "Helix")]
fn helix_load_global_config() -> Result<GlobalConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::load_global_config().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_hlx
#[magnus::wrap(class = "Helix")]
fn helix_load_hlx() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::load_hlx().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_latest
#[magnus::wrap(class = "Helix")]
fn helix_load_latest(path: &str) -> Result<VaultResult<Vec<u8>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_latest(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_memory
#[magnus::wrap(class = "Helix")]
fn helix_load_memory(address: u32, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_memory(address, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_module
#[magnus::wrap(class = "Helix")]
fn helix_load_module(path: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_module(path, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_project
#[magnus::wrap(class = "Helix")]
fn helix_load_project(path: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_project(path, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_schema
#[magnus::wrap(class = "Helix")]
fn helix_load_schema(schema: &str, _ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_schema(schema, _ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_script
#[magnus::wrap(class = "Helix")]
fn helix_load_script(path: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_script(path, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_section
#[magnus::wrap(class = "Helix")]
fn helix_load_section(section_type: SectionType) -> Result<&DataSection, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_section(section_type).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// load_version
#[magnus::wrap(class = "Helix")]
fn helix_load_version(file_hash: &str, version_id: &str) -> Result<VaultResult<Vec<u8>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::load_version(file_hash, version_id).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// make
#[magnus::wrap(class = "Helix")]
fn helix_make() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::make().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// manage_cache
#[magnus::wrap(class = "Helix")]
fn helix_manage_cache(action: CacheAction, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::manage_cache(action, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// manage_config
#[magnus::wrap(class = "Helix")]
fn helix_manage_config(action: ConfigAction, key: Option<String>, value: Option<String>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::manage_config(action, key.as_deref(), value.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// merge
#[magnus::wrap(class = "Helix")]
fn helix_merge(other: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::merge(other, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// merge_configs
#[magnus::wrap(class = "Helix")]
fn helix_merge_configs(env: Env, configs: Vec<RubyObject>, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::merge_configs(env, configs, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// merge_modules
#[magnus::wrap(class = "Helix")]
fn helix_merge_modules(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::merge_modules(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// migrate
#[magnus::wrap(class = "Helix")]
fn helix_migrate(ir: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::migrate(ir, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// migrate_env
#[magnus::wrap(class = "Helix")]
fn helix_migrate_env(env_str: &str) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::migrate_env(env_str).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// migrate_json
#[magnus::wrap(class = "Helix")]
fn helix_migrate_json(json_str: &str) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::migrate_json(json_str).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// migrate_toml
#[magnus::wrap(class = "Helix")]
fn helix_migrate_toml(toml_str: &str) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::migrate_toml(toml_str).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// migrate_yaml
#[magnus::wrap(class = "Helix")]
fn helix_migrate_yaml(yaml_str: &str) -> Result<CsResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::migrate_yaml(yaml_str).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// modules
#[magnus::wrap(class = "Helix")]
fn helix_modules(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::modules(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// new_enhanced
#[magnus::wrap(class = "Helix")]
fn helix_new_enhanced(tokens: Vec<RubyObject>) -> Result<RubyParser, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::new_enhanced(tokens).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// new_with_context
#[magnus::wrap(class = "Helix")]
fn helix_new_with_context(context: ExecutionContext) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::new_with_context(context).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// new_with_source_map
#[magnus::wrap(class = "Helix")]
fn helix_new_with_source_map(source_map: &str) -> Result<RubyParser, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::new_with_source_map(source_map).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// next_tab
#[magnus::wrap(class = "Helix")]
fn helix_next_tab(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::next_tab(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// next_token
#[magnus::wrap(class = "Helix")]
fn helix_next_token() -> Result<Token, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::next_token().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// next_token_with_location
#[magnus::wrap(class = "Helix")]
fn helix_next_token_with_location() -> Result<TokenWithLocation, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::next_token_with_location().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// number
#[magnus::wrap(class = "Helix")]
fn helix_number() -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::number().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// numeric_range
#[magnus::wrap(class = "Helix")]
fn helix_numeric_range(min: Option<f64>, max: Option<f64>) -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::numeric_range(min.as_deref(), max.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// object
#[magnus::wrap(class = "Helix")]
fn helix_object() -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::object().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// on_tick
#[magnus::wrap(class = "Helix")]
fn helix_on_tick(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::on_tick(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// open_selected_file
#[magnus::wrap(class = "Helix")]
fn helix_open_selected_file() -> Result<TuiResult<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::open_selected_file().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// operator_engine
#[magnus::wrap(class = "Helix")]
fn helix_operator_engine(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::operator_engine(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// operator_engine_mut
#[magnus::wrap(class = "Helix")]
fn helix_operator_engine_mut(env: Env, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::operator_engine_mut(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// operator_registry
#[magnus::wrap(class = "Helix")]
fn helix_operator_registry() -> Result<&OperatorRegistry, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::operator_registry().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// optimization_level
#[magnus::wrap(class = "Helix")]
fn helix_optimization_level(level: OptimizationLevel) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::optimization_level(level).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// optimize
#[magnus::wrap(class = "Helix")]
fn helix_optimize(_ir: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::optimize(_ir, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// optimize_command
#[magnus::wrap(class = "Helix")]
fn helix_optimize_command(input: PathBuf, output: Option<PathBuf>, level: u8, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::optimize_command(input, output.as_deref(), level, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// params_to_json
#[magnus::wrap(class = "Helix")]
fn helix_params_to_json(params: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::params_to_json(params).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse
#[magnus::wrap(class = "Helix")]
fn helix_parse(source: &str) -> Result<HelixAst, ParseError, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse(source).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_and_execute
#[magnus::wrap(class = "Helix")]
fn helix_parse_and_execute(source: &str) -> Result<DispatchResult, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_and_execute(source).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_array
#[magnus::wrap(class = "Helix")]
fn helix_parse_array(txt: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_array(txt).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_content
#[magnus::wrap(class = "Helix")]
fn helix_parse_content(content: &str) -> Result<HlxConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_content(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_date
#[magnus::wrap(class = "Helix")]
fn helix_parse_date(v: &str, parser: &str) -> Result<Option<Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_date(v, parser).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_dsl
#[magnus::wrap(class = "Helix")]
fn helix_parse_dsl(source: &str) -> Result<DispatchResult, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixDispatcher::parse_dsl(source).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_env
#[magnus::wrap(class = "Helix")]
fn helix_parse_env(v: &str) -> Result<Option<Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_env(v).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_global_var
#[magnus::wrap(class = "Helix")]
fn helix_parse_global_var(v: &str) -> Result<Option<Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_global_var(v).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_helix
#[magnus::wrap(class = "Helix")]
fn helix_parse_helix(source: &str) -> Result<HelixAst, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_helix(source).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_helix_source
#[magnus::wrap(class = "Helix")]
fn helix_parse_helix_source(_source: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_helix_source(_source, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_hlx_content
#[magnus::wrap(class = "Helix")]
fn helix_parse_hlx_content(content: &str) -> Result<HashMap<String, Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_hlx_content(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_line
#[magnus::wrap(class = "Helix")]
fn helix_parse_line(raw: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_line(raw).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_object
#[magnus::wrap(class = "Helix")]
fn helix_parse_object(txt: &str) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_object(txt).await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_only
#[magnus::wrap(class = "Helix")]
fn helix_parse_only(source: &str) -> Result<anyhow::Result<Vec<Assign>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixDispatcher::parse_only(source).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_params
#[magnus::wrap(class = "Helix")]
fn helix_parse_params(params: &str) -> Result<HashMap<String, Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_params(params).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_primitive
#[magnus::wrap(class = "Helix")]
fn helix_parse_primitive(v: &str) -> Result<Option<Value>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_primitive(v).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_program
#[magnus::wrap(class = "Helix")]
fn helix_parse_program(source: &str) -> Result<anyhow::Result<Vec<Assign>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_program(source).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_quoted_string
#[magnus::wrap(class = "Helix")]
fn helix_parse_quoted_string() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_quoted_string().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// parse_value
#[magnus::wrap(class = "Helix")]
fn helix_parse_value(value: &str) -> Result<crate::dna::atp::value::Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::parse_value(value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// pattern
#[magnus::wrap(class = "Helix")]
fn helix_pattern(pattern: impl Into<String>) -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::pattern(pattern).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// pause
#[magnus::wrap(class = "Helix")]
fn helix_pause(id: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::pause(id, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// pause_workflow
#[magnus::wrap(class = "Helix")]
fn helix_pause_workflow(workflow_id: &str, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::pause_workflow(workflow_id, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// pop
#[magnus::wrap(class = "Helix")]
fn helix_pop(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::pop(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// position
#[magnus::wrap(class = "Helix")]
fn helix_position() -> Result<usize, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::position().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// pretty_print
#[magnus::wrap(class = "Helix")]
fn helix_pretty_print(ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::pretty_print(ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// preview_command
#[magnus::wrap(class = "Helix")]
fn helix_preview_command(file: PathBuf, format: Option<String>, rows: Option<usize>, columns: Option<Vec<String>>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::preview_command(file, format.as_deref(), rows.as_deref(), columns.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// previous_tab
#[magnus::wrap(class = "Helix")]
fn helix_previous_tab(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::previous_tab(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// print
#[magnus::wrap(class = "Helix")]
fn helix_print(ast: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::print(ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process
#[magnus::wrap(class = "Helix")]
fn helix_process() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_caption_file
#[magnus::wrap(class = "Helix")]
fn helix_process_caption_file(path: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_caption_file(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_dataset
#[magnus::wrap(class = "Helix")]
fn helix_process_dataset(dataset_name: &str, config: &str) -> Result<TrainingDataset, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_dataset(dataset_name, config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_dataset_config
#[magnus::wrap(class = "Helix")]
fn helix_process_dataset_config(config_path: &str, dataset_name: &str) -> Result<HlxResult<DatasetConfig>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::process_dataset_config(config_path, dataset_name).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_e621_json_data
#[magnus::wrap(class = "Helix")]
fn helix_process_e621_json_data(data: &str, file_path: &str, config: Option<E621Config>) -> Result<anyhow::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_e621_json_data(data, file_path, config.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_e621_json_file
#[magnus::wrap(class = "Helix")]
fn helix_process_e621_json_file(file_path: &str, config: Option<caption::E621Config>) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_e621_json_file(file_path, config.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_e621_tags
#[magnus::wrap(class = "Helix")]
fn helix_process_e621_tags(tags_dict: &str, config: Option<&E621Config>) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_e621_tags(tags_dict, config.as_deref()).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_file
#[magnus::wrap(class = "Helix")]
fn helix_process_file(path: &str) -> Result<anyhow::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_file(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_image_file
#[magnus::wrap(class = "Helix")]
fn helix_process_image_file(image_path: &str, config: &str, dry_run: bool) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_image_file(image_path, config, dry_run).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_json_to_caption
#[magnus::wrap(class = "Helix")]
fn helix_process_json_to_caption(input_path: &str) -> Result<io::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_json_to_caption(input_path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_safetensors_file
#[magnus::wrap(class = "Helix")]
fn helix_process_safetensors_file(file: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_safetensors_file(file).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// process_with_hlx
#[magnus::wrap(class = "Helix")]
fn helix_process_with_hlx(hlx_config_path: &str, dataset_data: Vec<serde_json::Value>) -> Result<HlxResult<ProcessedDataset>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::process_with_hlx(hlx_config_path, dataset_data).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// publish_project
#[magnus::wrap(class = "Helix")]
fn helix_publish_project(registry: Option<String>, token: Option<String>, dry_run: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::publish_project(registry.as_deref(), token.as_deref(), dry_run, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// push
#[magnus::wrap(class = "Helix")]
fn helix_push(value: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::push(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// quality_assessment
#[magnus::wrap(class = "Helix")]
fn helix_quality_assessment(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::quality_assessment(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// quality_validation
#[magnus::wrap(class = "Helix")]
fn helix_quality_validation(score: f64, issues: Vec<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::quality_validation(score, issues).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// range
#[magnus::wrap(class = "Helix")]
fn helix_range(min: f64, max: f64) -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::range(min, max).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_batches
#[magnus::wrap(class = "Helix")]
fn helix_read_batches() -> Result<Vec<RecordBatch>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_batches().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_bool
#[magnus::wrap(class = "Helix")]
fn helix_read_bool() -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_bool().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_bytes
#[magnus::wrap(class = "Helix")]
fn helix_read_bytes(length: usize) -> Result<Vec<u8>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_bytes(length).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_config
#[magnus::wrap(class = "Helix")]
fn helix_read_config() -> Result<HelixConfig, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::read_config().await.map(|item| item.to_ruby())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_f32
#[magnus::wrap(class = "Helix")]
fn helix_read_f32() -> Result<f32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_f32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_f64
#[magnus::wrap(class = "Helix")]
fn helix_read_f64() -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_f64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_from_file
#[magnus::wrap(class = "Helix")]
fn helix_read_from_file(path: &str) -> Result<HelixBinary, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_from_file(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_header
#[magnus::wrap(class = "Helix")]
fn helix_read_header() -> Result<HlxcHeader, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_header().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_i32
#[magnus::wrap(class = "Helix")]
fn helix_read_i32() -> Result<i32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_i32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_i64
#[magnus::wrap(class = "Helix")]
fn helix_read_i64() -> Result<i64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_i64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_project_manifest
#[magnus::wrap(class = "Helix")]
fn helix_read_project_manifest(project_dir: &str) -> Result<crate::dna::mds::project::ProjectManifest, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_project_manifest(project_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_string
#[magnus::wrap(class = "Helix")]
fn helix_read_string() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_string().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_u32
#[magnus::wrap(class = "Helix")]
fn helix_read_u32() -> Result<u32, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_u32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// read_u64
#[magnus::wrap(class = "Helix")]
fn helix_read_u64() -> Result<u64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::read_u64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// remaining
#[magnus::wrap(class = "Helix")]
fn helix_remaining() -> Result<usize, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::remaining().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// remove_breakpoint
#[magnus::wrap(class = "Helix")]
fn helix_remove_breakpoint(address: usize, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::remove_breakpoint(address, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// remove_dependencies
#[magnus::wrap(class = "Helix")]
fn helix_remove_dependencies(dependencies: Vec<String>, dev: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::remove_dependencies(dependencies, dev, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// remove_dependency
#[magnus::wrap(class = "Helix")]
fn helix_remove_dependency(dependency: &str, dev: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::remove_dependency(dependency, dev, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// remove_file
#[magnus::wrap(class = "Helix")]
fn helix_remove_file(path: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::remove_file(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// remove_filter
#[magnus::wrap(class = "Helix")]
fn helix_remove_filter(name: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::remove_filter(name).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// rename_file_without_image_extension
#[magnus::wrap(class = "Helix")]
fn helix_rename_file_without_image_extension(path: &str) -> Result<io::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::rename_file_without_image_extension(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// replace_special_chars
#[magnus::wrap(class = "Helix")]
fn helix_replace_special_chars(path: PathBuf) -> Result<anyhow::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::replace_special_chars(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// replace_string
#[magnus::wrap(class = "Helix")]
fn helix_replace_string(path: &str, search: &str, replace: &str) -> Result<anyhow::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::replace_string(path, search, replace).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// report
#[magnus::wrap(class = "Helix")]
fn helix_report() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::report().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// required
#[magnus::wrap(class = "Helix")]
fn helix_required(field: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::required(field).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// reset
#[magnus::wrap(class = "Helix")]
fn helix_reset(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::reset(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// reset_operator_category
#[magnus::wrap(class = "Helix")]
fn helix_reset_operator_category(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::reset_operator_category(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// reset_project
#[magnus::wrap(class = "Helix")]
fn helix_reset_project(force: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::reset_project(force, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// resolve
#[magnus::wrap(class = "Helix")]
fn helix_resolve(module_name: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::resolve(module_name).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// resolve_dependencies
#[magnus::wrap(class = "Helix")]
fn helix_resolve_dependencies(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::resolve_dependencies(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// resume
#[magnus::wrap(class = "Helix")]
fn helix_resume(id: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::resume(id, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// resume_workflow
#[magnus::wrap(class = "Helix")]
fn helix_resume_workflow(workflow_id: &str, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::resume_workflow(workflow_id, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// revert
#[magnus::wrap(class = "Helix")]
fn helix_revert(path: &str, version_id: &str) -> Result<VaultResult<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::revert(path, version_id).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// ruby_version
#[magnus::wrap(class = "Helix")]
fn helix_ruby_version() -> Result<&'static str, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::ruby_version().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run
#[magnus::wrap(class = "Helix")]
fn helix_run(args: LintArgs) -> Result<anyhow::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run(args).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_benchmarks
#[magnus::wrap(class = "Helix")]
fn helix_run_benchmarks(pattern: Option<String>, iterations: Option<usize>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_benchmarks(pattern.as_deref(), iterations.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_build
#[magnus::wrap(class = "Helix")]
fn helix_run_build(args: crate::dna::cmd::build:: BuildArgs) -> Result<anyhow::Result<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_build(args).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_diagnostics
#[magnus::wrap(class = "Helix")]
fn helix_run_diagnostics(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_diagnostics(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_json_cmd
#[magnus::wrap(class = "Helix")]
fn helix_run_json_cmd(args: JsonArgs) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_json_cmd(args).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_multi_process_clean
#[magnus::wrap(class = "Helix")]
fn helix_run_multi_process_clean(src_files: Vec<PathBuf>, dst_root: &str, schema_dir: Option<&Path>, format_override: &str, _jobs: usize) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_multi_process_clean(src_files, dst_root, schema_dir.as_deref(), format_override, _jobs).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_program
#[magnus::wrap(class = "Helix")]
fn helix_run_program(assignments: &str) -> Result<anyhow::Result<Env>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_program(assignments).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_project
#[magnus::wrap(class = "Helix")]
fn helix_run_project(input: Option<PathBuf>, args: Vec<String>, optimize: u8, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_project(input.as_deref(), args, optimize, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// run_tests
#[magnus::wrap(class = "Helix")]
fn helix_run_tests(pattern: Option<String>, verbose: bool, integration: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::run_tests(pattern.as_deref(), verbose, integration).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// rust_result_bool_to_c
#[magnus::wrap(class = "Helix")]
fn helix_rust_result_bool_to_c(result: CsResult<bool>, error_out: *mut *mut c_char) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::rust_result_bool_to_c(result, error_out).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// rust_result_f64_to_c
#[magnus::wrap(class = "Helix")]
fn helix_rust_result_f64_to_c(result: CsResult<f64>, error_out: *mut *mut c_char) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::rust_result_f64_to_c(result, error_out).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// rust_result_string_to_c
#[magnus::wrap(class = "Helix")]
fn helix_rust_result_string_to_c(result: CsResult<String>) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::rust_result_string_to_c(result).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// rust_result_u64_to_c
#[magnus::wrap(class = "Helix")]
fn helix_rust_result_u64_to_c(result: CsResult<u64>, error_out: *mut *mut c_char) -> Result<u64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::rust_result_u64_to_c(result, error_out).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// rust_string_to_c
#[magnus::wrap(class = "Helix")]
fn helix_rust_string_to_c(s: &str) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::rust_string_to_c(s).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// save
#[magnus::wrap(class = "Helix")]
fn helix_save(path: &str, description: Option<String>) -> Result<VaultResult<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::save(path, description.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// save_active_tab
#[magnus::wrap(class = "Helix")]
fn helix_save_active_tab() -> Result<TuiResult<()>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::save_active_tab().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// save_global_config
#[magnus::wrap(class = "Helix")]
fn helix_save_global_config(config: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::save_global_config(config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// save_project
#[magnus::wrap(class = "Helix")]
fn helix_save_project(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::save_project(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// schema_command
#[magnus::wrap(class = "Helix")]
fn helix_schema_command(target: PathBuf, lang: Language, output: Option<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::schema_command(target, lang, output.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// search_command
#[magnus::wrap(class = "Helix")]
fn helix_search_command(query: &str, search_type: &str, limit: usize, threshold: f32, embeddings_path: Option<PathBuf>, auto_find: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::search_command(query, search_type, limit, threshold, embeddings_path.as_deref(), auto_find, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// search_embeddings
#[magnus::wrap(class = "Helix")]
fn helix_search_embeddings(embeddings: &str, query: &str, search_type: &str, limit: usize, threshold: f32) -> Result<Vec<SearchResult>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::search_embeddings(embeddings, query, search_type, limit, threshold).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// search_hlx_files
#[magnus::wrap(class = "Helix")]
fn helix_search_hlx_files(query: &str, search_type: &str, limit: usize) -> Result<Vec<SearchResult>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::search_hlx_files(query, search_type, limit).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// sections
#[magnus::wrap(class = "Helix")]
fn helix_sections() -> Result<Vec<&String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::sections().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// seek
#[magnus::wrap(class = "Helix")]
fn helix_seek(position: usize, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::seek(position, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select
#[magnus::wrap(class = "Helix")]
fn helix_select(section: &str, key: &str) -> Result<TypedGetter, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::select(section, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_best
#[magnus::wrap(class = "Helix")]
fn helix_select_best(data: &str) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::select_best(data).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_next_command
#[magnus::wrap(class = "Helix")]
fn helix_select_next_command(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::select_next_command(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_next_file
#[magnus::wrap(class = "Helix")]
fn helix_select_next_file(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::select_next_file(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_next_operator
#[magnus::wrap(class = "Helix")]
fn helix_select_next_operator(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::select_next_operator(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_prev_command
#[magnus::wrap(class = "Helix")]
fn helix_select_prev_command(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::select_prev_command(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_prev_file
#[magnus::wrap(class = "Helix")]
fn helix_select_prev_file(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::select_prev_file(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// select_prev_operator
#[magnus::wrap(class = "Helix")]
fn helix_select_prev_operator(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::select_prev_operator(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// serialization_error
#[magnus::wrap(class = "Helix")]
fn helix_serialization_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::serialization_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// serialize
#[magnus::wrap(class = "Helix")]
fn helix_serialize(data: RubyUnknown) -> Result<Vec<u8>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::serialize(data).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// serialize_config
#[magnus::wrap(class = "Helix")]
fn helix_serialize_config(config: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::serialize_config(config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// serve_binary_file
#[magnus::wrap(class = "Helix")]
fn helix_serve_binary_file(filename: &str, target_dir: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::serve_binary_file(filename, target_dir).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// serve_project
#[magnus::wrap(class = "Helix")]
fn helix_serve_project(port: Option<u16>, host: Option<String>, directory: Option<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::serve_project(port.as_deref(), host.as_deref(), directory.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// server
#[magnus::wrap(class = "Helix")]
fn helix_server() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::server().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set
#[magnus::wrap(class = "Helix")]
fn helix_set(key: &str, value: RubyUnknown, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set(key, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_bool
#[magnus::wrap(class = "Helix")]
fn helix_set_bool(section: &str, key: &str, value: bool, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_bool(section, key, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_breakpoint
#[magnus::wrap(class = "Helix")]
fn helix_set_breakpoint(address: usize, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_breakpoint(address, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_config
#[magnus::wrap(class = "Helix")]
fn helix_set_config(key: Option<String>, value: Option<String>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::set_config(key.as_deref(), value.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_config_value
#[magnus::wrap(class = "Helix")]
fn helix_set_config_value(config: &str, key: &str, value: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::set_config_value(config, key, value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_context
#[magnus::wrap(class = "Helix")]
fn helix_set_context(context: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_context(context, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_format
#[magnus::wrap(class = "Helix")]
fn helix_set_format(format: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_format(format, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_level
#[magnus::wrap(class = "Helix")]
fn helix_set_level(level: RubyUnknown, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_level(level, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_num
#[magnus::wrap(class = "Helix")]
fn helix_set_num(section: &str, key: &str, value: f64, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_num(section, key, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_runtime_context
#[magnus::wrap(class = "Helix")]
fn helix_set_runtime_context(context: HashMap<String, Value>, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::set_runtime_context(context, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_str
#[magnus::wrap(class = "Helix")]
fn helix_set_str(section: &str, key: &str, value: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_str(section, key, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_target
#[magnus::wrap(class = "Helix")]
fn helix_set_target(target: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::set_target(target, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_value
#[magnus::wrap(class = "Helix")]
fn helix_set_value(key: &str, value: RubyUnknown, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::set_value(key, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// set_variable
#[magnus::wrap(class = "Helix")]
fn helix_set_variable(name: &str, value: Value) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixInterpreter::set_variable(name, value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// should_ignore_e621_tag
#[magnus::wrap(class = "Helix")]
fn helix_should_ignore_e621_tag(tag: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::should_ignore_e621_tag(tag).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// show_cache_info
#[magnus::wrap(class = "Helix")]
fn helix_show_cache_info(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::show_cache_info(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// show_cache_size
#[magnus::wrap(class = "Helix")]
fn helix_show_cache_size(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::show_cache_size(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// sign_binary
#[magnus::wrap(class = "Helix")]
fn helix_sign_binary(input: PathBuf, key: Option<String>, output: Option<PathBuf>, verify: bool, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::sign_binary(input, key.as_deref(), output.as_deref(), verify, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// size
#[magnus::wrap(class = "Helix")]
fn helix_size() -> Result<usize, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::size().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// split_content
#[magnus::wrap(class = "Helix")]
fn helix_split_content(content: &str) -> Result<(Vec<String>, Vec<String>), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::split_content(content).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// start
#[magnus::wrap(class = "Helix")]
fn helix_start(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::start(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// start_default_server
#[magnus::wrap(class = "Helix")]
fn helix_start_default_server() -> Result<crate::dna::mds::server::HelixServer, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::start_default_server().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// start_hot_reload
#[magnus::wrap(class = "Helix")]
fn helix_start_hot_reload(directory: PathBuf, output: Option<PathBuf>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::start_hot_reload(directory, output.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// start_server
#[magnus::wrap(class = "Helix")]
fn helix_start_server(config: crate::dna::mds::server:: ServerConfig) -> Result<crate::dna::mds::server::HelixServer, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::start_server(config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// state
#[magnus::wrap(class = "Helix")]
fn helix_state(env: Env, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::state(env, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// stats
#[magnus::wrap(class = "Helix")]
fn helix_stats() -> Result<SymbolTableStats, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::stats().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// step
#[magnus::wrap(class = "Helix")]
fn helix_step(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::step(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// stop
#[magnus::wrap(class = "Helix")]
fn helix_stop(id: &str) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::stop(id).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// stop_hot_reload
#[magnus::wrap(class = "Helix")]
fn helix_stop_hot_reload(verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::stop_hot_reload(verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// stop_workflow
#[magnus::wrap(class = "Helix")]
fn helix_stop_workflow(workflow_id: &str, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::stop_workflow(workflow_id, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// store_memory
#[magnus::wrap(class = "Helix")]
fn helix_store_memory(address: u32, value: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::store_memory(address, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// str
#[magnus::wrap(class = "Helix")]
fn helix_str() -> Result<Option<&str>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::str().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// string
#[magnus::wrap(class = "Helix")]
fn helix_string() -> Result<Option<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::string().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// string_length
#[magnus::wrap(class = "Helix")]
fn helix_string_length(min: Option<usize>, max: Option<usize>) -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::string_length(min.as_deref(), max.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// string_or
#[magnus::wrap(class = "Helix")]
fn helix_string_or(default: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::string_or(default).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// string_or_default
#[magnus::wrap(class = "Helix")]
fn helix_string_or_default() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::string_or_default().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// suggest_for_syntax_error
#[magnus::wrap(class = "Helix")]
fn helix_suggest_for_syntax_error(found: &str, expected: &str) -> Result<Option<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::suggest_for_syntax_error(found, expected).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// suggest_for_undefined_reference
#[magnus::wrap(class = "Helix")]
fn helix_suggest_for_undefined_reference(name: &str) -> Result<Option<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::suggest_for_undefined_reference(name).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// suggestions
#[magnus::wrap(class = "Helix")]
fn helix_suggestions() -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::suggestions().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// supported_features
#[magnus::wrap(class = "Helix")]
fn helix_supported_features() -> Result<Vec<&'static str>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::supported_features().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// sync_operator_selection
#[magnus::wrap(class = "Helix")]
fn helix_sync_operator_selection(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::sync_operator_selection(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// test
#[magnus::wrap(class = "Helix")]
fn helix_test() -> Result<&'static str, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::test().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// test_conditional_operators
#[magnus::wrap(class = "Helix")]
fn helix_test_conditional_operators() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::test_conditional_operators().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// test_fundamental_operators
#[magnus::wrap(class = "Helix")]
fn helix_test_fundamental_operators() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::test_fundamental_operators().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_algorithm_format
#[magnus::wrap(class = "Helix")]
fn helix_to_algorithm_format(algorithm: &str) -> Result<Box<dyn std::any::Any>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_algorithm_format(algorithm).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_binary
#[magnus::wrap(class = "Helix")]
fn helix_to_binary() -> Result<RubyHelixBinary, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_binary().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_json
#[magnus::wrap(class = "Helix")]
fn helix_to_json() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_json().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_json_bytes
#[magnus::wrap(class = "Helix")]
fn helix_to_json_bytes() -> Result<Vec<u8>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_json_bytes().await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_json_value
#[magnus::wrap(class = "Helix")]
fn helix_to_json_value() -> Result<serde_json::Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::to_json_value().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_string
#[magnus::wrap(class = "Helix")]
fn helix_to_string() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_string().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_training_dataset
#[magnus::wrap(class = "Helix")]
fn helix_to_training_dataset() -> Result<RubyTrainingDataset, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_training_dataset().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// to_yaml
#[magnus::wrap(class = "Helix")]
fn helix_to_yaml() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::to_yaml().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// tokenize
#[magnus::wrap(class = "Helix")]
fn helix_tokenize(text: &str) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::tokenize(text).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// tokenize_with_locations
#[magnus::wrap(class = "Helix")]
fn helix_tokenize_with_locations(input: &str) -> Result<Vec<TokenWithLocation>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::tokenize_with_locations(input).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// total_size_gb
#[magnus::wrap(class = "Helix")]
fn helix_total_size_gb() -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::total_size_gb().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// total_size_mb
#[magnus::wrap(class = "Helix")]
fn helix_total_size_mb() -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::total_size_mb().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// trigger_command
#[magnus::wrap(class = "Helix")]
fn helix_trigger_command(ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::trigger_command(ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// try_math
#[magnus::wrap(class = "Helix")]
fn helix_try_math(s: &str) -> Result<f64, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Parser::try_math(s).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// u32
#[magnus::wrap(class = "Helix")]
fn helix_u32() -> Result<Option<u32>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::u32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// u64
#[magnus::wrap(class = "Helix")]
fn helix_u64() -> Result<Option<u64>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::u64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// unknown_error
#[magnus::wrap(class = "Helix")]
fn helix_unknown_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::unknown_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// unknown_operator
#[magnus::wrap(class = "Helix")]
fn helix_unknown_operator(operator: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        OperatorEngine::unknown_operator(operator).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// unset_config
#[magnus::wrap(class = "Helix")]
fn helix_unset_config(key: Option<String>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::unset_config(key.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// unset_config_value
#[magnus::wrap(class = "Helix")]
fn helix_unset_config_value(config: &str, key: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::unset_config_value(config, key).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// unsupported_algorithm
#[magnus::wrap(class = "Helix")]
fn helix_unsupported_algorithm(algorithm: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::unsupported_algorithm(algorithm).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// unwatch_file
#[magnus::wrap(class = "Helix")]
fn helix_unwatch_file(id: &str) -> Result<bool, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::unwatch_file(id).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// upload_to_registry
#[magnus::wrap(class = "Helix")]
fn helix_upload_to_registry(_archive_path: &str, _manifest: crate::dna::mds::project:: ProjectManifest, _registry: Option<String>, _token: Option<String>, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::upload_to_registry(_archive_path, _manifest, _registry.as_deref(), _token.as_deref(), verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// url
#[magnus::wrap(class = "Helix")]
fn helix_url() -> Result<ValidationRule, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::url().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validate
#[magnus::wrap(class = "Helix")]
fn helix_validate(ast: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::validate(ast).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validate_command
#[magnus::wrap(class = "Helix")]
fn helix_validate_command(file: PathBuf, detailed: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::validate_command(file, detailed).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validate_dataset
#[magnus::wrap(class = "Helix")]
fn helix_validate_dataset(dataset_config: &str, data_sample: serde_json:: Value) -> Result<HlxResult<ValidationResult>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::validate_dataset(dataset_config, data_sample).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validate_file
#[magnus::wrap(class = "Helix")]
fn helix_validate_file(path: &str) -> Result<Vec<String>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::validate_file(path).await.map(|items| items.into_iter().map(|item| item.to_ruby()).collect())
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validate_filter_config
#[magnus::wrap(class = "Helix")]
fn helix_validate_filter_config(config: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::validate_filter_config(config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validate_package
#[magnus::wrap(class = "Helix")]
fn helix_validate_package(project_dir: &str, manifest: &str, project_name: &str, version: &str, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::validate_package(project_dir, manifest, project_name, version, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// validation_error
#[magnus::wrap(class = "Helix")]
fn helix_validation_error(message: impl Into<String>, suggestion: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::validation_error(message, suggestion).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// value_to_arrow_array
#[magnus::wrap(class = "Helix")]
fn helix_value_to_arrow_array(field: &str, values: Vec<crate::dna::atp::value::Value>) -> Result<ArrayRef, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::value_to_arrow_array(field, values).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// value_to_csharp
#[magnus::wrap(class = "Helix")]
fn helix_value_to_csharp(env: Env, value: &str) -> Result<*mut c_char, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::value_to_csharp(env, value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// value_to_json
#[magnus::wrap(class = "Helix")]
fn helix_value_to_json(value: &str) -> Result<serde_json::Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::value_to_json(value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// value_to_json_value
#[magnus::wrap(class = "Helix")]
fn helix_value_to_json_value(value: &str) -> Result<JsonValue, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::value_to_json_value(value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// value_to_ruby
#[magnus::wrap(class = "Helix")]
fn helix_value_to_ruby(env: Env, value: &str, ruby: &Ruby) -> Result<Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::value_to_ruby(env, value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// value_type
#[magnus::wrap(class = "Helix")]
fn helix_value_type() -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Value::value_type().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// vec_bool
#[magnus::wrap(class = "Helix")]
fn helix_vec_bool() -> Result<Option<Vec<bool>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::vec_bool().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// vec_f64
#[magnus::wrap(class = "Helix")]
fn helix_vec_f64() -> Result<Option<Vec<f64>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::vec_f64().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// vec_i32
#[magnus::wrap(class = "Helix")]
fn helix_vec_i32() -> Result<Option<Vec<i32>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::vec_i32().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// vec_string
#[magnus::wrap(class = "Helix")]
fn helix_vec_string() -> Result<Option<Vec<String>>, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::vec_string().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// verbose
#[magnus::wrap(class = "Helix")]
fn helix_verbose(enable: bool) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::verbose(enable).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// version
#[magnus::wrap(class = "Helix")]
fn helix_version(version: impl Into<String>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::version(version).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// vm
#[magnus::wrap(class = "Helix")]
fn helix_vm() -> Result<RubyHelixVM, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::vm().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// watch
#[magnus::wrap(class = "Helix")]
fn helix_watch() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::watch().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// watch_command
#[magnus::wrap(class = "Helix")]
fn helix_watch_command(directory: PathBuf, output: Option<PathBuf>, optimize: u8, verbose: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::watch_command(directory, output.as_deref(), optimize, verbose).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// watch_file
#[magnus::wrap(class = "Helix")]
fn helix_watch_file(path: &str) -> Result<String, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::watch_file(path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_artist_prefix
#[magnus::wrap(class = "Helix")]
fn helix_with_artist_prefix(prefix: Option<String>) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_artist_prefix(prefix.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_artist_suffix
#[magnus::wrap(class = "Helix")]
fn helix_with_artist_suffix(suffix: Option<String>) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_artist_suffix(suffix.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_compression
#[magnus::wrap(class = "Helix")]
fn helix_with_compression(_compressed: bool, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_compression(_compressed, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_compression_method
#[magnus::wrap(class = "Helix")]
fn helix_with_compression_method(_method: RubyObject) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_compression_method(_method).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_config
#[magnus::wrap(class = "Helix")]
fn helix_with_config(_config: Config) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        HelixConfig::with_config(_config).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_debug
#[magnus::wrap(class = "Helix")]
fn helix_with_debug() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_debug().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_deduplication
#[magnus::wrap(class = "Helix")]
fn helix_with_deduplication(deduplicate: bool, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_deduplication(deduplicate, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_filter_tags
#[magnus::wrap(class = "Helix")]
fn helix_with_filter_tags(_filter_tags: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_filter_tags(_filter_tags).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_format
#[magnus::wrap(class = "Helix")]
fn helix_with_format(format: Option<String>) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_format(format.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_imports
#[magnus::wrap(class = "Helix")]
fn helix_with_imports(_follow: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_imports(_follow).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_iterations
#[magnus::wrap(class = "Helix")]
fn helix_with_iterations(iterations: usize, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_iterations(iterations, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_lazy
#[magnus::wrap(class = "Helix")]
fn helix_with_lazy(enable: bool) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_lazy(enable).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_metadata
#[magnus::wrap(class = "Helix")]
fn helix_with_metadata(metadata: HashMap<String, serde_json::Value>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_metadata(metadata).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_mmap
#[magnus::wrap(class = "Helix")]
fn helix_with_mmap(enable: bool) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_mmap(enable).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_preview
#[magnus::wrap(class = "Helix")]
fn helix_with_preview(_preview: Vec<RubyObject>, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_preview(_preview, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_rating_conversions
#[magnus::wrap(class = "Helix")]
fn helix_with_rating_conversions(conversions: Option<std::collections::HashMap<String, String>>) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_rating_conversions(conversions.as_deref()).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_replace_underscores
#[magnus::wrap(class = "Helix")]
fn helix_with_replace_underscores(_replace_underscores: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_replace_underscores(_replace_underscores).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_row_count
#[magnus::wrap(class = "Helix")]
fn helix_with_row_count(_count: u64, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_row_count(_count, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_schema
#[magnus::wrap(class = "Helix")]
fn helix_with_schema(schema: Schema) -> Result<Self, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_schema(schema).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_tree_shaking
#[magnus::wrap(class = "Helix")]
fn helix_with_tree_shaking(_enable: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_tree_shaking(_enable).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// with_warmup
#[magnus::wrap(class = "Helix")]
fn helix_with_warmup(warmup: usize, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::with_warmup(warmup, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// workflow_command
#[magnus::wrap(class = "Helix")]
fn helix_workflow_command(action: WorkflowAction, verbose: bool, _quiet: bool) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::workflow_command(action, verbose, _quiet).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_agents
#[magnus::wrap(class = "Helix")]
fn helix_write_agents(agents: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_agents(agents).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_batch
#[magnus::wrap(class = "Helix")]
fn helix_write_batch(batch: RubyObject, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Vault::write_batch(batch, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_bool
#[magnus::wrap(class = "Helix")]
fn helix_write_bool(value: bool, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_bool(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_bytes
#[magnus::wrap(class = "Helix")]
fn helix_write_bytes(bytes: Vec<u8>, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_bytes(bytes, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_contexts
#[magnus::wrap(class = "Helix")]
fn helix_write_contexts(contexts: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_contexts(contexts).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_crews
#[magnus::wrap(class = "Helix")]
fn helix_write_crews(crews: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_crews(crews).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_f32
#[magnus::wrap(class = "Helix")]
fn helix_write_f32(value: f32, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_f32(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_f64
#[magnus::wrap(class = "Helix")]
fn helix_write_f64(value: f64, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_f64(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_header
#[magnus::wrap(class = "Helix")]
fn helix_write_header() -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_header().await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_i32
#[magnus::wrap(class = "Helix")]
fn helix_write_i32(value: i32, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_i32(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_i64
#[magnus::wrap(class = "Helix")]
fn helix_write_i64(value: i64, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_i64(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_metadata
#[magnus::wrap(class = "Helix")]
fn helix_write_metadata(metadata: &str, value: serde_json:: Value) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_metadata(metadata, value).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_string
#[magnus::wrap(class = "Helix")]
fn helix_write_string(value: &str, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_string(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_to_file
#[magnus::wrap(class = "Helix")]
fn helix_write_to_file(binary: &str, path: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_to_file(binary, path).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_u32
#[magnus::wrap(class = "Helix")]
fn helix_write_u32(value: u32, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_u32(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_u64
#[magnus::wrap(class = "Helix")]
fn helix_write_u64(value: u64, ruby: &Ruby) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_u64(value, ruby).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// write_workflows
#[magnus::wrap(class = "Helix")]
fn helix_write_workflows(workflows: &str) -> Result<(), magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::write_workflows(workflows).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

// xlh
#[magnus::wrap(class = "Helix")]
fn helix_xlh(hlx: &str, operator: &str, params: &str) -> Result<crate::dna::atp::value::Value, magnus::Error> {
    let runtime = get_runtime()?;
    runtime.block_on(async {
        Hlx::xlh(hlx, operator, params).await
            .map_err(|e| magnus::Error::new(magnus::exception::runtime_error(), format!("{}", e)))
    })
}

#[magnus::init]
fn init() -> Result<(), MagnusError> {
    let class = Ruby::get().unwrap().define_class("Helix", Ruby::get().unwrap().class_object())?;
    
    class.define_method("add", magnus::function!(Helix::add, 1))?;
    
    class.define_method("add_agent", magnus::function!(Helix::add_agent, 2))?;
    
    class.define_method("add_batch", magnus::function!(Helix::add_batch, 1))?;
    
    class.define_method("add_context", magnus::function!(Helix::add_context, 2))?;
    
    class.define_method("add_crew", magnus::function!(Helix::add_crew, 2))?;
    
    class.define_method("add_database", magnus::function!(Helix::add_database, 2))?;
    
    class.define_method("add_declaration", magnus::function!(Helix::add_declaration, 2))?;
    
    class.define_method("add_dependencies", magnus::function!(Helix::add_dependencies, 4))?;
    
    class.define_method("add_dependency", magnus::function!(Helix::add_dependency, 3))?;
    
    class.define_method("add_entry", magnus::function!(Helix::add_entry, 2))?;
    
    class.define_method("add_file", magnus::function!(Helix::add_file, 3))?;
    
    class.define_method("add_filter", magnus::function!(Helix::add_filter, 3))?;
    
    class.define_method("add_load", magnus::function!(Helix::add_load, 2))?;
    
    class.define_method("add_memory", magnus::function!(Helix::add_memory, 2))?;
    
    class.define_method("add_migration", magnus::function!(Helix::add_migration, 4))?;
    
    class.define_method("add_pipeline", magnus::function!(Helix::add_pipeline, 2))?;
    
    class.define_method("add_plugin", magnus::function!(Helix::add_plugin, 2))?;
    
    class.define_method("add_project", magnus::function!(Helix::add_project, 2))?;
    
    class.define_method("add_row", magnus::function!(Helix::add_row, 2))?;
    
    class.define_method("add_search_path", magnus::function!(Helix::add_search_path, 1))?;
    
    class.define_method("add_section", magnus::function!(Helix::add_section, 2))?;
    
    class.define_method("add_workflow", magnus::function!(Helix::add_workflow, 2))?;
    
    class.define_method("analyze", magnus::function!(Helix::analyze, 2))?;
    
    class.define_method("analyze_python_files_with_options", magnus::function!(Helix::analyze_python_files_with_options, 4))?;
    
    class.define_method("apply_filters", magnus::function!(Helix::apply_filters, 1))?;
    
    class.define_method("array", magnus::function!(Helix::array, 0))?;
    
    class.define_method("as_boolean", magnus::function!(Helix::as_boolean, 0))?;
    
    class.define_method("as_f64", magnus::function!(Helix::as_f64, 0))?;
    
    class.define_method("as_integer", magnus::function!(Helix::as_integer, 0))?;
    
    class.define_method("ast_to_config", magnus::function!(Helix::ast_to_config, 1))?;
    
    class.define_method("base64_error", magnus::function!(Helix::base64_error, 2))?;
    
    class.define_method("benchmark_and_select", magnus::function!(Helix::benchmark_and_select, 1))?;
    
    class.define_method("binary", magnus::function!(Helix::binary, 3))?;
    
    class.define_method("binary_to_config", magnus::function!(Helix::binary_to_config, 1))?;
    
    class.define_method("bool", magnus::function!(Helix::bool, 0))?;
    
    class.define_method("bool_or", magnus::function!(Helix::bool_or, 1))?;
    
    class.define_method("bool_or_false", magnus::function!(Helix::bool_or_false, 0))?;
    
    class.define_method("bool_or_true", magnus::function!(Helix::bool_or_true, 0))?;
    
    class.define_method("boolean", magnus::function!(Helix::boolean, 0))?;
    
    class.define_method("build", magnus::function!(Helix::build, 0))?;
    
    class.define_method("build_bundle", magnus::function!(Helix::build_bundle, 2))?;
    
    class.define_method("builder", magnus::function!(Helix::builder, 0))?;
    
    class.define_method("bundle_command", magnus::function!(Helix::bundle_command, 7))?;
    
    class.define_method("bundle_files", magnus::function!(Helix::bundle_files, 2))?;
    
    class.define_method("cache", magnus::function!(Helix::cache, 1))?;
    
    class.define_method("cache_stats", magnus::function!(Helix::cache_stats, 0))?;
    
    class.define_method("calculate_checksum", magnus::function!(Helix::calculate_checksum, 0))?;
    
    class.define_method("can_migrate", magnus::function!(Helix::can_migrate, 2))?;
    
    class.define_method("caption_file_exists_and_not_empty", magnus::function!(Helix::caption_file_exists_and_not_empty, 1))?;
    
    class.define_method("check_circular", magnus::function!(Helix::check_circular, 1))?;
    
    class.define_method("check_dependencies", magnus::function!(Helix::check_dependencies, 1))?;
    
    class.define_method("check_environment", magnus::function!(Helix::check_environment, 1))?;
    
    class.define_method("check_file_issues", magnus::function!(Helix::check_file_issues, 2))?;
    
    class.define_method("check_line_issues", magnus::function!(Helix::check_line_issues, 2))?;
    
    class.define_method("check_type", magnus::function!(Helix::check_type, 2))?;
    
    class.define_method("check_types", magnus::function!(Helix::check_types, 1))?;
    
    class.define_method("clean_cache", magnus::function!(Helix::clean_cache, 1))?;
    
    class.define_method("clean_project", magnus::function!(Helix::clean_project, 3))?;
    
    class.define_method("clear", magnus::function!(Helix::clear, 1))?;
    
    class.define_method("clear_cache", magnus::function!(Helix::clear_cache, 0))?;
    
    class.define_method("clear_changes", magnus::function!(Helix::clear_changes, 1))?;
    
    class.define_method("clear_filters", magnus::function!(Helix::clear_filters, 1))?;
    
    class.define_method("close_active_tab", magnus::function!(Helix::close_active_tab, 1))?;
    
    class.define_method("cmd_add", magnus::function!(Helix::cmd_add, 4))?;
    
    class.define_method("cmd_bench", magnus::function!(Helix::cmd_bench, 2))?;
    
    class.define_method("cmd_bundle", magnus::function!(Helix::cmd_bundle, 6))?;
    
    class.define_method("cmd_clean", magnus::function!(Helix::cmd_clean, 2))?;
    
    class.define_method("cmd_compile", magnus::function!(Helix::cmd_compile, 7))?;
    
    class.define_method("cmd_completions", magnus::function!(Helix::cmd_completions, 3))?;
    
    class.define_method("cmd_dataset", magnus::function!(Helix::cmd_dataset, 3))?;
    
    class.define_method("cmd_diff", magnus::function!(Helix::cmd_diff, 3))?;
    
    class.define_method("cmd_doctor", magnus::function!(Helix::cmd_doctor, 1))?;
    
    class.define_method("cmd_export", magnus::function!(Helix::cmd_export, 4))?;
    
    class.define_method("cmd_filter", magnus::function!(Helix::cmd_filter, 1))?;
    
    class.define_method("cmd_fmt", magnus::function!(Helix::cmd_fmt, 3))?;
    
    class.define_method("cmd_generate", magnus::function!(Helix::cmd_generate, 5))?;
    
    class.define_method("cmd_import", magnus::function!(Helix::cmd_import, 4))?;
    
    class.define_method("cmd_info", magnus::function!(Helix::cmd_info, 7))?;
    
    class.define_method("cmd_init", magnus::function!(Helix::cmd_init, 4))?;
    
    class.define_method("cmd_lint", magnus::function!(Helix::cmd_lint, 2))?;
    
    class.define_method("cmd_optimize", magnus::function!(Helix::cmd_optimize, 3))?;
    
    class.define_method("cmd_publish", magnus::function!(Helix::cmd_publish, 12))?;
    
    class.define_method("cmd_remove", magnus::function!(Helix::cmd_remove, 1))?;
    
    class.define_method("cmd_reset", magnus::function!(Helix::cmd_reset, 1))?;
    
    class.define_method("cmd_schema", magnus::function!(Helix::cmd_schema, 4))?;
    
    class.define_method("cmd_search", magnus::function!(Helix::cmd_search, 6))?;
    
    class.define_method("cmd_serve", magnus::function!(Helix::cmd_serve, 3))?;
    
    class.define_method("cmd_sign", magnus::function!(Helix::cmd_sign, 5))?;
    
    class.define_method("cmd_test", magnus::function!(Helix::cmd_test, 2))?;
    
    class.define_method("cmd_tui", magnus::function!(Helix::cmd_tui, 0))?;
    
    class.define_method("cmd_validate", magnus::function!(Helix::cmd_validate, 1))?;
    
    class.define_method("cmd_vlt", magnus::function!(Helix::cmd_vlt, 16))?;
    
    class.define_method("cmd_watch", magnus::function!(Helix::cmd_watch, 5))?;
    
    class.define_method("collect_dependencies", magnus::function!(Helix::collect_dependencies, 1))?;
    
    class.define_method("collect_helix_files", magnus::function!(Helix::collect_helix_files, 2))?;
    
    class.define_method("collect_source_files", magnus::function!(Helix::collect_source_files, 1))?;
    
    class.define_method("compilation_error", magnus::function!(Helix::compilation_error, 2))?;
    
    class.define_method("compilation_order", magnus::function!(Helix::compilation_order, 0))?;
    
    class.define_method("compile", magnus::function!(Helix::compile, 0))?;
    
    class.define_method("compile_command", magnus::function!(Helix::compile_command, 7))?;
    
    class.define_method("compile_source", magnus::function!(Helix::compile_source, 2))?;
    
    class.define_method("compile_to_binary", magnus::function!(Helix::compile_to_binary, 1))?;
    
    class.define_method("completions_command", magnus::function!(Helix::completions_command, 3))?;
    
    class.define_method("compress", magnus::function!(Helix::compress, 1))?;
    
    class.define_method("compression", magnus::function!(Helix::compression, 1))?;
    
    class.define_method("compression_error", magnus::function!(Helix::compression_error, 2))?;
    
    class.define_method("compression_ratio", magnus::function!(Helix::compression_ratio, 1))?;
    
    class.define_method("compute_statistics", magnus::function!(Helix::compute_statistics, 2))?;
    
    class.define_method("concat_files", magnus::function!(Helix::concat_files, 3))?;
    
    class.define_method("config_conversion", magnus::function!(Helix::config_conversion, 2))?;
    
    class.define_method("context", magnus::function!(Helix::context, 0))?;
    
    class.define_method("continue_execution", magnus::function!(Helix::continue_execution, 1))?;
    
    class.define_method("convert_from_ruby_value", magnus::function!(Helix::convert_from_ruby_value, 1))?;
    
    class.define_method("convert_legacy_dataset", magnus::function!(Helix::convert_legacy_dataset, 1))?;
    
    class.define_method("copy_directory", magnus::function!(Helix::copy_directory, 2))?;
    
    class.define_method("cosine_similarity", magnus::function!(Helix::cosine_similarity, 2))?;
    
    class.define_method("create_default_config", magnus::function!(Helix::create_default_config, 0))?;
    
    class.define_method("create_default_filter", magnus::function!(Helix::create_default_filter, 0))?;
    
    class.define_method("create_error_response", magnus::function!(Helix::create_error_response, 2))?;
    
    class.define_method("create_health_response", magnus::function!(Helix::create_health_response, 0))?;
    
    class.define_method("create_html_response", magnus::function!(Helix::create_html_response, 1))?;
    
    class.define_method("create_new_tab", magnus::function!(Helix::create_new_tab, 1))?;
    
    class.define_method("create_package_archive", magnus::function!(Helix::create_package_archive, 5))?;
    
    class.define_method("create_project", magnus::function!(Helix::create_project, 3))?;
    
    class.define_method("create_ruby_array", magnus::function!(Helix::create_ruby_array, 2))?;
    
    class.define_method("create_ruby_boolean", magnus::function!(Helix::create_ruby_boolean, 2))?;
    
    class.define_method("create_ruby_error", magnus::function!(Helix::create_ruby_error, 1))?;
    
    class.define_method("create_ruby_number", magnus::function!(Helix::create_ruby_number, 2))?;
    
    class.define_method("create_ruby_object", magnus::function!(Helix::create_ruby_object, 1))?;
    
    class.define_method("create_ruby_string", magnus::function!(Helix::create_ruby_string, 2))?;
    
    class.define_method("create_template", magnus::function!(Helix::create_template, 3))?;
    
    class.define_method("cycle_operator_category_next", magnus::function!(Helix::cycle_operator_category_next, 1))?;
    
    class.define_method("cycle_operator_category_prev", magnus::function!(Helix::cycle_operator_category_prev, 1))?;
    
    class.define_method("dataset_command", magnus::function!(Helix::dataset_command, 2))?;
    
    class.define_method("dataset_not_found", magnus::function!(Helix::dataset_not_found, 1))?;
    
    class.define_method("dataset_processing", magnus::function!(Helix::dataset_processing, 1))?;
    
    class.define_method("decode_json_strings", magnus::function!(Helix::decode_json_strings, 1))?;
    
    class.define_method("decompile", magnus::function!(Helix::decompile, 1))?;
    
    class.define_method("decompile_binary", magnus::function!(Helix::decompile_binary, 1))?;
    
    class.define_method("decompile_command", magnus::function!(Helix::decompile_command, 3))?;
    
    class.define_method("decompile_ir", magnus::function!(Helix::decompile_ir, 1))?;
    
    class.define_method("decompress", magnus::function!(Helix::decompress, 0))?;
    
    class.define_method("decompression_error", magnus::function!(Helix::decompression_error, 2))?;
    
    class.define_method("delete", magnus::function!(Helix::delete, 1))?;
    
    class.define_method("dependency_graph", magnus::function!(Helix::dependency_graph, 0))?;
    
    class.define_method("description", magnus::function!(Helix::description, 1))?;
    
    class.define_method("deserialization_error", magnus::function!(Helix::deserialization_error, 2))?;
    
    class.define_method("deserialize", magnus::function!(Helix::deserialize, 1))?;
    
    class.define_method("deserialize_to_ir", magnus::function!(Helix::deserialize_to_ir, 1))?;
    
    class.define_method("detect_training_format", magnus::function!(Helix::detect_training_format, 2))?;
    
    class.define_method("diff_command", magnus::function!(Helix::diff_command, 3))?;
    
    class.define_method("edit_config", magnus::function!(Helix::edit_config, 1))?;
    
    class.define_method("edit_config_file", magnus::function!(Helix::edit_config_file, 1))?;
    
    class.define_method("email", magnus::function!(Helix::email, 0))?;
    
    class.define_method("ensure_calc_dir", magnus::function!(Helix::ensure_calc_dir, 0))?;
    
    class.define_method("enum_values", magnus::function!(Helix::enum_values, 1))?;
    
    class.define_method("error_csharp", magnus::function!(Helix::error_csharp, 1))?;
    
    class.define_method("eval_date_expression", magnus::function!(Helix::eval_date_expression, 1))?;
    
    class.define_method("eval_expr", magnus::function!(Helix::eval_expr, 2))?;
    
    class.define_method("eval_math_expression", magnus::function!(Helix::eval_math_expression, 1))?;
    
    class.define_method("evaluate", magnus::function!(Helix::evaluate, 1))?;
    
    class.define_method("evaluate_expression", magnus::function!(Helix::evaluate_expression, 1))?;
    
    class.define_method("exclude", magnus::function!(Helix::exclude, 1))?;
    
    class.define_method("execute", magnus::function!(Helix::execute, 1))?;
    
    class.define_method("execute_ast", magnus::function!(Helix::execute_ast, 1))?;
    
    class.define_method("execute_binary", magnus::function!(Helix::execute_binary, 2))?;
    
    class.define_method("execute_date", magnus::function!(Helix::execute_date, 1))?;
    
    class.define_method("execute_helix", magnus::function!(Helix::execute_helix, 1))?;
    
    class.define_method("execute_operator", magnus::function!(Helix::execute_operator, 2))?;
    
    class.define_method("execution_error", magnus::function!(Helix::execution_error, 2))?;
    
    class.define_method("export_project", magnus::function!(Helix::export_project, 4))?;
    
    class.define_method("export_to_docker", magnus::function!(Helix::export_to_docker, 3))?;
    
    class.define_method("export_to_json", magnus::function!(Helix::export_to_json, 3))?;
    
    class.define_method("export_to_k8s", magnus::function!(Helix::export_to_k8s, 3))?;
    
    class.define_method("export_to_kubernetes", magnus::function!(Helix::export_to_kubernetes, 3))?;
    
    class.define_method("export_to_toml", magnus::function!(Helix::export_to_toml, 3))?;
    
    class.define_method("export_to_yaml", magnus::function!(Helix::export_to_yaml, 3))?;
    
    class.define_method("extract_keywords", magnus::function!(Helix::extract_keywords, 1))?;
    
    class.define_method("extract_project_name", magnus::function!(Helix::extract_project_name, 1))?;
    
    class.define_method("extract_project_version", magnus::function!(Helix::extract_project_version, 1))?;
    
    class.define_method("extract_training_metadata", magnus::function!(Helix::extract_training_metadata, 1))?;
    
    class.define_method("f32", magnus::function!(Helix::f32, 0))?;
    
    class.define_method("f64", magnus::function!(Helix::f64, 0))?;
    
    class.define_method("f64_or", magnus::function!(Helix::f64_or, 1))?;
    
    class.define_method("feature_error", magnus::function!(Helix::feature_error, 2))?;
    
    class.define_method("field", magnus::function!(Helix::field, 2))?;
    
    class.define_method("finalize", magnus::function!(Helix::finalize, 1))?;
    
    class.define_method("finalize_all", magnus::function!(Helix::finalize_all, 1))?;
    
    class.define_method("finalize_enhanced_with_source_map", magnus::function!(Helix::finalize_enhanced_with_source_map, 1))?;
    
    class.define_method("find_embedding_directories", magnus::function!(Helix::find_embedding_directories, 0))?;
    
    class.define_method("find_helix_files", magnus::function!(Helix::find_helix_files, 2))?;
    
    class.define_method("find_helix_files_recursive", magnus::function!(Helix::find_helix_files_recursive, 2))?;
    
    class.define_method("find_project_root", magnus::function!(Helix::find_project_root, 0))?;
    
    class.define_method("find_schema_for_file", magnus::function!(Helix::find_schema_for_file, 2))?;
    
    class.define_method("flush_batch", magnus::function!(Helix::flush_batch, 1))?;
    
    class.define_method("fnmanage_cache", magnus::function!(Helix::fnmanage_cache, 2))?;
    
    class.define_method("fnmanage_config", magnus::function!(Helix::fnmanage_config, 4))?;
    
    class.define_method("fnrun_diagnostics", magnus::function!(Helix::fnrun_diagnostics, 1))?;
    
    class.define_method("focus", magnus::function!(Helix::focus, 2))?;
    
    class.define_method("format_conversion", magnus::function!(Helix::format_conversion, 2))?;
    
    class.define_method("format_files", magnus::function!(Helix::format_files, 3))?;
    
    class.define_method("format_json_file", magnus::function!(Helix::format_json_file, 1))?;
    
    class.define_method("format_text_content", magnus::function!(Helix::format_text_content, 1))?;
    
    class.define_method("format_value", magnus::function!(Helix::format_value, 1))?;
    
    class.define_method("format_with_source", magnus::function!(Helix::format_with_source, 2))?;
    
    class.define_method("from_binary", magnus::function!(Helix::from_binary, 1))?;
    
    class.define_method("from_file", magnus::function!(Helix::from_file, 1))?;
    
    class.define_method("from_json", magnus::function!(Helix::from_json, 2))?;
    
    class.define_method("from_json_bytes", magnus::function!(Helix::from_json_bytes, 2))?;
    
    class.define_method("from_preset", magnus::function!(Helix::from_preset, 2))?;
    
    class.define_method("from_str", magnus::function!(Helix::from_str, 1))?;
    
    class.define_method("from_string", magnus::function!(Helix::from_string, 1))?;
    
    class.define_method("from_u8", magnus::function!(Helix::from_u8, 2))?;
    
    class.define_method("garbage_collect", magnus::function!(Helix::garbage_collect, 0))?;
    
    class.define_method("gather_json_paths", magnus::function!(Helix::gather_json_paths, 2))?;
    
    class.define_method("generate", magnus::function!(Helix::generate, 2))?;
    
    class.define_method("generate_code", magnus::function!(Helix::generate_code, 5))?;
    
    class.define_method("generate_csharp_schema", magnus::function!(Helix::generate_csharp_schema, 1))?;
    
    class.define_method("generate_for_ast", magnus::function!(Helix::generate_for_ast, 1))?;
    
    class.define_method("generate_for_ir", magnus::function!(Helix::generate_for_ir, 1))?;
    
    class.define_method("generate_go_schema", magnus::function!(Helix::generate_go_schema, 1))?;
    
    class.define_method("generate_java_schema", magnus::function!(Helix::generate_java_schema, 1))?;
    
    class.define_method("generate_javascript_schema", magnus::function!(Helix::generate_javascript_schema, 1))?;
    
    class.define_method("generate_large_config", magnus::function!(Helix::generate_large_config, 0))?;
    
    class.define_method("generate_medium_config", magnus::function!(Helix::generate_medium_config, 0))?;
    
    class.define_method("generate_php_schema", magnus::function!(Helix::generate_php_schema, 1))?;
    
    class.define_method("generate_python_schema", magnus::function!(Helix::generate_python_schema, 1))?;
    
    class.define_method("generate_ruby_schema", magnus::function!(Helix::generate_ruby_schema, 1))?;
    
    class.define_method("generate_rust_schema", magnus::function!(Helix::generate_rust_schema, 1))?;
    
    class.define_method("generate_schema_code", magnus::function!(Helix::generate_schema_code, 2))?;
    
    class.define_method("generate_small_config", magnus::function!(Helix::generate_small_config, 0))?;
    
    class.define_method("get", magnus::function!(Helix::get, 1))?;
    
    class.define_method("get_agents", magnus::function!(Helix::get_agents, 2))?;
    
    class.define_method("get_all_configs", magnus::function!(Helix::get_all_configs, 0))?;
    
    class.define_method("get_array", magnus::function!(Helix::get_array, 2))?;
    
    class.define_method("get_auto", magnus::function!(Helix::get_auto, 2))?;
    
    class.define_method("get_bool", magnus::function!(Helix::get_bool, 2))?;
    
    class.define_method("get_boolean", magnus::function!(Helix::get_boolean, 1))?;
    
    class.define_method("get_bundle_path", magnus::function!(Helix::get_bundle_path, 0))?;
    
    class.define_method("get_cache_directory", magnus::function!(Helix::get_cache_directory, 0))?;
    
    class.define_method("get_changed_files", magnus::function!(Helix::get_changed_files, 0))?;
    
    class.define_method("get_compilation_order", magnus::function!(Helix::get_compilation_order, 0))?;
    
    class.define_method("get_config", magnus::function!(Helix::get_config, 3))?;
    
    class.define_method("get_config_value", magnus::function!(Helix::get_config_value, 2))?;
    
    class.define_method("get_context", magnus::function!(Helix::get_context, 2))?;
    
    class.define_method("get_contexts", magnus::function!(Helix::get_contexts, 2))?;
    
    class.define_method("get_default_editor", magnus::function!(Helix::get_default_editor, 0))?;
    
    class.define_method("get_dynamic", magnus::function!(Helix::get_dynamic, 2))?;
    
    class.define_method("get_editor", magnus::function!(Helix::get_editor, 0))?;
    
    class.define_method("get_embedded_templates", magnus::function!(Helix::get_embedded_templates, 0))?;
    
    class.define_method("get_embedding_stats", magnus::function!(Helix::get_embedding_stats, 1))?;
    
    class.define_method("get_endpoint", magnus::function!(Helix::get_endpoint, 0))?;
    
    class.define_method("get_error_count", magnus::function!(Helix::get_error_count, 0))?;
    
    class.define_method("get_errors", magnus::function!(Helix::get_errors, 0))?;
    
    class.define_method("get_f32", magnus::function!(Helix::get_f32, 2))?;
    
    class.define_method("get_f64", magnus::function!(Helix::get_f64, 2))?;
    
    class.define_method("get_features", magnus::function!(Helix::get_features, 2))?;
    
    class.define_method("get_file_path", magnus::function!(Helix::get_file_path, 0))?;
    
    class.define_method("get_files", magnus::function!(Helix::get_files, 0))?;
    
    class.define_method("get_filter_names", magnus::function!(Helix::get_filter_names, 0))?;
    
    class.define_method("get_global_config_path", magnus::function!(Helix::get_global_config_path, 0))?;
    
    class.define_method("get_history", magnus::function!(Helix::get_history, 1))?;
    
    class.define_method("get_i32", magnus::function!(Helix::get_i32, 2))?;
    
    class.define_method("get_i64", magnus::function!(Helix::get_i64, 2))?;
    
    class.define_method("get_level", magnus::function!(Helix::get_level, 0))?;
    
    class.define_method("get_line", magnus::function!(Helix::get_line, 1))?;
    
    class.define_method("get_memory", magnus::function!(Helix::get_memory, 4))?;
    
    class.define_method("get_migration_path", magnus::function!(Helix::get_migration_path, 2))?;
    
    class.define_method("get_mut", magnus::function!(Helix::get_mut, 3))?;
    
    class.define_method("get_num", magnus::function!(Helix::get_num, 2))?;
    
    class.define_method("get_number", magnus::function!(Helix::get_number, 1))?;
    
    class.define_method("get_object", magnus::function!(Helix::get_object, 3))?;
    
    class.define_method("get_or_create_helix_dir", magnus::function!(Helix::get_or_create_helix_dir, 0))?;
    
    class.define_method("get_output_files", magnus::function!(Helix::get_output_files, 0))?;
    
    class.define_method("get_preview", magnus::function!(Helix::get_preview, 0))?;
    
    class.define_method("get_project_name", magnus::function!(Helix::get_project_name, 0))?;
    
    class.define_method("get_project_path", magnus::function!(Helix::get_project_path, 0))?;
    
    class.define_method("get_projects", magnus::function!(Helix::get_projects, 2))?;
    
    class.define_method("get_random_sample", magnus::function!(Helix::get_random_sample, 2))?;
    
    class.define_method("get_raw", magnus::function!(Helix::get_raw, 2))?;
    
    class.define_method("get_ref", magnus::function!(Helix::get_ref, 3))?;
    
    class.define_method("get_registers", magnus::function!(Helix::get_registers, 2))?;
    
    class.define_method("get_report", magnus::function!(Helix::get_report, 0))?;
    
    class.define_method("get_ruby_null", magnus::function!(Helix::get_ruby_null, 1))?;
    
    class.define_method("get_schema", magnus::function!(Helix::get_schema, 0))?;
    
    class.define_method("get_schema_version", magnus::function!(Helix::get_schema_version, 0))?;
    
    class.define_method("get_similarity", magnus::function!(Helix::get_similarity, 2))?;
    
    class.define_method("get_str", magnus::function!(Helix::get_str, 2))?;
    
    class.define_method("get_string", magnus::function!(Helix::get_string, 2))?;
    
    class.define_method("get_supported_formats", magnus::function!(Helix::get_supported_formats, 0))?;
    
    class.define_method("get_supported_targets", magnus::function!(Helix::get_supported_targets, 0))?;
    
    class.define_method("get_u32", magnus::function!(Helix::get_u32, 2))?;
    
    class.define_method("get_u64", magnus::function!(Helix::get_u64, 2))?;
    
    class.define_method("get_value", magnus::function!(Helix::get_value, 3))?;
    
    class.define_method("get_variable", magnus::function!(Helix::get_variable, 1))?;
    
    class.define_method("get_vec_bool", magnus::function!(Helix::get_vec_bool, 2))?;
    
    class.define_method("get_vec_f64", magnus::function!(Helix::get_vec_f64, 2))?;
    
    class.define_method("get_vec_i32", magnus::function!(Helix::get_vec_i32, 2))?;
    
    class.define_method("get_vec_string", magnus::function!(Helix::get_vec_string, 2))?;
    
    class.define_method("get_workflow_status", magnus::function!(Helix::get_workflow_status, 1))?;
    
    class.define_method("get_workflows", magnus::function!(Helix::get_workflows, 2))?;
    
    class.define_method("handle_get_request", magnus::function!(Helix::handle_get_request, 2))?;
    
    class.define_method("handle_request", magnus::function!(Helix::handle_request, 2))?;
    
    class.define_method("has", magnus::function!(Helix::has, 1))?;
    
    class.define_method("has_errors", magnus::function!(Helix::has_errors, 0))?;
    
    class.define_method("has_variable", magnus::function!(Helix::has_variable, 1))?;
    
    class.define_method("hash_error", magnus::function!(Helix::hash_error, 2))?;
    
    class.define_method("helix_version", magnus::function!(Helix::helix_version, 0))?;
    
    class.define_method("i32", magnus::function!(Helix::i32, 0))?;
    
    class.define_method("i32_or", magnus::function!(Helix::i32_or, 1))?;
    
    class.define_method("i64", magnus::function!(Helix::i64, 0))?;
    
    class.define_method("i64_or", magnus::function!(Helix::i64_or, 1))?;
    
    class.define_method("import_export_data", magnus::function!(Helix::import_export_data, 3))?;
    
    class.define_method("import_from_json", magnus::function!(Helix::import_from_json, 3))?;
    
    class.define_method("import_from_toml", magnus::function!(Helix::import_from_toml, 3))?;
    
    class.define_method("import_from_yaml", magnus::function!(Helix::import_from_yaml, 3))?;
    
    class.define_method("import_project", magnus::function!(Helix::import_project, 3))?;
    
    class.define_method("include", magnus::function!(Helix::include, 1))?;
    
    class.define_method("increase", magnus::function!(Helix::increase, 3))?;
    
    class.define_method("index", magnus::function!(Helix::index, 1))?;
    
    class.define_method("index_mut", magnus::function!(Helix::index_mut, 1))?;
    
    class.define_method("infer_type", magnus::function!(Helix::infer_type, 1))?;
    
    class.define_method("info", magnus::function!(Helix::info, 2))?;
    
    class.define_method("info_command", magnus::function!(Helix::info_command, 5))?;
    
    class.define_method("init", magnus::function!(Helix::init, 1))?;
    
    class.define_method("init_command", magnus::function!(Helix::init_command, 5))?;
    
    class.define_method("init_project", magnus::function!(Helix::init_project, 5))?;
    
    class.define_method("initialize", magnus::function!(Helix::initialize, 0))?;
    
    class.define_method("initialize_ruby_bindings", magnus::function!(Helix::initialize_ruby_bindings, 0))?;
    
    class.define_method("insert_selected_operator", magnus::function!(Helix::insert_selected_operator, 1))?;
    
    class.define_method("inspect_state_dict", magnus::function!(Helix::inspect_state_dict, 1))?;
    
    class.define_method("intern", magnus::function!(Helix::intern, 1))?;
    
    class.define_method("interpreter", magnus::function!(Helix::interpreter, 0))?;
    
    class.define_method("interpreter_mut", magnus::function!(Helix::interpreter_mut, 0))?;
    
    class.define_method("invalid_input", magnus::function!(Helix::invalid_input, 2))?;
    
    class.define_method("invalid_parameters", magnus::function!(Helix::invalid_parameters, 2))?;
    
    class.define_method("io_error", magnus::function!(Helix::io_error, 2))?;
    
    class.define_method("is_array", magnus::function!(Helix::is_array, 0))?;
    
    class.define_method("is_boolean", magnus::function!(Helix::is_boolean, 0))?;
    
    class.define_method("is_compatible", magnus::function!(Helix::is_compatible, 1))?;
    
    class.define_method("is_compressed", magnus::function!(Helix::is_compressed, 0))?;
    
    class.define_method("is_empty", magnus::function!(Helix::is_empty, 0))?;
    
    class.define_method("is_loaded", magnus::function!(Helix::is_loaded, 1))?;
    
    class.define_method("is_null", magnus::function!(Helix::is_null, 0))?;
    
    class.define_method("is_number", magnus::function!(Helix::is_number, 0))?;
    
    class.define_method("is_object", magnus::function!(Helix::is_object, 0))?;
    
    class.define_method("is_paused", magnus::function!(Helix::is_paused, 0))?;
    
    class.define_method("is_ready", magnus::function!(Helix::is_ready, 0))?;
    
    class.define_method("is_recoverable", magnus::function!(Helix::is_recoverable, 0))?;
    
    class.define_method("is_running", magnus::function!(Helix::is_running, 0))?;
    
    class.define_method("is_string", magnus::function!(Helix::is_string, 0))?;
    
    class.define_method("items", magnus::function!(Helix::items, 2))?;
    
    class.define_method("items_cloned", magnus::function!(Helix::items_cloned, 2))?;
    
    class.define_method("json_error", magnus::function!(Helix::json_error, 2))?;
    
    class.define_method("json_to_text", magnus::function!(Helix::json_to_text, 1))?;
    
    class.define_method("json_to_value", magnus::function!(Helix::json_to_value, 1))?;
    
    class.define_method("json_value_to_value", magnus::function!(Helix::json_value_to_value, 1))?;
    
    class.define_method("keys", magnus::function!(Helix::keys, 1))?;
    
    class.define_method("launch", magnus::function!(Helix::launch, 0))?;
    
    class.define_method("len", magnus::function!(Helix::len, 0))?;
    
    class.define_method("lint_files", magnus::function!(Helix::lint_files, 2))?;
    
    class.define_method("lint_project", magnus::function!(Helix::lint_project, 1))?;
    
    class.define_method("lint_single_file", magnus::function!(Helix::lint_single_file, 2))?;
    
    class.define_method("lint_specific_files", magnus::function!(Helix::lint_specific_files, 2))?;
    
    class.define_method("list_binaries", magnus::function!(Helix::list_binaries, 1))?;
    
    class.define_method("list_config", magnus::function!(Helix::list_config, 1))?;
    
    class.define_method("list_config_values", magnus::function!(Helix::list_config_values, 1))?;
    
    class.define_method("list_variables", magnus::function!(Helix::list_variables, 0))?;
    
    class.define_method("list_versions", magnus::function!(Helix::list_versions, 1))?;
    
    class.define_method("list_workflows", magnus::function!(Helix::list_workflows, 1))?;
    
    class.define_method("load", magnus::function!(Helix::load, 3))?;
    
    class.define_method("load_binary", magnus::function!(Helix::load_binary, 2))?;
    
    class.define_method("load_default_config", magnus::function!(Helix::load_default_config, 0))?;
    
    class.define_method("load_embeddings", magnus::function!(Helix::load_embeddings, 1))?;
    
    class.define_method("load_file", magnus::function!(Helix::load_file, 2))?;
    
    class.define_method("load_from_file", magnus::function!(Helix::load_from_file, 2))?;
    
    class.define_method("load_from_hlx", magnus::function!(Helix::load_from_hlx, 0))?;
    
    class.define_method("load_from_string", magnus::function!(Helix::load_from_string, 2))?;
    
    class.define_method("load_global_config", magnus::function!(Helix::load_global_config, 0))?;
    
    class.define_method("load_hlx", magnus::function!(Helix::load_hlx, 0))?;
    
    class.define_method("load_latest", magnus::function!(Helix::load_latest, 1))?;
    
    class.define_method("load_memory", magnus::function!(Helix::load_memory, 2))?;
    
    class.define_method("load_module", magnus::function!(Helix::load_module, 2))?;
    
    class.define_method("load_project", magnus::function!(Helix::load_project, 2))?;
    
    class.define_method("load_schema", magnus::function!(Helix::load_schema, 2))?;
    
    class.define_method("load_script", magnus::function!(Helix::load_script, 2))?;
    
    class.define_method("load_section", magnus::function!(Helix::load_section, 1))?;
    
    class.define_method("load_version", magnus::function!(Helix::load_version, 2))?;
    
    class.define_method("make", magnus::function!(Helix::make, 0))?;
    
    class.define_method("manage_cache", magnus::function!(Helix::manage_cache, 2))?;
    
    class.define_method("manage_config", magnus::function!(Helix::manage_config, 4))?;
    
    class.define_method("merge", magnus::function!(Helix::merge, 2))?;
    
    class.define_method("merge_configs", magnus::function!(Helix::merge_configs, 3))?;
    
    class.define_method("merge_modules", magnus::function!(Helix::merge_modules, 2))?;
    
    class.define_method("migrate", magnus::function!(Helix::migrate, 2))?;
    
    class.define_method("migrate_env", magnus::function!(Helix::migrate_env, 1))?;
    
    class.define_method("migrate_json", magnus::function!(Helix::migrate_json, 1))?;
    
    class.define_method("migrate_toml", magnus::function!(Helix::migrate_toml, 1))?;
    
    class.define_method("migrate_yaml", magnus::function!(Helix::migrate_yaml, 1))?;
    
    class.define_method("modules", magnus::function!(Helix::modules, 2))?;
    
    class.define_method("new_enhanced", magnus::function!(Helix::new_enhanced, 1))?;
    
    class.define_method("new_with_context", magnus::function!(Helix::new_with_context, 1))?;
    
    class.define_method("new_with_source_map", magnus::function!(Helix::new_with_source_map, 1))?;
    
    class.define_method("next_tab", magnus::function!(Helix::next_tab, 1))?;
    
    class.define_method("next_token", magnus::function!(Helix::next_token, 0))?;
    
    class.define_method("next_token_with_location", magnus::function!(Helix::next_token_with_location, 0))?;
    
    class.define_method("number", magnus::function!(Helix::number, 0))?;
    
    class.define_method("numeric_range", magnus::function!(Helix::numeric_range, 2))?;
    
    class.define_method("object", magnus::function!(Helix::object, 0))?;
    
    class.define_method("on_tick", magnus::function!(Helix::on_tick, 1))?;
    
    class.define_method("open_selected_file", magnus::function!(Helix::open_selected_file, 0))?;
    
    class.define_method("operator_engine", magnus::function!(Helix::operator_engine, 2))?;
    
    class.define_method("operator_engine_mut", magnus::function!(Helix::operator_engine_mut, 2))?;
    
    class.define_method("operator_registry", magnus::function!(Helix::operator_registry, 0))?;
    
    class.define_method("optimization_level", magnus::function!(Helix::optimization_level, 1))?;
    
    class.define_method("optimize", magnus::function!(Helix::optimize, 2))?;
    
    class.define_method("optimize_command", magnus::function!(Helix::optimize_command, 4))?;
    
    class.define_method("params_to_json", magnus::function!(Helix::params_to_json, 1))?;
    
    class.define_method("parse", magnus::function!(Helix::parse, 1))?;
    
    class.define_method("parse_and_execute", magnus::function!(Helix::parse_and_execute, 1))?;
    
    class.define_method("parse_array", magnus::function!(Helix::parse_array, 1))?;
    
    class.define_method("parse_content", magnus::function!(Helix::parse_content, 1))?;
    
    class.define_method("parse_date", magnus::function!(Helix::parse_date, 2))?;
    
    class.define_method("parse_dsl", magnus::function!(Helix::parse_dsl, 1))?;
    
    class.define_method("parse_env", magnus::function!(Helix::parse_env, 1))?;
    
    class.define_method("parse_global_var", magnus::function!(Helix::parse_global_var, 1))?;
    
    class.define_method("parse_helix", magnus::function!(Helix::parse_helix, 1))?;
    
    class.define_method("parse_helix_source", magnus::function!(Helix::parse_helix_source, 2))?;
    
    class.define_method("parse_hlx_content", magnus::function!(Helix::parse_hlx_content, 1))?;
    
    class.define_method("parse_line", magnus::function!(Helix::parse_line, 1))?;
    
    class.define_method("parse_object", magnus::function!(Helix::parse_object, 1))?;
    
    class.define_method("parse_only", magnus::function!(Helix::parse_only, 1))?;
    
    class.define_method("parse_params", magnus::function!(Helix::parse_params, 1))?;
    
    class.define_method("parse_primitive", magnus::function!(Helix::parse_primitive, 1))?;
    
    class.define_method("parse_program", magnus::function!(Helix::parse_program, 1))?;
    
    class.define_method("parse_quoted_string", magnus::function!(Helix::parse_quoted_string, 0))?;
    
    class.define_method("parse_value", magnus::function!(Helix::parse_value, 1))?;
    
    class.define_method("pattern", magnus::function!(Helix::pattern, 1))?;
    
    class.define_method("pause", magnus::function!(Helix::pause, 2))?;
    
    class.define_method("pause_workflow", magnus::function!(Helix::pause_workflow, 2))?;
    
    class.define_method("pop", magnus::function!(Helix::pop, 1))?;
    
    class.define_method("position", magnus::function!(Helix::position, 0))?;
    
    class.define_method("pretty_print", magnus::function!(Helix::pretty_print, 1))?;
    
    class.define_method("preview_command", magnus::function!(Helix::preview_command, 5))?;
    
    class.define_method("previous_tab", magnus::function!(Helix::previous_tab, 1))?;
    
    class.define_method("print", magnus::function!(Helix::print, 1))?;
    
    class.define_method("process", magnus::function!(Helix::process, 0))?;
    
    class.define_method("process_caption_file", magnus::function!(Helix::process_caption_file, 1))?;
    
    class.define_method("process_dataset", magnus::function!(Helix::process_dataset, 2))?;
    
    class.define_method("process_dataset_config", magnus::function!(Helix::process_dataset_config, 2))?;
    
    class.define_method("process_e621_json_data", magnus::function!(Helix::process_e621_json_data, 3))?;
    
    class.define_method("process_e621_json_file", magnus::function!(Helix::process_e621_json_file, 2))?;
    
    class.define_method("process_e621_tags", magnus::function!(Helix::process_e621_tags, 2))?;
    
    class.define_method("process_file", magnus::function!(Helix::process_file, 1))?;
    
    class.define_method("process_image_file", magnus::function!(Helix::process_image_file, 3))?;
    
    class.define_method("process_json_to_caption", magnus::function!(Helix::process_json_to_caption, 1))?;
    
    class.define_method("process_safetensors_file", magnus::function!(Helix::process_safetensors_file, 1))?;
    
    class.define_method("process_with_hlx", magnus::function!(Helix::process_with_hlx, 2))?;
    
    class.define_method("publish_project", magnus::function!(Helix::publish_project, 4))?;
    
    class.define_method("push", magnus::function!(Helix::push, 2))?;
    
    class.define_method("quality_assessment", magnus::function!(Helix::quality_assessment, 2))?;
    
    class.define_method("quality_validation", magnus::function!(Helix::quality_validation, 2))?;
    
    class.define_method("range", magnus::function!(Helix::range, 2))?;
    
    class.define_method("read_batches", magnus::function!(Helix::read_batches, 0))?;
    
    class.define_method("read_bool", magnus::function!(Helix::read_bool, 0))?;
    
    class.define_method("read_bytes", magnus::function!(Helix::read_bytes, 1))?;
    
    class.define_method("read_config", magnus::function!(Helix::read_config, 0))?;
    
    class.define_method("read_f32", magnus::function!(Helix::read_f32, 0))?;
    
    class.define_method("read_f64", magnus::function!(Helix::read_f64, 0))?;
    
    class.define_method("read_from_file", magnus::function!(Helix::read_from_file, 1))?;
    
    class.define_method("read_header", magnus::function!(Helix::read_header, 0))?;
    
    class.define_method("read_i32", magnus::function!(Helix::read_i32, 0))?;
    
    class.define_method("read_i64", magnus::function!(Helix::read_i64, 0))?;
    
    class.define_method("read_project_manifest", magnus::function!(Helix::read_project_manifest, 1))?;
    
    class.define_method("read_string", magnus::function!(Helix::read_string, 0))?;
    
    class.define_method("read_u32", magnus::function!(Helix::read_u32, 0))?;
    
    class.define_method("read_u64", magnus::function!(Helix::read_u64, 0))?;
    
    class.define_method("remaining", magnus::function!(Helix::remaining, 0))?;
    
    class.define_method("remove_breakpoint", magnus::function!(Helix::remove_breakpoint, 2))?;
    
    class.define_method("remove_dependencies", magnus::function!(Helix::remove_dependencies, 3))?;
    
    class.define_method("remove_dependency", magnus::function!(Helix::remove_dependency, 3))?;
    
    class.define_method("remove_file", magnus::function!(Helix::remove_file, 1))?;
    
    class.define_method("remove_filter", magnus::function!(Helix::remove_filter, 1))?;
    
    class.define_method("rename_file_without_image_extension", magnus::function!(Helix::rename_file_without_image_extension, 1))?;
    
    class.define_method("replace_special_chars", magnus::function!(Helix::replace_special_chars, 1))?;
    
    class.define_method("replace_string", magnus::function!(Helix::replace_string, 3))?;
    
    class.define_method("report", magnus::function!(Helix::report, 0))?;
    
    class.define_method("required", magnus::function!(Helix::required, 1))?;
    
    class.define_method("reset", magnus::function!(Helix::reset, 1))?;
    
    class.define_method("reset_operator_category", magnus::function!(Helix::reset_operator_category, 1))?;
    
    class.define_method("reset_project", magnus::function!(Helix::reset_project, 2))?;
    
    class.define_method("resolve", magnus::function!(Helix::resolve, 1))?;
    
    class.define_method("resolve_dependencies", magnus::function!(Helix::resolve_dependencies, 1))?;
    
    class.define_method("resume", magnus::function!(Helix::resume, 2))?;
    
    class.define_method("resume_workflow", magnus::function!(Helix::resume_workflow, 2))?;
    
    class.define_method("revert", magnus::function!(Helix::revert, 2))?;
    
    class.define_method("ruby_version", magnus::function!(Helix::ruby_version, 0))?;
    
    class.define_method("run", magnus::function!(Helix::run, 1))?;
    
    class.define_method("run_benchmarks", magnus::function!(Helix::run_benchmarks, 3))?;
    
    class.define_method("run_build", magnus::function!(Helix::run_build, 1))?;
    
    class.define_method("run_diagnostics", magnus::function!(Helix::run_diagnostics, 1))?;
    
    class.define_method("run_json_cmd", magnus::function!(Helix::run_json_cmd, 1))?;
    
    class.define_method("run_multi_process_clean", magnus::function!(Helix::run_multi_process_clean, 5))?;
    
    class.define_method("run_program", magnus::function!(Helix::run_program, 1))?;
    
    class.define_method("run_project", magnus::function!(Helix::run_project, 4))?;
    
    class.define_method("run_tests", magnus::function!(Helix::run_tests, 3))?;
    
    class.define_method("rust_result_bool_to_c", magnus::function!(Helix::rust_result_bool_to_c, 2))?;
    
    class.define_method("rust_result_f64_to_c", magnus::function!(Helix::rust_result_f64_to_c, 2))?;
    
    class.define_method("rust_result_string_to_c", magnus::function!(Helix::rust_result_string_to_c, 1))?;
    
    class.define_method("rust_result_u64_to_c", magnus::function!(Helix::rust_result_u64_to_c, 2))?;
    
    class.define_method("rust_string_to_c", magnus::function!(Helix::rust_string_to_c, 1))?;
    
    class.define_method("save", magnus::function!(Helix::save, 2))?;
    
    class.define_method("save_active_tab", magnus::function!(Helix::save_active_tab, 0))?;
    
    class.define_method("save_global_config", magnus::function!(Helix::save_global_config, 1))?;
    
    class.define_method("save_project", magnus::function!(Helix::save_project, 1))?;
    
    class.define_method("schema_command", magnus::function!(Helix::schema_command, 4))?;
    
    class.define_method("search_command", magnus::function!(Helix::search_command, 7))?;
    
    class.define_method("search_embeddings", magnus::function!(Helix::search_embeddings, 5))?;
    
    class.define_method("search_hlx_files", magnus::function!(Helix::search_hlx_files, 3))?;
    
    class.define_method("sections", magnus::function!(Helix::sections, 0))?;
    
    class.define_method("seek", magnus::function!(Helix::seek, 2))?;
    
    class.define_method("select", magnus::function!(Helix::select, 2))?;
    
    class.define_method("select_best", magnus::function!(Helix::select_best, 1))?;
    
    class.define_method("select_next_command", magnus::function!(Helix::select_next_command, 1))?;
    
    class.define_method("select_next_file", magnus::function!(Helix::select_next_file, 1))?;
    
    class.define_method("select_next_operator", magnus::function!(Helix::select_next_operator, 1))?;
    
    class.define_method("select_prev_command", magnus::function!(Helix::select_prev_command, 1))?;
    
    class.define_method("select_prev_file", magnus::function!(Helix::select_prev_file, 1))?;
    
    class.define_method("select_prev_operator", magnus::function!(Helix::select_prev_operator, 1))?;
    
    class.define_method("serialization_error", magnus::function!(Helix::serialization_error, 2))?;
    
    class.define_method("serialize", magnus::function!(Helix::serialize, 1))?;
    
    class.define_method("serialize_config", magnus::function!(Helix::serialize_config, 1))?;
    
    class.define_method("serve_binary_file", magnus::function!(Helix::serve_binary_file, 2))?;
    
    class.define_method("serve_project", magnus::function!(Helix::serve_project, 4))?;
    
    class.define_method("server", magnus::function!(Helix::server, 0))?;
    
    class.define_method("set", magnus::function!(Helix::set, 3))?;
    
    class.define_method("set_bool", magnus::function!(Helix::set_bool, 4))?;
    
    class.define_method("set_breakpoint", magnus::function!(Helix::set_breakpoint, 2))?;
    
    class.define_method("set_config", magnus::function!(Helix::set_config, 3))?;
    
    class.define_method("set_config_value", magnus::function!(Helix::set_config_value, 3))?;
    
    class.define_method("set_context", magnus::function!(Helix::set_context, 2))?;
    
    class.define_method("set_format", magnus::function!(Helix::set_format, 2))?;
    
    class.define_method("set_level", magnus::function!(Helix::set_level, 2))?;
    
    class.define_method("set_num", magnus::function!(Helix::set_num, 4))?;
    
    class.define_method("set_runtime_context", magnus::function!(Helix::set_runtime_context, 2))?;
    
    class.define_method("set_str", magnus::function!(Helix::set_str, 4))?;
    
    class.define_method("set_target", magnus::function!(Helix::set_target, 2))?;
    
    class.define_method("set_value", magnus::function!(Helix::set_value, 3))?;
    
    class.define_method("set_variable", magnus::function!(Helix::set_variable, 2))?;
    
    class.define_method("should_ignore_e621_tag", magnus::function!(Helix::should_ignore_e621_tag, 1))?;
    
    class.define_method("show_cache_info", magnus::function!(Helix::show_cache_info, 1))?;
    
    class.define_method("show_cache_size", magnus::function!(Helix::show_cache_size, 1))?;
    
    class.define_method("sign_binary", magnus::function!(Helix::sign_binary, 5))?;
    
    class.define_method("size", magnus::function!(Helix::size, 0))?;
    
    class.define_method("split_content", magnus::function!(Helix::split_content, 1))?;
    
    class.define_method("start", magnus::function!(Helix::start, 1))?;
    
    class.define_method("start_default_server", magnus::function!(Helix::start_default_server, 0))?;
    
    class.define_method("start_hot_reload", magnus::function!(Helix::start_hot_reload, 3))?;
    
    class.define_method("start_server", magnus::function!(Helix::start_server, 1))?;
    
    class.define_method("state", magnus::function!(Helix::state, 2))?;
    
    class.define_method("stats", magnus::function!(Helix::stats, 0))?;
    
    class.define_method("step", magnus::function!(Helix::step, 1))?;
    
    class.define_method("stop", magnus::function!(Helix::stop, 1))?;
    
    class.define_method("stop_hot_reload", magnus::function!(Helix::stop_hot_reload, 1))?;
    
    class.define_method("stop_workflow", magnus::function!(Helix::stop_workflow, 2))?;
    
    class.define_method("store_memory", magnus::function!(Helix::store_memory, 3))?;
    
    class.define_method("str", magnus::function!(Helix::str, 0))?;
    
    class.define_method("string", magnus::function!(Helix::string, 0))?;
    
    class.define_method("string_length", magnus::function!(Helix::string_length, 2))?;
    
    class.define_method("string_or", magnus::function!(Helix::string_or, 1))?;
    
    class.define_method("string_or_default", magnus::function!(Helix::string_or_default, 0))?;
    
    class.define_method("suggest_for_syntax_error", magnus::function!(Helix::suggest_for_syntax_error, 2))?;
    
    class.define_method("suggest_for_undefined_reference", magnus::function!(Helix::suggest_for_undefined_reference, 1))?;
    
    class.define_method("suggestions", magnus::function!(Helix::suggestions, 0))?;
    
    class.define_method("supported_features", magnus::function!(Helix::supported_features, 0))?;
    
    class.define_method("sync_operator_selection", magnus::function!(Helix::sync_operator_selection, 1))?;
    
    class.define_method("test", magnus::function!(Helix::test, 0))?;
    
    class.define_method("test_conditional_operators", magnus::function!(Helix::test_conditional_operators, 0))?;
    
    class.define_method("test_fundamental_operators", magnus::function!(Helix::test_fundamental_operators, 0))?;
    
    class.define_method("to_algorithm_format", magnus::function!(Helix::to_algorithm_format, 1))?;
    
    class.define_method("to_binary", magnus::function!(Helix::to_binary, 0))?;
    
    class.define_method("to_json", magnus::function!(Helix::to_json, 0))?;
    
    class.define_method("to_json_bytes", magnus::function!(Helix::to_json_bytes, 0))?;
    
    class.define_method("to_json_value", magnus::function!(Helix::to_json_value, 0))?;
    
    class.define_method("to_string", magnus::function!(Helix::to_string, 0))?;
    
    class.define_method("to_training_dataset", magnus::function!(Helix::to_training_dataset, 0))?;
    
    class.define_method("to_yaml", magnus::function!(Helix::to_yaml, 0))?;
    
    class.define_method("tokenize", magnus::function!(Helix::tokenize, 1))?;
    
    class.define_method("tokenize_with_locations", magnus::function!(Helix::tokenize_with_locations, 1))?;
    
    class.define_method("total_size_gb", magnus::function!(Helix::total_size_gb, 0))?;
    
    class.define_method("total_size_mb", magnus::function!(Helix::total_size_mb, 0))?;
    
    class.define_method("trigger_command", magnus::function!(Helix::trigger_command, 1))?;
    
    class.define_method("try_math", magnus::function!(Helix::try_math, 1))?;
    
    class.define_method("u32", magnus::function!(Helix::u32, 0))?;
    
    class.define_method("u64", magnus::function!(Helix::u64, 0))?;
    
    class.define_method("unknown_error", magnus::function!(Helix::unknown_error, 2))?;
    
    class.define_method("unknown_operator", magnus::function!(Helix::unknown_operator, 1))?;
    
    class.define_method("unset_config", magnus::function!(Helix::unset_config, 2))?;
}