from typing import Union, Dict, Any, Tuple
from typing_extensions import Literal, TypedDict
import pydantic

__all__ = [
    "FunctionCall_Dict",
    "NameArgsTuple",
    "Ollama_ToolCall",
    "OpenAI_ChatCompletionMessageToolCall",
    "Function",
]


class FunctionCall_Dict(TypedDict):
    name: str
    arguments: Union[str, Dict[str, Any], None]


NameArgsTuple = Tuple[str, Union[str, Dict[str, Any], None]]


class Function(pydantic.BaseModel):
    arguments: str
    """
    The arguments to call the function with, as generated by the model in JSON
    format. Note that the model does not always generate valid JSON, and may
    hallucinate parameters not defined by your function schema. Validate the
    arguments in your code before calling your function.
    """

    name: str
    """The name of the function to call."""


class OpenAI_ChatCompletionMessageToolCall(pydantic.BaseModel):
    id: str
    """The ID of the tool call."""

    function: Function
    """The function that the model called."""

    type: Literal["function"]
    """The type of the tool. Currently, only `function` is supported."""


class Ollama_ToolCall(pydantic.BaseModel):
    function: Function
    """The function that the model called."""

    type: Literal["function"]
    """The type of the tool. Currently, only `function` is supported."""
