/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.HashSet;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SizeEstimate;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;

public class QuerySizeEstimator {
    public static void computeSizeEstimate(Query query) {
        SizeEstimate sizeEstimate = query.getKB().getSizeEstimate();
        HashSet<ATermAppl> concepts = new HashSet<ATermAppl>();
        HashSet<ATermAppl> properties = new HashSet<ATermAppl>();
        for (QueryAtom atom : query.getAtoms()) {
            for (ATermAppl argument : atom.getArguments()) {
                if (ATermUtils.isVar((ATermAppl)argument)) continue;
                if ((query.getKB().isClass((ATerm)argument) || ATermUtils.isComplexClass((ATerm)argument)) && !sizeEstimate.isComputed(argument)) {
                    concepts.add(argument);
                }
                if (!query.getKB().isProperty((ATerm)argument) || sizeEstimate.isComputed(argument)) continue;
                properties.add(argument);
            }
        }
        sizeEstimate.compute(concepts, properties);
    }
}

