/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.utils.ATermUtils;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;

public class QueryAtomImpl
implements QueryAtom {
    protected final QueryPredicate _predicate;
    protected final List<ATermAppl> _arguments;
    protected boolean _ground;

    public QueryAtomImpl(QueryPredicate predicate, ATermAppl ... arguments) {
        this(predicate, Arrays.asList(arguments));
    }

    public QueryAtomImpl(QueryPredicate predicate, List<ATermAppl> arguments) {
        if (predicate == null) {
            throw new OpenError("Predicate cannot be null.");
        }
        this._predicate = predicate;
        this._arguments = arguments;
        this._ground = true;
        for (ATermAppl a : arguments) {
            if (!ATermUtils.isVar((ATermAppl)a)) continue;
            this._ground = false;
            break;
        }
    }

    @Override
    public QueryPredicate getPredicate() {
        return this._predicate;
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this._arguments;
    }

    @Override
    public boolean isGround() {
        return this._ground;
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        if (this.isGround()) {
            return this;
        }
        ArrayList<ATermAppl> newArguments = new ArrayList<ATermAppl>();
        for (ATermAppl a : this._arguments) {
            if (binding.isBound(a)) {
                newArguments.add(binding.getValue(a));
                continue;
            }
            newArguments.add(a);
        }
        return newArguments.isEmpty() ? this : new QueryAtomImpl(this._predicate, newArguments);
    }

    public int hashCode() {
        return 31 * this._predicate.hashCode() + this._arguments.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryAtomImpl other = (QueryAtomImpl)obj;
        return this._predicate.equals((Object)other._predicate) && this._arguments.equals(other._arguments);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._arguments.size(); ++i) {
            ATermAppl a = this._arguments.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ATermUtils.toString((ATermAppl)a));
        }
        return this._predicate + "(" + sb.toString() + ")";
    }
}

