/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.rdf4j.common.io.IOUtil;

public class FileUtil {
    private static final String ILLEGAL_FILE_NAME_CHARS = "\\/:*?\"<>|";

    public static String getRelativePath(File subj, File relativeTo) {
        int idx;
        String subjPath = subj.getAbsolutePath();
        String relativeToPath = relativeTo.getAbsolutePath();
        if (!subj.isDirectory() && (idx = subjPath.lastIndexOf(File.separator)) != -1) {
            subjPath = subjPath.substring(0, idx);
        }
        if (!relativeTo.isDirectory() && (idx = relativeToPath.lastIndexOf(File.separator)) != -1) {
            relativeToPath = relativeToPath.substring(0, idx);
        }
        StringTokenizer subjPathTok = new StringTokenizer(subjPath, File.separator);
        StringTokenizer relativeToPathTok = new StringTokenizer(relativeToPath, File.separator);
        String subjTok = null;
        String relativeToTok = null;
        while (subjPathTok.hasMoreTokens() && relativeToPathTok.hasMoreTokens() && (subjTok = subjPathTok.nextToken()).equals(relativeToTok = relativeToPathTok.nextToken())) {
        }
        StringBuilder relPath = new StringBuilder();
        if (relativeToTok != null && !relativeToTok.equals(subjTok)) {
            relPath.append("..");
            relPath.append(File.separator);
        }
        while (relativeToPathTok.hasMoreTokens()) {
            relativeToPathTok.nextToken();
            relPath.append("..");
            relPath.append(File.separator);
        }
        if (subjTok != null && !subjTok.equals(relativeToTok)) {
            relPath.append(subjTok);
            relPath.append(File.separator);
        }
        while (subjPathTok.hasMoreTokens()) {
            subjTok = subjPathTok.nextToken();
            relPath.append(subjTok);
            relPath.append(File.separator);
        }
        relPath.append(subj.getName());
        return relPath.toString();
    }

    public static File getRelativeFile(File subj, File relativeTo) {
        return new File(FileUtil.getRelativePath(subj, relativeTo));
    }

    public static String getFileExtension(String fileName) {
        String extension;
        int lastDotIdx = fileName.lastIndexOf(46);
        if (lastDotIdx > 0 && lastDotIdx < fileName.length() - 1 && FileUtil.isLegalFileName(extension = fileName.substring(lastDotIdx + 1).trim())) {
            return extension;
        }
        return null;
    }

    public static boolean isLegalFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (FileUtil.isLegalFileNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalFileNameChar(char c) {
        return ILLEGAL_FILE_NAME_CHARS.indexOf(c) == -1;
    }

    public static void copyFile(File source, File destination) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(source);
            IOUtil.writeStream(in, destination);
        }
    }

    public static void createDirIfNotExists(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir.toString());
        }
    }

    public static boolean deltree(File directory) {
        if (directory == null || !directory.exists()) {
            return true;
        }
        boolean result = true;
        if (directory.isFile()) {
            result = directory.delete();
        } else {
            File[] list = directory.listFiles();
            int i = list.length;
            while (i-- > 0) {
                if (FileUtil.deltree(list[i])) continue;
                result = false;
            }
            if (!directory.delete()) {
                result = false;
            }
        }
        return result;
    }

    public static boolean deleteFiles(File directory) {
        boolean result = true;
        if (directory.isDirectory()) {
            File[] list = directory.listFiles();
            int i = list.length;
            while (i-- > 0) {
                File file = list[i];
                if (!file.isFile()) continue;
                result = result && file.delete();
            }
        }
        return result;
    }

    public static boolean deleteChildren(File directory) {
        boolean result = true;
        if (directory.isDirectory()) {
            File[] list = directory.listFiles();
            int i = list.length;
            while (i-- > 0) {
                result = result && FileUtil.deltree(list[i]);
            }
        }
        return result;
    }

    public static boolean moveRecursive(File from, File to, Collection<File> excludes) {
        if (from == null || !from.exists()) {
            return false;
        }
        boolean result = true;
        if (from.isFile()) {
            if (excludes == null || !excludes.contains(from)) {
                to.getParentFile().mkdirs();
                result = from.renameTo(to);
            }
        } else {
            boolean excludedFileFound = false;
            File[] list = from.listFiles();
            int i = list.length;
            while (i-- > 0) {
                File listItem = list[i];
                if (excludes != null && excludes.contains(listItem)) {
                    excludedFileFound = true;
                    continue;
                }
                if (FileUtil.moveRecursive(listItem, new File(to, listItem.getName()), excludes)) continue;
                result = false;
            }
            if (!excludedFileFound && !from.delete()) {
                result = false;
            }
        }
        return result;
    }

    public static File createTempDir(String prefix) throws IOException {
        boolean created;
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr == null) {
            throw new IOException("System property 'java.io.tmpdir' does not specify a tmp dir");
        }
        File tmpDir = new File(tmpDirStr);
        if (!tmpDir.exists() && !(created = tmpDir.mkdirs())) {
            throw new IOException("Unable to create tmp dir " + tmpDir);
        }
        File resultDir = null;
        int suffix = (int)System.currentTimeMillis();
        int failureCount = 0;
        do {
            resultDir = new File(tmpDir, prefix + suffix % 10000);
            ++suffix;
        } while (resultDir.exists() && ++failureCount < 50);
        if (resultDir.exists()) {
            throw new IOException(failureCount + " attempts to generate a non-existent directory name failed, giving up");
        }
        return Files.createDirectory(resultDir.toPath(), new FileAttribute[0]).toFile();
    }

    public static void deleteDir(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("Not a directory " + dir);
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.deleteDir(file);
                continue;
            }
            boolean deleted = file.delete();
            if (deleted) continue;
            throw new IOException("Unable to delete file" + file);
        }
        dir.delete();
    }
}

