/*
 * Decompiled with CFR 0.152.
 */
package openllet.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.progress.ConsoleProgressMonitor;
import openllet.core.utils.progress.ProgressMonitor;
import openllet.core.utils.progress.SilentProgressMonitor;
import openllet.shared.tools.Log;

public class OpenlletOptions {
    public static final Logger _logger = Log.getLogger(OpenlletOptions.class);
    public static boolean SATURATE_TABLEAU = false;
    public static boolean USE_UNIQUE_NAME_ASSUMPTION = false;
    public static boolean TRACK_BRANCH_EFFECTS = false;
    public static boolean TREAT_ALL_VARS_DISTINGUISHED = true;
    public static boolean USE_DISJUNCT_SORTING = !SATURATE_TABLEAU;
    public static MonitorType USE_CLASSIFICATION_MONITOR = MonitorType.CONSOLE;
    public static final String NO_SORTING = "NO";
    public static final String OLDEST_FIRST = "OLDEST_FIRST";
    public static String USE_DISJUNCTION_SORTING = "OLDEST_FIRST";
    public static boolean USE_ABSORPTION = true;
    public static UndefinedDatatypeHandling UNDEFINED_DATATYPE_HANDLING = UndefinedDatatypeHandling.INFINITE_STRING;
    public static boolean USE_ROLE_ABSORPTION = true;
    public static boolean USE_NOMINAL_ABSORPTION = true;
    public static boolean USE_HASVALUE_ABSORPTION = true;
    public static boolean USE_RULE_ABSORPTION = false;
    public static boolean USE_BINARY_ABSORPTION = true;
    public static boolean USE_BACKJUMPING = !SATURATE_TABLEAU & true;
    public static boolean USE_FULL_DATATYPE_REASONING = true;
    public static boolean USE_CACHING = true;
    public static boolean USE_ADVANCED_CACHING = true;
    public static boolean USE_INVERSE_CACHING = true;
    public static boolean USE_ANYWHERE_BLOCKING = true;
    public static int MAX_ANONYMOUS_CACHE = 20000;
    public static boolean CHECK_NOMINAL_EDGES = true;
    public static boolean USE_PSEUDO_NOMINALS = false;
    public static boolean IGNORE_INVERSES = false;
    public static boolean USE_COMPLETION_STRATEGY = !SATURATE_TABLEAU & true;
    public static boolean USE_CONTINUOUS_RULES = true;
    public static boolean ALWAYS_REBUILD_RETE = false;
    public static boolean USE_SEMANTIC_BRANCHING = !SATURATE_TABLEAU & true;
    public static boolean COPY_ON_WRITE = true;
    public static boolean SILENT_UNDEFINED_ENTITY_HANDLING = true;
    public static boolean REALIZE_INDIVIDUAL_AT_A_TIME = false;
    public static boolean AUTO_REALIZE = true;
    public static boolean VALIDATE_ABOX = false;
    public static boolean PRINT_ABOX = false;
    public static final boolean DEPTH_FIRST = true;
    public static boolean KEEP_ABOX_ASSERTIONS = false;
    public static boolean SEARCH_TYPE = true;
    public static InstanceRetrievalMethod INSTANCE_RETRIEVAL = InstanceRetrievalMethod.BINARY;
    public static boolean INVALID_LITERAL_AS_INCONSISTENCY = true;
    public static boolean OPTIMIZE_DOWN_MONOTONIC = false;
    public static boolean SIMPLIFY_QUERY = true;
    public static double SAMPLING_RATIO = 0.2;
    public static int STATIC_REORDERING_LIMIT = 8;
    public static boolean FULL_SIZE_ESTIMATE = false;
    public static boolean CACHE_RETRIEVAL = false;
    public static boolean USE_TRACING = false;
    public static String DEFAULT_CONFIGURATION_FILE = "openllet.properties";
    public static boolean FREEZE_BUILTIN_NAMESPACES = true;
    public static boolean IGNORE_DEPRECATED_TERMS = true;
    public static boolean IGNORE_UNSUPPORTED_AXIOMS = true;
    public static boolean DL_SAFE_RULES = true;
    @Deprecated
    public static boolean RETURN_DEDUCTIONS_GRAPH = false;
    public static boolean RETURN_NON_PRIMITIVE_EQUIVALENT_PROPERTIES = true;
    public static boolean USE_COMPLETION_QUEUE = false;
    public static boolean USE_OPTIMIZED_BASIC_COMPLETION_QUEUE;
    public static boolean USE_SMART_RESTORE;
    public static boolean USE_INCREMENTAL_CONSISTENCY;
    public static boolean USE_INCREMENTAL_DELETION;
    public static boolean MAINTAIN_COMPLETION_QUEUE;
    public static boolean USE_CD_CLASSIFICATION;
    @Deprecated
    public static boolean USE_NAIVE_QUERY_ENGINE;
    public static boolean USE_ANNOTATION_SUPPORT;
    public static boolean HIDE_TOP_PROPERTY_VALUES;
    public static boolean USE_LEGACY_TBOX;
    public static OrderedClassification ORDERED_CLASSIFICATION;
    public static boolean DISABLE_EL_CLASSIFIER;
    public static boolean PROCESS_JENA_UPDATES_INCREMENTALLY;
    public static boolean IGNORE_ANNOTATION_CLASSES;
    public static boolean USE_THREADED_KERNEL;

    public static Properties setOptions(Properties newOptions) {
        Properties oldOptions = new Properties();
        ALWAYS_REBUILD_RETE = OpenlletOptions.getBooleanProperty(newOptions, "ALWAYS_REBUILD_RETE", ALWAYS_REBUILD_RETE, oldOptions);
        CACHE_RETRIEVAL = OpenlletOptions.getBooleanProperty(newOptions, "CACHE_RETRIEVAL", CACHE_RETRIEVAL, oldOptions);
        DL_SAFE_RULES = OpenlletOptions.getBooleanProperty(newOptions, "DL_SAFE_RULES", DL_SAFE_RULES, oldOptions);
        FREEZE_BUILTIN_NAMESPACES = OpenlletOptions.getBooleanProperty(newOptions, "FREEZE_BUILTIN_NAMESPACES", FREEZE_BUILTIN_NAMESPACES, oldOptions);
        FULL_SIZE_ESTIMATE = OpenlletOptions.getBooleanProperty(newOptions, "FULL_SIZE_ESTIMATE", FULL_SIZE_ESTIMATE, oldOptions);
        IGNORE_DEPRECATED_TERMS = OpenlletOptions.getBooleanProperty(newOptions, "IGNORE_DEPRECATED_TERMS", IGNORE_DEPRECATED_TERMS, oldOptions);
        IGNORE_INVERSES = OpenlletOptions.getBooleanProperty(newOptions, "IGNORE_INVERSES", IGNORE_INVERSES, oldOptions);
        IGNORE_UNSUPPORTED_AXIOMS = OpenlletOptions.getBooleanProperty(newOptions, "IGNORE_UNSUPPORTED_AXIOMS", IGNORE_UNSUPPORTED_AXIOMS, oldOptions);
        MAINTAIN_COMPLETION_QUEUE = OpenlletOptions.getBooleanProperty(newOptions, "MAINTAIN_COMPLETION_QUEUE", MAINTAIN_COMPLETION_QUEUE, oldOptions);
        MAX_ANONYMOUS_CACHE = OpenlletOptions.getIntProperty(newOptions, "MAX_ANONYMOUS_CACHE", MAX_ANONYMOUS_CACHE, oldOptions);
        OPTIMIZE_DOWN_MONOTONIC = OpenlletOptions.getBooleanProperty(newOptions, "OPTIMIZE_DOWN_MONOTONIC", OPTIMIZE_DOWN_MONOTONIC, oldOptions);
        REALIZE_INDIVIDUAL_AT_A_TIME = OpenlletOptions.getBooleanProperty(newOptions, "REALIZE_INDIVIDUAL_AT_A_TIME", REALIZE_INDIVIDUAL_AT_A_TIME, oldOptions);
        AUTO_REALIZE = OpenlletOptions.getBooleanProperty(newOptions, "AUTO_REALIZE", AUTO_REALIZE, oldOptions);
        RETURN_DEDUCTIONS_GRAPH = OpenlletOptions.getBooleanProperty(newOptions, "RETURN_DEDUCTIONS_GRAPH", RETURN_DEDUCTIONS_GRAPH, oldOptions);
        SAMPLING_RATIO = OpenlletOptions.getDoubleProperty(newOptions, "SAMPLING_RATIO", SAMPLING_RATIO, oldOptions);
        SILENT_UNDEFINED_ENTITY_HANDLING = OpenlletOptions.getBooleanProperty(newOptions, "SILENT_UNDEFINED_ENTITY_HANDLING", SILENT_UNDEFINED_ENTITY_HANDLING, oldOptions);
        SIMPLIFY_QUERY = OpenlletOptions.getBooleanProperty(newOptions, "SIMPLIFY_QUERY", SIMPLIFY_QUERY, oldOptions);
        STATIC_REORDERING_LIMIT = OpenlletOptions.getIntProperty(newOptions, "STATIC_REORDERING_LIMIT", STATIC_REORDERING_LIMIT, oldOptions);
        TRACK_BRANCH_EFFECTS = OpenlletOptions.getBooleanProperty(newOptions, "TRACK_BRANCH_EFFECTS", TRACK_BRANCH_EFFECTS, oldOptions);
        TREAT_ALL_VARS_DISTINGUISHED = OpenlletOptions.getBooleanProperty(newOptions, "TREAT_ALL_VARS_DISTINGUISHED", TREAT_ALL_VARS_DISTINGUISHED, oldOptions);
        USE_ABSORPTION = OpenlletOptions.getBooleanProperty(newOptions, "USE_ABSORPTION", USE_ABSORPTION, oldOptions);
        USE_NOMINAL_ABSORPTION = OpenlletOptions.getBooleanProperty(newOptions, "USE_NOMINAL_ABSORPTION", USE_NOMINAL_ABSORPTION, oldOptions);
        USE_HASVALUE_ABSORPTION = OpenlletOptions.getBooleanProperty(newOptions, "USE_HASVALUE_ABSORPTION", USE_HASVALUE_ABSORPTION, oldOptions);
        USE_ROLE_ABSORPTION = OpenlletOptions.getBooleanProperty(newOptions, "USE_ROLE_ABSORPTION", USE_ROLE_ABSORPTION, oldOptions);
        USE_RULE_ABSORPTION = OpenlletOptions.getBooleanProperty(newOptions, "USE_RULE_ABSORPTION", USE_RULE_ABSORPTION, oldOptions);
        USE_ADVANCED_CACHING = OpenlletOptions.getBooleanProperty(newOptions, "USE_ADVANCED_CACHING", USE_ADVANCED_CACHING, oldOptions);
        USE_ANNOTATION_SUPPORT = OpenlletOptions.getBooleanProperty(newOptions, "USE_ANNOTATION_SUPPORT", USE_ANNOTATION_SUPPORT, oldOptions);
        USE_BACKJUMPING = OpenlletOptions.getBooleanProperty(newOptions, "USE_BACKJUMPING", USE_BACKJUMPING, oldOptions);
        USE_CACHING = OpenlletOptions.getBooleanProperty(newOptions, "USE_CACHING", USE_CACHING, oldOptions);
        USE_CD_CLASSIFICATION = OpenlletOptions.getBooleanProperty(newOptions, "USE_CD_CLASSIFICATION", USE_CD_CLASSIFICATION, oldOptions);
        USE_CLASSIFICATION_MONITOR = OpenlletOptions.getEnumProperty(newOptions, "USE_CLASSIFICATION_MONITOR", USE_CLASSIFICATION_MONITOR, oldOptions);
        RETURN_NON_PRIMITIVE_EQUIVALENT_PROPERTIES = OpenlletOptions.getBooleanProperty(newOptions, "RETURN_NON_PRIMITIVE_EQUIVALENT_PROPERTIES", RETURN_NON_PRIMITIVE_EQUIVALENT_PROPERTIES, oldOptions);
        USE_COMPLETION_QUEUE = OpenlletOptions.getBooleanProperty(newOptions, "USE_COMPLETION_QUEUE", USE_COMPLETION_QUEUE, oldOptions);
        USE_CONTINUOUS_RULES = OpenlletOptions.getBooleanProperty(newOptions, "USE_CONTINUOUS_RULES", USE_CONTINUOUS_RULES, oldOptions);
        USE_FULL_DATATYPE_REASONING = OpenlletOptions.getBooleanProperty(newOptions, "USE_FULL_DATATYPE_REASONING", USE_FULL_DATATYPE_REASONING, oldOptions);
        USE_INCREMENTAL_CONSISTENCY = OpenlletOptions.getBooleanProperty(newOptions, "USE_INCREMENTAL_CONSISTENCY", USE_INCREMENTAL_CONSISTENCY, oldOptions);
        USE_INCREMENTAL_DELETION = OpenlletOptions.getBooleanProperty(newOptions, "USE_INCREMENTAL_DELETION", USE_INCREMENTAL_DELETION, oldOptions);
        USE_NAIVE_QUERY_ENGINE = OpenlletOptions.getBooleanProperty(newOptions, "USE_NAIVE_QUERY_ENGINE", USE_NAIVE_QUERY_ENGINE, oldOptions);
        USE_PSEUDO_NOMINALS = OpenlletOptions.getBooleanProperty(newOptions, "USE_PSEUDO_NOMINALS", USE_PSEUDO_NOMINALS, oldOptions);
        USE_SEMANTIC_BRANCHING = OpenlletOptions.getBooleanProperty(newOptions, "USE_SEMANTIC_BRANCHING", USE_SEMANTIC_BRANCHING, oldOptions);
        USE_SMART_RESTORE = OpenlletOptions.getBooleanProperty(newOptions, "USE_SMART_RESTORE", USE_SMART_RESTORE, oldOptions);
        USE_TRACING = OpenlletOptions.getBooleanProperty(newOptions, "USE_TRACING", USE_TRACING, oldOptions);
        USE_UNIQUE_NAME_ASSUMPTION = OpenlletOptions.getBooleanProperty(newOptions, "USE_UNIQUE_NAME_ASSUMPTION", USE_UNIQUE_NAME_ASSUMPTION, oldOptions);
        HIDE_TOP_PROPERTY_VALUES = OpenlletOptions.getBooleanProperty(newOptions, "HIDE_TOP_PROPERTY_VALUES", HIDE_TOP_PROPERTY_VALUES, oldOptions);
        ORDERED_CLASSIFICATION = OpenlletOptions.getEnumProperty(newOptions, "ORDERED_CLASSIFICATION", ORDERED_CLASSIFICATION, oldOptions);
        DISABLE_EL_CLASSIFIER = OpenlletOptions.getBooleanProperty(newOptions, "DISABLE_EL_CLASSIFIER", DISABLE_EL_CLASSIFIER, oldOptions);
        PROCESS_JENA_UPDATES_INCREMENTALLY = OpenlletOptions.getBooleanProperty(newOptions, "PROCESS_JENA_UPDATES_INCREMENTALLY", PROCESS_JENA_UPDATES_INCREMENTALLY, oldOptions);
        IGNORE_ANNOTATION_CLASSES = OpenlletOptions.getBooleanProperty(newOptions, "IGNORE_ANNOTATION_CLASSES", IGNORE_ANNOTATION_CLASSES, oldOptions);
        return oldOptions;
    }

    public static void load(URL configFile) throws FileNotFoundException, IOException {
        _logger.fine("Reading Pellet configuration file " + configFile);
        Properties properties = new Properties();
        properties.load(configFile.openStream());
        OpenlletOptions.setOptions(properties);
    }

    private static boolean getBooleanProperty(Properties properties, String property, boolean defaultValue, Properties defaultValues) {
        if (null == properties) {
            return defaultValue;
        }
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        boolean returnValue = defaultValue;
        if (value != null) {
            if ("true".equalsIgnoreCase(value = value.trim())) {
                returnValue = true;
            } else if ("false".equalsIgnoreCase(value)) {
                returnValue = false;
            } else {
                _logger.severe("Ignoring invalid value (" + value + ") for the configuration option " + property);
            }
        }
        properties.setProperty(property, String.valueOf(returnValue));
        return returnValue;
    }

    private static double getDoubleProperty(Properties properties, String property, double defaultValue, Properties defaultValues) {
        if (null == properties) {
            return defaultValue;
        }
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        double doubleValue = defaultValue;
        if (value != null) {
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                Log.error((Logger)_logger, (String)("Ignoring invalid double value (" + value + ") for the configuration option " + property), (Throwable)e);
            }
        }
        properties.setProperty(property, String.valueOf(doubleValue));
        return doubleValue;
    }

    private static int getIntProperty(Properties properties, String property, int defaultValue, Properties defaultValues) {
        if (null == properties) {
            return defaultValue;
        }
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        int intValue = defaultValue;
        if (value != null) {
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.error((Logger)_logger, (String)("Ignoring invalid int value (" + value + ") for the configuration option " + property), (Throwable)e);
            }
        }
        properties.setProperty(property, String.valueOf(intValue));
        return intValue;
    }

    private static <T extends Enum<T>> T getEnumProperty(Properties properties, String property, T defaultValue, Properties defaultValues) {
        if (null == properties) {
            return defaultValue;
        }
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        T returnValue = defaultValue;
        if (value != null) {
            value = value.trim().toUpperCase();
            try {
                returnValue = Enum.valueOf(defaultValue.getDeclaringClass(), value);
            }
            catch (IllegalArgumentException e) {
                Log.error((Logger)_logger, (String)("Ignoring invalid value (" + value + ") for the configuration option " + property), (Throwable)e);
            }
        }
        properties.setProperty(property, String.valueOf(returnValue));
        return returnValue;
    }

    static {
        if (USE_COMPLETION_QUEUE) {
            // empty if block
        }
        USE_OPTIMIZED_BASIC_COMPLETION_QUEUE = false;
        USE_SMART_RESTORE = true;
        if (USE_COMPLETION_QUEUE) {
            // empty if block
        }
        if (!(USE_INCREMENTAL_CONSISTENCY = false) || USE_TRACING) {
            // empty if block
        }
        USE_INCREMENTAL_DELETION = false;
        if (!USE_TRACING || USE_COMPLETION_QUEUE) {
            // empty if block
        }
        MAINTAIN_COMPLETION_QUEUE = false;
        USE_CD_CLASSIFICATION = true;
        USE_NAIVE_QUERY_ENGINE = false;
        USE_ANNOTATION_SUPPORT = false;
        HIDE_TOP_PROPERTY_VALUES = true;
        USE_LEGACY_TBOX = true;
        ORDERED_CLASSIFICATION = OrderedClassification.ENABLED;
        DISABLE_EL_CLASSIFIER = false;
        PROCESS_JENA_UPDATES_INCREMENTALLY = true;
        IGNORE_ANNOTATION_CLASSES = true;
        USE_THREADED_KERNEL = false;
        String configFile = System.getProperty("openllet.configuration");
        URL url = null;
        if (configFile == null) {
            url = OpenlletOptions.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_FILE);
        } else {
            try {
                url = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                url = OpenlletOptions.class.getClassLoader().getResource(configFile);
            }
            if (url == null) {
                _logger.severe("Cannot file Openllet configuration file " + configFile);
            }
        }
        if (url != null) {
            try {
                OpenlletOptions.load(url);
            }
            catch (FileNotFoundException e) {
                Log.error((Logger)_logger, (String)"Openllet configuration file cannot be found", (Throwable)e);
            }
            catch (IOException e) {
                Log.error((Logger)_logger, (String)"I/O error while reading Openllet configuration file", (Throwable)e);
            }
        }
    }

    public static enum OrderedClassification {
        DISABLED,
        ENABLED,
        ENABLED_LEGACY_ORDERING;

    }

    public static enum UndefinedDatatypeHandling {
        EMPTY,
        EXCEPTION,
        INFINITE_STRING;

    }

    public static enum InstanceRetrievalMethod {
        BINARY,
        TRACING_BASED;

    }

    public static enum MonitorType implements EnumFactory<ProgressMonitor>
    {
        CONSOLE(ConsoleProgressMonitor.class),
        NONE(SilentProgressMonitor.class);

        private final Class<? extends ProgressMonitor> _c;

        private MonitorType(Class<? extends ProgressMonitor> c) {
            this._c = c;
        }

        @Override
        public ProgressMonitor create() {
            try {
                return this._c.newInstance();
            }
            catch (InstantiationException e) {
                throw new InternalReasonerException(e);
            }
            catch (IllegalAccessException e) {
                throw new InternalReasonerException(e);
            }
        }
    }

    private static interface EnumFactory<T> {
        public T create();
    }
}

