/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;

public class DefaultEdge
implements Edge {
    private final Individual _from;
    private final Node _to;
    private final Role _role;
    private volatile DependencySet _depends;

    public DefaultEdge(Role name, Individual from, Node to, DependencySet d) {
        this._role = name;
        this._from = from;
        this._to = to;
        this._depends = d;
    }

    @Override
    public Node getNeighbor(Node node) {
        if (this._from.equals(node)) {
            return this._to;
        }
        if (this._to.equals(node)) {
            return this._from;
        }
        return null;
    }

    public String toString() {
        return "[" + this._from + ", " + this._role + ", " + this._to + "] - " + this._depends;
    }

    @Override
    public DependencySet getDepends() {
        return this._depends;
    }

    @Override
    public Individual getFrom() {
        return this._from;
    }

    @Override
    public Role getRole() {
        return this._role;
    }

    @Override
    public Node getTo() {
        return this._to;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultEdge)) {
            return false;
        }
        DefaultEdge that = (DefaultEdge)other;
        return this._from.equals(that._from) && this._role.equals(that._role) && this._to.equals(that._to);
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 31 * hashCode + this._role.hashCode();
        hashCode = 31 * hashCode + this._from.hashCode();
        hashCode = 31 * hashCode + this._to.hashCode();
        return hashCode;
    }

    @Override
    public ATermAppl getFromName() {
        return this.getFrom().getName();
    }

    @Override
    public ATermAppl getToName() {
        return this.getTo().getName();
    }

    @Override
    public void setDepends(DependencySet ds) {
        this._depends = ds;
    }
}

