/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.ATermUtils;

public class EdgeList
extends ArrayList<Edge> {
    private static final long serialVersionUID = -4849551813090525636L;

    public EdgeList() {
    }

    public EdgeList(int n) {
        super(n);
    }

    public EdgeList(EdgeList edges) {
        this(edges.size());
        this.addEdgeList(edges);
    }

    @Deprecated
    public void addEdgeList(EdgeList edges) {
        super.addAll(edges);
    }

    @Deprecated
    public void addEdge(Edge e) {
        super.add(e);
    }

    public boolean removeEdge(Edge edge) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!((Edge)this.get(i)).equals(edge)) continue;
            this.removeEdge(i);
            return true;
        }
        return false;
    }

    protected void removeEdge(int index) {
        int l = this.size() - 1;
        if (index == l) {
            this.remove(l);
        } else {
            this.set(index, (Edge)this.remove(l));
        }
    }

    public Edge edgeAt(int i) {
        return (Edge)this.get(i);
    }

    public EdgeList sort() {
        EdgeList sorted = new EdgeList(this);
        this.sort((e1, e2) -> e1.getDepends().max() - e2.getDepends().max());
        return sorted;
    }

    private EdgeList findEdges(Role role, Individual from, Node to) {
        EdgeList result = new EdgeList();
        for (Edge e : this) {
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            result.addEdge(e);
        }
        return result;
    }

    public EdgeList getEdgesTo(Node to) {
        return this.findEdges(null, null, to);
    }

    public EdgeList getEdgesTo(Role r, Node to) {
        return this.findEdges(r, null, to);
    }

    public EdgeList getEdgesFrom(Individual from, Role r) {
        return this.findEdges(r, from, null);
    }

    public EdgeList getEdges(Role role) {
        EdgeList result = new EdgeList();
        for (Edge e : this) {
            if (!e.getRole().isSubRoleOf(role)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public Set<Role> getRoles() {
        HashSet<Role> result = new HashSet<Role>();
        for (Edge e : this) {
            result.add(e.getRole());
        }
        return result;
    }

    public Set<Node> getNeighbors(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        for (Edge e : this) {
            result.add(e.getNeighbor(node));
        }
        return result;
    }

    public Set<Node> getFilteredNeighbors(Individual node, ATermAppl c) {
        HashSet<Node> result = new HashSet<Node>();
        String lang = null;
        for (Edge edge : this) {
            Node neighbor = edge.getNeighbor(node);
            if (!ATermUtils.isTop(c) && !neighbor.hasType((ATerm)c)) continue;
            if (neighbor instanceof Literal) {
                Literal lit = (Literal)neighbor;
                if (lang == null) {
                    lang = lit.getLang();
                    result.add(neighbor);
                    continue;
                }
                if (!lang.equals(lit.getLang())) continue;
                result.add(neighbor);
                continue;
            }
            result.add(neighbor);
        }
        return result;
    }

    public boolean hasEdgeFrom(Individual from) {
        return this.hasEdge(from, null, null);
    }

    public boolean hasEdgeTo(Node to) {
        return this.hasEdge(null, null, to);
    }

    public boolean hasEdge(Role role) {
        return this.hasEdge(null, role, null);
    }

    public boolean hasEdge(Individual from, Role role, Node to) {
        for (Edge e : this) {
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactEdge(Individual from, Role role, Node to) {
        for (Edge e : this) {
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().equals(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(Edge e) {
        return this.hasEdge(e.getFrom(), e.getRole(), e.getTo());
    }

    public Edge getExactEdge(Individual from, Role role, Node to) {
        for (Edge e : this) {
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().equals(role) || to != null && !to.equals(e.getTo())) continue;
            return e;
        }
        return null;
    }

    public DependencySet getDepends(boolean doExplanation) {
        DependencySet ds = DependencySet.INDEPENDENT;
        for (Edge e : this) {
            ds = ds.union(e.getDepends(), doExplanation);
        }
        return ds;
    }

    public void reset() {
        for (int i = 0; i < this.size(); ++i) {
            Edge e = (Edge)this.get(i);
            if (e.getDepends().getBranch() == -1) continue;
            this.removeEdge(i--);
        }
    }
}

