/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import openllet.aterm.AFun;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;

public class TermDefinition {
    private final List<ATermAppl> _subClassAxioms = new ArrayList<ATermAppl>();
    private final List<ATermAppl> _eqClassAxioms = new ArrayList<ATermAppl>();
    private Set<ATermAppl> _dependencies;

    public TermDefinition() {
        this.updateDependencies();
    }

    public Set<ATermAppl> getDependencies() {
        if (this._dependencies == null) {
            this.updateDependencies();
        }
        return this._dependencies;
    }

    public void clearDependencies() {
        this._dependencies = null;
    }

    public ATermAppl getName() {
        if (!this._subClassAxioms.isEmpty()) {
            return (ATermAppl)this._subClassAxioms.get(0).getArgument(0);
        }
        if (!this._eqClassAxioms.isEmpty()) {
            return (ATermAppl)this._eqClassAxioms.get(0).getArgument(0);
        }
        return null;
    }

    public boolean addDef(ATermAppl appl) {
        boolean added = false;
        AFun fun = appl.getAFun();
        if (fun.equals(ATermUtils.SUBFUN)) {
            added = this._subClassAxioms.contains(appl) ? false : this._subClassAxioms.add(appl);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            added = this._eqClassAxioms.contains(appl) ? false : this._eqClassAxioms.add(appl);
        } else {
            throw new OpenError("Cannot add non-definition!");
        }
        if (added) {
            this.updateDependencies();
        }
        return added;
    }

    public boolean removeDef(ATermAppl axiom) {
        boolean removed;
        AFun fun = axiom.getAFun();
        if (fun.equals(ATermUtils.SUBFUN)) {
            removed = this._subClassAxioms.remove(axiom);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            removed = this._eqClassAxioms.remove(axiom);
        } else {
            throw new OpenError("Cannot remove non-definition!");
        }
        this.updateDependencies();
        return removed;
    }

    public boolean isPrimitive() {
        return this._eqClassAxioms.isEmpty();
    }

    public boolean isUnique() {
        return this._eqClassAxioms.isEmpty() || this._subClassAxioms.isEmpty() && this._eqClassAxioms.size() == 1;
    }

    public boolean isUnique(ATermAppl axiom) {
        return this._eqClassAxioms.isEmpty() && (this._subClassAxioms.isEmpty() || axiom.getAFun().equals(ATermUtils.SUBFUN));
    }

    public List<ATermAppl> getSubClassAxioms() {
        return this._subClassAxioms;
    }

    public List<ATermAppl> getEqClassAxioms() {
        return this._eqClassAxioms;
    }

    public String toString() {
        return this._subClassAxioms + "; " + this._eqClassAxioms;
    }

    protected void updateDependencies() {
        this._dependencies = CollectionUtils.makeIdentitySet();
        for (ATermAppl sub : this.getSubClassAxioms()) {
            ATermUtils.findPrimitives((ATermAppl)sub.getArgument(1), this._dependencies);
        }
        for (ATermAppl eq : this.getEqClassAxioms()) {
            ATermUtils.findPrimitives((ATermAppl)eq.getArgument(1), this._dependencies);
        }
    }
}

