/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Literal;
import openllet.core.datatypes.DNF;
import openllet.core.datatypes.DataRange;
import openllet.core.datatypes.DataValueEnumeration;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.DatatypeReasoner;
import openllet.core.datatypes.EmptyDataRange;
import openllet.core.datatypes.InfiniteNamedDatatype;
import openllet.core.datatypes.NamedDataRangeExpander;
import openllet.core.datatypes.NamedDatatype;
import openllet.core.datatypes.NegatedDataRange;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.UnionDataRange;
import openllet.core.datatypes.exceptions.InvalidConstrainingFacetException;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.datatypes.types.bool.XSDBoolean;
import openllet.core.datatypes.types.datetime.XSDDate;
import openllet.core.datatypes.types.datetime.XSDDateTime;
import openllet.core.datatypes.types.datetime.XSDDateTimeStamp;
import openllet.core.datatypes.types.datetime.XSDGDay;
import openllet.core.datatypes.types.datetime.XSDGMonth;
import openllet.core.datatypes.types.datetime.XSDGMonthDay;
import openllet.core.datatypes.types.datetime.XSDGYear;
import openllet.core.datatypes.types.datetime.XSDGYearMonth;
import openllet.core.datatypes.types.datetime.XSDTime;
import openllet.core.datatypes.types.duration.XSDDuration;
import openllet.core.datatypes.types.floating.XSDDouble;
import openllet.core.datatypes.types.floating.XSDFloat;
import openllet.core.datatypes.types.real.OWLRational;
import openllet.core.datatypes.types.real.OWLReal;
import openllet.core.datatypes.types.real.XSDByte;
import openllet.core.datatypes.types.real.XSDDecimal;
import openllet.core.datatypes.types.real.XSDInt;
import openllet.core.datatypes.types.real.XSDInteger;
import openllet.core.datatypes.types.real.XSDLong;
import openllet.core.datatypes.types.real.XSDNegativeInteger;
import openllet.core.datatypes.types.real.XSDNonNegativeInteger;
import openllet.core.datatypes.types.real.XSDNonPositiveInteger;
import openllet.core.datatypes.types.real.XSDPositiveInteger;
import openllet.core.datatypes.types.real.XSDShort;
import openllet.core.datatypes.types.real.XSDUnsignedByte;
import openllet.core.datatypes.types.real.XSDUnsignedInt;
import openllet.core.datatypes.types.real.XSDUnsignedLong;
import openllet.core.datatypes.types.real.XSDUnsignedShort;
import openllet.core.datatypes.types.text.RDFPlainLiteral;
import openllet.core.datatypes.types.text.XSDLanguage;
import openllet.core.datatypes.types.text.XSDNCName;
import openllet.core.datatypes.types.text.XSDNMToken;
import openllet.core.datatypes.types.text.XSDName;
import openllet.core.datatypes.types.text.XSDNormalizedString;
import openllet.core.datatypes.types.text.XSDString;
import openllet.core.datatypes.types.text.XSDToken;
import openllet.core.datatypes.types.uri.XSDAnyURI;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class DatatypeReasonerImpl
implements DatatypeReasoner {
    private static final Logger _logger = Log.getLogger(DatatypeReasonerImpl.class);
    private static final Map<ATermAppl, Datatype<?>> _coreDatatypes = new HashMap();
    private static final DataRange<?> EMPTY_RANGE;
    private static final DataRange<?> TRIVIALLY_SATISFIABLE;
    private final Set<ATermAppl> declaredUndefined = new HashSet<ATermAppl>();
    private final NamedDataRangeExpander expander = new NamedDataRangeExpander();
    private final Map<ATermAppl, ATermAppl> namedDataRanges = new HashMap<ATermAppl, ATermAppl>();

    private static <T> DataValueEnumeration<? extends T> findSmallestEnumeration(Collection<DataValueEnumeration<? extends T>> ranges) {
        DataValueEnumeration<T> ret = null;
        int best = Integer.MAX_VALUE;
        for (DataValueEnumeration<T> r : ranges) {
            DataValueEnumeration<T> e = r;
            int s = e.size();
            if (s >= best) continue;
            ret = e;
            best = s;
        }
        return ret;
    }

    private static final ATermAppl getDatatypeName(ATermAppl literal) {
        if (!ATermUtils.isLiteral(literal)) {
            String msg = "Method _expected an ATermAppl literal as an argument";
            _logger.severe("Method _expected an ATermAppl literal as an argument");
            throw new IllegalArgumentException("Method _expected an ATermAppl literal as an argument");
        }
        ATermAppl dtName = (ATermAppl)literal.getArgument(2);
        if (ATermUtils.EMPTY.equals(dtName)) {
            String msg = "Untyped literals not supported by this datatype reasoner";
            _logger.severe("Untyped literals not supported by this datatype reasoner");
            throw new IllegalArgumentException("Untyped literals not supported by this datatype reasoner");
        }
        return dtName;
    }

    private static int inequalityCount(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        return others == null ? 0 : others.size();
    }

    private static <T> void partitionDConjunction(Collection<DataRange<? extends T>> dconjunction, Set<DataValueEnumeration<? extends T>> positiveEnumerations, Set<DataValueEnumeration<? extends T>> negativeEnumerations, Set<RestrictedDatatype<? extends T>> positiveRestrictions, Set<RestrictedDatatype<? extends T>> negativeRestrictions) {
        for (DataRange<T> dataRange : dconjunction) {
            if (dataRange instanceof DataValueEnumeration) {
                positiveEnumerations.add((DataValueEnumeration)dataRange);
                continue;
            }
            if (dataRange instanceof RestrictedDatatype) {
                positiveRestrictions.add((RestrictedDatatype)dataRange);
                continue;
            }
            if (dataRange instanceof NegatedDataRange) {
                DataRange ndr = ((NegatedDataRange)dataRange).getDataRange();
                if (ndr instanceof DataValueEnumeration) {
                    negativeEnumerations.add((DataValueEnumeration)ndr);
                    continue;
                }
                if (ndr instanceof RestrictedDatatype) {
                    negativeRestrictions.add((RestrictedDatatype)ndr);
                    continue;
                }
                if (dataRange == TRIVIALLY_SATISFIABLE) continue;
                _logger.warning("Unknown datatype: " + dataRange);
                continue;
            }
            if (dataRange == TRIVIALLY_SATISFIABLE) continue;
            _logger.warning("Unknown datatype: " + dataRange);
        }
    }

    private static boolean removeInequalities(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        if (others == null) {
            return false;
        }
        for (Integer yIndex : others) {
            Set<Integer> s = nes[yIndex];
            if (s == null) {
                throw new IllegalStateException();
            }
            if (s.remove(xIndex)) continue;
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean containedIn(Object value, ATermAppl dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (ATermUtils.isAnd(dconjunction)) {
            ATermList l = (ATermList)dconjunction.getArgument(0);
            while (!l.isEmpty()) {
                if (!this.getDataRange((ATermAppl)l.getFirst()).contains(value)) {
                    return false;
                }
                l = l.getNext();
            }
            return true;
        }
        return this.getDataRange(dconjunction).contains(value);
    }

    @Override
    public boolean containsAtLeast(int n, Collection<ATermAppl> ranges) throws UnrecognizedDatatypeException, InvalidConstrainingFacetException, InvalidLiteralException {
        ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(ranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr(dnf)) {
            ArrayList disjuncts = new ArrayList();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.normalizeVarRanges((ATermAppl)l.getFirst());
                if (!dr.isEmpty()) {
                    disjuncts.add(dr);
                }
                l = l.getNext();
            }
            return DatatypeReasonerImpl.getDisjunction(disjuncts).containsAtLeast(n);
        }
        return this.normalizeVarRanges(dnf).containsAtLeast(n);
    }

    @Override
    public boolean declare(ATermAppl name) {
        if (this.isDeclared(name)) {
            return false;
        }
        this.declaredUndefined.add(name);
        return true;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl literal) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dtName = DatatypeReasonerImpl.getDatatypeName(literal);
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (OpenlletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, ATermUtils.getLiteralValue(literal));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getCanonicalRepresentation(literal);
    }

    private DataRange<?> getDataRange(ATermAppl a) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (a.equals(ATermUtils.TOP_LIT)) {
            return TRIVIALLY_SATISFIABLE;
        }
        if (a.equals(ATermUtils.BOTTOM_LIT)) {
            return EMPTY_RANGE;
        }
        if (ATermUtils.isPrimitive(a)) {
            InfiniteNamedDatatype dt = this.getDatatype(a);
            if (dt == null) {
                switch (OpenlletOptions.UNDEFINED_DATATYPE_HANDLING) {
                    case INFINITE_STRING: {
                        dt = InfiniteNamedDatatype.get(a);
                        break;
                    }
                    case EMPTY: {
                        return EMPTY_RANGE;
                    }
                    case EXCEPTION: {
                        throw new UnrecognizedDatatypeException(a);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return dt.asDataRange();
        }
        if (ATermUtils.isRestrictedDatatype(a)) {
            ATermList facetValues;
            ATermAppl dtTerm = (ATermAppl)a.getArgument(0);
            DataRange<?> dt = this.getDataRange(dtTerm);
            if (!(dt instanceof RestrictedDatatype)) {
                throw new InvalidConstrainingFacetException(dtTerm, dt);
            }
            RestrictedDatatype dr = (RestrictedDatatype)dt;
            ATermList l = facetValues = (ATermList)a.getArgument(1);
            while (!l.isEmpty()) {
                Object value;
                ATermAppl fv = (ATermAppl)l.getFirst();
                ATermAppl facet = (ATermAppl)fv.getArgument(0);
                ATermAppl valueTerm = (ATermAppl)fv.getArgument(1);
                try {
                    value = this.getValue(valueTerm);
                }
                catch (InvalidLiteralException e) {
                    throw new InvalidConstrainingFacetException(facet, (Object)valueTerm, e);
                }
                dr = dr.applyConstrainingFacet(facet, value);
                l = l.getNext();
            }
            return dr;
        }
        if (ATermUtils.isNot(a)) {
            ATermAppl n = (ATermAppl)a.getArgument(0);
            DataRange<?> ndr = this.getDataRange(n);
            NegatedDataRange dr = new NegatedDataRange(ndr);
            return dr;
        }
        if (ATermUtils.isNominal(a)) {
            ATermAppl literal = (ATermAppl)a.getArgument(0);
            DataValueEnumeration<Object> dr = new DataValueEnumeration<Object>(Collections.singleton(this.getValue(literal)));
            return dr;
        }
        String msg = String.format("Unrecognized input term (%s) for datarange conversion", a);
        _logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Datatype<?> getDatatype(ATermAppl uri) {
        try {
            ATermAppl definition;
            Datatype<?> dt = _coreDatatypes.get(uri);
            if (dt == null && (definition = this.namedDataRanges.get(uri)) != null && ATermUtils.isRestrictedDatatype(definition)) {
                RestrictedDatatype dataRange = (RestrictedDatatype)this.getDataRange(definition);
                NamedDatatype namedDatatype = new NamedDatatype(uri, dataRange);
                dt = namedDatatype;
            }
            return dt;
        }
        catch (Exception e) {
            throw new OpenError((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DataRange<?> getDisjunction(Collection<DataRange<?>> ranges) {
        Iterator<Object> it;
        if (ranges.size() == 1) {
            return ranges.iterator().next();
        }
        for (DataRange<?> r : ranges) {
            if (r != TRIVIALLY_SATISFIABLE) continue;
            return r;
        }
        Set oneOf = Collections.emptySet();
        HashMap byPrimitive = new HashMap();
        for (DataRange<?> dr : ranges) {
            if (dr instanceof RestrictedDatatype) {
                void var7_7;
                RestrictedDatatype rd = (RestrictedDatatype)dr;
                Datatype<?> pd = rd.getDatatype().getPrimitiveDatatype();
                Set set = (Set)byPrimitive.get(pd);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    byPrimitive.put(pd, hashSet);
                }
                var7_7.add(rd);
                continue;
            }
            if (!(dr instanceof DataValueEnumeration)) continue;
            DataValueEnumeration enm = (DataValueEnumeration)dr;
            if (oneOf.isEmpty()) {
                oneOf = new HashSet();
            }
            it = enm.valueIterator();
            while (it.hasNext()) {
                oneOf.add(it.next());
            }
        }
        HashSet disjointRanges = new HashSet();
        for (Set s : byPrimitive.values()) {
            void var7_12;
            it = s.iterator();
            RestrictedDatatype restrictedDatatype = (RestrictedDatatype)it.next();
            while (it.hasNext()) {
                RestrictedDatatype restrictedDatatype2 = var7_12.union((RestrictedDatatype)it.next());
            }
            disjointRanges.add(var7_12);
        }
        Iterator it2 = oneOf.iterator();
        while (it2.hasNext()) {
            Object o = it2.next();
            for (RestrictedDatatype restrictedDatatype : disjointRanges) {
                if (!restrictedDatatype.contains(o)) continue;
                it2.remove();
            }
        }
        return new UnionDataRange(disjointRanges, oneOf);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        for (Datatype<?> dt : _coreDatatypes.values()) {
            if (!dt.isPrimitive() || !dt.asDataRange().contains(value)) continue;
            return dt.getLiteral(value);
        }
        String msg = "Value is not in the value space of any recognized datatypes: " + value.toString();
        _logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Object getValue(ATermAppl literal) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dtName = DatatypeReasonerImpl.getDatatypeName(literal);
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (OpenlletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, ATermUtils.getLiteralValue(literal));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getValue(literal);
    }

    @Override
    public boolean isDeclared(ATermAppl name) {
        return ATermUtils.TOP_LIT.equals(name) || _coreDatatypes.containsKey(name) || this.namedDataRanges.containsKey(name) || this.declaredUndefined.contains(name);
    }

    @Override
    public boolean isDefined(ATermAppl name) {
        if (ATermUtils.TOP_LIT.equals(name)) {
            return true;
        }
        if (_coreDatatypes.containsKey(name)) {
            return true;
        }
        return this.namedDataRanges.containsKey(name);
    }

    @Override
    public ATermAppl getDefinition(ATermAppl name) {
        return this.namedDataRanges.get(name);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        return this.isSatisfiable(dataranges, null);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> dataranges, Object value) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dnfDisjuncts;
        Set<Integer> vars;
        HashSet<Integer> consts;
        if (value == null) {
            consts = new HashSet();
            vars = new HashSet<Integer>(Collections.singleton(0));
        } else {
            consts = Collections.singleton(0);
            vars = Collections.emptySet();
        }
        ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(dataranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr(dnf)) {
            ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                disjuncts.add((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            dnfDisjuncts = disjuncts;
        } else {
            dnfDisjuncts = Collections.singleton(dnf);
        }
        Collection[] dnfTypes = new Collection[]{dnfDisjuncts};
        Set[] ne = new Set[]{Collections.emptySet()};
        return this.isSatisfiable(consts, vars, dnfTypes, new Object[]{value}, ne);
    }

    private boolean isSatisfiable(Set<Integer> consts, Set<Integer> vars, Collection<ATermAppl>[] dnfTypes, Object[] constValues, Set<Integer>[] ne) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Object dr;
        int n = dnfTypes.length;
        for (int i = 0; i < n; ++i) {
            Collection<ATermAppl> drs = dnfTypes[i];
            Iterator<ATermAppl> it2 = drs.iterator();
            while (it2.hasNext()) {
                dr = it2.next();
                if (!ATermUtils.BOTTOM_LIT.equals(dr)) continue;
                it2.remove();
            }
            if (!drs.isEmpty()) continue;
            return false;
        }
        DataRange[] normalized = new DataRange[n];
        for (int i = 0; i < n; ++i) {
            if (consts.contains(i)) {
                boolean satisfied = false;
                for (ATermAppl aTermAppl : dnfTypes[i]) {
                    if (!this.containedIn(constValues[i], aTermAppl)) continue;
                    satisfied = true;
                    break;
                }
                if (satisfied) {
                    normalized[i] = TRIVIALLY_SATISFIABLE;
                    continue;
                }
                return false;
            }
            List<DataRange<?>> drs = new ArrayList();
            for (ATermAppl aTermAppl : dnfTypes[i]) {
                DataRange<?> dr2 = this.normalizeVarRanges(aTermAppl);
                if (dr2 == TRIVIALLY_SATISFIABLE) {
                    drs = Collections.singletonList(TRIVIALLY_SATISFIABLE);
                    break;
                }
                if (dr2.isEmpty()) continue;
                drs.add(dr2);
            }
            if (drs.isEmpty()) {
                return false;
            }
            normalized[i] = DatatypeReasonerImpl.getDisjunction(drs);
        }
        Iterator<Integer> it3 = vars.iterator();
        while (it3.hasNext()) {
            Integer i = it3.next();
            dr = normalized[i];
            if (TRIVIALLY_SATISFIABLE == dr) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i);
                continue;
            }
            if (dr.isEmpty()) {
                return false;
            }
            if (dr.containsAtLeast(DatatypeReasonerImpl.inequalityCount(ne, i) + 1)) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i);
                continue;
            }
            if (!dr.isFinite() || !dr.isEnumerable() || dr.containsAtLeast(2)) continue;
            Object t = dr.valueIterator().next();
            it3.remove();
            consts.add(i);
            constValues[i.intValue()] = t;
            normalized[i.intValue()] = TRIVIALLY_SATISFIABLE;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(String.format("After variable _data range normalization %d variables and %d constants", vars.size(), consts.size()));
        }
        for (Integer i : consts) {
            Set<Integer> diffs = ne[i];
            if (diffs == null) continue;
            Iterator<Integer> iterator = diffs.iterator();
            while (iterator.hasNext()) {
                int j = iterator.next();
                if (!consts.contains(j)) continue;
                if (constValues[i].equals(constValues[j])) {
                    return false;
                }
                iterator.remove();
                ne[j].remove(i);
            }
        }
        Iterator<Integer> it = vars.iterator();
        while (it.hasNext()) {
            Set<Integer> set;
            int min;
            int i = it.next();
            dr = normalized[i];
            if (!dr.containsAtLeast(min = (set = ne[i]) == null ? 1 : set.size() + 1)) continue;
            it.remove();
            if (set != null) {
                for (int j : set) {
                    if (ne[j] == null) continue;
                    ne[j].remove(i);
                }
            }
            ne[i] = null;
            vars.remove(i);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(String.format("After size check on variable _data ranges %d variables", vars.size()));
        }
        if (vars.isEmpty()) {
            return true;
        }
        HashSet<Integer> remaining = new HashSet<Integer>(vars);
        ArrayList partitions = new ArrayList();
        while (!remaining.isEmpty()) {
            HashSet<Integer> p = new HashSet<Integer>();
            Iterator iterator = remaining.iterator();
            int i = (Integer)iterator.next();
            iterator.remove();
            p.add(i);
            if (ne[i] != null) {
                HashSet<Integer> others = new HashSet<Integer>();
                others.addAll(ne[i]);
                while (!others.isEmpty()) {
                    Iterator jt = others.iterator();
                    int j = (Integer)jt.next();
                    jt.remove();
                    if (!remaining.contains(j)) continue;
                    p.add(j);
                    remaining.remove(j);
                    if (ne[j] == null) continue;
                    others.addAll(ne[j]);
                }
            }
            partitions.add(p);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(String.format("Enumerating to find solutions for %d partitions", partitions.size()));
        }
        for (Set set : partitions) {
            int nPart = set.size();
            int[] indices = new int[nPart];
            HashMap<Integer, Integer> revInd = new HashMap<Integer, Integer>();
            DataRange[] drs = new DataRange[nPart];
            int i = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                drs[i] = normalized[j];
                indices[i] = j;
                revInd.put(j, i);
                ++i;
            }
            Iterator[] its = new Iterator[nPart];
            for (i = 0; i < nPart; ++i) {
                its[i] = drs[i].valueIterator();
            }
            Object[] values = new Object[nPart];
            for (i = 0; i < nPart; ++i) {
                values[i] = its[i].next();
            }
            boolean solutionFound = false;
            while (!solutionFound) {
                solutionFound = true;
                block17: for (i = 0; i < nPart && solutionFound; ++i) {
                    Set<Integer> diffs = ne[indices[i]];
                    if (diffs == null) continue;
                    Object a = values[i];
                    for (int j : diffs) {
                        Object b = set.contains(j) ? values[(Integer)revInd.get(j)] : constValues[j];
                        if (!a.equals(b)) continue;
                        solutionFound = false;
                        continue block17;
                    }
                }
                if (solutionFound) continue;
                i = nPart - 1;
                while (!its[i].hasNext()) {
                    if (i == 0) {
                        return false;
                    }
                    its[i] = drs[i].valueIterator();
                    values[i] = its[i].next();
                    --i;
                }
                values[i] = its[i].next();
            }
        }
        return true;
    }

    @Override
    public boolean isSatisfiable(Set<Literal> nodes, Map<Literal, Set<Literal>> neqs) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal[] literals = nodes.toArray(new Literal[0]);
        HashSet<Integer> vars = new HashSet<Integer>();
        HashSet<Integer> consts = new HashSet<Integer>();
        Object[] constValues = new Object[literals.length];
        HashMap<Literal, Integer> rev = new HashMap<Literal, Integer>();
        for (int i = 0; i < literals.length; ++i) {
            rev.put(literals[i], i);
            if (literals[i].isNominal()) {
                consts.add(i);
                constValues[i] = literals[i].getValue();
                continue;
            }
            vars.add(i);
        }
        Set[] ne = new Set[literals.length];
        for (Map.Entry<Literal, Set<Literal>> e : neqs.entrySet()) {
            int index = (Integer)rev.get(e.getKey());
            ne[index] = new HashSet();
            for (Literal l : e.getValue()) {
                ne[index].add((Integer)rev.get(l));
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(String.format("Checking satisfiability for %d variables and %d constants", vars.size(), consts.size()));
        }
        Collection[] dnfs = new Collection[literals.length];
        for (int i = 0; i < literals.length; ++i) {
            ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(literals[i].getTypes()));
            ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
            if (ATermUtils.isOr(dnf)) {
                ArrayList<ATermAppl> disjuncts = new ArrayList<ATermAppl>();
                ATermList l = (ATermList)dnf.getArgument(0);
                while (!l.isEmpty()) {
                    disjuncts.add((ATermAppl)l.getFirst());
                    l = l.getNext();
                }
                dnfs[i] = disjuncts;
                continue;
            }
            dnfs[i] = Collections.singleton(dnf);
        }
        return this.isSatisfiable(consts, vars, dnfs, constValues, ne);
    }

    @Override
    public boolean define(ATermAppl name, ATermAppl datarange) {
        if (name.equals(datarange)) {
            throw new IllegalArgumentException();
        }
        if (this.namedDataRanges.containsKey(name)) {
            return false;
        }
        this.namedDataRanges.put(name, datarange);
        this.declaredUndefined.remove(name);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private DataRange<?> normalizeVarRanges(ATermAppl dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        DataRange<?> ret;
        if (ATermUtils.isAnd(dconjunction)) {
            void var10_19;
            void var10_16;
            LinkedHashSet ranges = new LinkedHashSet();
            ATermList l = (ATermList)dconjunction.getArgument(0);
            while (!l.isEmpty()) {
                DataRange<?> dr = this.getDataRange((ATermAppl)l.getFirst());
                if (dr.isEmpty()) {
                    return EMPTY_RANGE;
                }
                ranges.add(dr);
                l = l.getNext();
            }
            HashSet positiveEnumerations = new HashSet();
            HashSet negativeEnumerations = new HashSet();
            HashSet positiveRestrictions = new HashSet();
            HashSet negativeRestrictions = new HashSet();
            DatatypeReasonerImpl.partitionDConjunction(ranges, positiveEnumerations, negativeEnumerations, positiveRestrictions, negativeRestrictions);
            if (!positiveEnumerations.isEmpty()) {
                DataValueEnumeration enumeration = DatatypeReasonerImpl.findSmallestEnumeration(positiveEnumerations);
                HashSet remainingValues = new HashSet();
                Iterator iterator = enumeration.valueIterator();
                boolean same = true;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    boolean bl = true;
                    for (DataRange dataRange : ranges) {
                        if (dataRange == enumeration || dataRange.contains(t)) continue;
                        bl = false;
                        same = false;
                        break;
                    }
                    if (!bl) continue;
                    remainingValues.add(t);
                }
                if (same) {
                    return enumeration;
                }
                if (remainingValues.isEmpty()) {
                    return EMPTY_RANGE;
                }
                return new DataValueEnumeration(remainingValues);
            }
            if (positiveRestrictions.isEmpty()) {
                return TRIVIALLY_SATISFIABLE;
            }
            Datatype<?> rootDt = null;
            for (RestrictedDatatype restrictedDatatype : positiveRestrictions) {
                Datatype<?> dt = restrictedDatatype.getDatatype().getPrimitiveDatatype();
                if (rootDt == null) {
                    rootDt = dt;
                    continue;
                }
                if (rootDt.equals(dt)) continue;
                return EMPTY_RANGE;
            }
            Iterator it = positiveRestrictions.iterator();
            RestrictedDatatype restrictedDatatype = (RestrictedDatatype)it.next();
            while (it.hasNext()) {
                void var10_14;
                RestrictedDatatype other = (RestrictedDatatype)it.next();
                RestrictedDatatype restrictedDatatype2 = var10_14.intersect(other, false);
            }
            for (RestrictedDatatype restrictedDatatype3 : negativeRestrictions) {
                if (restrictedDatatype3.isEmpty()) continue;
                Datatype<?> datatype = restrictedDatatype3.getDatatype().getPrimitiveDatatype();
                if (rootDt != null && !rootDt.equals(datatype)) continue;
                RestrictedDatatype restrictedDatatype4 = var10_16.intersect(restrictedDatatype3, true);
            }
            if (!negativeEnumerations.isEmpty()) {
                HashSet notOneOf = new HashSet();
                for (DataValueEnumeration dataValueEnumeration : negativeEnumerations) {
                    Iterator oi = dataValueEnumeration.valueIterator();
                    while (oi.hasNext()) {
                        notOneOf.add(oi.next());
                    }
                }
                RestrictedDatatype restrictedDatatype5 = var10_16.exclude(notOneOf);
            }
            ret = var10_19;
        } else {
            ret = this.getDataRange(dconjunction);
        }
        if (!ret.isFinite()) {
            return TRIVIALLY_SATISFIABLE;
        }
        return ret;
    }

    @Override
    public Collection<ATermAppl> listDataRanges() {
        HashSet<ATermAppl> dataRanges = new HashSet<ATermAppl>(_coreDatatypes.keySet());
        dataRanges.addAll(this.declaredUndefined);
        dataRanges.addAll(this.namedDataRanges.keySet());
        return dataRanges;
    }

    @Override
    public boolean validLiteral(ATermAppl typedLiteral) throws UnrecognizedDatatypeException {
        if (!ATermUtils.isLiteral(typedLiteral)) {
            throw new IllegalArgumentException();
        }
        ATermAppl dtTerm = (ATermAppl)typedLiteral.getArgument(2);
        if (dtTerm == null) {
            throw new IllegalArgumentException();
        }
        Datatype<?> dt = this.getDatatype(dtTerm);
        if (dt == null) {
            throw new UnrecognizedDatatypeException(dtTerm);
        }
        try {
            dt.getValue(typedLiteral);
        }
        catch (InvalidLiteralException e) {
            _logger.log(Level.FINE, "", e);
            return false;
        }
        return true;
    }

    @Override
    public Iterator<?> valueIterator(Collection<ATermAppl> dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl and = ATermUtils.makeAnd(ATermUtils.makeList(dataranges));
        ATermAppl dnf = DNF.dnf(this.expander.expand(and, this.namedDataRanges));
        if (ATermUtils.isOr(dnf)) {
            ArrayList disjuncts = new ArrayList();
            ATermList l = (ATermList)dnf.getArgument(0);
            while (!l.isEmpty()) {
                disjuncts.add(this.normalizeVarRanges((ATermAppl)l.getFirst()));
                l = l.getNext();
            }
            return DatatypeReasonerImpl.getDisjunction(disjuncts).valueIterator();
        }
        return this.normalizeVarRanges(dnf).valueIterator();
    }

    static {
        _coreDatatypes.put(RDFPlainLiteral.getInstance().getName(), RDFPlainLiteral.getInstance());
        _coreDatatypes.put(XSDString.getInstance().getName(), XSDString.getInstance());
        _coreDatatypes.put(XSDNormalizedString.getInstance().getName(), XSDNormalizedString.getInstance());
        _coreDatatypes.put(XSDToken.getInstance().getName(), XSDToken.getInstance());
        _coreDatatypes.put(XSDLanguage.getInstance().getName(), XSDLanguage.getInstance());
        _coreDatatypes.put(XSDNMToken.getInstance().getName(), XSDNMToken.getInstance());
        _coreDatatypes.put(XSDName.getInstance().getName(), XSDName.getInstance());
        _coreDatatypes.put(XSDNCName.getInstance().getName(), XSDNCName.getInstance());
        _coreDatatypes.put(XSDBoolean.getInstance().getName(), XSDBoolean.getInstance());
        _coreDatatypes.put(OWLReal.getInstance().getName(), OWLReal.getInstance());
        _coreDatatypes.put(OWLRational.getInstance().getName(), OWLRational.getInstance());
        _coreDatatypes.put(XSDDecimal.getInstance().getName(), XSDDecimal.getInstance());
        _coreDatatypes.put(XSDInteger.getInstance().getName(), XSDInteger.getInstance());
        _coreDatatypes.put(XSDLong.getInstance().getName(), XSDLong.getInstance());
        _coreDatatypes.put(XSDInt.getInstance().getName(), XSDInt.getInstance());
        _coreDatatypes.put(XSDShort.getInstance().getName(), XSDShort.getInstance());
        _coreDatatypes.put(XSDByte.getInstance().getName(), XSDByte.getInstance());
        _coreDatatypes.put(XSDNonNegativeInteger.getInstance().getName(), XSDNonNegativeInteger.getInstance());
        _coreDatatypes.put(XSDNonPositiveInteger.getInstance().getName(), XSDNonPositiveInteger.getInstance());
        _coreDatatypes.put(XSDNegativeInteger.getInstance().getName(), XSDNegativeInteger.getInstance());
        _coreDatatypes.put(XSDPositiveInteger.getInstance().getName(), XSDPositiveInteger.getInstance());
        _coreDatatypes.put(XSDUnsignedLong.getInstance().getName(), XSDUnsignedLong.getInstance());
        _coreDatatypes.put(XSDUnsignedInt.getInstance().getName(), XSDUnsignedInt.getInstance());
        _coreDatatypes.put(XSDUnsignedShort.getInstance().getName(), XSDUnsignedShort.getInstance());
        _coreDatatypes.put(XSDUnsignedByte.getInstance().getName(), XSDUnsignedByte.getInstance());
        _coreDatatypes.put(XSDDouble.getInstance().getName(), XSDDouble.getInstance());
        _coreDatatypes.put(XSDFloat.getInstance().getName(), XSDFloat.getInstance());
        _coreDatatypes.put(XSDDateTime.getInstance().getName(), XSDDateTime.getInstance());
        _coreDatatypes.put(XSDDateTimeStamp.getInstance().getName(), XSDDateTimeStamp.getInstance());
        _coreDatatypes.put(XSDDate.getInstance().getName(), XSDDate.getInstance());
        _coreDatatypes.put(XSDGYearMonth.getInstance().getName(), XSDGYearMonth.getInstance());
        _coreDatatypes.put(XSDGMonthDay.getInstance().getName(), XSDGMonthDay.getInstance());
        _coreDatatypes.put(XSDGYear.getInstance().getName(), XSDGYear.getInstance());
        _coreDatatypes.put(XSDGMonth.getInstance().getName(), XSDGMonth.getInstance());
        _coreDatatypes.put(XSDGDay.getInstance().getName(), XSDGDay.getInstance());
        _coreDatatypes.put(XSDTime.getInstance().getName(), XSDTime.getInstance());
        _coreDatatypes.put(XSDDuration.getInstance().getName(), XSDDuration.getInstance());
        _coreDatatypes.put(XSDAnyURI.getInstance().getName(), XSDAnyURI.getInstance());
        EMPTY_RANGE = new EmptyDataRange();
        TRIVIALLY_SATISFIABLE = new DataRange<Object>(){

            @Override
            public boolean contains(Object value) {
                return true;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public Iterator<Object> valueIterator() {
                return Collections.emptyIterator();
            }
        };
    }
}

