/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.utils.ATermUtils;

class NamedDatatype<T>
implements Datatype<T> {
    private final ATermAppl _name;
    private final RestrictedDatatype<T> _range;

    NamedDatatype(ATermAppl name, RestrictedDatatype<T> range) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.getArity() != 0) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._range = range;
    }

    @Override
    public RestrictedDatatype<T> asDataRange() {
        return this._range;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedDatatype other = (NamedDatatype)obj;
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this._range.getDatatype().getCanonicalRepresentation(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        ATermAppl a;
        if (value instanceof ATermAppl && ATermUtils.isLiteral(a = (ATermAppl)value) && this._name.equals(a.getArgument(2))) {
            return a;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this._name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this._range.getDatatype().getPrimitiveDatatype();
    }

    @Override
    public T getValue(ATermAppl literal) throws InvalidLiteralException {
        T value = this._range.getDatatype().getValue(literal);
        if (!this._range.contains(value)) {
            throw new InvalidLiteralException(this._name, literal.getArgument(0).toString());
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this._name.getName();
    }
}

