/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.bool;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.EmptyIterator;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidConstrainingFacetException;

public class RestrictedBooleanDatatype
implements RestrictedDatatype<Boolean> {
    private final Datatype<Boolean> _dt;
    private final boolean _permitFalse;
    private final boolean _permitTrue;

    public RestrictedBooleanDatatype(Datatype<Boolean> dt) {
        this._dt = dt;
        this._permitTrue = true;
        this._permitFalse = true;
    }

    private RestrictedBooleanDatatype(RestrictedBooleanDatatype other, boolean permitTrue, boolean permitFalse) {
        this._dt = other._dt;
        this._permitFalse = permitFalse;
        this._permitTrue = permitTrue;
    }

    @Override
    public RestrictedDatatype<Boolean> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        throw new InvalidConstrainingFacetException(facet, value);
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? this._permitTrue : this._permitFalse;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        if (n == 1) {
            return this._permitTrue || this._permitFalse;
        }
        if (n == 2) {
            return this._permitTrue && this._permitFalse;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Boolean> exclude(Collection<?> values) {
        boolean permitTrue = this._permitTrue;
        boolean permitFalse = this._permitFalse;
        for (Object o : values) {
            if (!(o instanceof Boolean)) continue;
            Boolean b = (Boolean)o;
            if (b.booleanValue()) {
                permitTrue = false;
                continue;
            }
            permitFalse = false;
        }
        if (permitTrue == this._permitTrue && permitFalse == this._permitFalse) {
            return this;
        }
        return new RestrictedBooleanDatatype(this, permitTrue, permitFalse);
    }

    @Override
    public Datatype<? extends Boolean> getDatatype() {
        return this._dt;
    }

    @Override
    public RestrictedDatatype<Boolean> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedBooleanDatatype) {
            boolean permitFalse;
            RestrictedBooleanDatatype otherRBD = (RestrictedBooleanDatatype)other;
            boolean permitTrue = this._permitTrue && otherRBD._permitTrue;
            boolean bl = permitFalse = this._permitFalse && otherRBD._permitFalse;
            if (permitTrue == this._permitTrue && permitFalse == this._permitFalse) {
                return this;
            }
            if (permitTrue == otherRBD._permitTrue && permitFalse == otherRBD._permitFalse) {
                return otherRBD;
            }
            return new RestrictedBooleanDatatype(this, permitTrue, permitFalse);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return !this._permitTrue && !this._permitFalse;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public RestrictedDatatype<Boolean> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedBooleanDatatype) {
            boolean permitFalse;
            RestrictedBooleanDatatype otherRBD = (RestrictedBooleanDatatype)other;
            boolean permitTrue = this._permitTrue || otherRBD._permitTrue;
            boolean bl = permitFalse = this._permitFalse || otherRBD._permitFalse;
            if (permitTrue == this._permitTrue && permitFalse == this._permitFalse) {
                return this;
            }
            if (permitTrue == otherRBD._permitTrue && permitFalse == otherRBD._permitFalse) {
                return otherRBD;
            }
            return new RestrictedBooleanDatatype(this, permitTrue, permitFalse);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Boolean> valueIterator() {
        if (this._permitTrue) {
            if (this._permitFalse) {
                return Arrays.asList(Boolean.TRUE, Boolean.FALSE).iterator();
            }
            return Arrays.asList(Boolean.TRUE).iterator();
        }
        if (this._permitFalse) {
            return Arrays.asList(Boolean.FALSE).iterator();
        }
        return new EmptyIterator<Boolean>();
    }
}

