/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.floating;

import openllet.core.datatypes.DiscreteInterval;
import openllet.core.datatypes.types.floating.FloatingPointType;

public class FloatingPointInterval<T extends Number>
extends DiscreteInterval<T, FloatingPointInterval<T>> {
    private final FloatingPointType<T> _type;

    public static <U extends Number> FloatingPointInterval<U> unconstrained(FloatingPointType<U> type) {
        return new FloatingPointInterval<U>(type, type.getNegativeInfinity(), type.getPositiveInfinity());
    }

    public FloatingPointInterval(FloatingPointType<T> type, T point) {
        super(point);
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.isNaN(point)) {
            throw new IllegalArgumentException();
        }
        this._type = type;
        if (!this.valid(point)) {
            throw new IllegalArgumentException();
        }
    }

    public FloatingPointInterval(FloatingPointType<T> type, T lower, T upper) {
        super(lower, upper);
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.isNaN(lower)) {
            throw new IllegalArgumentException();
        }
        if (type.isNaN(upper)) {
            throw new IllegalArgumentException();
        }
        this._type = type;
        if (!this.valid(lower)) {
            throw new IllegalArgumentException();
        }
        if (!this.valid(upper)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected FloatingPointInterval<T> cast(DiscreteInterval<T, FloatingPointInterval<T>> i) {
        if (i instanceof FloatingPointInterval) {
            return (FloatingPointInterval)i;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected int compare(T a, DiscreteInterval.NullSemantics na, T b, DiscreteInterval.NullSemantics nb) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        return ((Comparable)a).compareTo(b);
    }

    @Override
    public boolean contains(T n) {
        if (this._type.isNaN(n)) {
            return false;
        }
        return super.contains(n);
    }

    @Override
    protected FloatingPointInterval<T> create(T lower, T upper) {
        return new FloatingPointInterval<T>(this._type, lower, upper);
    }

    @Override
    protected T decrement(T t) {
        return this._type.decrement(t);
    }

    @Override
    protected boolean equal(T a, T b) {
        return a.equals(b);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingPointInterval other = (FloatingPointInterval)obj;
        if (!this.getLower().equals(other.getLower())) {
            return false;
        }
        return this.getUpper().equals(other.getUpper());
    }

    @Override
    public FloatingPointInterval<T> greater(T n) {
        if (this._type.isNaN(n)) {
            throw new IllegalArgumentException();
        }
        return (FloatingPointInterval)super.greater(n);
    }

    @Override
    protected T increment(T t) {
        return this._type.increment(t);
    }

    @Override
    public FloatingPointInterval<T> less(T n) {
        if (this._type.isNaN(n)) {
            throw new IllegalArgumentException();
        }
        return (FloatingPointInterval)super.less(n);
    }

    @Override
    public Number size() {
        return this._type.intervalSize(this.getLower(), this.getUpper());
    }

    @Override
    protected boolean valid(T t) {
        return t != null && (this._type == null || this._type.isInstance(t));
    }
}

