/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.ContinuousRealInterval;
import openllet.core.datatypes.types.real.IntegerInterval;
import openllet.core.datatypes.types.real.OWLReal;
import openllet.core.datatypes.types.real.Rational;
import openllet.core.datatypes.types.real.RestrictedRealDatatype;
import openllet.core.utils.ATermUtils;

public class OWLRational
extends AbstractBaseDatatype<Number> {
    private static final OWLRational instance = new OWLRational();
    private final RestrictedRealDatatype _dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLRational getInstance() {
        return instance;
    }

    private OWLRational() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#rational"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this._dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        Number n = this.getValue(input);
        if (n instanceof Rational) {
            String canonicalForm = Rational.simplify((Rational)n).toString();
            if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
        }
        return OWLReal.getInstance().getLiteral(OWLRealUtils.getCanonicalObject(n));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Rational) {
            Rational r = (Rational)value;
            String lexicalForm = r.toString();
            return ATermUtils.makeTypedLiteral(lexicalForm, this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return OWLReal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = OWLRational.getLexicalForm(literal);
        try {
            return OWLRealUtils.getCanonicalObject(Rational.valueOf(lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

