/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Collection;
import java.util.Iterator;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.rbox.Role;
import openllet.core.el.ELSyntaxUtils;
import openllet.core.expressivity.Expressivity;
import openllet.core.expressivity.ProfileBasedExpressivityChecker;
import openllet.core.utils.ATermUtils;

public class ELExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private Expressivity _expressivity;

    public ELExpressivityChecker(KnowledgeBase kb) {
        super(kb);
    }

    @Override
    public boolean compute(Expressivity expressivity) {
        this._expressivity = expressivity;
        if (!this.processIndividuals()) {
            return false;
        }
        if (!this.processClasses()) {
            return false;
        }
        return this.processRoles();
    }

    private boolean processIndividuals() {
        IndividualIterator i = this._KB.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = i.next();
            ATermAppl nominal = ATermUtils.makeValue((ATerm)ind.getName());
            for (ATermAppl term : ind.getTypes()) {
                if (term.equals(nominal) || ELSyntaxUtils.isEL(term)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processClasses() {
        for (ATermAppl axiom : this._KB.getTBox().getAssertedAxioms()) {
            AFun fun = axiom.getAFun();
            if (fun.equals(ATermUtils.DISJOINTSFUN)) {
                this._expressivity.setHasDisjointClasses(true);
                ATermList args = (ATermList)axiom.getArgument(0);
                while (!args.isEmpty()) {
                    if (!ELSyntaxUtils.isEL((ATermAppl)args.getFirst())) {
                        return false;
                    }
                    args = args.getNext();
                }
                continue;
            }
            ATermAppl sub = (ATermAppl)axiom.getArgument(0);
            ATermAppl sup = (ATermAppl)axiom.getArgument(1);
            if (!ELSyntaxUtils.isEL(sub) || !ELSyntaxUtils.isEL(sup)) {
                return false;
            }
            if (fun.equals(ATermUtils.SUBFUN)) {
                if (!ATermUtils.isBottom(ELSyntaxUtils.simplify(sup))) continue;
                this._expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (fun.equals(ATermUtils.EQCLASSFUN)) {
                if (!ATermUtils.isBottom(ELSyntaxUtils.simplify(sub)) && !ATermUtils.isBottom(ELSyntaxUtils.simplify(sup))) continue;
                this._expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (fun.equals(ATermUtils.DISJOINTFUN)) {
                this._expressivity.setHasDisjointClasses(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean processRoles() {
        Collection<Role> roles = this._KB.getRBox().getRoles().values();
        for (Role r : roles) {
            if (r.isBuiltin()) continue;
            if (r.isDatatypeRole()) {
                return false;
            }
            if (r.isAnon()) {
                for (Role role : r.getSubRoles()) {
                    if (role.isAnon() || role.isBottom()) continue;
                    return false;
                }
            }
            if (r.isAnon() && r.isFunctional()) {
                return false;
            }
            if (r.isFunctional()) {
                return false;
            }
            if (r.isTransitive()) {
                this._expressivity.setHasTransitivity(true);
            }
            if (r.isReflexive()) {
                this._expressivity.setHasReflexivity(true);
            }
            if (r.isIrreflexive()) {
                return false;
            }
            if (r.isAsymmetric()) {
                return false;
            }
            if (!r.getDisjointRoles().isEmpty()) {
                return false;
            }
            if (r.hasComplexSubRole()) {
                this._expressivity.setHasComplexSubRoles(true);
                boolean isInv = r.isAnon();
                for (ATermList chain : r.getSubRoleChains()) {
                    while (!chain.isEmpty()) {
                        if (ATermUtils.isInv((ATermAppl)chain.getFirst()) != isInv) {
                            return false;
                        }
                        chain = chain.getNext();
                    }
                }
            }
            if (r.getSubRoles().size() <= 1) continue;
            this._expressivity.setHasRoleHierarchy(true);
        }
        for (Role r : roles) {
            Iterator<ATermAppl> assertedDomains = this._KB.getRBox().getAssertedDomains(r);
            while (assertedDomains.hasNext()) {
                ATermAppl aTermAppl = assertedDomains.next();
                if (!ELSyntaxUtils.isEL(aTermAppl)) {
                    return false;
                }
                this._expressivity.setHasDomain(true);
            }
            Iterator<ATermAppl> iterator = this._KB.getRBox().getAssertedRanges(r);
            while (iterator.hasNext()) {
                ATermAppl range = iterator.next();
                if (!ELSyntaxUtils.isEL(range)) {
                    return false;
                }
                this._expressivity.setHasDomain(true);
            }
        }
        return true;
    }

    @Override
    public boolean updateWith(Expressivity expressivity, ATermAppl term) {
        return false;
    }
}

