/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.el;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.rbox.RBox;
import openllet.core.boxes.rbox.Role;
import openllet.core.el.ELSyntaxUtils;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.iterator.IteratorUtils;

public class RoleRestrictionCache {
    private final Map<ATermAppl, ATermAppl> _domains = CollectionUtils.makeMap();
    private final Map<ATermAppl, ATermAppl> _ranges = CollectionUtils.makeMap();

    public RoleRestrictionCache(RBox rbox) {
        this.prepareDomainsRanges(rbox);
    }

    private void prepareDomainsRanges(RBox rbox) {
        for (Role role : rbox.getRoles().values()) {
            Iterator<ATermAppl> assertedRanges;
            Iterator<ATermAppl> assertedDomains = rbox.getAssertedDomains(role);
            if (assertedDomains.hasNext()) {
                RoleRestrictionCache.addTo(this._domains, role.getName(), IteratorUtils.toSet(assertedDomains));
            }
            if (!(assertedRanges = rbox.getAssertedRanges(role)).hasNext()) continue;
            RoleRestrictionCache.addTo(this._ranges, role.getName(), IteratorUtils.toSet(assertedRanges));
        }
    }

    private static void addTo(Map<ATermAppl, ATermAppl> map, ATermAppl roleName, Set<ATermAppl> asserted) {
        if (asserted.isEmpty()) {
            return;
        }
        ATermAppl range = null;
        range = asserted.size() == 1 ? asserted.iterator().next() : ATermUtils.makeAnd(ATermUtils.toSet(asserted));
        range = ELSyntaxUtils.simplify(ATermUtils.nnf(range));
        map.put(roleName, range);
    }

    public Map<ATermAppl, ATermAppl> getDomains() {
        return this._domains;
    }

    public Map<ATermAppl, ATermAppl> getRanges() {
        return this._ranges;
    }

    public ATermAppl getDomain(ATermAppl prop) {
        return this._domains.get(prop);
    }

    public ATermAppl getRange(ATermAppl prop) {
        return this._ranges.get(prop);
    }
}

