/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.expressivity;

import java.util.Iterator;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.TBox;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.expressivity.Expressivity;
import openllet.core.expressivity.ProfileBasedExpressivityChecker;
import openllet.core.output.ATermBaseVisitor;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;

public class DLExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private static Set<ATermAppl> TOP_SET = SetUtils.singleton(ATermUtils.TOP);
    private final Visitor _visitor = new Visitor();
    private Expressivity _expressivity;

    public DLExpressivityChecker(KnowledgeBase kb) {
        super(kb);
    }

    @Override
    public boolean compute(Expressivity expressivity) {
        this._expressivity = expressivity;
        this.processIndividuals();
        this.processClasses();
        this.processRoles();
        return true;
    }

    @Override
    public boolean updateWith(Expressivity expressivity, ATermAppl term) {
        this._expressivity = expressivity;
        this._visitor.visit(term);
        return true;
    }

    private void processIndividuals() {
        if (!this._KB.getABox().isEmpty()) {
            this._expressivity.setHasIndividual(true);
        }
        IndividualIterator i = this._KB.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            ATermAppl nominal = ATermUtils.makeValue((ATerm)ind.getName());
            for (ATermAppl term : ind.getTypes()) {
                if (term.equals(nominal)) continue;
                this._visitor.visit(term);
            }
        }
    }

    private void processClasses() {
        TBox tbox = this._KB.getTBox();
        for (ATermAppl c : this._KB.getAllClasses()) {
            Iterator<Unfolding> unfoldC = tbox.unfold(c);
            while (unfoldC.hasNext()) {
                Unfolding unf = unfoldC.next();
                this._visitor.visit(unf.getResult());
            }
        }
    }

    private void processRoles() {
        for (Role r : this._KB.getRBox().getRoles().values()) {
            Set<ATermAppl> set;
            Set<ATermAppl> domains;
            if (r.isBuiltin()) continue;
            if (r.isDatatypeRole()) {
                this._expressivity.setHasDatatype(true);
                if (r.isInverseFunctional()) {
                    this._expressivity.setHasKeys(true);
                }
            }
            if (r.isAnon()) {
                for (Role role : r.getSubRoles()) {
                    if (role.isAnon() || role.isBottom()) continue;
                    this._expressivity.setHasInverse(true);
                }
            }
            if (r.isAnon() && r.isFunctional()) {
                this._expressivity.setHasInverse(true);
            }
            if (r.isFunctional()) {
                if (r.isDatatypeRole()) {
                    this._expressivity.setHasFunctionalityD(true);
                } else if (r.isObjectRole()) {
                    this._expressivity.setHasFunctionality(true);
                }
            }
            if (r.isTransitive()) {
                this._expressivity.setHasTransitivity(true);
            }
            if (r.isReflexive()) {
                this._expressivity.setHasReflexivity(true);
            }
            if (r.isIrreflexive()) {
                this._expressivity.setHasIrreflexivity(true);
            }
            if (r.isAsymmetric()) {
                this._expressivity.setHasAsymmetry(true);
            }
            if (!r.getDisjointRoles().isEmpty()) {
                this._expressivity.setHasDisjointRoles(true);
            }
            if (r.hasComplexSubRole()) {
                this._expressivity.setHasComplexSubRoles(true);
            }
            if (r.getSubRoles().size() > 1) {
                this._expressivity.setHasRoleHierarchy(true);
            }
            if (!(domains = r.getDomains()).isEmpty() && !domains.equals(TOP_SET)) {
                this._expressivity.setHasDomain(true);
                for (ATermAppl domain : domains) {
                    this._visitor.visit(domain);
                }
            }
            if ((set = r.getRanges()).isEmpty() || set.equals(TOP_SET)) continue;
            this._expressivity.setHasRange(true);
            for (ATermAppl range : set) {
                this._visitor.visit(range);
            }
        }
    }

    class Visitor
    extends ATermBaseVisitor {
        Visitor() {
        }

        @Override
        public void visitTerm(ATermAppl term) {
        }

        void visitRole(ATermAppl p) {
            if (!ATermUtils.isPrimitive(p)) {
                DLExpressivityChecker.this._expressivity.setHasInverse(true);
                DLExpressivityChecker.this._expressivity.addAnonInverse((ATermAppl)p.getArgument(0));
            }
        }

        @Override
        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        @Override
        public void visitOr(ATermAppl term) {
            DLExpressivityChecker.this._expressivity.setHasNegation(true);
            this.visitList((ATermList)term.getArgument(0));
        }

        @Override
        public void visitNot(ATermAppl term) {
            DLExpressivityChecker.this._expressivity.setHasNegation(true);
            this.visit((ATermAppl)term.getArgument(0));
        }

        @Override
        public void visitSome(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visit((ATermAppl)term.getArgument(1));
        }

        @Override
        public void visitAll(ATermAppl term) {
            DLExpressivityChecker.this._expressivity.setHasAllValues(true);
            ATerm p = term.getArgument(0);
            if (p instanceof ATermAppl) {
                this.visitRole((ATermAppl)p);
            }
            this.visit((ATermAppl)term.getArgument(1));
        }

        @Override
        public void visitCard(ATermAppl term) {
            this.visitMin(term);
            this.visitMax(term);
        }

        @Override
        public void visitMin(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            Role role = DLExpressivityChecker.this._KB.getRole(term.getArgument(0));
            ATermAppl c = (ATermAppl)term.getArgument(2);
            if (!ATermUtils.isTop(c)) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this._expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this._expressivity.setHasCardinalityQ(true);
                }
            } else if (role.isDatatypeRole()) {
                DLExpressivityChecker.this._expressivity.setHasCardinalityD(true);
            } else {
                DLExpressivityChecker.this._expressivity.setHasCardinality(true);
            }
        }

        @Override
        public void visitMax(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            Role role = DLExpressivityChecker.this._KB.getRole(term.getArgument(0));
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            ATermAppl c = (ATermAppl)term.getArgument(2);
            if (!ATermUtils.isTop(c)) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this._expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this._expressivity.setHasCardinalityQ(true);
                }
            } else if (cardinality > 1) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this._expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this._expressivity.setHasCardinality(true);
                }
            }
        }

        @Override
        public void visitHasValue(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visitValue((ATermAppl)term.getArgument(1));
        }

        @Override
        public void visitValue(ATermAppl term) {
            ATermAppl nom = (ATermAppl)term.getArgument(0);
            if (!ATermUtils.isLiteral(nom)) {
                DLExpressivityChecker.this._expressivity.addNominal(nom);
            } else {
                DLExpressivityChecker.this._expressivity.setHasUserDefinedDatatype(true);
            }
        }

        @Override
        public void visitOneOf(ATermAppl term) {
            DLExpressivityChecker.this._expressivity.setHasNegation(true);
            this.visitList((ATermList)term.getArgument(0));
        }

        @Override
        public void visitSelf(ATermAppl term) {
            DLExpressivityChecker.this._expressivity.setHasReflexivity(true);
            DLExpressivityChecker.this._expressivity.setHasIrreflexivity(true);
        }

        @Override
        public void visitInverse(ATermAppl p) {
            DLExpressivityChecker.this._expressivity.setHasInverse(true);
        }

        @Override
        public void visitRestrictedDatatype(ATermAppl dt) {
            DLExpressivityChecker.this._expressivity.setHasDatatype(true);
            DLExpressivityChecker.this._expressivity.setHasUserDefinedDatatype(true);
        }
    }
}

