/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.knowledge;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.rbox.Role;
import openllet.core.knowledge.Base;
import openllet.core.knowledge.MessageBase;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.taxonomy.printer.ClassTreePrinter;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.TermFactory;
import openllet.shared.tools.Logging;

public interface ClassesBase
extends MessageBase,
Logging,
Base {
    @Override
    default public boolean isSubClassOf(ATermAppl subCls, ATermAppl supCls) {
        Bool isSubNode;
        if (null == subCls || null == supCls) {
            return false;
        }
        this.ensureConsistency();
        if (!this.isClass((ATerm)subCls)) {
            Base.handleUndefinedEntity(subCls + " is not a known class!");
            return false;
        }
        if (!this.isClass((ATerm)supCls)) {
            Base.handleUndefinedEntity(supCls + " is not a known class!");
            return false;
        }
        if (subCls.equals(supCls)) {
            return true;
        }
        ATermAppl normalC1 = ATermUtils.normalize(subCls);
        ATermAppl normalC2 = ATermUtils.normalize(supCls);
        if (this.isClassified() && !this.doExplanation() && (isSubNode = this.getTaxonomyBuilder().getTaxonomy().isSubNodeOf(normalC1, normalC2)).isKnown()) {
            return isSubNode.isTrue();
        }
        return this.getABox().isSubClassOf(normalC1, normalC2);
    }

    default public boolean isEquivalentClass(ATermAppl c1, ATermAppl c2) {
        ATermAppl c2NotC1;
        if (null == c1 || null == c2) {
            return false;
        }
        this.ensureConsistency();
        if (!this.isClass((ATerm)c1)) {
            Base.handleUndefinedEntity(c1 + " is not a known class!");
            return false;
        }
        if (!this.isClass((ATerm)c2)) {
            Base.handleUndefinedEntity(c2 + " is not a known class!");
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        ATermAppl normalC1 = ATermUtils.normalize(c1);
        ATermAppl normalC2 = ATermUtils.normalize(c2);
        if (!this.doExplanation()) {
            Bool isEquivalent = Bool.UNKNOWN;
            if (this.isClassified()) {
                isEquivalent = this.getTaxonomyBuilder().getTaxonomy().isEquivalent(normalC1, normalC2);
            }
            if (isEquivalent.isUnknown()) {
                isEquivalent = this.getABox().isKnownSubClassOf(normalC1, normalC2).and(this.getABox().isKnownSubClassOf(normalC2, normalC1));
            }
            if (isEquivalent.isKnown()) {
                return isEquivalent.isTrue();
            }
        }
        ATermAppl notC2 = ATermUtils.negate(normalC2);
        ATermAppl notC1 = ATermUtils.negate(normalC1);
        ATermAppl c1NotC2 = ATermUtils.makeAnd((ATerm)normalC1, (ATerm)notC2);
        ATermAppl test = ATermUtils.makeOr(c1NotC2, c2NotC1 = ATermUtils.makeAnd((ATerm)c2, (ATerm)notC1));
        return !this.isSatisfiable(test);
    }

    default public Set<Set<ATermAppl>> getSubClasses(ATermAppl c, boolean direct) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl normalC = ATermUtils.normalize(c);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
        if (!taxonomy.contains(normalC)) {
            this.getTaxonomyBuilder().classify(normalC);
        }
        HashSet<Set<ATermAppl>> subs = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> s : taxonomy.getSubs(normalC, direct)) {
            Set<ATermAppl> subEqSet = ATermUtils.primitiveOrBottom(s);
            if (subEqSet.isEmpty()) continue;
            subs.add(subEqSet);
        }
        return subs;
    }

    default public Set<Set<ATermAppl>> getDisjointClasses(ATermAppl c, boolean direct) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot((ATerm)c));
        Set<ATermAppl> complements = this.getAllEquivalentClasses(notC);
        if (notC.equals(ATermUtils.BOTTOM)) {
            complements.add(ATermUtils.BOTTOM);
        }
        if (direct && !complements.isEmpty()) {
            return Collections.singleton(complements);
        }
        Set<Set<ATermAppl>> disjoints = this.getSubClasses(notC, direct);
        if (!complements.isEmpty()) {
            disjoints.add(complements);
        }
        return disjoints;
    }

    default public Set<ATermAppl> getAllEquivalentClasses(ATermAppl c) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl normalC = ATermUtils.normalize(c);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
        if (!taxonomy.contains(normalC)) {
            this.getTaxonomyBuilder().classify(normalC);
        }
        return ATermUtils.primitiveOrBottom(taxonomy.getAllEquivalents(normalC));
    }

    default public Bool isKnownType(ATermAppl x, ATermAppl c) {
        if (null == x || null == c) {
            return Bool.FALSE;
        }
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)x)) {
            Base.handleUndefinedEntity(x + " is not an individual!");
            return Bool.FALSE;
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a valid class expression");
            return Bool.FALSE;
        }
        return this.getABox().isKnownType(x, ATermUtils.normalize(c));
    }

    default public boolean isType(ATermAppl x, ATermAppl c) {
        if (null == x || null == c) {
            return false;
        }
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)x)) {
            Base.handleUndefinedEntity(x + " is not an individual!");
            return false;
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        if (this.isRealized() && !this.doExplanation()) {
            Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
            if (taxonomy == null) {
                throw new NullPointerException("Taxonomy is null");
            }
            if (taxonomy.contains(c)) {
                return TaxonomyUtils.isType(taxonomy, x, c);
            }
        }
        return this.getABox().isType(x, c);
    }

    default public boolean hasRange(ATermAppl p, ATermAppl c) {
        if (null == p || null == c) {
            return false;
        }
        if (!this.isClass((ATerm)c) && !this.isDatatype(c)) {
            Base.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        ATermAppl allValues = ATermUtils.makeAllValues((ATerm)p, (ATerm)c);
        return this.isSubClassOf(ATermUtils.TOP, allValues);
    }

    default public boolean isDisjoint(ATermAppl c1, ATermAppl c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        if (this.isClass((ATerm)c1) && this.isClass((ATerm)c2)) {
            return this.isDisjointClass(c1, c2);
        }
        if (this.isProperty((ATerm)c1) && this.isProperty((ATerm)c2)) {
            return this.isDisjointProperty(c1, c2);
        }
        return false;
    }

    default public boolean isDisjointProperty(ATermAppl r1, ATermAppl r2) {
        if (null == r1 || null == r2) {
            return false;
        }
        Role role1 = this.getRole((ATerm)r1);
        Role role2 = this.getRole((ATerm)r2);
        if (role1 == null) {
            Base.handleUndefinedEntity(r1 + " is not a known property!");
            return false;
        }
        if (role2 == null) {
            Base.handleUndefinedEntity(r2 + " is not a known property!");
            return false;
        }
        if (role1.getType() != role2.getType()) {
            return false;
        }
        if (role1.isBottom() || role2.isBottom()) {
            if (this.doExplanation()) {
                this.getABox().setExplanation(DependencySet.INDEPENDENT);
            }
            return true;
        }
        if (role1.isTop() || role2.isTop()) {
            return false;
        }
        if (role1.getSubRoles().contains(role2) || role2.getSubRoles().contains(role1)) {
            return false;
        }
        if (role1.getDisjointRoles().contains(role2) && !this.doExplanation()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl anon = ATermUtils.makeAnonNominal(Integer.MAX_VALUE);
        if (role1.isDatatypeRole()) {
            anon = ATermUtils.makeLiteral(anon);
        }
        ATermAppl nominal = ATermUtils.makeValue((ATerm)anon);
        ATermAppl test = TermFactory.and(TermFactory.some(r1, nominal), TermFactory.some(r2, nominal));
        return !this.getABox().isSatisfiable(test);
    }

    default public boolean isDisjointClass(ATermAppl c1, ATermAppl c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        ATermAppl notC2 = ATermUtils.makeNot((ATerm)c2);
        return this.isSubClassOf(c1, notC2);
    }

    default public boolean isComplement(ATermAppl c1, ATermAppl c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        ATermAppl notC2 = ATermUtils.makeNot((ATerm)c2);
        return this.isEquivalentClass(c1, notC2);
    }

    @Override
    default public Set<Set<ATermAppl>> getSuperClasses(ATermAppl cParam, boolean direct) {
        if (null == cParam) {
            return Collections.emptySet();
        }
        ATermAppl c = cParam;
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        c = ATermUtils.normalize(c);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.getTaxonomyBuilder().getTaxonomy();
        if (!taxonomy.contains(c)) {
            this.getTaxonomyBuilder().classify(c);
        }
        return taxonomy.supers(c, direct).map(ATermUtils::primitiveOrBottom).filter(supEqSet -> !supEqSet.isEmpty()).collect(Collectors.toSet());
    }

    default public Set<ATermAppl> getEquivalentClasses(ATermAppl c) {
        if (null == c) {
            return Collections.emptySet();
        }
        Set<ATermAppl> result = this.getAllEquivalentClasses(c);
        result.remove(c);
        return result;
    }

    default public void printClassTree() {
        this.classify();
        new ClassTreePrinter().print(this.getTaxonomyBuilder().getTaxonomy());
    }
}

