/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import openllet.aterm.ATerm;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.rbox.Role;
import openllet.core.rules.AllNamedIndividualsIterator;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.LiteralFilter;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.DatavaluedPropertyAtom;

public class DatavaluePropertyBindingHelper
implements BindingHelper {
    private final ABox _abox;
    private VariableBinding _binding;
    private Literal _object;
    private Iterator<Literal> _objectIterator;
    private final DatavaluedPropertyAtom _pattern;
    private Role _role;
    private Individual _subject;
    private Iterator<Individual> _subjectIterator;

    public DatavaluePropertyBindingHelper(ABox abox, DatavaluedPropertyAtom pattern) {
        this._abox = abox;
        this._pattern = pattern;
    }

    public Collection<AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
        return VariableUtils.getVars(this._pattern);
    }

    private Literal getObject() {
        return this._binding.get((AtomDObject)this._pattern.getArgument2());
    }

    public Collection<AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return Collections.emptySet();
    }

    private Role getRole() {
        if (this._role == null) {
            this._role = this._abox.getRole((ATerm)this._pattern.getPredicate());
        }
        return this._role;
    }

    private Individual getSubject() {
        return this._binding.get((AtomIObject)this._pattern.getArgument1());
    }

    private boolean isObjectSet() {
        return this._binding.get((AtomDObject)this._pattern.getArgument2()) != null;
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        this._binding = new VariableBinding(newBinding);
        this._subjectIterator = this.getSubject() != null ? Collections.singleton(this.getSubject()).iterator() : new AllNamedIndividualsIterator(this._abox);
    }

    @Override
    public boolean selectNextBinding() {
        if (this._binding == null) {
            return false;
        }
        while (true) {
            if (this._subject == null || this.isObjectSet()) {
                if (!this._subjectIterator.hasNext()) {
                    return false;
                }
                this._subject = this._subjectIterator.next();
                if (!this.isObjectSet()) {
                    this._objectIterator = new LiteralFilter(this._subject.getRNeighbors(this.getRole()).iterator());
                }
            }
            if (this.isObjectSet()) {
                boolean result = this._subject.getRNeighbors(this.getRole()).contains(this.getObject());
                if (!result) continue;
                return true;
            }
            if (this._objectIterator.hasNext()) {
                this._object = this._objectIterator.next();
                return true;
            }
            this._subject = null;
        }
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
        currentBinding.set((AtomIObject)this._pattern.getArgument1(), this._subject);
        currentBinding.set((AtomDObject)this._pattern.getArgument2(), this._object);
    }

    public String toString() {
        return "edges(" + this._pattern + ")";
    }
}

