/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.Arrays;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.builtins.GeneralFunction;
import openllet.core.utils.TermFactory;

public class BooleanOperators {
    public static final GeneralFunction booleanNot;
    private static final ATermAppl TRUE_TERM;
    private static final ATermAppl FALSE_TERM;

    static {
        TRUE_TERM = TermFactory.literal(true);
        FALSE_TERM = TermFactory.literal(false);
        booleanNot = new BooleanNot();
    }

    private static class BooleanNot
    implements GeneralFunction {
        private BooleanNot() {
        }

        @Override
        public boolean apply(ABox abox, Literal[] args) {
            if (args.length != 2) {
                return false;
            }
            if (args[0] == null) {
                if (args[1] != null && args[1].getValue() instanceof Boolean) {
                    args[0] = abox.addLiteral((Boolean)args[1].getValue() != false ? FALSE_TERM : TRUE_TERM);
                    return true;
                }
            } else if (args[1] == null) {
                if (args[0].getValue() instanceof Boolean) {
                    args[1] = abox.addLiteral((Boolean)args[0].getValue() != false ? FALSE_TERM : TRUE_TERM);
                    return true;
                }
            } else if (args[0].getValue() instanceof Boolean && args[1].getValue() instanceof Boolean) {
                return !args[0].equals(args[1]);
            }
            return false;
        }

        @Override
        public boolean isApplicable(boolean[] boundPositions) {
            if (boundPositions.length != 2) {
                return false;
            }
            return !Arrays.equals(boundPositions, new boolean[]{false, false});
        }
    }
}

