/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.builtins.NumericVisitor;

public class NumericPromotion {
    private BigInteger[] _bigIntArgs;
    private BigDecimal[] _decimalArgs;
    private Double[] _doubleArgs;
    private Float[] _floatArgs;
    private Type _type;

    public void accept(NumericVisitor visitor) {
        switch (this._type) {
            case BIGDECIMAL: {
                visitor.visit(this._decimalArgs);
                break;
            }
            case BIGINTEGER: {
                visitor.visit(this._bigIntArgs);
                break;
            }
            case DOUBLE: {
                visitor.visit(this._doubleArgs);
                break;
            }
            case FLOAT: {
                visitor.visit(this._floatArgs);
                break;
            }
            default: {
                throw new InternalReasonerException("Cannot visit _type " + this._type);
            }
        }
    }

    private static Type findHighestType(Number[] nums) {
        Type largest = Type.BYTE;
        for (Number num : nums) {
            Type type = NumericPromotion.findType(num);
            if (!largest.isLessThan(type)) continue;
            largest = type;
        }
        return largest;
    }

    private static Type findType(Number num) {
        if (num instanceof Byte) {
            return Type.BYTE;
        }
        if (num instanceof Short) {
            return Type.SHORT;
        }
        if (num instanceof Integer) {
            return Type.INTEGER;
        }
        if (num instanceof Long) {
            return Type.LONG;
        }
        if (num instanceof BigInteger) {
            return Type.BIGINTEGER;
        }
        if (num instanceof BigDecimal) {
            return Type.BIGDECIMAL;
        }
        if (num instanceof Float) {
            return Type.FLOAT;
        }
        if (num instanceof Double) {
            return Type.DOUBLE;
        }
        throw new InternalReasonerException("Unexpected numeric _type '" + num.getClass() + "': " + num);
    }

    private void prepArray(Type type, int length) {
        this._bigIntArgs = null;
        this._decimalArgs = null;
        this._doubleArgs = null;
        this._floatArgs = null;
        switch (type) {
            case BIGDECIMAL: {
                this._decimalArgs = new BigDecimal[length];
                break;
            }
            case BIGINTEGER: {
                this._bigIntArgs = new BigInteger[length];
                break;
            }
            case DOUBLE: {
                this._doubleArgs = new Double[length];
                break;
            }
            case FLOAT: {
                this._floatArgs = new Float[length];
                break;
            }
            default: {
                throw new InternalReasonerException("Faulty switch: Don't know how to handle '" + type + "'.");
            }
        }
    }

    public void promote(Number ... nums) {
        this.promote(Type.BIGINTEGER, nums);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void promote(Number arg, int position, Type type2) {
        if (type2.isLessThan(Type.BIGINTEGER)) {
            throw new InternalReasonerException("Cannot promote to anything less than BigInteger");
        }
        Type type1 = NumericPromotion.findType(arg);
        if (type2 == Type.DOUBLE) {
            this._doubleArgs[position] = arg.doubleValue();
            return;
        } else if (type2 == Type.FLOAT) {
            this._floatArgs[position] = Float.valueOf(arg.floatValue());
            return;
        } else if (type2 == Type.BIGDECIMAL) {
            if (type1 == Type.BIGDECIMAL) {
                this._decimalArgs[position] = (BigDecimal)arg;
                return;
            } else if (type1 == Type.BIGINTEGER) {
                this._decimalArgs[position] = new BigDecimal((BigInteger)arg, 0, MathContext.DECIMAL128);
                return;
            } else {
                if (!type1.isLessThan(Type.BIGINTEGER)) throw new InternalReasonerException("Do not know how to convert " + type1 + " to BigDecimal.");
                this._decimalArgs[position] = new BigDecimal(arg.longValue(), MathContext.DECIMAL128);
            }
            return;
        } else {
            if (type2 != Type.BIGINTEGER) throw new InternalReasonerException("Do not know how to promote numbers to _type " + type2);
            if (type1 == Type.BIGINTEGER) {
                this._bigIntArgs[position] = (BigInteger)arg;
                return;
            } else {
                if (!type1.isLessThan(Type.BIGINTEGER)) throw new InternalReasonerException("Do not know how to convert " + type1 + " to BigInteger.");
                this._bigIntArgs[position] = new BigDecimal(arg.longValue(), MathContext.DECIMAL128).toBigInteger();
            }
        }
    }

    private void promote(Type minType, Number ... nums) {
        Type largest = NumericPromotion.findHighestType(nums);
        if (largest.isLessThan(minType)) {
            largest = minType;
        }
        this.prepArray(largest, nums.length);
        for (int i = 0; i < nums.length; ++i) {
            this.promote(nums[i], i, largest);
        }
        this._type = largest;
    }

    private static enum Type {
        BIGDECIMAL(5),
        BIGINTEGER(4),
        BYTE(0),
        DOUBLE(7),
        FLOAT(6),
        INTEGER(2),
        LONG(3),
        SHORT(1);

        private final int _rank;

        private Type(int rank) {
            this._rank = rank;
        }

        public boolean isLessThan(Type t) {
            if (t == null) {
                return false;
            }
            return this._rank < t._rank;
        }
    }
}

