/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import openllet.core.DependencySet;
import openllet.core.exceptions.InternalReasonerException;

public class Tuple<T> {
    private final DependencySet _ds;
    private final List<T> _elements;

    @SafeVarargs
    public Tuple(DependencySet ds, T ... elementArgs) {
        if (ds == null) {
            throw new InternalReasonerException("Null dependencyset argument to rete tuple");
        }
        this._ds = ds;
        this._elements = Collections.unmodifiableList(Arrays.asList(elementArgs));
    }

    public Tuple(DependencySet ds, List<T> elements) {
        this._ds = ds;
        this._elements = Collections.unmodifiableList(new ArrayList<T>(elements));
    }

    public DependencySet getDependencySet() {
        return this._ds;
    }

    public List<T> getElements() {
        return this._elements;
    }

    public int hashCode() {
        return this._elements.hashCode();
    }

    public String toString() {
        return this._elements.toString();
    }
}

