/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Arrays;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.utils.ATermUtils;

public abstract class WME {
    public abstract Node getArg(int var1);

    public abstract DependencySet getDepends();

    public boolean dependsOn(int branch) {
        return this.getDepends().max() > branch;
    }

    public abstract Kind getKind();

    public static TypeWME createType(Individual arg, ATermAppl type, DependencySet depends) {
        return new TypeWME(arg, type, depends);
    }

    public static DiffFrom createDiffFrom(Individual subject, Individual object, DependencySet depends) {
        return new DiffFrom(subject, object, depends);
    }

    public static WME createEdge(Edge edge) {
        return new EdgeWME(edge, EdgeDirection.FORWARD);
    }

    public static WME createEdge(Edge edge, EdgeDirection dir) {
        return new EdgeWME(edge, dir);
    }

    public static WME createBuiltin(Literal[] literals, DependencySet ds) {
        return new BuiltinWME(literals, ds);
    }

    public static enum EdgeDirection {
        FORWARD,
        BACKWARD,
        BOTH;

    }

    public static class BuiltinWME
    extends WME {
        private final Literal[] _literals;
        private final DependencySet _depends;

        public BuiltinWME(Literal[] literals, DependencySet depends) {
            this._literals = literals;
            this._depends = depends;
        }

        @Override
        public Kind getKind() {
            return Kind.BUILT_IN;
        }

        @Override
        public Node getArg(int index) {
            return this._literals[index];
        }

        @Override
        public DependencySet getDepends() {
            return this._depends;
        }

        public String toString() {
            return this.getKind() + Arrays.toString(this._literals);
        }
    }

    public static class EdgeWME
    extends WME {
        private final Edge _edge;
        private final EdgeDirection _dir;

        public EdgeWME(Edge edge, EdgeDirection dir) {
            if (dir == null || dir == EdgeDirection.BOTH) {
                throw new IllegalArgumentException();
            }
            this._edge = edge;
            this._dir = dir;
        }

        @Override
        public Kind getKind() {
            return Kind.EDGE;
        }

        @Override
        public Node getArg(int index) {
            assert (index == 0 || index == 1);
            return index == (this._dir == EdgeDirection.FORWARD ? 0 : 1) ? this._edge.getFrom() : this._edge.getTo();
        }

        @Override
        public DependencySet getDepends() {
            return this._edge.getDepends();
        }

        public String toString() {
            boolean isFwd = this._dir == EdgeDirection.FORWARD;
            return String.format("%s%s-%s-%s%s %s", this._edge.getFrom(), isFwd ? "" : "<", this._edge.getRole(), isFwd ? ">" : "", this._edge.getTo(), this._edge.getDepends());
        }
    }

    public static class DiffFrom
    extends BinaryWME {
        public DiffFrom(Individual subject, Individual object, DependencySet depends) {
            super(subject, object, depends);
        }

        @Override
        public Kind getKind() {
            return Kind.DIFF_FROM;
        }
    }

    public static class TypeWME
    extends AbstractWME {
        private final ATermAppl _type;

        public TypeWME(Individual subject, ATermAppl type, DependencySet depends) {
            super(subject, depends);
            this._type = type;
        }

        @Override
        public Kind getKind() {
            return Kind.TYPE;
        }

        @Override
        public Node getArg(int index) {
            assert (index == 0);
            return this._subject;
        }

        public String toString() {
            return ATermUtils.toString(this._type) + "(" + this._subject + ")";
        }
    }

    private static abstract class BinaryWME
    extends AbstractWME {
        private final Individual _object;

        public BinaryWME(Individual subject, Individual object, DependencySet depends) {
            super(subject, depends);
            this._object = object;
        }

        @Override
        public Node getArg(int index) {
            assert (index == 0 || index == 1);
            return index == 0 ? this._subject : this._object;
        }

        public String toString() {
            return this.getKind() + "(" + this._subject + ", " + this._object + ")";
        }
    }

    private static abstract class AbstractWME
    extends WME {
        protected final Individual _subject;
        private final DependencySet _depends;

        public AbstractWME(Individual subject, DependencySet depends) {
            this._subject = subject;
            this._depends = depends;
        }

        @Override
        public DependencySet getDepends() {
            return this._depends;
        }
    }

    public static enum Kind {
        TYPE,
        EDGE,
        SAME_AS,
        DIFF_FROM,
        BUILT_IN;

    }
}

