/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.blocking;

import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.blocking.BlockingCondition;
import openllet.core.tableau.blocking.BlockingContext;
import openllet.core.utils.ATermUtils;

public class Block2All
implements BlockingCondition {
    @Override
    public boolean isBlocked(BlockingContext cxt) {
        for (ATermAppl av : cxt._blocker.getTypes(3)) {
            ATerm p = av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            Role s = cxt._blocked.getABox().getRole(p);
            if (p instanceof ATermList) {
                ATermList chain = (ATermList)p;
                if (Block2All.isBlockedByChain(cxt, chain, c)) continue;
                return false;
            }
            if (s.isDatatypeRole()) continue;
            if (cxt.isRSuccessor(s.getInverse()) && !cxt._blocked.getParent().hasType((ATerm)c)) {
                return false;
            }
            if (s.isSimple()) continue;
            Set<ATermList> subRoleChains = s.getSubRoleChains();
            for (ATermList chain : subRoleChains) {
                if (Block2All.isBlockedByChain(cxt, chain, c)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isBlockedByChain(BlockingContext cxt, ATermList chain, ATermAppl c) {
        Role firstRole = cxt._blocked.getABox().getRole((ATerm)chain.getFirst());
        return !cxt.getIncomingRoles().contains(firstRole.getInverse()) && cxt._blocked.getParent().hasType((ATerm)ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c));
    }
}

