/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.branch;

import java.util.logging.Logger;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Node;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.shared.tools.Log;

public abstract class Branch
implements Comparable<Branch> {
    public static final Logger _logger = Log.getLogger(Branch.class);
    protected final ABox _abox;
    private final int _branchIndexInABox;
    private final int _anonCount;
    private volatile DependencySet _termDepends;
    private volatile DependencySet _combinedClash;
    protected volatile CompletionStrategy _strategy;
    protected volatile int _tryCount;
    protected volatile int _tryNext;
    protected volatile int _nodeCount;

    protected Branch(ABox abox, CompletionStrategy strategy, DependencySet ds, int n) {
        this._abox = abox;
        this._strategy = strategy;
        this._termDepends = ds;
        this._tryCount = n;
        this._combinedClash = DependencySet.EMPTY;
        this._tryNext = 0;
        this._branchIndexInABox = abox.getBranchIndex();
        this._anonCount = abox.getAnonCount();
        this._nodeCount = abox.size();
    }

    protected Branch(ABox abox, int n, Branch br) {
        this._abox = abox;
        this._strategy = br._strategy;
        this._termDepends = br._termDepends;
        this._tryCount = n;
        this._combinedClash = DependencySet.EMPTY;
        this._tryNext = br._tryNext;
        this._branchIndexInABox = br._branchIndexInABox;
        this._anonCount = br._anonCount;
        this._nodeCount = br._nodeCount;
    }

    public void setLastClash(DependencySet ds) {
        if (this.getTryNext() >= 0) {
            this._combinedClash = this._combinedClash.union(ds, this._abox.doExplanation());
            if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                this._abox.getKB().getDependencyIndex().addCloseBranchDependency(this, ds);
            }
        }
    }

    public DependencySet getCombinedClash() {
        return this._combinedClash;
    }

    public void setStrategy(CompletionStrategy strategy) {
        this._strategy = strategy;
    }

    public boolean tryNext() {
        if (this.getTryNext() == this.getTryCount()) {
            if (!this._abox.isClosed()) {
                this._abox.setClash(Clash.unexplained(this.getNode(), this._termDepends));
            } else {
                this._abox.getClash().setDepends(this.getCombinedClash());
            }
        }
        if (!this._abox.isClosed()) {
            this.tryBranch();
        }
        if (this._abox.isClosed() && !OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._abox.getClash().getDepends().remove(this.getBranchIndexInABox());
        }
        return !this._abox.isClosed();
    }

    public abstract Branch copyTo(ABox var1);

    protected abstract void tryBranch();

    public abstract Node getNode();

    public String toString() {
        return "{Branch [" + this.getNode() + "]  n\u00b0: " + this.getBranchIndexInABox() + " tryNext:" + this.getTryNext() + " tryCount:" + this.getTryCount() + "}";
    }

    public abstract void shiftTryNext(int var1);

    public void setNodeCount(int nodeCount) {
        this._nodeCount = nodeCount;
    }

    public int getNodeCount() {
        return this._nodeCount;
    }

    public int getBranchIndexInABox() {
        return this._branchIndexInABox;
    }

    public int getAnonCount() {
        return this._anonCount;
    }

    public void setTryNext(int tryNext) {
        this._tryNext = tryNext;
    }

    public int getTryNext() {
        return this._tryNext;
    }

    public void setTryCount(int tryCount) {
        this._tryCount = tryCount;
    }

    public int getTryCount() {
        return this._tryCount;
    }

    public void setTermDepends(DependencySet termDepends) {
        this._termDepends = termDepends;
    }

    public DependencySet getTermDepends() {
        return this._termDepends;
    }

    @Override
    public int compareTo(Branch that) {
        return this == that ? 0 : this._branchIndexInABox - that._branchIndexInABox;
    }
}

