/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.branch;

import java.util.List;
import java.util.logging.Level;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.abox.NodeMerge;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.branch.IndividualBranch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.utils.ATermUtils;

public class MaxBranch
extends IndividualBranch {
    private final List<NodeMerge> _mergePairs;
    private final Role _r;
    private final int _n;
    private final ATermAppl _qualification;
    private final DependencySet[] _prevDS;

    public MaxBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int n, ATermAppl qualification, List<NodeMerge> mergePairs, DependencySet ds) {
        super(abox, strategy, x, ds, mergePairs.size());
        this._r = r;
        this._n = n;
        this._mergePairs = mergePairs;
        this._qualification = qualification;
        this._prevDS = new DependencySet[mergePairs.size()];
    }

    public MaxBranch(ABox abox, MaxBranch mb) {
        super(abox, mb, mb._mergePairs.size());
        this._mergePairs = mb._mergePairs;
        this._r = mb._r;
        this._n = mb._n;
        this._qualification = mb._qualification;
        this._prevDS = new DependencySet[mb._mergePairs.size()];
        System.arraycopy(mb._prevDS, 0, this._prevDS, 0, this.getTryNext());
        this._ind = abox.getIndividual((ATerm)this._ind.getName());
    }

    @Override
    public IndividualBranch copyTo(ABox abox) {
        return new MaxBranch(abox, this);
    }

    @Override
    protected void tryBranch() {
        this._abox.incrementBranch();
        ATermAppl maxCon = ATermUtils.makeMax((ATerm)this._r.getName(), this._n, (ATerm)this._qualification);
        maxCon = ATermUtils.normalize(maxCon);
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            QueueElement qElement = new QueueElement(this._ind, maxCon);
            this._abox.getCompletionQueue().add(qElement, NodeSelector.MAX_NUMBER);
            this._abox.getCompletionQueue().add(qElement, NodeSelector.CHOOSE);
        }
        DependencySet ds = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            Branch branch;
            this._abox.getKB().getTimers()._mainTimer.check();
            if (OpenlletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.getTryNext(); ++m) {
                    NodeMerge nm = this._mergePairs.get(m);
                    Node y = this._abox.getNode((ATerm)nm.getSource()).getSame();
                    Node z = this._abox.getNode((ATerm)nm.getTarget()).getSame();
                    this._strategy.setDifferent(y, z, this._prevDS[m]);
                }
            }
            NodeMerge nm = this._mergePairs.get(this.getTryNext());
            Node y = this._abox.getNode((ATerm)nm.getSource()).getSame();
            Node z = this._abox.getNode((ATerm)nm.getTarget()).getSame();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("MAX : (" + (this.getTryNext() + 1) + "/" + this._mergePairs.size() + ") at _branch (" + this.getBranchIndexInABox() + ") to  " + this._ind + " for prop " + this._r + " _qualification " + this._qualification + " merge " + y + " -> " + z + " " + ds);
            }
            ds = ds.union(new DependencySet(this.getBranchIndexInABox()), this._abox.doExplanation());
            EdgeList rNeighbors = this._ind.getRNeighborEdges(this._r);
            boolean yEdge = false;
            boolean zEdge = false;
            for (Edge edge : rNeighbors) {
                Node neighbor = edge.getNeighbor(this._ind);
                if (neighbor.equals(y)) {
                    ds = ds.union(edge.getDepends(), this._abox.doExplanation());
                    yEdge = true;
                    continue;
                }
                if (!neighbor.equals(z)) continue;
                ds = ds.union(edge.getDepends(), this._abox.doExplanation());
                zEdge = true;
            }
            if (!yEdge || !zEdge) {
                throw new InternalReasonerException("An error occurred related to the max cardinality restriction about " + this._r);
            }
            ds = ds.union(y.getDepends((ATerm)this._qualification), this._abox.doExplanation());
            ds = ds.union(z.getDepends((ATerm)this._qualification), this._abox.doExplanation());
            for (int b = this._abox.getBranches().size() - 2; b >= 0 && (branch = this._abox.getBranches().get(b)) instanceof MaxBranch; --b) {
                MaxBranch prevBranch = (MaxBranch)branch;
                if (!prevBranch._ind.equals(this._ind) || !prevBranch._r.equals(this._r) || !prevBranch._qualification.equals(this._qualification)) break;
                ds.add(prevBranch.getBranchIndexInABox());
            }
            this._strategy.mergeTo(y, z, ds);
            boolean earlyClash = this._abox.isClosed();
            if (earlyClash) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("CLASH: Branch " + this.getBranchIndexInABox() + " " + this._abox.getClash() + "!");
                }
                if (!(clashDepends = this._abox.getClash().getDepends()).contains(this.getBranchIndexInABox())) {
                    return;
                }
            } else {
                return;
            }
            this._strategy.restore(this);
            this._abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this._tryNext;
        }
        ds = this.getCombinedClash();
        if (!OpenlletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.getBranchIndexInABox());
        }
        if (this._abox.doExplanation()) {
            this._abox.setClash(Clash.maxCardinality(this._ind, ds, this._r.getName(), this._n));
        } else {
            this._abox.setClash(Clash.maxCardinality(this._ind, ds));
        }
    }

    @Override
    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.getTryNext() >= 0) {
            this._prevDS[this.getTryNext()] = ds;
        }
    }

    @Override
    public String toString() {
        if (this.getTryNext() < this._mergePairs.size()) {
            return "Branch " + this.getBranchIndexInABox() + " max rule on " + this._ind + " merged  " + this._mergePairs.get(this.getTryNext());
        }
        return "Branch " + this.getBranchIndexInABox() + " max rule on " + this._ind + " exhausted merge possibilities";
    }

    @Override
    public void shiftTryNext(int openIndex) {
        NodeMerge nm = this._mergePairs.remove(openIndex);
        this._mergePairs.add(nm);
        for (int i = openIndex; i < this._mergePairs.size(); ++i) {
            this._prevDS[i] = this._prevDS[i + 1];
        }
        this._prevDS[this._mergePairs.size() - 1] = null;
        this.setTryNext(this.getTryNext() - 1);
    }
}

