/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.tableau.cache.AbstractConceptCache;
import openllet.core.tableau.cache.CacheSafety;
import openllet.core.tableau.cache.CacheSafetyFactory;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.utils.ATermUtils;

public class ConceptCacheLRU
extends AbstractConceptCache {
    private Map<ATermAppl, CachedNode> _primitive;
    private Map<ATermAppl, CachedNode> _nonPrimitive;
    private CacheSafety _cacheSafety;

    public ConceptCacheLRU(KnowledgeBase kb) {
        this(kb, Integer.MAX_VALUE);
    }

    public ConceptCacheLRU(KnowledgeBase kb, int maxSize) {
        super(maxSize);
        this._cacheSafety = CacheSafetyFactory.createCacheSafety(kb.getExpressivity());
        this._primitive = new ConcurrentHashMap<ATermAppl, CachedNode>();
        this._nonPrimitive = Integer.MAX_VALUE == maxSize ? new ConcurrentHashMap<ATermAppl, CachedNode>() : Collections.synchronizedMap(new LinkedHashMap<ATermAppl, CachedNode>(16, 0.75f, true){
            private static final long serialVersionUID = 3701638684292370398L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<ATermAppl, CachedNode> eldest) {
                return ConceptCacheLRU.this._nonPrimitive.size() > ConceptCacheLRU.this.getMaxSize();
            }
        });
    }

    @Override
    public CacheSafety getSafety() {
        return this._cacheSafety;
    }

    @Override
    public void clear() {
        this._primitive.clear();
        this._nonPrimitive.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._primitive.containsKey(key) || this._nonPrimitive.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._primitive.containsValue(value) || this._nonPrimitive.containsValue(value);
    }

    @Override
    public Set<Map.Entry<ATermAppl, CachedNode>> entrySet() {
        HashSet<Map.Entry<ATermAppl, CachedNode>> returnSet = new HashSet<Map.Entry<ATermAppl, CachedNode>>(this._primitive.entrySet());
        returnSet.addAll(this._nonPrimitive.entrySet());
        return returnSet;
    }

    @Override
    public CachedNode get(Object key) {
        CachedNode node = this._primitive.get(key);
        if (node != null) {
            return node;
        }
        return this._nonPrimitive.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._primitive.isEmpty() && this._nonPrimitive.isEmpty();
    }

    @Override
    public Set<ATermAppl> keySet() {
        HashSet<ATermAppl> keys = new HashSet<ATermAppl>(this._primitive.keySet());
        keys.addAll(this._nonPrimitive.keySet());
        return keys;
    }

    @Override
    public CachedNode put(ATermAppl key, CachedNode value) {
        if (ATermUtils.isPrimitiveOrNegated(key)) {
            CachedNode prev = this._primitive.put(key, value);
            if (this.isFull()) {
                this._nonPrimitive.entrySet();
            }
            return prev;
        }
        return this._nonPrimitive.put(key, value);
    }

    @Override
    public void putAll(Map<? extends ATermAppl, ? extends CachedNode> t) {
        for (Map.Entry<? extends ATermAppl, ? extends CachedNode> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public CachedNode remove(Object key) {
        if (this._primitive.containsKey(key)) {
            return this._primitive.remove(key);
        }
        return this._nonPrimitive.remove(key);
    }

    @Override
    public int size() {
        return this._primitive.size() + this._nonPrimitive.size();
    }

    @Override
    public Collection<CachedNode> values() {
        HashSet<CachedNode> valueSet = new HashSet<CachedNode>(this._primitive.values());
        valueSet.addAll(this._nonPrimitive.values());
        return valueSet;
    }

    public String toString() {
        return "[Cache size: " + this._primitive.size() + "," + this._nonPrimitive.size() + "]";
    }
}

