/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.abox.NodeMerge;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.TBox;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.expressivity.Expressivity;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.tableau.blocking.Blocking;
import openllet.core.tableau.blocking.BlockingFactory;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.branch.GuessBranch;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.tableau.completion.rule.AllValuesRule;
import openllet.core.tableau.completion.rule.ChooseRule;
import openllet.core.tableau.completion.rule.DataCardinalityRule;
import openllet.core.tableau.completion.rule.DataSatisfiabilityRule;
import openllet.core.tableau.completion.rule.DisjunctionRule;
import openllet.core.tableau.completion.rule.GuessRule;
import openllet.core.tableau.completion.rule.MaxCardinalityRule;
import openllet.core.tableau.completion.rule.MinCardinalityRule;
import openllet.core.tableau.completion.rule.NominalRule;
import openllet.core.tableau.completion.rule.SelfRule;
import openllet.core.tableau.completion.rule.SimpleAllValuesRule;
import openllet.core.tableau.completion.rule.SomeValuesRule;
import openllet.core.tableau.completion.rule.TableauRule;
import openllet.core.tableau.completion.rule.UnfoldingRule;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.TermFactory;
import openllet.core.utils.Timer;
import openllet.core.utils.Timers;
import openllet.shared.tools.Log;

public abstract class CompletionStrategy {
    public static final Logger _logger = Log.getLogger(CompletionStrategy.class);
    protected final ABox _abox;
    protected final TBox _tbox;
    protected volatile Blocking _blocking;
    protected final Timers _timers;
    protected final Optional<Timer> _completionTimer;
    private boolean _merging = false;
    private boolean _mergingAll = false;
    protected final List<NodeMerge> _mergeList = new ArrayList<NodeMerge>();
    protected final TableauRule _unfoldingRule = new UnfoldingRule(this);
    protected final TableauRule _disjunctionRule = new DisjunctionRule(this);
    protected final TableauRule _someValuesRule = new SomeValuesRule(this);
    protected final TableauRule _chooseRule = new ChooseRule(this);
    protected final TableauRule _minRule = new MinCardinalityRule(this);
    protected final MaxCardinalityRule _maxRule = new MaxCardinalityRule(this);
    protected final TableauRule _selfRule = new SelfRule(this);
    protected final TableauRule _nominalRule = new NominalRule(this);
    protected final TableauRule _guessRule = new GuessRule(this);
    protected final TableauRule _dataSatRule = new DataSatisfiabilityRule(this);
    protected final TableauRule _dataCardRule = new DataCardinalityRule(this);
    protected volatile AllValuesRule _allValuesRule = new AllValuesRule(this);
    protected final List<TableauRule> _tableauRules = new ArrayList<TableauRule>();

    public CompletionStrategy(ABox abox) {
        this._abox = abox;
        this._tbox = abox.getTBox();
        this._timers = abox.getKB().getTimers();
        this._completionTimer = this._timers.getTimer("complete");
    }

    public ABox getABox() {
        return this._abox;
    }

    public TBox getTBox() {
        return this._tbox;
    }

    public Blocking getBlocking() {
        return this._blocking;
    }

    public void checkTimer() {
        this._completionTimer.ifPresent(t -> t.check());
    }

    public Iterator<Individual> getInitializeIterator() {
        return new IndividualIterator(this._abox);
    }

    protected void configureTableauRules(Expressivity expr) {
        if (!OpenlletOptions.USE_COMPLETION_STRATEGY) {
            this.addAllRules();
            return;
        }
        boolean fullDatatypeReasoning = OpenlletOptions.USE_FULL_DATATYPE_REASONING && (expr.hasUserDefinedDatatype() || expr.hasCardinalityD() || expr.hasKeys());
        this._tableauRules.clear();
        if (!OpenlletOptions.USE_PSEUDO_NOMINALS && expr.hasNominal() || this.implicitNominals()) {
            this._tableauRules.add(this._nominalRule);
            if (expr.hasCardinalityQ()) {
                this._tableauRules.add(this._guessRule);
            }
        }
        if (expr.hasCardinalityQ() || expr.hasCardinalityD()) {
            this._tableauRules.add(this._chooseRule);
        }
        this._tableauRules.add(this._maxRule);
        if (fullDatatypeReasoning) {
            this._tableauRules.add(this._dataCardRule);
        }
        this._tableauRules.add(this._dataSatRule);
        this._tableauRules.add(this._unfoldingRule);
        this._tableauRules.add(this._disjunctionRule);
        this._tableauRules.add(this._someValuesRule);
        this._tableauRules.add(this._minRule);
        this._allValuesRule = expr.hasComplexSubRoles() ? new AllValuesRule(this) : new SimpleAllValuesRule(this);
    }

    protected void addAllRules() {
        this._tableauRules.clear();
        this._tableauRules.add(this._nominalRule);
        this._tableauRules.add(this._guessRule);
        this._tableauRules.add(this._chooseRule);
        this._tableauRules.add(this._maxRule);
        this._tableauRules.add(this._dataCardRule);
        this._tableauRules.add(this._dataSatRule);
        this._tableauRules.add(this._unfoldingRule);
        this._tableauRules.add(this._disjunctionRule);
        this._tableauRules.add(this._someValuesRule);
        this._tableauRules.add(this._minRule);
        this._allValuesRule = new AllValuesRule(this);
    }

    protected boolean implicitNominals() {
        Collection<Rule> rules = this._abox.getKB().getNormalizedRules().values();
        for (Rule rule : rules) {
            if (rule == null) continue;
            for (RuleAtom ruleAtom : rule.getBody()) {
                if (!(ruleAtom instanceof DifferentIndividualsAtom)) continue;
                return true;
            }
            for (RuleAtom ruleAtom : rule.getHead()) {
                if (!(ruleAtom instanceof SameIndividualAtom)) continue;
                return true;
            }
        }
        return false;
    }

    public void initialize(Expressivity expressivity) {
        this._mergeList.clear();
        this._blocking = BlockingFactory.createBlocking(expressivity);
        this.configureTableauRules(expressivity);
        for (Branch branch : this._abox.getBranches()) {
            branch.setStrategy(this);
        }
        if (this._abox.isInitialized()) {
            Iterator<Individual> i = this.getInitializeIterator();
            block1: while (i.hasNext()) {
                Individual n = i.next();
                if (n.isMerged()) continue;
                if (n.isConceptRoot()) {
                    this.applyUniversalRestrictions(n);
                }
                this._allValuesRule.apply(n);
                if (n.isMerged()) continue;
                this._nominalRule.apply(n);
                if (n.isMerged()) continue;
                this._selfRule.apply(n);
                EdgeList allEdges = n.getOutEdges();
                for (int e = 0; e < allEdges.size(); ++e) {
                    Edge edge = (Edge)allEdges.get(e);
                    if (edge.getTo().isPruned()) continue;
                    this.applyPropertyRestrictions(edge);
                    if (n.isMerged()) continue block1;
                }
            }
            return;
        }
        _logger.fine("Initialize started");
        this._abox.setBranchIndex(0);
        this._mergeList.addAll(this._abox.getToBeMerged());
        if (!this._mergeList.isEmpty()) {
            this.mergeAll();
        }
        Role topRole = this._abox.getRole((ATerm)TermFactory.TOP_OBJECT_PROPERTY);
        Iterator<Individual> i = this.getInitializeIterator();
        while (i.hasNext()) {
            Individual n = i.next();
            if (n.isMerged()) continue;
            this.applyUniversalRestrictions(n);
            if (n.isMerged()) continue;
            this._selfRule.apply(n);
            if (n.isMerged()) continue;
            EdgeList allEdges = n.getOutEdges();
            for (int e = 0; e < allEdges.size(); ++e) {
                Edge edge = (Edge)allEdges.get(e);
                if (edge.getTo().isPruned()) continue;
                this.applyPropertyRestrictions(edge);
                if (n.isMerged()) break;
            }
            if (n.isMerged()) continue;
            this.applyPropertyRestrictions(n, topRole, n, DependencySet.INDEPENDENT);
        }
        _logger.fine(() -> "Merging: " + this._mergeList);
        if (!this._mergeList.isEmpty()) {
            this.mergeAll();
        }
        _logger.fine("Initialize finished");
        this._abox.setBranchIndex(this._abox.getBranches().size() + 1);
        this._abox.getStats()._treeDepth = 1;
        this._abox.setChanged(true);
        this._abox.setComplete(false);
        this._abox.setInitialized(true);
    }

    public abstract void complete(Expressivity var1);

    public Individual createFreshIndividual(Individual parent, DependencySet ds) {
        Individual ind = this._abox.addFreshIndividual(parent, ds);
        this.applyUniversalRestrictions(ind);
        return ind;
    }

    public void applyUniversalRestrictions(Individual node) {
        this.addType(node, ATermUtils.TOP, DependencySet.INDEPENDENT);
        Set<Role> reflexives = this._abox.getKB().getRBox().getReflexiveRoles();
        for (Role r : reflexives) {
            _logger.fine(() -> "REF : " + node + " " + r);
            this.addEdge(node, r, node, r.getExplainReflexive());
            if (!node.isMerged()) continue;
            return;
        }
        Role topObjProp = this._abox.getKB().getRole((ATerm)ATermUtils.TOP_OBJECT_PROPERTY);
        for (ATermAppl domain : topObjProp.getDomains()) {
            this.addType(node, domain, topObjProp.getExplainDomain(domain));
            if (!node.isMerged()) continue;
        }
        for (ATermAppl range : topObjProp.getRanges()) {
            this.addType(node, range, topObjProp.getExplainRange(range));
            if (!node.isMerged()) continue;
        }
    }

    public void addType(Node startNode, ATermAppl c, DependencySet ds) {
        Literal l;
        NodeMerge mtc;
        Node node = startNode;
        if (this._abox.isClosed()) {
            return;
        }
        node.addType(c, ds);
        if (node.isLiteral() && (mtc = (l = (Literal)node).getMergeToConstant()) != null) {
            l.clearMergeToConstant();
            Literal mergeTo = this._abox.getLiteral((ATerm)mtc.getTarget());
            this.mergeTo(l, mergeTo, mtc.getDepends());
            node = mergeTo;
        }
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._abox.getKB().getDependencyIndex().addTypeDependency(node.getName(), c, ds);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("ADD: " + node + " " + c + " - " + ds + " " + ds.getExplain());
        }
        if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(node, conj, ds);
                node = node.getSame();
                cs = cs.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this._allValuesRule.applyAllValues((Individual)node, c, ds);
        } else if (c.getAFun().equals(ATermUtils.SELFFUN)) {
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this._abox.getRole((ATerm)pred);
            if (_logger.isLoggable(Level.FINE) && !((Individual)node).hasRSuccessor(role, node)) {
                _logger.fine("SELF: " + node + " " + role + " " + node.getDepends((ATerm)c));
            }
            this.addEdge((Individual)node, role, node, ds);
        }
    }

    protected void updateQueueAddEdge(Individual subj, Role pred, Node obj) {
        Role r;
        ATermAppl max;
        ATermAppl c;
        int j;
        List<ATermAppl> types = subj.getTypes(5);
        int size = types.size();
        for (j = 0; j < size; ++j) {
            c = types.get(j);
            max = (ATermAppl)c.getArgument(0);
            r = this._abox.getRole(max.getArgument(0));
            if (!pred.isSubRoleOf(r)) continue;
            QueueElement newElement = new QueueElement(subj, c);
            this._abox.getCompletionQueue().add(newElement, NodeSelector.MAX_NUMBER);
            this._abox.getCompletionQueue().add(newElement, NodeSelector.CHOOSE);
        }
        if (obj instanceof Individual) {
            types = ((Individual)obj).getTypes(5);
            size = types.size();
            for (j = 0; j < size; ++j) {
                c = types.get(j);
                max = (ATermAppl)c.getArgument(0);
                r = this._abox.getRole(max.getArgument(0));
                Role invR = pred.getInverse();
                if (invR == null || !invR.isSubRoleOf(r)) continue;
                QueueElement newElement = new QueueElement(obj, c);
                this._abox.getCompletionQueue().add(newElement, NodeSelector.MAX_NUMBER);
                this._abox.getCompletionQueue().add(newElement, NodeSelector.CHOOSE);
            }
        }
    }

    public Edge addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = subj.addEdge(pred, obj, ds);
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._abox.getKB().getDependencyIndex().addEdgeDependency(edge, ds);
        }
        if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), subj.getName());
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), obj.getName());
        }
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            this.updateQueueAddEdge(subj, pred, obj);
        }
        if (edge != null) {
            if (subj.isBlockable() && obj.isNominal() && !obj.isLiteral() && pred.isInverseFunctional()) {
                Individual o = (Individual)obj;
                boolean max = true;
                if (!o.hasDistinctRNeighborsForMin(pred.getInverse(), 1, ATermUtils.TOP, true)) {
                    int guessMin = o.getMinCard(pred.getInverse(), ATermUtils.TOP);
                    if (guessMin == 0) {
                        guessMin = 1;
                    }
                    if (guessMin > 1) {
                        return edge;
                    }
                    GuessBranch newBranch = new GuessBranch(this._abox, this, o, pred.getInverse(), guessMin, 1, ATermUtils.TOP, ds);
                    this.addBranch(newBranch);
                    if (!newBranch.tryNext()) {
                        return edge;
                    }
                    if (this._abox.isClosed()) {
                        return edge;
                    }
                    if (subj.isPruned()) {
                        return edge;
                    }
                }
            }
            this.applyPropertyRestrictions(subj, pred, obj, ds);
        }
        return edge;
    }

    public void applyPropertyRestrictions(Edge edge) {
        this.applyPropertyRestrictions(edge.getFrom(), edge.getRole(), edge.getTo(), edge.getDepends());
    }

    public void applyPropertyRestrictions(Individual subj, Role pred, Node obj, DependencySet ds) {
        this.applyDomainRange(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyFunctionality(subj, pred, obj);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyDisjointness(subj, pred, obj, ds);
        this._allValuesRule.applyAllValues(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        if (pred.isObjectRole()) {
            Individual o = (Individual)obj;
            this._allValuesRule.applyAllValues(o, pred.getInverse(), subj, ds);
            this.checkReflexivitySymmetry(subj, pred, o, ds);
            this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
            this.applyDisjointness(o, pred.getInverse(), subj, ds);
        }
    }

    public void applyDomainRange(Individual subj, Role pred, Node obj, DependencySet ds) {
        Set<ATermAppl> domains = pred.getDomains();
        Set<ATermAppl> ranges = pred.getRanges();
        for (ATermAppl domain : domains) {
            if (_logger.isLoggable(Level.FINE) && !subj.hasType((ATerm)domain)) {
                _logger.fine("DOM : " + obj + " <- " + pred + " <- " + subj + " : " + ATermUtils.toString(domain));
            }
            this.addType(subj, domain, ds.union(pred.getExplainDomain(domain), this._abox.doExplanation()));
            if (!subj.isPruned() && !obj.isPruned()) continue;
            return;
        }
        for (ATermAppl range : ranges) {
            if (_logger.isLoggable(Level.FINE) && !obj.hasType((ATerm)range)) {
                _logger.fine("RAN : " + subj + " -> " + pred + " -> " + obj + " : " + ATermUtils.toString(range));
            }
            this.addType(obj, range, ds.union(pred.getExplainRange(range), this._abox.doExplanation()));
            if (!subj.isPruned() && !obj.isPruned()) continue;
            return;
        }
    }

    public void applyFunctionality(Individual subj, Role pred, Node obj) {
        DependencySet maxCardDS;
        DependencySet dependencySet = maxCardDS = pred.isFunctional() ? pred.getExplainFunctional() : subj.hasMax1(pred);
        if (maxCardDS != null) {
            this._maxRule.applyFunctionalMaxRule(subj, pred, ATermUtils.getTop(pred), maxCardDS);
        }
        if (pred.isDatatypeRole() && pred.isInverseFunctional()) {
            this.applyFunctionalMaxRule((Literal)obj, pred, DependencySet.INDEPENDENT);
        } else if (pred.isObjectRole()) {
            Individual val = (Individual)obj;
            Role invR = pred.getInverse();
            DependencySet dependencySet2 = maxCardDS = invR.isFunctional() ? invR.getExplainFunctional() : val.hasMax1(invR);
            if (maxCardDS != null) {
                this._maxRule.applyFunctionalMaxRule(val, invR, ATermUtils.TOP, maxCardDS);
            }
        }
    }

    private void applyDisjointness(Individual subj, Role pred, Node obj, DependencySet dsParam) {
        DependencySet ds = dsParam;
        Set<Role> disjoints = pred.getDisjointRoles();
        if (disjoints.isEmpty()) {
            return;
        }
        EdgeList edges = subj.getEdgesTo(obj);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge otherEdge = (Edge)edges.get(i);
            if (!disjoints.contains(otherEdge.getRole())) continue;
            ds = ds.union(otherEdge.getDepends(), this._abox.doExplanation());
            ds = ds.union(pred.getExplainDisjointRole(otherEdge.getRole()), this._abox.doExplanation());
            this._abox.setClash(Clash.disjointProps(subj, ds, pred.getName(), otherEdge.getRole().getName()));
            return;
        }
    }

    public void checkReflexivitySymmetry(Individual subj, Role pred, Individual obj, DependencySet dsParam) {
        DependencySet ds = dsParam;
        if (pred.isAsymmetric() && obj.hasRSuccessor(pred, subj)) {
            EdgeList edges = obj.getEdgesTo(subj, pred);
            ds = ds.union(((Edge)edges.get(0)).getDepends(), this._abox.doExplanation());
            if (OpenlletOptions.USE_TRACING) {
                ds = ds.union(pred.getExplainAsymmetric(), this._abox.doExplanation());
            }
            this._abox.setClash(Clash.unexplained(subj, ds, "Antisymmetric property " + pred));
        } else if (subj.equals(obj)) {
            if (pred.isIrreflexive()) {
                this._abox.setClash(Clash.unexplained(subj, ds.union(pred.getExplainIrreflexive(), this._abox.doExplanation()), "Irreflexive property " + pred));
            } else {
                ATermAppl notSelfP = ATermUtils.makeNot((ATerm)ATermUtils.makeSelf(pred.getName()));
                if (subj.hasType((ATerm)notSelfP)) {
                    this._abox.setClash(Clash.unexplained(subj, ds.union(subj.getDepends((ATerm)notSelfP), this._abox.doExplanation()), "Local irreflexive property " + pred));
                }
            }
        }
    }

    protected void applyFunctionalMaxRule(Literal x, Role r, DependencySet dsParam) {
        Edge edge;
        DependencySet ds = dsParam;
        EdgeList edges = x.getInEdges().getEdges(r);
        if (edges.size() <= 1) {
            return;
        }
        Set<Node> neighbors = edges.getNeighbors(x);
        if (neighbors.size() <= 1) {
            return;
        }
        Individual head = null;
        DependencySet headDS = null;
        for (int edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
            edge = (Edge)edges.get(edgeIndex);
            Individual ind = edge.getFrom();
            if (!ind.isNominal() || head != null && ind.getNominalLevel() >= head.getNominalLevel()) continue;
            head = ind;
            headDS = edge.getDepends();
        }
        if (head == null) {
            head = this._abox.addFreshIndividual(null, ds);
        } else {
            ds = ds.union(headDS, this._abox.doExplanation());
        }
        for (int i = 0; i < edges.size(); ++i) {
            edge = (Edge)edges.get(i);
            Individual next = edge.getFrom();
            if (next.isPruned() || head.isSame(next)) continue;
            ds = ds.union(edge.getDepends(), this._abox.doExplanation());
            if (next.isDifferent(head)) {
                ds = ds.union(next.getDifferenceDependency(head), this._abox.doExplanation());
                if (r.isFunctional()) {
                    this._abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                    break;
                }
                this._abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                break;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
            }
            this.mergeTo(next, head, ds);
            if (this._abox.isClosed()) {
                return;
            }
            if (!head.isPruned()) continue;
            ds = ds.union(head.getMergeDependency(true), this._abox.doExplanation());
            head = head.getSame();
        }
    }

    private void mergeLater(Node y, Node z, DependencySet ds) {
        this._mergeList.add(new NodeMerge(y, z, ds));
    }

    public void mergeAll() {
        if (this._mergingAll) {
            return;
        }
        this._mergingAll = true;
        while (!(this._merging || this._mergeList.isEmpty() || this._abox.isClosed())) {
            NodeMerge merge = this._mergeList.remove(0);
            Node y = this._abox.getNode((ATerm)merge.getSource());
            Node z = this._abox.getNode((ATerm)merge.getTarget());
            DependencySet ds = merge.getDepends();
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this._abox.doExplanation());
                y = y.getSame();
            }
            if (z.isMerged()) {
                ds = ds.union(z.getMergeDependency(true), this._abox.doExplanation());
                z = z.getSame();
            }
            if (y.isPruned() || z.isPruned()) continue;
            this.mergeTo(y, z, ds);
        }
        this._mergingAll = false;
    }

    public void mergeTo(Node y, Node z, DependencySet dsParam) {
        DependencySet ds = dsParam;
        if (this._abox.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), y.getName());
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), z.getName());
        }
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._abox.getKB().getDependencyIndex().addMergeDependency(y.getName(), z.getName(), ds);
        }
        if (y.isDifferent(z)) {
            this._abox.setClash(Clash.nominal(y, y.getDifferenceDependency(z).union(ds, this._abox.doExplanation())));
            return;
        }
        if (!y.isSame(z)) {
            this._abox.setChanged(true);
            if (this._merging) {
                this.mergeLater(y, z, ds);
                return;
            }
            this._merging = true;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("MERG: " + y + " -> " + z + " " + ds);
            }
            ds = ds.copy(this._abox.getBranchIndex());
            if (y instanceof Literal && z instanceof Literal) {
                this.mergeLiterals((Literal)y, (Literal)z, ds);
            } else if (y instanceof Individual && z instanceof Individual) {
                this.mergeIndividuals((Individual)y, (Individual)z, ds);
            } else {
                throw new InternalReasonerException("Invalid merge operation!");
            }
        }
        this._merging = false;
        this.mergeAll();
    }

    protected boolean mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        boolean merged = y.setSame(x, ds);
        if (!merged) {
            return false;
        }
        x.setNominalLevel(Math.min(x.getNominalLevel(), y.getNominalLevel()));
        Map<ATermAppl, DependencySet> types = y.getDepends();
        for (Map.Entry<ATermAppl, DependencySet> entry : types.entrySet()) {
            ATermAppl yType = entry.getKey();
            DependencySet finalDS = ds.union(entry.getValue(), this._abox.doExplanation());
            this.addType(x, yType, finalDS);
        }
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = (Edge)inEdges.get(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this._abox.doExplanation());
            if (y.equals(z)) {
                this.addEdge(x, r, x, finalDS);
            } else if (x.hasSuccessor(z)) {
                this.addEdge(x, r.getInverse(), z, finalDS);
            } else {
                this.addEdge(z, r, x, finalDS);
            }
            z.removeEdge(edge);
            if (this._abox.getBranchIndex() < 0 || !OpenlletOptions.TRACK_BRANCH_EFFECTS) continue;
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
        EdgeList outEdges = y.getOutEdges();
        for (int e = 0; e < outEdges.size(); ++e) {
            Edge edge = (Edge)outEdges.get(e);
            Node z = edge.getTo();
            if (!z.isNominal() || y.equals(z)) continue;
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this._abox.doExplanation());
            this.addEdge(x, r, z, finalDS);
            if (this._abox.getBranchIndex() < 0 || !OpenlletOptions.TRACK_BRANCH_EFFECTS) continue;
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), z.getName());
        }
        return true;
    }

    protected void mergeLiterals(Literal y, Literal x, DependencySet ds) {
        y.setSame(x, ds);
        x.addAllTypes(y.getDepends(), ds);
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = (Edge)inEdges.get(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this._abox.doExplanation());
            this.addEdge(z, r, x, finalDS);
            z.removeEdge(edge);
            if (this._abox.getBranchIndex() < 0 || !OpenlletOptions.TRACK_BRANCH_EFFECTS) continue;
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
        if (x.getNodeDepends() == null || y.getNodeDepends() == null) {
            throw new OpenError("No node depend.");
        }
    }

    public boolean setDifferent(Node y, Node z, DependencySet ds) {
        return y.setDifferent(z, ds);
    }

    public void restoreLocal(Individual ind, Branch br) {
        ++this._abox.getStats()._localRestores;
        this._abox.setClash(null);
        this._abox.setBranchIndex(br.getBranchIndexInABox());
        HashMap<Node, Boolean> visited = new HashMap<Node, Boolean>();
        this.restoreLocal(ind, br.getBranchIndexInABox(), visited);
        for (Map.Entry entry : visited.entrySet()) {
            boolean restored = (Boolean)entry.getValue();
            if (!restored) continue;
            this._allValuesRule.apply((Individual)entry.getKey());
        }
    }

    private void restoreLocal(Individual ind, int branch, Map<Node, Boolean> visited) {
        boolean restored = ind.restore(branch);
        visited.put(ind, restored);
        if (restored) {
            for (Edge edge : ind.getOutEdges()) {
                Node succ = edge.getTo();
                if (visited.containsKey(succ)) continue;
                if (succ.isLiteral()) {
                    visited.put(succ, Boolean.FALSE);
                    succ.restore(branch);
                    continue;
                }
                this.restoreLocal((Individual)succ, branch, visited);
            }
            for (Edge edge : ind.getInEdges()) {
                Individual pred = edge.getFrom();
                if (visited.containsKey(pred)) continue;
                this.restoreLocal(pred, branch, visited);
            }
        }
    }

    public void restore(Branch br) {
        this._abox.setBranchIndex(br.getBranchIndexInABox());
        this._abox.setClash(null);
        this._abox.setRulesNotApplied(true);
        this._mergeList.clear();
        List<ATermAppl> nodeList = this._abox.getNodeNames();
        _logger.fine(() -> "RESTORE: Branch " + br.getBranchIndexInABox());
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            this._abox.getCompletionQueue().clearQueue(NodeSelector.UNIVERSAL);
            this._abox.getCompletionQueue().restore(br.getBranchIndexInABox());
        }
        if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this._abox.getIncrementalChangeTracker().clear();
        }
        int nodeCount = nodeList.size();
        int deleteBlock = 0;
        for (int i = 0; i < nodeCount; ++i) {
            ATermAppl a = nodeList.get(i);
            Node node = this._abox.getNode((ATerm)a);
            if (node.getNodeDepends() == null || node.getNodeDepends().getBranch() > br.getBranchIndexInABox()) {
                this._abox.removeNode(a);
                if (node.isMerged()) {
                    node.undoSetSame();
                }
                ++deleteBlock;
                continue;
            }
            if (deleteBlock > 0) {
                List<ATermAppl> subList = nodeList.subList(i - deleteBlock, i);
                _logger.fine(() -> "Remove nodes " + subList);
                subList.clear();
                nodeCount -= deleteBlock;
                i -= deleteBlock;
                deleteBlock = 0;
            }
            if (OpenlletOptions.TRACK_BRANCH_EFFECTS) continue;
            node.restore(br.getBranchIndexInABox());
        }
        if (deleteBlock > 0) {
            nodeList.subList(nodeCount - deleteBlock, nodeCount).clear();
        }
        if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            Set<ATermAppl> effected = this._abox.getBranchEffectTracker().removeAll(br.getBranchIndexInABox() + 1);
            for (ATermAppl a : effected) {
                Node n = this._abox.getNode((ATerm)a);
                if (n == null) continue;
                n.restore(br.getBranchIndexInABox());
            }
        }
        this.restoreAllValues();
        if (_logger.isLoggable(Level.FINE)) {
            this._abox.printTree();
        }
        if (!this._abox.isClosed()) {
            this._abox.validate();
        }
    }

    public void addBranch(Branch newBranch) {
        this._abox.getBranches().add(newBranch);
        if (newBranch.getBranchIndexInABox() != this._abox.getBranches().size()) {
            throw new OpenError("Invalid branch created: " + newBranch.getBranchIndexInABox() + " != " + this._abox.getBranches().size());
        }
        this._completionTimer.ifPresent(t -> t.check());
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._abox.getKB().getDependencyIndex().addBranchAddDependency(newBranch);
        }
    }

    public void printBlocked() {
        int blockedCount = 0;
        StringBuilder blockedNodes = new StringBuilder();
        IndividualIterator n = this._abox.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            ATermAppl x = node.getName();
            if (!this._blocking.isBlocked(node)) continue;
            ++blockedCount;
            blockedNodes.append(x).append(" ");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Blocked nodes " + blockedCount + " [" + blockedNodes + "]");
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        int lastIndex = name.lastIndexOf(46);
        return name.substring(lastIndex + 1);
    }

    protected void restoreAllValues() {
        IndividualIterator i = new IndividualIterator(this._abox);
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this._allValuesRule.apply(ind);
        }
    }
}

