/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.incremental;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.incremental.AddBranchDependency;
import openllet.core.tableau.completion.incremental.ClashDependency;
import openllet.core.tableau.completion.incremental.CloseBranchDependency;
import openllet.core.tableau.completion.incremental.DependencyEntry;
import openllet.core.tableau.completion.incremental.DependencyIndex;
import openllet.core.tableau.completion.incremental.MergeDependency;
import openllet.core.tableau.completion.incremental.TypeDependency;
import openllet.core.tracker.IncrementalChangeTracker;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.intset.IntSet;

public class IncrementalRestore {
    private final KnowledgeBase _kb;

    public static void restoreDependencies(KnowledgeBase kb) {
        new IncrementalRestore(kb).restoreDependencies();
    }

    private IncrementalRestore(KnowledgeBase kb) {
        this._kb = kb;
    }

    private static void phase1(AddBranchDependency branch, ABox abox) {
        List<ATermAppl> allEffects = OpenlletOptions.TRACK_BRANCH_EFFECTS ? abox.getBranchEffectTracker().getAll(branch.getBranch().getBranchIndexInABox()) : abox.getNodeNames();
        ArrayList<IntSet> updatedList = new ArrayList<IntSet>();
        for (ATermAppl a : allEffects) {
            int i;
            boolean exit;
            DependencySet tDS;
            Node node = abox.getNode((ATerm)a);
            for (Map.Entry<ATermAppl, DependencySet> entry : node.getDepends().entrySet()) {
                tDS = entry.getValue();
                exit = false;
                for (i = 0; i < updatedList.size(); ++i) {
                    if (updatedList.get(i) != tDS.getDepends()) continue;
                    exit = true;
                }
                if (exit) continue;
                updatedList.add(tDS.getDepends());
                if (tDS.getBranch() > branch.getBranch().getBranchIndexInABox()) {
                    tDS = tDS.copy(tDS.getBranch() - 1);
                }
                for (i = branch.getBranch().getBranchIndexInABox(); i <= abox.getBranches().size(); ++i) {
                    if (!tDS.contains(i)) continue;
                    tDS.remove(i);
                    tDS.add(i - 1);
                }
                entry.setValue(tDS);
            }
            for (Edge edge : node.getInEdges()) {
                tDS = edge.getDepends();
                exit = false;
                for (i = 0; i < updatedList.size(); ++i) {
                    if (updatedList.get(i) != tDS.getDepends()) continue;
                    exit = true;
                }
                if (exit) continue;
                updatedList.add(tDS.getDepends());
                if (tDS.getBranch() > branch.getBranch().getBranchIndexInABox()) {
                    tDS = tDS.copy(edge.getDepends().getBranch() - 1);
                }
                for (i = branch.getBranch().getBranchIndexInABox(); i <= abox.getBranches().size(); ++i) {
                    if (!tDS.contains(i)) continue;
                    tDS.remove(i);
                    tDS.add(i - 1);
                }
                edge.setDepends(tDS);
            }
        }
    }

    private void updateBranchesOfABox(AddBranchDependency branch, ABox abox) {
        List<Branch> branches = abox.getBranches();
        for (int i = branch.getBranch().getBranchIndexInABox(); i < branches.size(); ++i) {
            Branch br = branches.get(i);
            DependencySet termDepends = br.getTermDepends();
            if (termDepends.getBranch() > branch.getBranch().getBranchIndexInABox()) {
                termDepends = termDepends.copy(termDepends.getBranch() - 1);
            }
            for (int j = branch.getBranch().getBranchIndexInABox(); j < this._kb.getABox().getBranches().size(); ++j) {
                if (!termDepends.contains(j)) continue;
                termDepends.remove(j);
                termDepends.add(j - 1);
                break;
            }
            br.setTermDepends(termDepends);
        }
        branches.remove(branch.getBranch());
    }

    private void restoreBranchAdd(ATermAppl assertion, AddBranchDependency branch) {
        DependencyIndex._logger.fine(() -> "    Removing branch add? " + branch.getBranch());
        DependencySet ds = branch.getBranch().getTermDepends();
        ds.removeExplain(assertion);
        if (ds.getExplain().isEmpty()) {
            DependencyIndex._logger.fine("           Actually removing branch!");
            ABox abox = this._kb.getABox();
            IncrementalRestore.phase1(branch, abox);
            if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
                abox.getBranchEffectTracker().remove(branch.getBranch().getBranchIndexInABox() + 1);
            }
            this.updateBranchesOfABox(branch, abox);
            abox.setBranchIndex(abox.getBranchIndex() - 1);
        }
    }

    private void restoreClash(ATermAppl assertion, ClashDependency clash) {
        DependencyIndex._logger.fine(() -> "    Restoring clash dependency clash: " + clash.getClash());
        clash.getClash().getDepends().removeExplain(assertion);
        if (clash.getClash().getDepends().getExplain().isEmpty() && clash.getClash().getDepends().isIndependent()) {
            DependencyIndex._logger.fine(() -> "           Actually removing clash!");
            this._kb.getABox().setClash(null);
        }
    }

    private static void restoreCloseBranch(ATermAppl assertion, CloseBranchDependency branch) {
        if (branch.getCloseBranch().getTryNext() > -1) {
            DependencyIndex._logger.fine(() -> "    Undoing branch remove - _branch " + branch.getBranch() + "  -  " + branch.getInd() + "   _tryNext: " + branch.getTryNext());
            branch.getCloseBranch().shiftTryNext(branch.getTryNext());
        }
    }

    private void restoreDependencies() {
        for (ATermAppl next : this._kb.getDeletedAssertions()) {
            DependencyEntry entry = this._kb.getDependencyIndex().getDependencies(next);
            if (entry != null) {
                DependencyIndex._logger.fine(() -> "Restoring dependencies for " + next);
                this.restoreDependency(next, entry);
            }
            this._kb.getDependencyIndex().removeDependencies(next);
        }
    }

    private void restoreDependency(ATermAppl assertion, DependencyEntry entry) {
        DependencyIndex._logger.fine(() -> "  Restoring Edge Dependencies:");
        for (Edge edge : entry.getEdges()) {
            this.restoreEdge(assertion, edge);
        }
        DependencyIndex._logger.fine(() -> "  Restoring Type Dependencies:");
        for (TypeDependency typeDependency : entry.getTypes()) {
            this.restoreType(assertion, typeDependency);
        }
        DependencyIndex._logger.fine(() -> "  Restoring Merge Dependencies: " + entry.getMerges());
        for (MergeDependency mergeDependency : entry.getMerges()) {
            this.restoreMerge(assertion, mergeDependency);
        }
        DependencyIndex._logger.fine(() -> "  Restoring Branch Add Dependencies: " + entry.getBranchAdds());
        for (AddBranchDependency addBranchDependency : entry.getBranchAdds()) {
            this.restoreBranchAdd(assertion, addBranchDependency);
        }
        DependencyIndex._logger.fine(() -> "  Restoring Branch Remove DS Dependencies: " + entry.getBranchAdds());
        for (CloseBranchDependency closeBranchDependency : entry.getCloseBranches()) {
            IncrementalRestore.restoreCloseBranch(assertion, closeBranchDependency);
        }
        DependencyIndex._logger.fine(() -> "  Restoring clash dependency: " + entry.getClash());
        entry.getClash().ifPresent(clash -> this.restoreClash(assertion, (ClashDependency)clash));
    }

    private void restoreEdge(ATermAppl assertion, Edge theEdge) {
        DependencyIndex._logger.fine(() -> "    Removing edge? " + theEdge);
        if (theEdge == null) {
            return;
        }
        Individual subj = this._kb.getABox().getIndividual((ATerm)theEdge.getFrom().getName());
        Node obj = this._kb.getABox().getNode((ATerm)theEdge.getTo().getName());
        Role role = this._kb.getRole((ATerm)theEdge.getRole().getName());
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = (Edge)edges.get(i);
            if (!edge.getRole().equals(role)) continue;
            DependencySet ds = edge.getDepends();
            ds.removeExplain(assertion);
            if (!ds.getExplain().isEmpty()) break;
            IncrementalChangeTracker tracker = this._kb.getABox().getIncrementalChangeTracker();
            subj.removeEdge(edge);
            obj.removeInEdge(edge);
            tracker.addDeletedEdge(edge);
            tracker.addUpdatedIndividual(subj);
            if (obj instanceof Individual) {
                tracker.addUpdatedIndividual((Individual)obj);
            }
            DependencyIndex._logger.fine("           Actually removed edge!");
            break;
        }
    }

    private void restoreMerge(ATermAppl assertion, MergeDependency merge) {
        DependencyIndex._logger.fine(() -> "    Removing merge? " + merge.getInd() + " merged to " + merge.getmergedIntoInd());
        DependencySet ds = this._kb.getABox().getNode((ATerm)merge.getInd()).getMergeDependency(false);
        ds.removeExplain(assertion);
        if (ds.getExplain().isEmpty()) {
            DependencyIndex._logger.fine(() -> "           Actually removing merge!");
            Node ind = this._kb.getABox().getNode((ATerm)merge.getInd());
            Node mergedToInd = this._kb.getABox().getNode((ATerm)merge.getmergedIntoInd());
            if (!ind.isSame(mergedToInd)) {
                throw new InternalReasonerException(" Restore merge error: " + ind + " not same as " + mergedToInd);
            }
            if (!ind.isPruned()) {
                throw new InternalReasonerException(" Restore merge error: " + ind + " not pruned");
            }
            ind.unprune(ind.getPruned().getBranch());
            ind.undoSetSame();
            IncrementalChangeTracker tracker = this._kb.getABox().getIncrementalChangeTracker();
            tracker.addUnprunedNode(ind);
            if (ind instanceof Individual) {
                tracker.addUpdatedIndividual((Individual)ind);
            }
            if (mergedToInd instanceof Individual) {
                tracker.addUpdatedIndividual((Individual)mergedToInd);
            }
        }
    }

    private void restoreType(ATermAppl assertion, TypeDependency type) {
        Node node = this._kb.getABox().getNode((ATerm)type.getInd());
        ATermAppl desc = type.getType();
        DependencyIndex._logger.fine(() -> "    Removing type? " + desc + " from " + (node instanceof Individual ? ((Individual)node).debugString() : node));
        DependencySet ds = node.getDepends((ATerm)ATermUtils.normalize(desc));
        if (ds == null || desc == ATermUtils.TOP) {
            return;
        }
        ds.removeExplain(assertion);
        if (ds.getExplain().isEmpty()) {
            IncrementalChangeTracker tracker = this._kb.getABox().getIncrementalChangeTracker();
            this._kb.getABox().removeType(node.getName(), desc);
            tracker.addDeletedType(node, type.getType());
            if (node instanceof Individual) {
                Individual ind = (Individual)node;
                tracker.addUpdatedIndividual(ind);
                for (Edge e : ind.getInEdges()) {
                    tracker.addUpdatedIndividual(e.getFrom());
                }
                for (Edge e : ind.getOutEdges()) {
                    if (!(e.getTo() instanceof Individual)) continue;
                    tracker.addUpdatedIndividual((Individual)e.getTo());
                }
            }
            DependencyIndex._logger.fine("           Actually removed type!");
        }
    }
}

