/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class AllValuesRule
extends AbstractTableauRule {
    public AllValuesRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.UNIVERSAL, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual x) {
        List<ATermAppl> allValues = x.getTypes(3);
        int size = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            DependencySet avDepends = x.getDepends((ATerm)av);
            if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && avDepends == null) continue;
            this.applyAllValues(x, av, avDepends);
            if (x.isMerged() || this._strategy.getABox().isClosed()) {
                return;
            }
            if (size == allValues.size()) continue;
            i = allValues.iterator();
            size = allValues.size();
        }
    }

    public void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        if (av.getArity() == 0) {
            throw new InternalReasonerException();
        }
        ATerm p = av.getArgument(0);
        ATermAppl c = (ATermAppl)av.getArgument(1);
        ATermList roleChain = ATermUtils.EMPTY_LIST;
        Role s = null;
        if (p.getType() == 4) {
            roleChain = (ATermList)p;
            s = this._strategy.getABox().getRole((ATerm)roleChain.getFirst());
            roleChain = roleChain.getNext();
        } else {
            s = this._strategy.getABox().getRole(p);
        }
        if (null == s) {
            _logger.severe(() -> "[1] Role " + p + " of " + av + "  is null.");
            return;
        }
        if (s.isTop() && s.isObjectRole()) {
            this.applyAllValuesTop(av, c, ds);
            return;
        }
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = (Edge)edges.get(e);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this._strategy.getABox().doExplanation());
            if (roleChain.isEmpty()) {
                this.applyAllValues(x, s, y, c, finalDS);
            } else if (y.isIndividual()) {
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)roleChain, (ATerm)c);
                this._strategy.addType(y, allRC, finalDS);
            }
            if (!x.isMerged() && !this._strategy.getABox().isClosed()) continue;
            return;
        }
        if (!s.isSimple()) {
            Set<ATermList> subRoleChains = s.getSubRoleChains();
            for (ATermList chain : subRoleChains) {
                DependencySet subChainDS;
                if (this.applyAllValuesPropertyChain(x, chain, c, subChainDS = ds.union(s.getExplainSub((ATerm)chain), this._strategy.getABox().doExplanation()))) continue;
                return;
            }
        }
        if (!roleChain.isEmpty()) {
            this.applyAllValuesPropertyChain(x, (ATermList)p, c, ds);
        }
    }

    protected boolean applyAllValuesPropertyChain(Individual x, ATermList chain, ATermAppl c, DependencySet ds) {
        Role r = this._strategy.getABox().getRole((ATerm)chain.getFirst());
        EdgeList edges = x.getRNeighborEdges(r);
        if (!edges.isEmpty()) {
            ATermAppl allRC = ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c);
            for (int e = 0; e < edges.size(); ++e) {
                Edge edgeToY = (Edge)edges.get(e);
                Node y = edgeToY.getNeighbor(x);
                DependencySet finalDS = ds.union(edgeToY.getDepends(), this._strategy.getABox().doExplanation());
                this.applyAllValues(x, r, y, allRC, finalDS);
                if (!x.isMerged() && !this._strategy.getABox().isClosed()) continue;
                return false;
            }
        }
        return true;
    }

    protected void applyAllValues(Individual subj, Role pred, Node obj, ATermAppl c, DependencySet ds) {
        if (!obj.hasType((ATerm)c)) {
            _logger.fine(() -> "ALL : " + subj + " -> " + pred + " -> " + obj + " : " + ATermUtils.toString(c) + " - " + ds);
            if (obj.isPruned()) {
                return;
            }
            this._strategy.addType(obj, c, ds);
        }
    }

    public void applyAllValues(Individual subj, Role pred, Node startNode, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int allValuesSize = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        Node obj = startNode;
        while (i.hasNext()) {
            DependencySet finalDS;
            ATermAppl av = i.next();
            ATerm p = av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            ATermList roleChain = ATermUtils.EMPTY_LIST;
            Role s = null;
            if (p.getType() == 4) {
                roleChain = (ATermList)p;
                s = this._strategy.getABox().getRole((ATerm)roleChain.getFirst());
                roleChain = roleChain.getNext();
            } else {
                s = this._strategy.getABox().getRole(p);
            }
            if (null == s) {
                _logger.severe(() -> "[2] Role " + p + " of " + av + "  is null.");
                return;
            }
            if (s.isTop() && s.isObjectRole()) {
                this.applyAllValuesTop(av, c, ds);
                if (!this._strategy.getABox().isClosed()) continue;
                return;
            }
            if (pred.isSubRoleOf(s)) {
                finalDS = subj.getDepends((ATerm)av);
                finalDS = finalDS.union(ds, this._strategy.getABox().doExplanation());
                finalDS = finalDS.union(s.getExplainSubOrInv(pred), this._strategy.getABox().doExplanation());
                if (roleChain.isEmpty()) {
                    this.applyAllValues(subj, s, obj, c, finalDS);
                } else if (obj.isIndividual()) {
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)roleChain, (ATerm)c);
                    this._strategy.addType(obj, allRC, finalDS);
                }
                if (this._strategy.getABox().isClosed()) {
                    return;
                }
            }
            if (!s.isSimple()) {
                finalDS = subj.getDepends((ATerm)av).union(ds, this._strategy.getABox().doExplanation());
                Set<ATermList> subRoleChains = s.getSubRoleChains();
                for (ATermList chain : subRoleChains) {
                    Role firstRole = this._strategy.getABox().getRole((ATerm)chain.getFirst());
                    if (!pred.isSubRoleOf(firstRole)) continue;
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c);
                    this.applyAllValues(subj, pred, obj, allRC, finalDS.union(firstRole.getExplainSub((ATerm)pred.getName()), this._strategy.getABox().doExplanation()).union(s.getExplainSub((ATerm)chain), this._strategy.getABox().doExplanation()));
                    if (!subj.isMerged() && !this._strategy.getABox().isClosed()) continue;
                    return;
                }
            }
            if (subj.isMerged()) {
                return;
            }
            obj = obj.getSame();
            if (allValuesSize == allValues.size()) continue;
            i = allValues.iterator();
            allValuesSize = allValues.size();
        }
    }

    public void applyAllValuesTop(ATermAppl allTopC, ATermAppl c, DependencySet ds) {
        for (Node node : this._strategy.getABox().getNodes().values()) {
            if (!node.isIndividual() || node.isPruned() || node.hasType((ATerm)c)) continue;
            node.addType(c, ds);
            node.addType(allTopC, ds);
            if (!this._strategy.getABox().isClosed()) continue;
            break;
        }
    }
}

