/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.List;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.branch.ChooseBranch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class ChooseRule
extends AbstractTableauRule {
    public ChooseRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.CHOOSE, AbstractTableauRule.BlockingType.INDIRECT);
    }

    @Override
    public void apply(Individual x) {
        if (!x.canApply(5)) {
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (ATermAppl maxCard : maxCardinality) {
            this.apply(x, maxCard);
        }
    }

    protected void apply(Individual x, ATermAppl maxCard) {
        ATermAppl max = (ATermAppl)maxCard.getArgument(0);
        Role r = this._strategy.getABox().getRole(max.getArgument(0));
        ATermAppl c = (ATermAppl)max.getArgument(2);
        if (ATermUtils.isTop(c)) {
            return;
        }
        if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends((ATerm)maxCard) == null) {
            return;
        }
        EdgeList edges = x.getRNeighborEdges(r);
        for (Edge edge : edges) {
            Node neighbor = edge.getNeighbor(x);
            if (neighbor.hasType((ATerm)c) || neighbor.hasType((ATerm)ATermUtils.negate(c))) continue;
            ChooseBranch newBranch = new ChooseBranch(this._strategy.getABox(), this._strategy, neighbor, c, x.getDepends((ATerm)maxCard));
            this._strategy.addBranch(newBranch);
            newBranch.tryNext();
            if (!this._strategy.getABox().isClosed()) continue;
            return;
        }
    }
}

