/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;

public class DataCardinalityRule
extends AbstractTableauRule {
    public DataCardinalityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DATATYPE, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual x) {
        Role role;
        ATermAppl r;
        DependencySet ds;
        Collection<Object> existing;
        HashMap dataranges = new HashMap();
        HashMap<ATermAppl, DependencySet> rangeDepends = new HashMap<ATermAppl, DependencySet>();
        for (ATermAppl allDesc : x.getTypes(3)) {
            ATerm rTerm = allDesc.getArgument(0);
            if (rTerm instanceof ATermList) continue;
            ATermAppl r2 = (ATermAppl)rTerm;
            Role role2 = this._strategy.getABox().getRole((ATerm)r2);
            if (null == role2 || !role2.isDatatypeRole()) continue;
            existing = (ArrayList<ATermAppl>)dataranges.get(r2);
            ds = x.getDepends((ATerm)allDesc);
            if (existing == null) {
                existing = new ArrayList<ATermAppl>();
                dataranges.put(r2, existing);
            } else {
                ds = ds.union((DependencySet)rangeDepends.get(r2), this._strategy.getABox().doExplanation());
            }
            existing.add((ATermAppl)allDesc.getArgument(1));
            rangeDepends.put(r2, ds);
        }
        for (ATermAppl minDesc : x.getTypes(4)) {
            Set<ATermAppl> ranges;
            r = (ATermAppl)minDesc.getArgument(0);
            role = this._strategy.getABox().getRole((ATerm)r);
            if (!role.isDatatypeRole() || (ranges = role.getRanges()).isEmpty()) continue;
            existing = (Collection)dataranges.get(r);
            if (existing == null) {
                existing = new ArrayList();
                dataranges.put(r, existing);
                ds = DependencySet.EMPTY;
            } else {
                ds = (DependencySet)rangeDepends.get(r);
            }
            for (ATermAppl dataRange : role.getRanges()) {
                existing.add(dataRange);
                ds = ds.union(role.getExplainRange(dataRange), this._strategy.getABox().doExplanation());
                rangeDepends.put(r, ds);
            }
        }
        for (ATermAppl minDesc : x.getTypes(4)) {
            r = (ATermAppl)minDesc.getArgument(0);
            role = this._strategy.getABox().getRole((ATerm)r);
            HashSet<ATermAppl> drs = new HashSet<ATermAppl>();
            Collection direct = (Collection)dataranges.get(r);
            if (direct != null) {
                drs.addAll(direct);
                ds = (DependencySet)rangeDepends.get(r);
            } else {
                ds = DependencySet.EMPTY;
            }
            ds = ds.union(x.getDepends((ATerm)minDesc), this._strategy.getABox().doExplanation());
            for (Role superRole : role.getSuperRoles()) {
                ATermAppl s = superRole.getName();
                Collection inherited = (Collection)dataranges.get(s);
                if (inherited == null) continue;
                drs.addAll(inherited);
                ds = ds.union((DependencySet)rangeDepends.get(s), this._strategy.getABox().doExplanation()).union(role.getExplainSuper((ATerm)s), this._strategy.getABox().doExplanation());
            }
            if (drs.isEmpty()) continue;
            int n = ((ATermInt)minDesc.getArgument(1)).getInt();
            try {
                if (this._strategy.getABox().getDatatypeReasoner().containsAtLeast(n, drs)) continue;
                this._strategy.getABox().setClash(Clash.minMax(x, ds));
                return;
            }
            catch (DatatypeReasonerException e) {
                throw new InternalReasonerException(e);
            }
        }
    }
}

