/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;
import openllet.core.utils.ATermUtils;

public class SomeValuesRule
extends AbstractTableauRule {
    public SomeValuesRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.EXISTENTIAL, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual x) {
        if (!x.canApply(2)) {
            return;
        }
        List<ATermAppl> types = x.getTypes(2);
        int size = types.size();
        for (int j = x._applyNext[2]; j < size; ++j) {
            ATermAppl sv = types.get(j);
            this.applySomeValuesRule(x, sv);
            if (!this._strategy.getABox().isClosed() && !x.isPruned()) continue;
            return;
        }
        x._applyNext[2] = size;
    }

    protected void applySomeValuesRule(Individual x, ATermAppl sv) {
        ATermAppl a = (ATermAppl)sv.getArgument(0);
        ATermAppl s = (ATermAppl)a.getArgument(0);
        ATermAppl c = (ATermAppl)a.getArgument(1);
        DependencySet ds = x.getDepends((ATerm)sv);
        if (!OpenlletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        c = ATermUtils.negate(c);
        if (s.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            if (ATermUtils.isNominal(c)) {
                return;
            }
            for (Node node : this._strategy.getABox().getNodes().values()) {
                if (!node.isIndividual() || node.isPruned() || !node.hasType((ATerm)c)) continue;
                return;
            }
            Individual y = this._strategy.createFreshIndividual(x, ds);
            this._strategy.addType(y, c, ds);
            return;
        }
        Role role = this._strategy.getABox().getRole((ATerm)s);
        boolean neighborFound = false;
        boolean neighborSafe = x.isBlockable();
        Node y = null;
        Edge edge2 = null;
        EdgeList edges = x.getRNeighborEdges(role);
        for (Edge edge2 : edges) {
            y = edge2.getNeighbor(x);
            if (OpenlletOptions.USE_COMPLETION_QUEUE && y.isPruned()) {
                y = null;
                continue;
            }
            if (y == null || !y.hasType((ATerm)c) || !(neighborFound = neighborSafe || y.isLiteral() || !this._strategy.getBlocking().isBlocked((Individual)y))) continue;
        }
        if (neighborFound) {
            return;
        }
        if (null == role) {
            return;
        }
        if (role.isDatatypeRole()) {
            Literal literal = (Literal)y;
            if (ATermUtils.isNominal(c) && !OpenlletOptions.USE_PSEUDO_NOMINALS) {
                ATermAppl canonical;
                this._strategy.getABox().copyOnWrite();
                ATermAppl input = (ATermAppl)c.getArgument(0);
                if (input.getArgument(2).equals((Object)ATermUtils.NO_DATATYPE)) {
                    canonical = input;
                } else {
                    try {
                        canonical = this._strategy.getABox().getDatatypeReasoner().getCanonicalRepresentation(input);
                    }
                    catch (InvalidLiteralException e) {
                        String msg = "Invalid literal encountered in nominal when attempting to apply some values rule: " + e.getMessage();
                        throw new InternalReasonerException(msg, e);
                    }
                    catch (UnrecognizedDatatypeException e) {
                        String msg = "Unrecognized datatype for literal encountered in nominal when attempting to apply some values rule: " + e.getMessage();
                        throw new InternalReasonerException(msg, e);
                    }
                }
                literal = this._strategy.getABox().addLiteral(canonical);
            } else {
                if (!role.isFunctional() || literal == null) {
                    literal = this._strategy.getABox().addLiteral(ds);
                } else {
                    ds = ds.union(role.getExplainFunctional(), this._strategy.getABox().doExplanation());
                    if (edge2 != null) {
                        ds = ds.union(edge2.getDepends(), this._strategy.getABox().doExplanation());
                    }
                }
                this._strategy.addType(literal, c, ds);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("SOME: " + x + " -> " + s + " -> " + literal + " : " + ATermUtils.toString(c) + " - " + ds);
            }
            this._strategy.addEdge(x, role, literal, ds);
        } else if (ATermUtils.isNominal(c) && !OpenlletOptions.USE_PSEUDO_NOMINALS) {
            this._strategy.getABox().copyOnWrite();
            ATermAppl value = (ATermAppl)c.getArgument(0);
            y = this._strategy.getABox().getIndividual((ATerm)value);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("VAL : " + x + " -> " + ATermUtils.toString(s) + " -> " + y + " - " + ds);
            }
            if (y == null) {
                if (ATermUtils.isAnonNominal(value)) {
                    y = this._strategy.getABox().addIndividual(value, ds);
                } else {
                    if (ATermUtils.isLiteral(value)) {
                        throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction where the value is a literal: " + ATermUtils.toString(value));
                    }
                    throw new InternalReasonerException("Nominal " + c + " is not found in the KB!");
                }
            }
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this._strategy.getABox().doExplanation());
                y = y.getSame();
            }
            this._strategy.addEdge(x, role, y, ds);
        } else {
            DependencySet maxCardDS;
            boolean useExistingNode = false;
            boolean useExistingRole = false;
            DependencySet dependencySet = maxCardDS = role.isFunctional() ? role.getExplainFunctional() : x.hasMax1(role);
            if (maxCardDS != null) {
                ds = ds.union(maxCardDS, this._strategy.getABox().doExplanation());
                if (edge2 != null) {
                    useExistingNode = true;
                    useExistingRole = true;
                } else {
                    Set<Role> fs = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                    for (Role f : fs) {
                        edges = x.getRNeighborEdges(f);
                        if (edges.isEmpty()) continue;
                        if (useExistingNode) {
                            DependencySet fds = DependencySet.INDEPENDENT;
                            if (OpenlletOptions.USE_TRACING) {
                                fds = role.isFunctional() ? role.getExplainSuper((ATerm)f.getName()) : role.getExplainSub((ATerm)f.getName());
                            }
                            Edge otherEdge = (Edge)edges.get(0);
                            Node otherNode = otherEdge.getNeighbor(x);
                            if (edge2 == null) continue;
                            DependencySet d = ds.union(edge2.getDepends(), this._strategy.getABox().doExplanation()).union(otherEdge.getDepends(), this._strategy.getABox().doExplanation()).union(fds, this._strategy.getABox().doExplanation());
                            this._strategy.mergeTo(y, otherNode, d);
                            continue;
                        }
                        useExistingNode = true;
                        edge2 = (Edge)edges.get(0);
                        y = edge2.getNeighbor(x);
                    }
                    if (y != null) {
                        y = y.getSame();
                    }
                }
            }
            if (useExistingNode) {
                if (edge2 != null) {
                    ds = ds.union(edge2.getDepends(), this._strategy.getABox().doExplanation());
                }
            } else {
                y = this._strategy.createFreshIndividual(x, ds);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("SOME: " + x + " -> " + role + " -> " + y + " : " + ATermUtils.toString(c) + (useExistingNode ? "" : " (*)") + " - " + ds);
            }
            this._strategy.addType(y, c, ds);
            if (!useExistingRole) {
                if (x.isBlockable() && y != null && y.isConceptRoot()) {
                    this._strategy.addEdge((Individual)y, role.getInverse(), x, ds);
                } else {
                    this._strategy.addEdge(x, role, y, ds);
                }
            }
        }
    }
}

